/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.client.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.client.common.canvas.SwingCanvas;
import org.jetbrains.projector.common.protocol.toServer.ClientEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientMouseEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientRawKeyEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWheelEvent;
import org.jetbrains.projector.common.protocol.toServer.MouseModifier;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00120\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/projector/client/swing/ProjectorViewPanel;", "Ljavax/swing/JPanel;", "canvas", "Lorg/jetbrains/projector/client/common/canvas/SwingCanvas;", "connectionTime", "", "appliedCanvasScale", "", "(Lorg/jetbrains/projector/client/common/canvas/SwingCanvas;JD)V", "getAppliedCanvasScale", "()D", "setAppliedCanvasScale", "(D)V", "getCanvas", "()Lorg/jetbrains/projector/client/common/canvas/SwingCanvas;", "getConnectionTime", "()J", "addListeners", "", "windowId", "", "eventSink", "Lkotlin/Function1;", "Lorg/jetbrains/projector/common/protocol/toServer/ClientEvent;", "paintComponent", "g", "Ljava/awt/Graphics;", "preferredSize", "Ljava/awt/Dimension;", "projector-client-swing"})
public class ProjectorViewPanel
extends JPanel {
    @NotNull
    private final SwingCanvas canvas;
    private final long connectionTime;
    private double appliedCanvasScale;

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        g.drawImage(this.canvas.getImage(), 0, 0, (int)((double)this.canvas.getImage().getWidth() * this.appliedCanvasScale), (int)((double)this.canvas.getImage().getHeight() * this.appliedCanvasScale), this);
    }

    @Override
    @NotNull
    public Dimension preferredSize() {
        return new Dimension((int)((double)this.canvas.getImage().getWidth() * this.appliedCanvasScale), (int)((double)this.canvas.getImage().getHeight() * this.appliedCanvasScale));
    }

    public final void addListeners(int windowId, @NotNull Function1<? super ClientEvent, Unit> eventSink) {
        Intrinsics.checkNotNullParameter(eventSink, (String)"eventSink");
        MouseAdapter mouseListener2 = new MouseAdapter(this, windowId, eventSink){
            final /* synthetic */ ProjectorViewPanel this$0;
            final /* synthetic */ int $windowId;
            final /* synthetic */ Function1 $eventSink;

            @NotNull
            public final ClientMouseEvent convertMouseEvent(@NotNull MouseEvent event, @NotNull ClientMouseEvent.MouseEventType eventType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
                int n = 0;
                int n2 = event.getButton() - 1;
                boolean bl = false;
                return new ClientMouseEvent((int)(System.currentTimeMillis() - this.this$0.getConnectionTime()), this.$windowId, event.getXOnScreen(), event.getYOnScreen(), (short)Math.max(n, n2), event.getClickCount(), this.convertModifiers(event.getModifiersEx()), eventType);
            }

            @NotNull
            public final Set<MouseModifier> convertModifiers(int modifiers) {
                boolean bl = false;
                Set set = new LinkedHashSet<E>();
                if ((modifiers & 0x40) != 0) {
                    set.add(MouseModifier.SHIFT_KEY);
                }
                if ((modifiers & 0x80) != 0) {
                    set.add(MouseModifier.CTRL_KEY);
                }
                if ((modifiers & 0x200) != 0) {
                    set.add(MouseModifier.ALT_KEY);
                }
                if ((modifiers & 0x100) != 0) {
                    set.add(MouseModifier.META_KEY);
                }
                return set;
            }

            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$eventSink.invoke((Object)this.convertMouseEvent(e, ClientMouseEvent.MouseEventType.CLICK));
            }

            public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
                double d;
                ClientWheelEvent.ScrollingMode scrollingMode;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                switch (e.getScrollType()) {
                    case 1: {
                        scrollingMode = ClientWheelEvent.ScrollingMode.PAGE;
                        break;
                    }
                    case 0: {
                        scrollingMode = ClientWheelEvent.ScrollingMode.LINE;
                        break;
                    }
                    default: {
                        String string = "Unknown scroll type " + e.getScrollType();
                        boolean bl = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                }
                ClientWheelEvent.ScrollingMode scrollType = scrollingMode;
                boolean isHorizontal = e.isShiftDown();
                switch (e.getScrollType()) {
                    case 0: {
                        d = e.getWheelRotation();
                        break;
                    }
                    case 1: {
                        d = e.getWheelRotation();
                        break;
                    }
                    default: {
                        String string = "Unknown scroll type " + e.getScrollType();
                        boolean bl = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                }
                double delta = d;
                double deltaX = isHorizontal ? delta : 0.0;
                double deltaY = isHorizontal ? 0.0 : delta;
                this.$eventSink.invoke((Object)new ClientWheelEvent((int)(System.currentTimeMillis() - this.this$0.getConnectionTime()), this.$windowId, this.convertModifiers(e.getModifiersEx()), scrollType, e.getXOnScreen(), e.getYOnScreen(), deltaX, deltaY));
            }

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$eventSink.invoke((Object)this.convertMouseEvent(e, ClientMouseEvent.MouseEventType.MOVE));
            }

            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$eventSink.invoke((Object)this.convertMouseEvent(e, ClientMouseEvent.MouseEventType.DOWN));
                this.this$0.requestFocusInWindow(FocusEvent.Cause.MOUSE_EVENT);
            }

            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$eventSink.invoke((Object)this.convertMouseEvent(e, ClientMouseEvent.MouseEventType.UP));
            }

            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$eventSink.invoke((Object)this.convertMouseEvent(e, ClientMouseEvent.MouseEventType.OUT));
            }

            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$eventSink.invoke((Object)this.convertMouseEvent(e, ClientMouseEvent.MouseEventType.DRAG));
            }
            {
                this.this$0 = this$0;
                this.$windowId = $captured_local_variable$1;
                this.$eventSink = $captured_local_variable$2;
            }
        };
        KeyAdapter keyboardListener2 = new KeyAdapter(this, eventSink){
            final /* synthetic */ ProjectorViewPanel this$0;
            final /* synthetic */ Function1 $eventSink;

            private final ClientRawKeyEvent convertKeyEvent(KeyEvent e, ClientRawKeyEvent.RawKeyEventType eventType) {
                return new ClientRawKeyEvent((int)(System.currentTimeMillis() - this.this$0.getConnectionTime()), e.getKeyCode(), e.getKeyChar(), e.getModifiersEx(), e.getKeyLocation(), eventType);
            }

            public void keyTyped(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$eventSink.invoke((Object)this.convertKeyEvent(e, ClientRawKeyEvent.RawKeyEventType.TYPED));
            }

            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$eventSink.invoke((Object)this.convertKeyEvent(e, ClientRawKeyEvent.RawKeyEventType.DOWN));
            }

            public void keyReleased(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$eventSink.invoke((Object)this.convertKeyEvent(e, ClientRawKeyEvent.RawKeyEventType.UP));
            }
            {
                this.this$0 = this$0;
                this.$eventSink = $captured_local_variable$1;
            }
        };
        this.addMouseListener(mouseListener2);
        this.addMouseMotionListener(mouseListener2);
        this.addMouseWheelListener(mouseListener2);
        this.addKeyListener(keyboardListener2);
    }

    @NotNull
    public final SwingCanvas getCanvas() {
        return this.canvas;
    }

    public final long getConnectionTime() {
        return this.connectionTime;
    }

    public final double getAppliedCanvasScale() {
        return this.appliedCanvasScale;
    }

    public final void setAppliedCanvasScale(double d) {
        this.appliedCanvasScale = d;
    }

    public ProjectorViewPanel(@NotNull SwingCanvas canvas, long connectionTime, double appliedCanvasScale) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.canvas = canvas;
        this.connectionTime = connectionTime;
        this.appliedCanvasScale = appliedCanvasScale;
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
    }

    public /* synthetic */ ProjectorViewPanel(SwingCanvas swingCanvas, long l, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        this(swingCanvas, l, d);
    }
}

