/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.client.swing;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.client.common.DrawEvent;
import org.jetbrains.projector.client.common.SingleRenderingSurfaceProcessor;
import org.jetbrains.projector.client.common.canvas.Canvas;
import org.jetbrains.projector.client.common.canvas.SwingCanvas;
import org.jetbrains.projector.client.common.canvas.buffering.DoubleBufferedRenderingSurface;
import org.jetbrains.projector.client.common.canvas.buffering.RenderingSurface;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowSetChangedEvent;
import org.jetbrains.projector.common.protocol.toClient.WindowData;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u001a\u0010\u0015\u001a\u000e\u0018\u00010\u0007R\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0011\u001a\u00020\u0006J\u001a\u0010\u0016\u001a\u00020\u00172\u0010\u0010\u000e\u001a\f0\u0007R\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J%\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH&\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\rJ\u001a\u0010\u001f\u001a\u00020\r2\u0010\u0010\u000e\u001a\f0\u0007R\b\u0012\u0004\u0012\u00028\u00000\u0000H&J\u001a\u0010 \u001a\u00020\r2\u0010\u0010!\u001a\f0\u0007R\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\u000e\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$R>\u0010\u0004\u001a2\u0012\u0004\u0012\u00020\u0006\u0012\u000e\u0012\f0\u0007R\b\u0012\u0004\u0012\u00028\u00000\u00000\u0005j\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u000e\u0012\f0\u0007R\b\u0012\u0004\u0012\u00028\u00000\u0000`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/projector/client/swing/AbstractWindowManager;", "FrameType", "", "()V", "currentWindows", "Ljava/util/HashMap;", "", "Lorg/jetbrains/projector/client/swing/AbstractWindowManager$FrameData;", "Lkotlin/collections/HashMap;", "lastLoggedWindowCount", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "deleteFrame", "", "frame", "(Ljava/lang/Object;)V", "doWindowDraw", "windowId", "drawEvents", "", "Lorg/jetbrains/projector/common/protocol/toClient/ServerWindowEvent;", "getFrameData", "getScalingForWindow", "", "newFrame", "canvas", "Lorg/jetbrains/projector/client/common/canvas/SwingCanvas;", "windowData", "Lorg/jetbrains/projector/common/protocol/toClient/WindowData;", "(ILorg/jetbrains/projector/client/common/canvas/SwingCanvas;Lorg/jetbrains/projector/common/protocol/toClient/WindowData;)Ljava/lang/Object;", "reapplyWindowProperties", "redrawWindow", "updateFrameProperties", "frameData", "windowSetUpdated", "event", "Lorg/jetbrains/projector/common/protocol/toClient/ServerWindowSetChangedEvent;", "FrameData", "projector-client-swing"})
public abstract class AbstractWindowManager<FrameType> {
    private final Logger logger;
    private final HashMap<Integer, FrameData> currentWindows;
    private int lastLoggedWindowCount;

    public abstract FrameType newFrame(int var1, @NotNull SwingCanvas var2, @NotNull WindowData var3);

    public abstract void deleteFrame(FrameType var1);

    public abstract void redrawWindow(@NotNull FrameData var1);

    public double getScalingForWindow(@NotNull FrameData frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        return 1.0;
    }

    public void updateFrameProperties(@NotNull FrameData frameData) {
        Intrinsics.checkNotNullParameter((Object)frameData, (String)"frameData");
        WindowData it = frameData.getWindowData();
        frameData.setSurfaceSizeScale(this.getScalingForWindow(frameData));
        frameData.getSurface().setBounds((int)(it.getBounds().getWidth() * frameData.getSurfaceSizeScale()), (int)(it.getBounds().getHeight() * frameData.getSurfaceSizeScale()));
        frameData.getSurface().setScalingRatio(1.0);
    }

    @Nullable
    public final FrameData getFrameData(int windowId) {
        return this.currentWindows.get(windowId);
    }

    /*
     * WARNING - void declaration
     */
    public final void windowSetUpdated(@NotNull ServerWindowSetChangedEvent event) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.lastLoggedWindowCount != event.getWindowDataList().size()) {
            this.lastLoggedWindowCount = event.getWindowDataList().size();
            Logger.DefaultImpls.debug$default((Logger)this.logger, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ AbstractWindowManager this$0;

                @NotNull
                public final String invoke() {
                    return "Updating window set with " + AbstractWindowManager.access$getLastLoggedWindowCount$p(this.this$0) + " windows";
                }
                {
                    this.this$0 = abstractWindowManager;
                    super(0);
                }
            }), (int)1, null);
        }
        Set<Integer> set = this.currentWindows.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"currentWindows.keys");
        HashSet windowsToDelete = CollectionsKt.toHashSet((Iterable)set);
        Iterable $this$forEach$iv = event.getWindowDataList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$getOrPut$iv;
            it = (WindowData)element$iv;
            boolean bl = false;
            windowsToDelete.remove(it.getId());
            Map map = this.currentWindows;
            Integer key$iv = it.getId();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                SwingCanvas canvas = new SwingCanvas();
                DoubleBufferedRenderingSurface surface = new DoubleBufferedRenderingSurface((Canvas)canvas);
                FrameData answer$iv = new FrameData(this.newFrame(it.getId(), canvas, (WindowData)it), (WindowData)it, (ArrayDeque<DrawEvent>)new ArrayDeque(), surface, new SingleRenderingSurfaceProcessor((RenderingSurface)surface), 1.0);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            FrameData existing = (FrameData)object;
            existing.setWindowData((WindowData)it);
            this.updateFrameProperties(existing);
        }
        $this$forEach$iv = windowsToDelete;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FrameData oldFrame;
            it = (Integer)element$iv;
            boolean bl = false;
            if (this.currentWindows.remove(it) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)oldFrame, (String)"currentWindows.remove(it) ?: return@forEach");
            this.deleteFrame(oldFrame.getFrame());
        }
    }

    public final void reapplyWindowProperties() {
        Map map = this.currentWindows;
        boolean bl = false;
        for (Map.Entry it : map.entrySet()) {
            this.updateFrameProperties((FrameData)it.getValue());
        }
    }

    public final void doWindowDraw(int windowId, @NotNull List<? extends ServerWindowEvent> drawEvents) {
        Intrinsics.checkNotNullParameter(drawEvents, (String)"drawEvents");
        FrameData window = this.currentWindows.get(windowId);
        if (window == null) {
            Logger.DefaultImpls.error$default((Logger)this.logger, null, (Function0)((Function0)new Function0<String>(windowId){
                final /* synthetic */ int $windowId;

                @NotNull
                public final String invoke() {
                    return "Received draw command for unknown window " + this.$windowId;
                }
                {
                    this.$windowId = n;
                    super(0);
                }
            }), (int)1, null);
            return;
        }
        List newDrawEvents = SingleRenderingSurfaceProcessor.Companion.shrinkByPaintEvents(drawEvents);
        Collection collection = newDrawEvents;
        boolean bl = false;
        if (!collection.isEmpty()) {
            window.getDrawEvents().addAll((Collection)newDrawEvents);
            window.getProcessor().process(window.getDrawEvents());
            window.getSurface().flush();
            this.redrawWindow(window);
        }
    }

    public AbstractWindowManager() {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(AbstractWindowManager.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        this.logger = LoggerKt.Logger((String)string);
        this.currentWindows = new HashMap();
    }

    public static final /* synthetic */ int access$getLastLoggedWindowCount$p(AbstractWindowManager $this) {
        return $this.lastLoggedWindowCount;
    }

    public static final /* synthetic */ void access$setLastLoggedWindowCount$p(AbstractWindowManager $this, int n) {
        $this.lastLoggedWindowCount = n;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0013\b\u0086\u0004\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00028\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0002\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lorg/jetbrains/projector/client/swing/AbstractWindowManager$FrameData;", "", "frame", "windowData", "Lorg/jetbrains/projector/common/protocol/toClient/WindowData;", "drawEvents", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/projector/client/common/DrawEvent;", "surface", "Lorg/jetbrains/projector/client/common/canvas/buffering/DoubleBufferedRenderingSurface;", "processor", "Lorg/jetbrains/projector/client/common/SingleRenderingSurfaceProcessor;", "surfaceSizeScale", "", "(Lorg/jetbrains/projector/client/swing/AbstractWindowManager;Ljava/lang/Object;Lorg/jetbrains/projector/common/protocol/toClient/WindowData;Lkotlin/collections/ArrayDeque;Lorg/jetbrains/projector/client/common/canvas/buffering/DoubleBufferedRenderingSurface;Lorg/jetbrains/projector/client/common/SingleRenderingSurfaceProcessor;D)V", "getDrawEvents", "()Lkotlin/collections/ArrayDeque;", "getFrame", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getProcessor", "()Lorg/jetbrains/projector/client/common/SingleRenderingSurfaceProcessor;", "getSurface", "()Lorg/jetbrains/projector/client/common/canvas/buffering/DoubleBufferedRenderingSurface;", "getSurfaceSizeScale", "()D", "setSurfaceSizeScale", "(D)V", "getWindowData", "()Lorg/jetbrains/projector/common/protocol/toClient/WindowData;", "setWindowData", "(Lorg/jetbrains/projector/common/protocol/toClient/WindowData;)V", "projector-client-swing"})
    public final class FrameData {
        private final FrameType frame;
        @NotNull
        private WindowData windowData;
        @NotNull
        private final ArrayDeque<DrawEvent> drawEvents;
        @NotNull
        private final DoubleBufferedRenderingSurface surface;
        @NotNull
        private final SingleRenderingSurfaceProcessor processor;
        private double surfaceSizeScale;

        public final FrameType getFrame() {
            return this.frame;
        }

        @NotNull
        public final WindowData getWindowData() {
            return this.windowData;
        }

        public final void setWindowData(@NotNull WindowData windowData) {
            Intrinsics.checkNotNullParameter((Object)windowData, (String)"<set-?>");
            this.windowData = windowData;
        }

        @NotNull
        public final ArrayDeque<DrawEvent> getDrawEvents() {
            return this.drawEvents;
        }

        @NotNull
        public final DoubleBufferedRenderingSurface getSurface() {
            return this.surface;
        }

        @NotNull
        public final SingleRenderingSurfaceProcessor getProcessor() {
            return this.processor;
        }

        public final double getSurfaceSizeScale() {
            return this.surfaceSizeScale;
        }

        public final void setSurfaceSizeScale(double d) {
            this.surfaceSizeScale = d;
        }

        public FrameData(@NotNull FrameType frame, @NotNull WindowData windowData, @NotNull ArrayDeque<DrawEvent> drawEvents, @NotNull DoubleBufferedRenderingSurface surface, SingleRenderingSurfaceProcessor processor, double surfaceSizeScale) {
            Intrinsics.checkNotNullParameter((Object)windowData, (String)"windowData");
            Intrinsics.checkNotNullParameter(drawEvents, (String)"drawEvents");
            Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
            Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
            this.frame = frame;
            this.windowData = windowData;
            this.drawEvents = drawEvents;
            this.surface = surface;
            this.processor = processor;
            this.surfaceSizeScale = surfaceSizeScale;
        }
    }
}

