/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.utils;

import com.intellij.openapi.util.TextRange;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0007J\n\u0010\u0012\u001a\u00020\f*\u00020\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/grazie/utils/Text;", "", "()V", "PUNCTUATIONS", "", "", "findParagraphRange", "Lcom/intellij/openapi/util/TextRange;", "text", "", "range", "isNewline", "", "char", "", "isPunctuation", "isQuote", "isSingleSentence", "looksLikeCode", "intellij.grazie.core"})
public final class Text {
    private static final Set<Byte> PUNCTUATIONS;
    @NotNull
    public static final Text INSTANCE;

    public final boolean isNewline(char c) {
        return c == '\n';
    }

    public final boolean isPunctuation(char c) {
        byte by = (byte)Character.getType(c);
        return PUNCTUATIONS.contains(by);
    }

    public final boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }

    @JvmStatic
    public static final boolean isSingleSentence(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        CharSequence charSequence = text2;
        Regex regex = new Regex("\\.\\s");
        boolean bl = false;
        return !regex.containsMatchIn(charSequence);
    }

    @JvmStatic
    @NotNull
    public static final TextRange findParagraphRange(@NotNull CharSequence text2, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int start = range.getStartOffset();
        while (start > 0) {
            int wsStart;
            for (wsStart = start; wsStart > 0 && CharsKt.isWhitespace((char)text2.charAt(wsStart - 1)); --wsStart) {
            }
            if (wsStart < start) {
                CharSequence $this$count$iv = text2.subSequence(wsStart, start);
                boolean $i$f$count = false;
                int count$iv = 0;
                CharSequence charSequence = $this$count$iv;
                for (int i = 0; i < charSequence.length(); ++i) {
                    char element$iv;
                    char it = element$iv = charSequence.charAt(i);
                    boolean bl = false;
                    if (!(it == '\n')) continue;
                    ++count$iv;
                }
                if (count$iv > 1) break;
            }
            start = wsStart - 1;
        }
        int end = range.getEndOffset();
        while (end < text2.length()) {
            int wsEnd;
            for (wsEnd = end; wsEnd < text2.length() && CharsKt.isWhitespace((char)text2.charAt(wsEnd)); ++wsEnd) {
            }
            if (wsEnd > end) {
                CharSequence $this$count$iv = text2.subSequence(end, wsEnd);
                boolean $i$f$count = false;
                int count$iv = 0;
                CharSequence charSequence = $this$count$iv;
                for (int i = 0; i < charSequence.length(); ++i) {
                    char element$iv;
                    char it = element$iv = charSequence.charAt(i);
                    boolean bl = false;
                    if (!(it == '\n')) continue;
                    ++count$iv;
                }
                if (count$iv > 1) break;
            }
            end = wsEnd + 1;
        }
        return new TextRange(RangesKt.coerceAtLeast((int)start, (int)0), RangesKt.coerceAtMost((int)end, (int)text2.length()));
    }

    public final boolean looksLikeCode(@NotNull CharSequence $this$looksLikeCode) {
        Intrinsics.checkNotNullParameter((Object)$this$looksLikeCode, (String)"$this$looksLikeCode");
        int codeChars = 0;
        int textChars = 0;
        CharSequence charSequence = $this$looksLikeCode;
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (StringsKt.contains$default((CharSequence)"(){}[]<>=+-*/%|&!;,.:\"'\\@$#^", (char)c, (boolean)false, (int)2, null)) {
                ++codeChars;
                continue;
            }
            char c2 = c;
            boolean bl = false;
            if (!Character.isLetterOrDigit(c2)) continue;
            ++textChars;
        }
        return codeChars > 0 && textChars / codeChars < 4;
    }

    private Text() {
    }

    static {
        Text text2;
        INSTANCE = text2 = new Text();
        PUNCTUATIONS = SetsKt.setOf((Object[])new Byte[]{(byte)21, (byte)22, (byte)24, (byte)23, (byte)20, (byte)29, (byte)30});
    }
}

