/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JTreeFixture;
import org.fest.swing.fixture.JTreeNodeFixture;
import org.fest.util.VisibleForTesting;

public class JTreePathFixture
implements JTreeNodeFixture<JTreePathFixture> {
    private final JTreeFixture tree;
    private final String path;

    protected JTreePathFixture(@Nonnull JTreeFixture tree, @Nonnull String path) {
        this.tree = tree;
        this.path = path;
    }

    @Override
    @Nonnull
    public JTreePathFixture expand() {
        this.tree.expandPath(this.path());
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture collapse() {
        this.tree.collapsePath(this.path());
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture select() {
        this.tree.selectPath(this.path());
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture click() {
        this.tree.clickPath(this.path());
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture click(@Nonnull MouseButton button) {
        this.tree.clickPath(this.path(), button);
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture click(@Nonnull MouseClickInfo mouseClickInfo) {
        this.tree.clickPath(this.path(), mouseClickInfo);
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture doubleClick() {
        this.tree.doubleClickPath(this.path());
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture rightClick() {
        this.tree.rightClickPath(this.path());
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture drag() {
        this.tree.drag(this.path());
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture drop() {
        this.tree.drop(this.path());
        return this;
    }

    @Override
    @Nonnull
    public JPopupMenuFixture showPopupMenu() {
        return this.tree.showPopupMenuAt(this.path());
    }

    @Override
    @Nullable
    public String value() {
        return this.tree.valueAt(this.path());
    }

    @Nonnull
    public String path() {
        return this.path;
    }

    @Nonnull
    @VisibleForTesting
    JTreeFixture treeFixture() {
        return this.tree;
    }
}

