/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.core.Settings;
import org.fest.swing.input.InputState;
import org.fest.swing.monitor.WindowMonitor;
import org.fest.swing.timing.Pause;

class AWTEventPoster {
    private final Toolkit toolkit;
    private final InputState inputState;
    private final WindowMonitor windowMonitor;
    private final Settings settings;

    AWTEventPoster(@Nonnull Toolkit toolkit, @Nonnull InputState inputState, @Nonnull WindowMonitor windowMonitor, @Nonnull Settings settings) {
        this.toolkit = toolkit;
        this.inputState = inputState;
        this.windowMonitor = windowMonitor;
        this.settings = settings;
    }

    void postEvent(@Nullable Component c, @Nonnull AWTEvent event) {
        this.inputState.update(event);
        EventQueue eventQueue = this.eventQueueFor(c);
        if (eventQueue != null) {
            eventQueue.postEvent(event);
        }
        Pause.pause(this.settings.delayBetweenEvents());
    }

    @Nullable
    private EventQueue eventQueueFor(@Nullable Component c) {
        return c != null ? this.windowMonitor.eventQueueFor(c) : this.toolkit.getSystemEventQueue();
    }
}

