/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.SingleConnectionNetService;
import org.jetbrains.builtInWebServer.liveReload.WebServerPageConnectionService;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.ClientInfo;
import org.jetbrains.io.fastCgi.FastCgiDecoder;
import org.jetbrains.io.fastCgi.FastCgiRequest;
import org.jetbrains.io.fastCgi.FastCgiServiceKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0014J\u001a\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0018\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u00112\b\u0010&\u001a\u0004\u0018\u00010#J\u0016\u0010'\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/io/fastCgi/FastCgiService;", "Lorg/jetbrains/builtInWebServer/SingleConnectionNetService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "requestIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "requests", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "Lorg/jetbrains/io/fastCgi/ClientInfo;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addCloseListener", "", "it", "Lio/netty/channel/Channel;", "allocateRequestId", "", "channel", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "configureBootstrap", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "handleError", "fastCgiRequest", "Lorg/jetbrains/io/fastCgi/FastCgiRequest;", "content", "Lio/netty/buffer/ByteBuf;", "responseReceived", "id", "buffer", "send", "intellij.platform.builtInServer.impl"})
public abstract class FastCgiService
extends SingleConnectionNetService {
    private final AtomicInteger requestIdCounter;
    private final ConcurrentIntObjectMap<ClientInfo> requests;

    @Override
    protected void configureBootstrap(@NotNull Bootstrap bootstrap, @NotNull Consumer<String> errorOutputConsumer) {
        Intrinsics.checkNotNullParameter((Object)bootstrap, (String)"bootstrap");
        Intrinsics.checkNotNullParameter(errorOutputConsumer, (String)"errorOutputConsumer");
        Bootstrap $this$handler$iv = bootstrap;
        boolean $i$f$handler = false;
        $this$handler$iv.handler((ChannelHandler)new ChannelInitializer<Channel>(this, errorOutputConsumer){
            final /* synthetic */ FastCgiService this$0;
            final /* synthetic */ Consumer $errorOutputConsumer$inlined;
            {
                this.this$0 = fastCgiService;
                this.$errorOutputConsumer$inlined = consumer;
            }

            protected void initChannel(@NotNull Channel channel2) {
                Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
                Channel it = channel2;
                boolean bl = false;
                it.pipeline().addLast("fastCgiDecoder", (ChannelHandler)new FastCgiDecoder((Consumer<String>)this.$errorOutputConsumer$inlined, this.this$0));
                it.pipeline().addLast("exceptionHandler", ChannelExceptionHandler.getInstance());
            }
        });
    }

    @Override
    protected void addCloseListener(@NotNull Channel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        super.addCloseListener(it);
        ChannelFuture channelFuture = it.closeFuture();
        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"it.closeFuture()");
        ChannelFuture $this$addChannelListener$iv = channelFuture;
        boolean $i$f$addChannelListener = false;
        $this$addChannelListener$iv.addListener(new GenericFutureListener(this){
            final /* synthetic */ FastCgiService this$0;
            {
                this.this$0 = fastCgiService;
            }

            public final void operationComplete(ChannelFuture it) {
                ChannelFuture channelFuture = it;
                Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"it");
                ChannelFuture it2 = channelFuture;
                boolean bl = false;
                FastCgiService.access$getRequestIdCounter$p(this.this$0).set(0);
                if (!FastCgiService.access$getRequests$p(this.this$0).isEmpty()) {
                    Enumeration enumeration = FastCgiService.access$getRequests$p(this.this$0).elements();
                    Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"requests.elements()");
                    Enumeration enumeration2 = enumeration;
                    boolean bl2 = false;
                    ArrayList<T> arrayList = Collections.list(enumeration2);
                    Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
                    List waitingClients = arrayList;
                    FastCgiService.access$getRequests$p(this.this$0).clear();
                    for (ClientInfo client : waitingClients) {
                        FastCgiServiceKt.access$sendBadGateway(client.getChannel(), client.getExtraHeaders());
                    }
                }
            }
        });
    }

    public final void send(@NotNull FastCgiRequest fastCgiRequest, @NotNull ByteBuf content2) {
        Intrinsics.checkNotNullParameter((Object)fastCgiRequest, (String)"fastCgiRequest");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        ByteBuf notEmptyContent = null;
        if (content2.isReadable()) {
            content2.retain();
            notEmptyContent = content2;
            notEmptyContent.touch();
        } else {
            notEmptyContent = null;
        }
        try {
            Promise<Channel> promise = null;
            OSProcessHandler handler2 = (OSProcessHandler)this.getProcessHandler().getResultIfFullFilled();
            if (handler2 == null) {
                Promise<Channel> promise2 = this.getProcessHandler().get();
                Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"processHandler.get()");
                promise = promise2;
            } else {
                Channel channel2 = this.getProcessChannel().get();
                if (channel2 == null || !channel2.isOpen()) {
                    promise = this.connectAgain();
                } else {
                    fastCgiRequest.writeToServerChannel(notEmptyContent, channel2);
                    return;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)promise.onSuccess(new java.util.function.Consumer(this, fastCgiRequest, notEmptyContent){
                final /* synthetic */ FastCgiService this$0;
                final /* synthetic */ FastCgiRequest $fastCgiRequest;
                final /* synthetic */ ByteBuf $notEmptyContent;

                public final void accept(Object it) {
                    V v = FastCgiService.access$getProcessChannel$p(this.this$0).get();
                    Intrinsics.checkNotNull(v);
                    this.$fastCgiRequest.writeToServerChannel(this.$notEmptyContent, (Channel)v);
                }
                {
                    this.this$0 = fastCgiService;
                    this.$fastCgiRequest = fastCgiRequest;
                    this.$notEmptyContent = byteBuf;
                }
            }).onError(new java.util.function.Consumer(this, fastCgiRequest, notEmptyContent){
                final /* synthetic */ FastCgiService this$0;
                final /* synthetic */ FastCgiRequest $fastCgiRequest;
                final /* synthetic */ ByteBuf $notEmptyContent;

                public final void accept(Throwable it) {
                    Logger logger = FastCgiServiceKt.getLOG();
                    Throwable throwable = it;
                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"it");
                    Promises.errorIfNotMessage((Logger)logger, (Throwable)throwable);
                    FastCgiService.access$handleError(this.this$0, this.$fastCgiRequest, this.$notEmptyContent);
                }
                {
                    this.this$0 = fastCgiService;
                    this.$fastCgiRequest = fastCgiRequest;
                    this.$notEmptyContent = byteBuf;
                }
            }), (String)"promise\n        .onSucce\u2026otEmptyContent)\n        }");
        }
        catch (Throwable e) {
            FastCgiServiceKt.getLOG().error(e);
            this.handleError(fastCgiRequest, notEmptyContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleError(FastCgiRequest fastCgiRequest, ByteBuf content2) {
        try {
            if (content2 != null && content2.refCnt() != 0) {
                content2.release();
            }
        }
        finally {
            ClientInfo clientInfo = (ClientInfo)this.requests.remove(fastCgiRequest.getRequestId());
            if (clientInfo != null) {
                ClientInfo clientInfo2 = clientInfo;
                boolean bl = false;
                boolean bl2 = false;
                ClientInfo it = clientInfo2;
                boolean bl3 = false;
                FastCgiServiceKt.access$sendBadGateway(it.getChannel(), it.getExtraHeaders());
            }
        }
    }

    public final int allocateRequestId(@NotNull Channel channel2, @NotNull PathInfo pathInfo, @NotNull FullHttpRequest request, @NotNull HttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)pathInfo, (String)"pathInfo");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)extraHeaders, (String)"extraHeaders");
        int requestId = this.requestIdCounter.getAndIncrement();
        if (requestId >= Short.MAX_VALUE) {
            this.requestIdCounter.set(0);
            requestId = this.requestIdCounter.getAndDecrement();
        }
        this.requests.put(requestId, (Object)new ClientInfo(channel2, pathInfo, request, extraHeaders));
        return requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void responseReceived(int id2, @Nullable ByteBuf buffer) {
        ClientInfo client = (ClientInfo)this.requests.remove(id2);
        if (client == null || !client.getChannel().isActive()) {
            ByteBuf byteBuf = buffer;
            if (byteBuf != null) {
                byteBuf.release();
            }
            return;
        }
        Channel channel2 = client.getChannel();
        if (buffer == null) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_GATEWAY;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"HttpResponseStatus.BAD_GATEWAY");
            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel2, null, null, null, (int)14, null);
            return;
        }
        Function0 function0 = (Function0)new Function0<VirtualFile>(client.getPathInfo()){

            @Nullable
            public final VirtualFile invoke() {
                return ((PathInfo)this.receiver).getOrResolveVirtualFile();
            }
        };
        CharSequence extraSuffix2 = WebServerPageConnectionService.Companion.getInstance().fileRequested(client.getRequest(), false, new Supplier(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ Object get() {
                return this.function.invoke();
            }
        });
        ByteBuf bufferWithExtraSuffix = extraSuffix2 == null ? buffer : Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{buffer, Unpooled.copiedBuffer((CharSequence)extraSuffix2, (Charset)Charsets.UTF_8)});
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, bufferWithExtraSuffix);
        try {
            HttpResponse httpResponse2 = (HttpResponse)httpResponse;
            ByteBuf byteBuf = bufferWithExtraSuffix;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"bufferWithExtraSuffix");
            FastCgiServiceKt.access$parseHeaders(httpResponse2, byteBuf);
            Responses.addServer((HttpResponse)((HttpResponse)httpResponse));
            if (!HttpUtil.isContentLengthSet((HttpMessage)((HttpMessage)httpResponse))) {
                HttpUtil.setContentLength((HttpMessage)((HttpMessage)httpResponse), (long)bufferWithExtraSuffix.readableBytes());
            }
            httpResponse.headers().add(client.getExtraHeaders());
        }
        catch (Throwable e) {
            bufferWithExtraSuffix.release();
            try {
                FastCgiServiceKt.getLOG().error(e);
            }
            finally {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"HttpResponseStatus.INTERNAL_SERVER_ERROR");
                Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel2, null, null, null, (int)14, null);
            }
            return;
        }
        channel2.writeAndFlush((Object)httpResponse);
    }

    public FastCgiService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.requestIdCounter = new AtomicInteger();
        ConcurrentIntObjectMap concurrentIntObjectMap = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentIntObjectMap, (String)"ConcurrentCollectionFact\u2026ntObjectMap<ClientInfo>()");
        this.requests = concurrentIntObjectMap;
    }

    public static final /* synthetic */ AtomicInteger access$getRequestIdCounter$p(FastCgiService $this) {
        return $this.requestIdCounter;
    }

    public static final /* synthetic */ ConcurrentIntObjectMap access$getRequests$p(FastCgiService $this) {
        return $this.requests;
    }

    public static final /* synthetic */ AtomicReference access$getProcessChannel$p(FastCgiService $this) {
        return $this.getProcessChannel();
    }

    public static final /* synthetic */ void access$handleError(FastCgiService $this, FastCgiRequest fastCgiRequest, ByteBuf content2) {
        $this.handleError(fastCgiRequest, content2);
    }
}

