/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.XSourcePositionWrapper;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XKeywordValuePresentation;
import com.intellij.xdebugger.frame.presentation.XStringValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.concurrency.ValueNodeAsyncFunction;
import org.jetbrains.debugger.ArrayPresentation;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.FunctionScopesValueGroup;
import org.jetbrains.debugger.LazyVariablesGroupKt;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.ObjectProperty;
import org.jetbrains.debugger.ObjectValuePresentation;
import org.jetbrains.debugger.PresentationProvider;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptDebuggerBundle;
import org.jetbrains.debugger.ScriptManager;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariableView$Companion$WhenMappings;
import org.jetbrains.debugger.VariableView$WhenMappings;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.VariablesKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ArrayValue;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.IndexedVariablesConsumer;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.StringValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 U2\u00020\u00012\u00020\u0002:\u0003UVWB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ(\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040/2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u00100\u001a\u00020\u0004H\u0002J\b\u00101\u001a\u000202H\u0016J\u001e\u00103\u001a\u00020-2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020-2\u0006\u00105\u001a\u000206H\u0016J\u0018\u00107\u001a\u00020-2\u0006\u00108\u001a\u0002092\u0006\u00105\u001a\u000206H\u0002J$\u0010:\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010 \u001a\u00020;2\u0006\u00105\u001a\u0002062\u0006\u0010<\u001a\u000202H\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J&\u0010A\u001a\b\u0012\u0004\u0012\u00020-0\u00142\u0006\u0010 \u001a\u00020B2\u0006\u00105\u001a\u0002062\u0006\u0010<\u001a\u000202H\u0002J\u0018\u0010C\u001a\u00020-2\u0006\u00105\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0016J\u0018\u0010C\u001a\u00020-2\u0006\u0010 \u001a\u00020!2\u0006\u00105\u001a\u00020DH\u0002J\u0010\u0010G\u001a\u00020-2\u0006\u0010H\u001a\u00020IH\u0016J\n\u0010J\u001a\u0004\u0018\u00010\u0004H\u0016J\n\u0010K\u001a\u0004\u0018\u00010LH\u0016J\b\u0010M\u001a\u0004\u0018\u00010!JF\u0010N\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u001b2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u00105\u001a\u0002062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010P\u001a\u0002092\u0006\u0010Q\u001a\u000202H\u0002J$\u0010R\u001a\u00020-2\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010S\u001a\u0004\u0018\u00010\u00042\u0006\u00105\u001a\u00020DH\u0002J\b\u0010T\u001a\u000202H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0016\u0010(\u001a\u0004\u0018\u00010)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006X"}, d2={"Lorg/jetbrains/debugger/VariableView;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "Lorg/jetbrains/debugger/VariableContext;", "variableName", "", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "(Ljava/lang/String;Lorg/jetbrains/debugger/Variable;Lorg/jetbrains/debugger/VariableContext;)V", "_memberFilter", "Lorg/jetbrains/debugger/MemberFilter;", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getEvaluateContext", "()Lorg/jetbrains/debugger/EvaluateContext;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "memberFilter", "Lorg/jetbrains/concurrency/Promise;", "getMemberFilter", "()Lorg/jetbrains/concurrency/Promise;", "parent", "getParent", "()Lorg/jetbrains/debugger/VariableContext;", "remainingChildren", "", "scope", "Lorg/jetbrains/debugger/Scope;", "getScope", "()Lorg/jetbrains/debugger/Scope;", "value", "Lorg/jetbrains/debugger/values/Value;", "getVariableName", "()Ljava/lang/String;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "getViewSupport", "()Lorg/jetbrains/debugger/DebuggerViewSupport;", "vm", "Lorg/jetbrains/debugger/Vm;", "getVm", "()Lorg/jetbrains/debugger/Vm;", "addVarName", "", "list", "Lcom/intellij/util/SmartList;", "name", "canNavigateToSource", "", "computeArrayRanges", "properties", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "computeChildren", "remainingChildrenOffset", "", "computeIndexedProperties", "Lorg/jetbrains/debugger/values/ArrayValue;", "isLastChildren", "computeInlineDebuggerData", "Lcom/intellij/util/ThreeState;", "callback", "Lcom/intellij/xdebugger/frame/XInlineDebuggerDataCallback;", "computeNamedProperties", "Lorg/jetbrains/debugger/values/ObjectValue;", "computePresentation", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "computeSourcePosition", "navigatable", "Lcom/intellij/xdebugger/frame/XNavigatable;", "getEvaluationExpression", "getModifier", "Lcom/intellij/xdebugger/frame/XValueModifier;", "getValue", "processNamedObjectProperties", "variables", "maxChildrenToAdd", "defaultIsLast", "setEvaluatedValue", "error", "watchableAsEvaluationExpression", "Companion", "MyFullValueEvaluator", "ObsolescentIndexedVariablesConsumer", "intellij.platform.scriptDebugger.ui"})
public final class VariableView
extends XNamedValue
implements VariableContext {
    private volatile Value value;
    private MemberFilter _memberFilter;
    private volatile List<? extends Variable> remainingChildren;
    @NotNull
    private final VariableContext parent;
    @NotNull
    private final String variableName;
    private final Variable variable;
    private final VariableContext context;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean watchableAsEvaluationExpression() {
        return this.context.watchableAsEvaluationExpression();
    }

    @Override
    @NotNull
    public DebuggerViewSupport getViewSupport() {
        return this.context.getViewSupport();
    }

    @Override
    @NotNull
    public VariableContext getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter() {
        return this.context.getViewSupport().getMemberFilter(this);
    }

    @Override
    @NotNull
    public EvaluateContext getEvaluateContext() {
        return this.context.getEvaluateContext();
    }

    @Override
    @Nullable
    public Scope getScope() {
        return this.context.getScope();
    }

    @Override
    @Nullable
    public Vm getVm() {
        return this.context.getVm();
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        this.value = this.variable.getValue();
        if (this.value != null) {
            Value value2 = this.value;
            Intrinsics.checkNotNull((Object)value2);
            this.computePresentation(value2, node);
            return;
        }
        if (!(this.variable instanceof ObjectProperty) || ((ObjectProperty)this.variable).getGetter() == null) {
            this.context.getMemberFilter().then(new Function(this, node){
                final /* synthetic */ VariableView this$0;
                final /* synthetic */ XValueNode $node;

                /*
                 * WARNING - void declaration
                 */
                public final Promise<? extends Object> fun(MemberFilter filter) {
                    void $this$onError$iv;
                    Promise $this$onSuccess$iv;
                    EvaluateContext evaluateContext2 = this.this$0.getEvaluateContext();
                    String string = VariableView.access$getVariable$p(this.this$0).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variable.name");
                    String string2 = filter.sourceNameToRaw(string);
                    if (string2 == null) {
                        String string3 = VariableView.access$getVariable$p(this.this$0).getName();
                        string2 = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"variable.name");
                    }
                    Promise promise = EvaluateContext.DefaultImpls.evaluate$default(evaluateContext2, string2, null, false, null, 14, null);
                    Obsolescent node$iv = (Obsolescent)this.$node;
                    boolean $i$f$onSuccess = false;
                    Promise promise2 = $this$onSuccess$iv.onSuccess((Consumer)new ObsolescentConsumer<EvaluateResult>(node$iv, node$iv, this){
                        final /* synthetic */ Obsolescent $node;
                        final /* synthetic */ computePresentation.1 this$0;
                        {
                            this.$node = $captured_local_variable$1;
                            this.this$0 = var3_3;
                            super($super_call_param$2);
                        }

                        /*
                         * Ignored method signature, as it can't be verified against descriptor
                         */
                        public void accept(Object param) {
                            EvaluateResult it = (EvaluateResult)param;
                            boolean bl = false;
                            if (it.getWasThrown()) {
                                VariableView.access$setEvaluatedValue(this.this$0.this$0, this.this$0.this$0.getViewSupport().transformErrorOnGetUsedReferenceValue(it.getValue(), null), null, this.this$0.$node);
                            } else {
                                VariableView.access$setValue$p(this.this$0.this$0, it.getValue());
                                VariableView.access$getVariable$p(this.this$0.this$0).setValue(it.getValue());
                                VariableView.access$computePresentation(this.this$0.this$0, it.getValue(), this.this$0.$node);
                            }
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"onSuccess(object : Obsol\u2026m: T) = handler(param)\n})");
                    $this$onSuccess$iv = promise2;
                    node$iv = (Obsolescent)this.$node;
                    boolean $i$f$onError = false;
                    Promise promise3 = $this$onError$iv.onError((Consumer)new ObsolescentConsumer<Throwable>(node$iv, node$iv, this){
                        final /* synthetic */ Obsolescent $node;
                        final /* synthetic */ computePresentation.1 this$0;
                        {
                            this.$node = $captured_local_variable$1;
                            this.this$0 = var3_3;
                            super($super_call_param$2);
                        }

                        public void accept(@NotNull Throwable param) {
                            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                            Throwable it = param;
                            boolean bl = false;
                            VariableView.access$setEvaluatedValue(this.this$0.this$0, this.this$0.this$0.getViewSupport().transformErrorOnGetUsedReferenceValue(null, it.getMessage()), it.getMessage(), this.this$0.$node);
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"onError(object : Obsoles\u2026able) = handler(param)\n})");
                    return promise3;
                }
                {
                    this.this$0 = variableView;
                    this.$node = xValueNode;
                }
            });
            return;
        }
        node.setPresentation(null, new XValuePresentation(){

            public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
                renderer.renderValue("\u2026");
            }
        }, false);
        node.setFullValueEvaluator(new XFullValueEvaluator(this, node, ScriptDebuggerBundle.message("full.evaluator.invoke.getter", new Object[0])){
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ XValueNode $node;

            /*
             * WARNING - void declaration
             */
            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback2) {
                void $this$onSuccess$iv;
                Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
                ValueModifier valueModifier = ((ObjectProperty)VariableView.access$getVariable$p(this.this$0)).getValueModifier();
                VariableContext nonProtoContext = VariableView.access$getContext$p(this.this$0);
                while (nonProtoContext instanceof VariableView && Intrinsics.areEqual((Object)((VariableView)nonProtoContext).getVariableName(), (Object)"__proto__")) {
                    valueModifier = VariableView.access$getVariable$p((VariableView)nonProtoContext).getValueModifier();
                    nonProtoContext = ((VariableView)nonProtoContext).getParent();
                }
                ValueModifier valueModifier2 = valueModifier;
                Intrinsics.checkNotNull((Object)valueModifier2);
                Promise<Value> promise = valueModifier2.evaluateGet(VariableView.access$getVariable$p(this.this$0), this.this$0.getEvaluateContext());
                Obsolescent node$iv = (Obsolescent)this.$node;
                boolean $i$f$onSuccess = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$onSuccess$iv.onSuccess((Consumer)new ObsolescentConsumer<Value>(node$iv, node$iv, this, callback2){
                    final /* synthetic */ Obsolescent $node;
                    final /* synthetic */ computePresentation.3 this$0;
                    final /* synthetic */ XFullValueEvaluator.XFullValueEvaluationCallback $callback$inlined;
                    {
                        this.$node = $captured_local_variable$1;
                        this.this$0 = var3_3;
                        this.$callback$inlined = xFullValueEvaluationCallback;
                        super($super_call_param$2);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public void accept(Object param) {
                        Value it = (Value)param;
                        boolean bl = false;
                        this.$callback$inlined.evaluated("");
                        VariableView.access$setEvaluatedValue(this.this$0.this$0, it, null, this.this$0.$node);
                    }
                }), (String)"onSuccess(object : Obsol\u2026m: T) = handler(param)\n})");
            }
            {
                this.this$0 = this$0;
                this.$node = $captured_local_variable$1;
                super($super_call_param$2);
            }
        }.setShowValuePopup(false));
    }

    private final void setEvaluatedValue(Value value2, String error2, XValueNode node) {
        if (value2 == null) {
            String string = error2;
            if (string == null) {
                string = "Internal Error";
            }
            node.setPresentation(AllIcons.Debugger.Db_primitive, null, string, false);
        } else {
            this.value = value2;
            this.computePresentation(value2, node);
        }
    }

    private final void computePresentation(Value value2, XValueNode node) {
        if (this.variable instanceof ObjectProperty && Intrinsics.areEqual((Object)((ObjectProperty)this.variable).getName(), (Object)"__proto__")) {
            Value value3 = value2;
            if (value3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.debugger.values.ObjectValue");
            }
            Companion.setObjectPresentation((ObjectValue)value3, this.getIcon(), node);
            return;
        }
        switch (VariableView$WhenMappings.$EnumSwitchMapping$0[value2.getType().ordinal()]) {
            case 1: 
            case 2: {
                Value value4 = value2;
                if (value4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.debugger.values.ObjectValue");
                }
                this.context.getViewSupport().computeObjectPresentation((ObjectValue)value4, this.variable, this.context, node, this.getIcon());
                break;
            }
            case 3: {
                node.setPresentation(this.getIcon(), (XValuePresentation)new ObjectValuePresentation(VariableViewKt.trimFunctionDescription(value2)), true);
                break;
            }
            case 4: {
                this.context.getViewSupport().computeArrayPresentation(value2, this.variable, this.context, node, this.getIcon());
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                Icon icon2 = this.getIcon();
                String string = value2.getValueString();
                Intrinsics.checkNotNull((Object)string);
                node.setPresentation(icon2, (XValuePresentation)new XKeywordValuePresentation(string), false);
                break;
            }
            case 8: 
            case 9: {
                Icon icon3 = this.getIcon();
                String string = value2.getValueString();
                Intrinsics.checkNotNull((Object)string);
                node.setPresentation(icon3, VariableViewKt.access$createNumberPresentation(string), false);
                break;
            }
            case 10: {
                Icon icon4 = this.getIcon();
                String string = value2.getValueString();
                Intrinsics.checkNotNull((Object)string);
                node.setPresentation(icon4, (XValuePresentation)new XStringValuePresentation(string), false);
                if (!(value2 instanceof StringValue) || !((StringValue)value2).isTruncated()) {
                    String string2 = value2.getValueString();
                    Intrinsics.checkNotNull((Object)string2);
                    if (string2.length() <= 1000) break;
                }
                node.setFullValueEvaluator((XFullValueEvaluator)new MyFullValueEvaluator(value2));
                break;
            }
            default: {
                Icon icon5 = this.getIcon();
                String string = value2.getValueString();
                Intrinsics.checkNotNull((Object)string);
                node.setPresentation(icon5, null, string, true);
            }
        }
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.computeChildren(0, node);
    }

    private final void computeChildren(int remainingChildrenOffset, XCompositeNode node) {
        node.setAlreadySorted(true);
        if (!(this.value instanceof ObjectValue)) {
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        if (remainingChildrenOffset > 0) {
            List<? extends Variable> list2 = this.remainingChildren;
            Intrinsics.checkNotNull(list2);
            List<? extends Variable> list3 = list2;
            int to = RangesKt.coerceAtMost((int)(remainingChildrenOffset + 100), (int)list3.size());
            boolean isLast = to == list3.size();
            node.addChildren(VariablesKt.createVariablesList(list3, remainingChildrenOffset, to, this, this._memberFilter), isLast);
            if (!isLast) {
                node.tooManyChildren(list3.size() - to, new Runnable(this, remainingChildrenOffset, node){
                    final /* synthetic */ VariableView this$0;
                    final /* synthetic */ int $remainingChildrenOffset;
                    final /* synthetic */ XCompositeNode $node;

                    public final void run() {
                        VariableView.access$computeChildren(this.this$0, this.$remainingChildrenOffset + 100, this.$node);
                    }
                    {
                        this.this$0 = variableView;
                        this.$remainingChildrenOffset = n;
                        this.$node = xCompositeNode;
                    }
                });
            }
            return;
        }
        Value value2 = this.value;
        if (value2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.debugger.values.ObjectValue");
        }
        ObjectValue objectValue = (ObjectValue)value2;
        boolean hasNamedProperties = objectValue.hasProperties() != ThreeState.NO;
        boolean hasIndexedProperties = objectValue.hasIndexedProperties() != ThreeState.NO;
        SmartList promises = new SmartList();
        Promise<Object> additionalProperties = this.getViewSupport().computeAdditionalObjectProperties(objectValue, this.variable, this, node);
        if (additionalProperties != null) {
            promises.add(additionalProperties);
        }
        if (hasIndexedProperties) {
            ObjectValue objectValue2 = objectValue;
            if (objectValue2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.debugger.values.ArrayValue");
            }
            promises.add(this.computeIndexedProperties((ArrayValue)objectValue2, node, !hasNamedProperties && additionalProperties == null));
        }
        if (hasNamedProperties) {
            if (additionalProperties == null || additionalProperties.getState() != Promise.State.PENDING) {
                promises.add(this.computeNamedProperties(objectValue, node, !hasIndexedProperties && additionalProperties == null));
            } else {
                Promise<Object> $this$thenAsync$iv = additionalProperties;
                boolean $i$f$thenAsync = false;
                Promise promise = $this$thenAsync$iv.thenAsync((Function)new ValueNodeAsyncFunction<Object, Unit>((Obsolescent)node, (Obsolescent)node, this, objectValue, node){
                    final /* synthetic */ Obsolescent $node;
                    final /* synthetic */ VariableView this$0;
                    final /* synthetic */ ObjectValue $objectValue$inlined;
                    final /* synthetic */ XCompositeNode $node$inlined;
                    {
                        this.$node = $captured_local_variable$1;
                        this.this$0 = variableView;
                        this.$objectValue$inlined = objectValue;
                        this.$node$inlined = xCompositeNode;
                        super($super_call_param$2);
                    }

                    @NotNull
                    public Promise<Unit> fun(Object param) {
                        Object it = param;
                        boolean bl = false;
                        return VariableView.access$computeNamedProperties(this.this$0, this.$objectValue$inlined, this.$node$inlined, true);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"thenAsync(object : Value\u2026m: T) = handler(param)\n})");
                promises.add((Object)promise);
            }
        }
        if (hasIndexedProperties == hasNamedProperties || additionalProperties != null) {
            Promise $this$processed$iv = Promises.all((Collection)((Collection)promises));
            boolean $i$f$processed = false;
            $this$processed$iv.onProcessed((Consumer)new ObsolescentConsumer<Object>((Obsolescent)node, (Obsolescent)node, node){
                final /* synthetic */ Obsolescent $node;
                final /* synthetic */ XCompositeNode $node$inlined;
                {
                    this.$node = $captured_local_variable$1;
                    this.$node$inlined = xCompositeNode;
                    super($super_call_param$2);
                }

                public void accept(@Nullable Object param) {
                    boolean bl = false;
                    this.$node$inlined.addChildren(XValueChildrenList.EMPTY, true);
                }
            });
        }
    }

    private final Promise<?> computeIndexedProperties(ArrayValue value2, XCompositeNode node, boolean isLastChildren) {
        return ObjectValue.DefaultImpls.getIndexedProperties$default(value2, 0, value2.getLength(), 100, new ObsolescentIndexedVariablesConsumer(this, value2, node, isLastChildren, node){
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ ArrayValue $value;
            final /* synthetic */ XCompositeNode $node;
            final /* synthetic */ boolean $isLastChildren;

            public void consumeRanges(@Nullable int[] ranges) {
                if (ranges == null) {
                    XValueChildrenList groupList = new XValueChildrenList();
                    LazyVariablesGroupKt.addGroups(this.$value, computeIndexedProperties.consumeRanges.1.INSTANCE, groupList, 0, this.$value.getLength(), 100, this.this$0);
                    this.$node.addChildren(groupList, this.$isLastChildren);
                } else {
                    LazyVariablesGroupKt.addRanges(this.$value, ranges, this.$node, this.this$0, this.$isLastChildren);
                }
            }

            public void consumeVariables(@NotNull List<? extends Variable> variables) {
                Intrinsics.checkNotNullParameter(variables, (String)"variables");
                this.$node.addChildren(VariablesKt.createVariablesList(variables, this.this$0, null), this.$isLastChildren);
            }
            {
                this.this$0 = this$0;
                this.$value = $captured_local_variable$1;
                this.$node = $captured_local_variable$2;
                this.$isLastChildren = $captured_local_variable$3;
                super($super_call_param$4);
            }
        }, null, 16, null);
    }

    private final Promise<Unit> computeNamedProperties(ObjectValue value2, XCompositeNode node, boolean isLastChildren) {
        return VariablesKt.processVariables(this, value2.getProperties(), (Obsolescent)node, (Function2<? super MemberFilter, ? super List<? extends Variable>, Unit>)((Function2)new Function2<MemberFilter, List<? extends Variable>, Unit>(this, value2, node, isLastChildren){
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ ObjectValue $value;
            final /* synthetic */ XCompositeNode $node;
            final /* synthetic */ boolean $isLastChildren;

            public final void invoke(@NotNull MemberFilter memberFilter, @NotNull List<? extends Variable> variables) {
                FunctionValue functionValue;
                Intrinsics.checkNotNullParameter((Object)memberFilter, (String)"memberFilter");
                Intrinsics.checkNotNullParameter(variables, (String)"variables");
                VariableView.access$set_memberFilter$p(this.this$0, memberFilter);
                if (this.$value.getType() == ValueType.ARRAY && !(this.$value instanceof ArrayValue)) {
                    VariableView.access$computeArrayRanges(this.this$0, variables, this.$node);
                    return;
                }
                ObjectValue objectValue = this.$value;
                if (!(objectValue instanceof FunctionValue)) {
                    objectValue = null;
                }
                if ((functionValue = (FunctionValue)objectValue) != null && functionValue.hasScopes() == ThreeState.NO) {
                    functionValue = null;
                }
                VariableView.access$setRemainingChildren$p(this.this$0, VariableView.access$processNamedObjectProperties(this.this$0, variables, this.$node, this.this$0, memberFilter, 100, this.$isLastChildren && functionValue == null));
                if (functionValue != null) {
                    this.$node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)new FunctionScopesValueGroup(functionValue, VariableView.access$getContext$p(this.this$0))), this.$isLastChildren && VariableView.access$getRemainingChildren$p(this.this$0) == null);
                }
            }
            {
                this.this$0 = variableView;
                this.$value = objectValue;
                this.$node = xCompositeNode;
                this.$isLastChildren = bl;
                super(2);
            }
        }));
    }

    private final List<Variable> processNamedObjectProperties(List<? extends Variable> variables, XCompositeNode node, VariableContext context2, MemberFilter memberFilter, int maxChildrenToAdd, boolean defaultIsLast) {
        List<Variable> list2 = VariablesKt.filterAndSort(variables, memberFilter);
        if (list2.isEmpty()) {
            if (defaultIsLast) {
                node.addChildren(XValueChildrenList.EMPTY, true);
            }
            return null;
        }
        int to = RangesKt.coerceAtMost((int)maxChildrenToAdd, (int)list2.size());
        boolean isLast = to == list2.size();
        node.addChildren(VariablesKt.createVariablesList(list2, 0, to, context2, memberFilter), defaultIsLast && isLast);
        if (isLast) {
            return null;
        }
        node.tooManyChildren(list2.size() - to, new Runnable(this, node){
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ XCompositeNode $node;

            public final void run() {
                VariableView.access$computeChildren(this.this$0, 100, this.$node);
            }
            {
                this.this$0 = variableView;
                this.$node = xCompositeNode;
            }
        });
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final void computeArrayRanges(List<? extends Variable> properties, XCompositeNode node) {
        int count;
        MemberFilter memberFilter = this._memberFilter;
        Intrinsics.checkNotNull((Object)memberFilter);
        List<Variable> variables = VariablesKt.filterAndSort(properties, memberFilter);
        int bucketSize = 100;
        if (count <= bucketSize) {
            node.addChildren(VariablesKt.createVariablesList(variables, this, null), true);
            return;
        }
        for (count = variables.size(); count > 0 && !Character.isDigit(variables.get(count - 1).getName().charAt(0)); --count) {
        }
        XValueChildrenList groupList = new XValueChildrenList();
        if (count > 0) {
            LazyVariablesGroupKt.addGroups(variables, computeArrayRanges.1.INSTANCE, groupList, 0, count, bucketSize, this);
        }
        int notGroupedVariablesOffset = 0;
        if (variables.size() - count > bucketSize) {
            for (notGroupedVariablesOffset = variables.size(); notGroupedVariablesOffset > 0; --notGroupedVariablesOffset) {
                String string = variables.get(notGroupedVariablesOffset - 1).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variables[notGroupedVariablesOffset - 1].name");
                if (!StringsKt.startsWith$default((String)string, (String)"__", (boolean)false, (int)2, null)) break;
            }
            if (notGroupedVariablesOffset > 0) {
                LazyVariablesGroupKt.addGroups(variables, computeArrayRanges.2.INSTANCE, groupList, count, notGroupedVariablesOffset, bucketSize, this);
            }
        } else {
            notGroupedVariablesOffset = count;
        }
        int n = notGroupedVariablesOffset;
        int n2 = variables.size();
        while (n < n2) {
            void i2;
            Variable variable = variables.get((int)i2);
            MemberFilter memberFilter2 = this._memberFilter;
            Intrinsics.checkNotNull((Object)memberFilter2);
            groupList.add((XNamedValue)new VariableView(memberFilter2.rawNameToSource(variable), variable, this));
            ++i2;
        }
        node.addChildren(groupList, true);
    }

    private final Icon getIcon() {
        Value value2 = this.value;
        Intrinsics.checkNotNull((Object)value2);
        return Companion.getIcon(value2);
    }

    @Nullable
    public XValueModifier getModifier() {
        if (!this.variable.isMutable()) {
            return null;
        }
        return new XValueModifier(this){
            final /* synthetic */ VariableView this$0;

            @Nullable
            public String getInitialValueEditorText() {
                String string;
                Value value2 = VariableView.access$getValue$p(this.this$0);
                Intrinsics.checkNotNull((Object)value2);
                if (value2.getType() == ValueType.STRING) {
                    Value value3 = VariableView.access$getValue$p(this.this$0);
                    Intrinsics.checkNotNull((Object)value3);
                    String string2 = value3.getValueString();
                    Intrinsics.checkNotNull((Object)string2);
                    String string3 = string2;
                    StringBuilder builder2 = new StringBuilder(string3.length());
                    builder2.append('\"');
                    StringUtil.escapeStringCharacters((int)string3.length(), (String)string3, (StringBuilder)builder2);
                    builder2.append('\"');
                    return builder2.toString();
                }
                Value value4 = VariableView.access$getValue$p(this.this$0);
                Intrinsics.checkNotNull((Object)value4);
                if (value4.getType().isObjectType()) {
                    string = null;
                } else {
                    Value value5 = VariableView.access$getValue$p(this.this$0);
                    Intrinsics.checkNotNull((Object)value5);
                    string = value5.getValueString();
                }
                return string;
            }

            public void setValue(@NotNull XExpression expression, @NotNull XValueModifier.XModificationCallback callback2) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
                ValueModifier valueModifier = VariableView.access$getVariable$p(this.this$0).getValueModifier();
                Intrinsics.checkNotNull((Object)valueModifier);
                Variable variable = VariableView.access$getVariable$p(this.this$0);
                String string = expression.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expression.expression");
                valueModifier.setValue(variable, string, this.this$0.getEvaluateContext()).onSuccess(new Consumer(this, callback2){
                    final /* synthetic */ getModifier.1 this$0;
                    final /* synthetic */ XValueModifier.XModificationCallback $callback;

                    public final void accept(Object it) {
                        VariableView.access$setValue$p(this.this$0.this$0, null);
                        this.$callback.valueModified();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$callback = xModificationCallback;
                    }
                }).onError(new Consumer(callback2){
                    final /* synthetic */ XValueModifier.XModificationCallback $callback;

                    public final void accept(Throwable it) {
                        String string = it.getMessage();
                        Intrinsics.checkNotNull((Object)string);
                        this.$callback.errorOccurred(string);
                    }
                    {
                        this.$callback = xModificationCallback;
                    }
                });
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    @Nullable
    public final Value getValue() {
        return this.variable.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canNavigateToSource() {
        if (this.value instanceof FunctionValue) {
            Value value2 = this.value;
            Object object = value2;
            if (value2 == null) return true;
            String string = object.getValueString();
            object = string;
            if (string == null) return true;
            if (!StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"[native code]", (boolean)false, (int)2, null)) return true;
        }
        if (!this.getViewSupport().canNavigateToSource(this.variable, this.context)) return false;
        return true;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        if (this.value instanceof FunctionValue) {
            Value value2 = this.value;
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.debugger.values.FunctionValue");
            }
            Intrinsics.checkNotNullExpressionValue((Object)((FunctionValue)value2).resolve().onSuccess(new Consumer(this, navigatable){
                final /* synthetic */ VariableView this$0;
                final /* synthetic */ XNavigatable $navigatable;

                public final void accept(FunctionValue function) {
                    Vm vm = this.this$0.getVm();
                    Intrinsics.checkNotNull((Object)vm);
                    ScriptManager scriptManager = vm.getScriptManager();
                    FunctionValue functionValue = function;
                    Intrinsics.checkNotNullExpressionValue((Object)functionValue, (String)"function");
                    scriptManager.getScript(functionValue).onSuccess(new Consumer(this, function){
                        final /* synthetic */ computeSourcePosition.1 this$0;
                        final /* synthetic */ FunctionValue $function;

                        /*
                         * Unable to fully structure code
                         * Could not resolve type clashes
                         */
                        public final void accept(Script script) {
                            v0 = this.this$0.$navigatable;
                            v1 = script;
                            if (v1 == null) ** GOTO lbl-1000
                            var2_2 = v1;
                            var3_3 = false;
                            var4_4 = false;
                            var5_5 = var2_2;
                            var7_6 = v0;
                            $i$a$-let-VariableView$computeSourcePosition$1$1$1 = false;
                            v2 = this.this$0.this$0.getViewSupport();
                            v3 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                            var8_8 /* !! */  = v2.getSourceInfo(null, (Script)v3, this.$function.getOpenParenLine(), this.$function.getOpenParenColumn());
                            v0 = var7_6;
                            v1 = var8_8 /* !! */ ;
                            if (v1 != null) {
                                var2_2 = v1;
                                var3_3 = false;
                                var4_4 = false;
                                it = var2_2;
                                var7_6 = v0;
                                $i$a$-let-VariableView$computeSourcePosition$1$1$2 = false;
                                var8_8 /* !! */  = new XSourcePositionWrapper((SourceInfo)it, (XSourcePosition)it){
                                    final /* synthetic */ SourceInfo $it;

                                    @NotNull
                                    public Navigatable createNavigatable(@NotNull Project project) {
                                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                                        Navigatable navigatable = (Navigatable)PsiVisitors.visit(this.myPosition, project, computeSourcePosition.2.createNavigatable.1.INSTANCE);
                                        if (navigatable == null) {
                                            Navigatable navigatable2 = super.createNavigatable(project);
                                            navigatable = navigatable2;
                                            Intrinsics.checkNotNullExpressionValue((Object)navigatable2, (String)"super.createNavigatable(project)");
                                        }
                                        return navigatable;
                                    }
                                    {
                                        this.$it = $captured_local_variable$0;
                                        super($super_call_param$1);
                                    }
                                };
                                v0 = var7_6;
                                v4 /* !! */  = var8_8 /* !! */ ;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v4 /* !! */  = null;
                            }
                            v0.setSourcePosition((XSourcePosition)v4 /* !! */ );
                        }
                        {
                            this.this$0 = var1_1;
                            this.$function = functionValue;
                        }
                    });
                }
                {
                    this.this$0 = variableView;
                    this.$navigatable = xNavigatable;
                }
            }), (String)"(value as FunctionValue)\u2026)\n            }\n        }");
        } else {
            DebuggerViewSupport debuggerViewSupport = this.getViewSupport();
            String string = this.getVariableName();
            Value value3 = this.value;
            Intrinsics.checkNotNull((Object)value3);
            debuggerViewSupport.computeSourcePosition(string, value3, this.variable, this.context, navigatable);
        }
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        return this.getViewSupport().computeInlineDebuggerData(this.getVariableName(), this.variable, this.context, callback2);
    }

    @Nullable
    public String getEvaluationExpression() {
        if (!this.watchableAsEvaluationExpression()) {
            return null;
        }
        if (this.context.getVariableName() == null) {
            return this.variable.getName();
        }
        SmartList list2 = new SmartList();
        VariableContext variableContext = this.getParent();
        String string = this.variable.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variable.name");
        this.addVarName((SmartList<String>)list2, variableContext, string);
        VariableContext parent = this.context;
        while (true) {
            VariableContext variableContext2 = parent;
            if ((variableContext2 != null ? variableContext2.getVariableName() : null) == null) break;
            VariableContext variableContext3 = parent.getParent();
            String string2 = parent.getVariableName();
            Intrinsics.checkNotNull((Object)string2);
            this.addVarName((SmartList<String>)list2, variableContext3, string2);
            parent = parent.getParent();
        }
        return this.context.getViewSupport().propertyNamesToString((List)list2, false);
    }

    private final void addVarName(SmartList<String> list2, VariableContext parent, String name) {
        if (parent == null || parent.getVariableName() != null) {
            list2.add((Object)name);
        } else {
            list2.addAll((Collection)CollectionsKt.reversed((Iterable)StringsKt.split$default((CharSequence)name, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null)));
        }
    }

    @Override
    @NotNull
    public String getVariableName() {
        return this.variableName;
    }

    public VariableView(@NotNull String variableName, @NotNull Variable variable, @NotNull VariableContext context2) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(variableName);
        this.variableName = variableName;
        this.variable = variable;
        this.parent = this.context = context2;
    }

    public static final /* synthetic */ Variable access$getVariable$p(VariableView $this) {
        return $this.variable;
    }

    public static final /* synthetic */ void access$setEvaluatedValue(VariableView $this, Value value2, String error2, XValueNode node) {
        $this.setEvaluatedValue(value2, error2, node);
    }

    public static final /* synthetic */ Value access$getValue$p(VariableView $this) {
        return $this.value;
    }

    public static final /* synthetic */ void access$setValue$p(VariableView $this, Value value2) {
        $this.value = value2;
    }

    public static final /* synthetic */ void access$computePresentation(VariableView $this, Value value2, XValueNode node) {
        $this.computePresentation(value2, node);
    }

    public static final /* synthetic */ VariableContext access$getContext$p(VariableView $this) {
        return $this.context;
    }

    public static final /* synthetic */ void access$computeChildren(VariableView $this, int remainingChildrenOffset, XCompositeNode node) {
        $this.computeChildren(remainingChildrenOffset, node);
    }

    public static final /* synthetic */ Promise access$computeNamedProperties(VariableView $this, ObjectValue value2, XCompositeNode node, boolean isLastChildren) {
        return $this.computeNamedProperties(value2, node, isLastChildren);
    }

    public static final /* synthetic */ MemberFilter access$get_memberFilter$p(VariableView $this) {
        return $this._memberFilter;
    }

    public static final /* synthetic */ void access$set_memberFilter$p(VariableView $this, MemberFilter memberFilter) {
        $this._memberFilter = memberFilter;
    }

    public static final /* synthetic */ void access$computeArrayRanges(VariableView $this, List properties, XCompositeNode node) {
        $this.computeArrayRanges(properties, node);
    }

    public static final /* synthetic */ List access$getRemainingChildren$p(VariableView $this) {
        return $this.remainingChildren;
    }

    public static final /* synthetic */ void access$setRemainingChildren$p(VariableView $this, List list2) {
        $this.remainingChildren = list2;
    }

    public static final /* synthetic */ List access$processNamedObjectProperties(VariableView $this, List variables, XCompositeNode node, VariableContext context2, MemberFilter memberFilter, int maxChildrenToAdd, boolean defaultIsLast) {
        return $this.processNamedObjectProperties(variables, node, context2, memberFilter, maxChildrenToAdd, defaultIsLast);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/debugger/VariableView$ObsolescentIndexedVariablesConsumer;", "Lorg/jetbrains/debugger/values/IndexedVariablesConsumer;", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "(Lcom/intellij/xdebugger/frame/XCompositeNode;)V", "isObsolete", "", "()Z", "getNode", "()Lcom/intellij/xdebugger/frame/XCompositeNode;", "intellij.platform.scriptDebugger.ui"})
    public static abstract class ObsolescentIndexedVariablesConsumer
    extends IndexedVariablesConsumer {
        @NotNull
        private final XCompositeNode node;

        @Override
        public boolean isObsolete() {
            return this.node.isObsolete();
        }

        @NotNull
        protected final XCompositeNode getNode() {
            return this.node;
        }

        public ObsolescentIndexedVariablesConsumer(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.node = node;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/debugger/VariableView$MyFullValueEvaluator;", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator;", "value", "Lorg/jetbrains/debugger/values/Value;", "(Lorg/jetbrains/debugger/values/Value;)V", "startEvaluation", "", "callback", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator$XFullValueEvaluationCallback;", "intellij.platform.scriptDebugger.ui"})
    private static final class MyFullValueEvaluator
    extends XFullValueEvaluator {
        private final Value value;

        public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback2) {
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            if (!(this.value instanceof StringValue) || !((StringValue)this.value).isTruncated()) {
                String string = this.value.getValueString();
                Intrinsics.checkNotNull((Object)string);
                callback2.evaluated(string);
                return;
            }
            AtomicBoolean evaluated = new AtomicBoolean();
            ((StringValue)this.value).getFullString().onSuccess(new Consumer(this, callback2, evaluated){
                final /* synthetic */ MyFullValueEvaluator this$0;
                final /* synthetic */ XFullValueEvaluator.XFullValueEvaluationCallback $callback;
                final /* synthetic */ AtomicBoolean $evaluated;

                public final void accept(String it) {
                    if (!this.$callback.isObsolete() && this.$evaluated.compareAndSet(false, true)) {
                        String string = MyFullValueEvaluator.access$getValue$p(this.this$0).getValueString();
                        Intrinsics.checkNotNull((Object)string);
                        this.$callback.evaluated(string);
                    }
                }
                {
                    this.this$0 = myFullValueEvaluator;
                    this.$callback = xFullValueEvaluationCallback;
                    this.$evaluated = atomicBoolean;
                }
            }).onError(new Consumer(callback2){
                final /* synthetic */ XFullValueEvaluator.XFullValueEvaluationCallback $callback;

                public final void accept(Throwable it) {
                    String string = it.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    this.$callback.errorOccurred(string);
                }
                {
                    this.$callback = xFullValueEvaluationCallback;
                }
            });
        }

        public MyFullValueEvaluator(@NotNull Value value2) {
            int n;
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            if (value2 instanceof StringValue) {
                n = ((StringValue)value2).getLength();
            } else {
                String string = value2.getValueString();
                Intrinsics.checkNotNull((Object)string);
                n = string.length();
            }
            super(n);
            this.value = value2;
        }

        public static final /* synthetic */ Value access$getValue$p(MyFullValueEvaluator $this) {
            return $this.value;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/debugger/VariableView$Companion;", "", "()V", "getIcon", "Ljavax/swing/Icon;", "value", "Lorg/jetbrains/debugger/values/Value;", "setArrayPresentation", "", "context", "Lorg/jetbrains/debugger/VariableContext;", "icon", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "setObjectPresentation", "Lorg/jetbrains/debugger/values/ObjectValue;", "intellij.platform.scriptDebugger.ui"})
    public static final class Companion {
        public final void setObjectPresentation(@NotNull ObjectValue value2, @NotNull Icon icon2, @NotNull XValueNode node) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            node.setPresentation(icon2, (XValuePresentation)new ObjectValuePresentation(VariableViewKt.getObjectValueDescription(value2)), value2.hasProperties() != ThreeState.NO);
        }

        /*
         * WARNING - void declaration
         */
        public final void setArrayPresentation(@NotNull Value value2, @NotNull VariableContext context2, @NotNull Icon icon2, @NotNull XValueNode node) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            boolean bl = value2.getType() == ValueType.ARRAY;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (value2 instanceof ArrayValue) {
                int length = ((ArrayValue)value2).getLength();
                node.setPresentation(icon2, (XValuePresentation)new ArrayPresentation(length, ((ArrayValue)value2).getClassName()), length > 0);
                return;
            }
            if (value2 instanceof PresentationProvider && ((PresentationProvider)((Object)value2)).computePresentation(node, icon2)) {
                return;
            }
            String valueString = value2.getValueString();
            if (valueString != null && (StringsKt.endsWith$default((String)valueString, (String)")", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)valueString, (char)']', (boolean)false, (int)2, null)) && VariableViewKt.access$getARRAY_DESCRIPTION_PATTERN$p().matcher(valueString).find()) {
                node.setPresentation(icon2, null, valueString, true);
            } else {
                void $this$onError$iv;
                Promise $this$onSuccess$iv;
                Promise promise = EvaluateContext.DefaultImpls.evaluate$default(context2.getEvaluateContext(), "a.length", Collections.singletonMap("a", value2), false, null, 8, null);
                boolean $i$f$onSuccess = false;
                Promise promise2 = $this$onSuccess$iv.onSuccess((Consumer)new ObsolescentConsumer<EvaluateResult>((Obsolescent)node, (Obsolescent)node, node, icon2){
                    final /* synthetic */ Obsolescent $node;
                    final /* synthetic */ XValueNode $node$inlined;
                    final /* synthetic */ Icon $icon$inlined;
                    {
                        this.$node = $captured_local_variable$1;
                        this.$node$inlined = xValueNode;
                        this.$icon$inlined = icon2;
                        super($super_call_param$2);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public void accept(Object param) {
                        EvaluateResult it = (EvaluateResult)param;
                        boolean bl = false;
                        this.$node$inlined.setPresentation(this.$icon$inlined, null, "Array[" + it.getValue().getValueString() + ']', true);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"onSuccess(object : Obsol\u2026m: T) = handler(param)\n})");
                $this$onSuccess$iv = promise2;
                boolean $i$f$onError = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$onError$iv.onError((Consumer)new ObsolescentConsumer<Throwable>((Obsolescent)node, (Obsolescent)node, node, icon2, valueString){
                    final /* synthetic */ Obsolescent $node;
                    final /* synthetic */ XValueNode $node$inlined;
                    final /* synthetic */ Icon $icon$inlined;
                    final /* synthetic */ String $valueString$inlined;
                    {
                        this.$node = $captured_local_variable$1;
                        this.$node$inlined = xValueNode;
                        this.$icon$inlined = icon2;
                        this.$valueString$inlined = string;
                        super($super_call_param$2);
                    }

                    public void accept(@NotNull Throwable param) {
                        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                        Throwable it = param;
                        boolean bl = false;
                        boolean $i$f$logger = false;
                        Logger logger = Logger.getInstance(VariableView.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                        logger.error("Failed to evaluate array length: " + it);
                        String string = this.$valueString$inlined;
                        if (string == null) {
                            string = "Array";
                        }
                        this.$node$inlined.setPresentation(this.$icon$inlined, null, string, true);
                    }
                }), (String)"onError(object : Obsoles\u2026able) = handler(param)\n})");
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Icon getIcon(@NotNull Value value2) {
            Icon icon2;
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            ValueType valueType = value2.getType();
            switch (VariableView$Companion$WhenMappings.$EnumSwitchMapping$0[valueType.ordinal()]) {
                case 1: {
                    Icon icon3 = AllIcons.Nodes.Lambda;
                    icon2 = icon3;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"AllIcons.Nodes.Lambda");
                    break;
                }
                case 2: {
                    Icon icon4 = AllIcons.Debugger.Db_array;
                    icon2 = icon4;
                    Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"AllIcons.Debugger.Db_array");
                    break;
                }
                default: {
                    void type;
                    Icon icon5 = type.isObjectType() ? AllIcons.Debugger.Value : AllIcons.Debugger.Db_primitive;
                    icon2 = icon5;
                    Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"if (type.isObjectType) A\u2026ons.Debugger.Db_primitive");
                }
            }
            return icon2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

