/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.liveReload;

import com.intellij.CommonBundle;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.browsers.ReloadMode;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.WebBrowserXmlService;
import com.intellij.ide.browsers.actions.WebPreviewFileEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.GotItTooltip;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import java.awt.Component;
import java.awt.Point;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.liveReload.WebServerFileContentListener;
import org.jetbrains.builtInWebServer.liveReload.WebServerPageConnectionService;
import org.jetbrains.ide.BuiltInServerBundle;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.JsonRpcServer;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.WebSocketClient;
import org.jetbrains.io.webSocket.WebSocketHandshakeHandler;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0007\u0018\u0000 !2\u00020\u0001:\u0004!\"#$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001b0\u001aJ\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001fJ\u0016\u0010 \u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001fH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService;", "", "()V", "RELOAD_PAGE_MESSAGE", "Lio/netty/buffer/ByteBuf;", "kotlin.jvm.PlatformType", "myRpcServer", "Lorg/jetbrains/io/jsonRpc/JsonRpcServer;", "myServer", "Lorg/jetbrains/io/jsonRpc/ClientManager;", "myState", "Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$RequestedPagesState;", "clientConnected", "", "client", "Lorg/jetbrains/io/webSocket/WebSocketClient;", "clientId", "", "clientDisconnected", "fileRequested", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "onlyIfHtmlFile", "", "fileSupplier", "Ljava/util/function/Supplier;", "Lcom/intellij/openapi/vfs/VirtualFile;", "reloadRelatedClients", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "modifiedFiles", "", "showGotItTooltip", "Companion", "RequestedPage", "RequestedPagesState", "WebServerPageRequestHandler", "intellij.platform.builtInServer.impl"})
public final class WebServerPageConnectionService {
    private final ByteBuf RELOAD_PAGE_MESSAGE = Unpooled.copiedBuffer((CharSequence)"reload", (Charset)CharsetUtil.US_ASCII).asReadOnly();
    private ClientManager myServer;
    private JsonRpcServer myRpcServer;
    private final RequestedPagesState myState = new RequestedPagesState();
    @NotNull
    public static final String RELOAD_URL_PARAM = "_ij_reload";
    @NotNull
    public static final String SERVER_RELOAD_TOOLTIP_ID = "builtin.web.server.reload.on.save";
    private static final String RELOAD_WS_REQUEST = "reload";
    private static final String UPDATE_LINK_WS_REQUEST_PREFIX = "update-css ";
    private static final String RELOAD_WS_URL_PREFIX = "jb-server-page";
    private static final String RELOAD_CLIENT_ID_URL_PARAMETER = "reloadServiceClientId";
    private static final String UPDATE_LINKS_ID_URL_PARAMETER = "jbUpdateLinksId";
    private static final Logger LOGGER;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final CharSequence fileRequested(@NotNull FullHttpRequest request, boolean onlyIfHtmlFile, @NotNull Supplier<? extends VirtualFile> fileSupplier) {
        String uri;
        Object reloadRequest;
        block8: {
            Object object;
            block9: {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter(fileSupplier, (String)"fileSupplier");
                reloadRequest = ReloadMode.DISABLED;
                uri = request.uri();
                if (uri == null || !StringsKt.contains$default((CharSequence)uri, (CharSequence)RELOAD_URL_PARAM, (boolean)false, (int)2, null)) break block8;
                QueryStringDecoder decoder = new QueryStringDecoder(uri);
                object = (List)decoder.parameters().get(RELOAD_URL_PARAM);
                if (object == null || (object = (String)object.get(0)) == null) break block9;
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                object = ReloadMode.valueOf((String)it);
                if (object != null) break block8;
            }
            object = reloadRequest = ReloadMode.DISABLED;
        }
        if (reloadRequest == ReloadMode.DISABLED && this.myState.isEmpty()) {
            return null;
        }
        VirtualFile file2 = fileSupplier.get();
        if (reloadRequest == ReloadMode.DISABLED && file2 != null) {
            this.myState.resourceRequested(request, file2);
            return null;
        }
        if (reloadRequest == ReloadMode.DISABLED) {
            return null;
        }
        if (file2 == null) {
            LOGGER.warn("VirtualFile for " + uri + " isn't resolved, reload on save can't be started");
            return null;
        }
        if (onlyIfHtmlFile && !WebBrowserXmlService.Companion.getInstance().isHtmlFile(file2)) {
            return null;
        }
        String string = uri;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri");
        int clientId = this.myState.pageRequested(string, file2, (ReloadMode)reloadRequest);
        String optionalConsoleLog = LOGGER.isDebugEnabled() ? "\nconsole.log('JetBrains Reload on Save script loaded, clientId = " + clientId + "');" : "";
        return StringsKt.trimIndent((String)("\n<script>\n(function() {" + optionalConsoleLog + "\n  var ws = new WebSocket('ws://' + window.location.host + '/jb-server-page?reloadServiceClientId=" + clientId + "');\n  ws.onmessage = function (msg) {\n      if (msg.data === 'reload') {\n          window.location.reload();\n      }\n      if (msg.data.startsWith('update-css ')) {\n          var messageId = msg.data.substring(11);\n          var links = document.getElementsByTagName('link');\n          for (var i = 0; i < links.length; i++) {\n              var link = links[i];\n              if (link.rel !== 'stylesheet') continue;\n              var clonedLink = link.cloneNode(true);\n              var newHref = link.href.replace(/(&|\\?)jbUpdateLinksId=\\d+/, \"$1jbUpdateLinksId=\" + messageId);\n              if (newHref !== link.href) {\n                clonedLink.href = newHref;\n              }\n              else {\n                var indexOfQuest = newHref.indexOf('?');\n                if (indexOfQuest >= 0) {\n                  // to support ?foo#hash \n                  clonedLink.href = newHref.substring(0, indexOfQuest + 1) + 'jbUpdateLinksId=' + messageId + '&' + \n                                    newHref.substring(indexOfQuest + 1);\n                }\n                else {\n                  clonedLink.href += '?' + 'jbUpdateLinksId=' + messageId;\n                }\n              }\n              link.replaceWith(clonedLink);\n          }\n      }\n  };\n})();\n</script>\n    "));
    }

    @Nullable
    public final AsyncFileListener.ChangeApplier reloadRelatedClients(@NotNull List<? extends VirtualFile> modifiedFiles) {
        Intrinsics.checkNotNullParameter(modifiedFiles, (String)"modifiedFiles");
        if (this.myServer == null) {
            return null;
        }
        if (this.myState.isRequestedFileWithoutReferrerModified(modifiedFiles)) {
            return new AsyncFileListener.ChangeApplier(this, modifiedFiles){
                final /* synthetic */ WebServerPageConnectionService this$0;
                final /* synthetic */ List $modifiedFiles;

                public void afterVfsChange() {
                    block0: {
                        ClientManager server;
                        WebServerPageConnectionService.access$showGotItTooltip(this.this$0, this.$modifiedFiles);
                        WebServerPageConnectionService.access$getMyState$p(this.this$0).clear();
                        ClientManager clientManager = server = WebServerPageConnectionService.access$getMyServer$p(this.this$0);
                        if (clientManager == null) break block0;
                        ByteBuf byteBuf = WebServerPageConnectionService.access$getRELOAD_PAGE_MESSAGE$p(this.this$0).retainedDuplicate();
                        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"RELOAD_PAGE_MESSAGE.retainedDuplicate()");
                        clientManager.send(-1, byteBuf, null);
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$modifiedFiles = $captured_local_variable$1;
                }
            };
        }
        Map<RequestedPage, List<VirtualFile>> affectedClients = this.myState.collectAffectedPages(modifiedFiles);
        return affectedClients.isEmpty() ? null : (AsyncFileListener.ChangeApplier)new AsyncFileListener.ChangeApplier(this, modifiedFiles, affectedClients){
            final /* synthetic */ WebServerPageConnectionService this$0;
            final /* synthetic */ List $modifiedFiles;
            final /* synthetic */ Map $affectedClients;

            /*
             * WARNING - void declaration
             */
            public void afterVfsChange() {
                WebServerPageConnectionService.access$showGotItTooltip(this.this$0, this.$modifiedFiles);
                Object object = this.$affectedClients;
                boolean bl = false;
                Iterator<Map.Entry<K, V>> iterator2 = object.entrySet().iterator();
                while (iterator2.hasNext()) {
                    void requestedPage2;
                    Map.Entry<K, V> entry2;
                    Map.Entry<K, V> entry3 = entry2 = iterator2.next();
                    boolean bl2 = false;
                    object = (RequestedPage)entry3.getKey();
                    entry3 = entry2;
                    bl2 = false;
                    List affectedFiles2 = (List)entry3.getValue();
                    CompletableFuture<WebSocketClient> clientFuture = requestedPage2.getMyClient();
                    if (affectedFiles2.isEmpty()) {
                        WebServerPageConnectionService.access$getLOGGER$cp().debug("Reload page for clientId = " + requestedPage2.getMyClientId());
                        clientFuture.thenAccept(new Consumer(this){
                            final /* synthetic */ reloadRelatedClients.2 this$0;

                            public final void accept(@Nullable WebSocketClient client) {
                                WebSocketClient webSocketClient = client;
                                Intrinsics.checkNotNull((Object)((Object)webSocketClient));
                                webSocketClient.send(WebServerPageConnectionService.access$getRELOAD_PAGE_MESSAGE$p(this.this$0.this$0).retainedDuplicate());
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                        continue;
                    }
                    int messageId = WebServerPageConnectionService.access$getMyState$p(this.this$0).getNextMessageId();
                    WebServerPageConnectionService.access$getMyState$p(this.this$0).linkedFilesRequested(messageId, affectedFiles2);
                    for (VirtualFile affectedFile : affectedFiles2) {
                        WebServerPageConnectionService.access$getLOGGER$cp().debug("Reload file " + affectedFile.getName() + " for clientId = " + requestedPage2.getMyClientId());
                        clientFuture.thenAccept(new Consumer(messageId){
                            final /* synthetic */ int $messageId;

                            public final void accept(@Nullable WebSocketClient client) {
                                String message2 = "update-css " + this.$messageId;
                                WebSocketClient webSocketClient = client;
                                Intrinsics.checkNotNull((Object)((Object)webSocketClient));
                                webSocketClient.send(Unpooled.copiedBuffer((CharSequence)message2, (Charset)Charsets.UTF_8));
                            }
                            {
                                this.$messageId = n;
                            }
                        });
                    }
                    JobScheduler.getScheduler().schedule(new Runnable(this, messageId, (RequestedPage)requestedPage2, clientFuture){
                        final /* synthetic */ reloadRelatedClients.2 this$0;
                        final /* synthetic */ int $messageId;
                        final /* synthetic */ RequestedPage $requestedPage;
                        final /* synthetic */ CompletableFuture $clientFuture;

                        public final void run() {
                            if (!WebServerPageConnectionService.access$getMyState$p(this.this$0.this$0).isAllLinkedFilesReloaded(this.$messageId)) {
                                WebServerPageConnectionService.access$getLOGGER$cp().debug("Some files weren't reloaded, reload whole page for clientId = " + this.$requestedPage.getMyClientId());
                                this.$clientFuture.thenAccept(new Consumer(this){
                                    final /* synthetic */ reloadRelatedClients.afterVfsChange.3 this$0;

                                    public final void accept(@Nullable WebSocketClient client) {
                                        WebSocketClient webSocketClient = client;
                                        Intrinsics.checkNotNull((Object)((Object)webSocketClient));
                                        webSocketClient.send(WebServerPageConnectionService.access$getRELOAD_PAGE_MESSAGE$p(this.this$0.this$0.this$0).retainedDuplicate());
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                });
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$messageId = n;
                            this.$requestedPage = requestedPage2;
                            this.$clientFuture = completableFuture;
                        }
                    }, 1L, TimeUnit.SECONDS);
                }
            }
            {
                this.this$0 = this$0;
                this.$modifiedFiles = $captured_local_variable$1;
                this.$affectedClients = $captured_local_variable$2;
            }
        };
    }

    private final void clientConnected(WebSocketClient client, int clientId) {
        this.myState.clientConnected(client, clientId);
    }

    private final void clientDisconnected(WebSocketClient client) {
        this.myState.clientDisconnected(client);
    }

    private final void showGotItTooltip(List<? extends VirtualFile> modifiedFiles) {
        String string = BuiltInServerBundle.message((String)"reload.on.save.got.it.content", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BuiltInServerBundle.mess\u2026.on.save.got.it.content\")");
        ClientManager clientManager = this.myServer;
        Intrinsics.checkNotNull((Object)clientManager);
        GotItTooltip gotItTooltip = new GotItTooltip(SERVER_RELOAD_TOOLTIP_ID, string, clientManager);
        if (!gotItTooltip.canShow() || WebPreviewFileEditor.isPreviewOpened()) {
            return;
        }
        if (WebBrowserManager.BROWSER_RELOAD_MODE_DEFAULT != ReloadMode.RELOAD_ON_SAVE) {
            Logger.getInstance(WebServerPageConnectionService.class).error("Default value for " + BuiltInServerBundle.message((String)"reload.on.save.got.it.title", (Object[])new Object[0]) + " has changed, tooltip is outdated.");
            return;
        }
        WebBrowserManager webBrowserManager = WebBrowserManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)webBrowserManager), (String)"WebBrowserManager.getInstance()");
        if (webBrowserManager.getWebServerReloadMode() != ReloadMode.RELOAD_ON_SAVE) {
            return;
        }
        String string2 = BuiltInServerBundle.message((String)"reload.on.save.got.it.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"BuiltInServerBundle.mess\u2026ad.on.save.got.it.title\")");
        gotItTooltip.withHeader(string2).withPosition(Balloon.Position.above);
        IdeFocusManager ideFocusManager = IdeFocusManager.getGlobalInstance();
        Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"IdeFocusManager.getGlobalInstance()");
        Component component2 = ideFocusManager.getFocusOwner();
        if (!(component2 instanceof EditorComponentImpl)) {
            component2 = null;
        }
        EditorComponentImpl editorComponentImpl = (EditorComponentImpl)component2;
        if (editorComponentImpl == null) {
            return;
        }
        EditorComponentImpl editorComponent = editorComponentImpl;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        EditorImpl editorImpl = editorComponent.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorImpl, (String)"editorComponent.editor");
        VirtualFile editorFile = fileDocumentManager.getFile((Document)editorImpl.getDocument());
        if (!CollectionsKt.contains((Iterable)modifiedFiles, (Object)editorFile)) {
            return;
        }
        String string3 = CommonBundle.message((String)"action.text.configure.ellipsis", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"CommonBundle.message(\"ac\u2026text.configure.ellipsis\")");
        gotItTooltip.withLink(string3, (Function0<Unit>)((Function0)new Function0<Unit>(editorComponent){
            final /* synthetic */ EditorComponentImpl $editorComponent;

            public final void invoke() {
                ShowSettingsUtil showSettingsUtil = ShowSettingsUtil.getInstance();
                EditorImpl editorImpl = this.$editorComponent.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editorImpl, (String)"editorComponent.editor");
                showSettingsUtil.showSettingsDialog(editorImpl.getProject(), (Predicate)showGotItTooltip.1.INSTANCE, null);
            }
            {
                this.$editorComponent = editorComponentImpl;
                super(0);
            }
        }));
        gotItTooltip.show((JComponent)editorComponent, (Function2<? super Component, ? super Balloon, ? extends Point>)((Function2)showGotItTooltip.2.INSTANCE));
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(WebServerPageConnectionService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(WebSe\u2026ctionService::class.java)");
        LOGGER = logger;
    }

    public static final /* synthetic */ ClientManager access$getMyServer$p(WebServerPageConnectionService $this) {
        return $this.myServer;
    }

    public static final /* synthetic */ void access$showGotItTooltip(WebServerPageConnectionService $this, List modifiedFiles) {
        $this.showGotItTooltip(modifiedFiles);
    }

    public static final /* synthetic */ RequestedPagesState access$getMyState$p(WebServerPageConnectionService $this) {
        return $this.myState;
    }

    public static final /* synthetic */ ByteBuf access$getRELOAD_PAGE_MESSAGE$p(WebServerPageConnectionService $this) {
        return $this.RELOAD_PAGE_MESSAGE;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u001a\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n\u0018\u00010\bH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$WebServerPageRequestHandler;", "Lorg/jetbrains/io/webSocket/WebSocketHandshakeHandler;", "()V", "connected", "", "client", "Lorg/jetbrains/io/jsonRpc/Client;", "parameters", "", "", "", "disconnected", "getMessageServer", "Lorg/jetbrains/io/jsonRpc/MessageServer;", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "serverCreated", "server", "Lorg/jetbrains/io/jsonRpc/ClientManager;", "intellij.platform.builtInServer.impl"})
    public static final class WebServerPageRequestHandler
    extends WebSocketHandshakeHandler {
        @Override
        protected void serverCreated(@NotNull ClientManager server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            WebServerPageConnectionService instance = Companion.getInstance();
            instance.myServer = server;
            instance.myRpcServer = new JsonRpcServer(server);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isSupported(@NotNull FullHttpRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            if (!super.isSupported(request)) return false;
            String string = request.uri();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.uri()");
            if (!HttpRequestHandler.Companion.checkPrefix(string, WebServerPageConnectionService.RELOAD_WS_URL_PREFIX)) return false;
            return true;
        }

        @Override
        @NotNull
        protected MessageServer getMessageServer() {
            JsonRpcServer jsonRpcServer = Companion.getInstance().myRpcServer;
            Intrinsics.checkNotNull((Object)jsonRpcServer);
            return jsonRpcServer;
        }

        public void connected(@NotNull Client client, @Nullable Map<String, ? extends List<String>> parameters2) {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            if (parameters2 == null || !(client instanceof WebSocketClient)) {
                return;
            }
            List<String> list2 = parameters2.get(WebServerPageConnectionService.RELOAD_CLIENT_ID_URL_PARAMETER);
            Intrinsics.checkNotNull(list2);
            List<String> ids = list2;
            if (ids.size() != 1) {
                return;
            }
            int id2 = StringUtil.parseInt((String)ids.get(0), (int)-1);
            if (id2 == -1) {
                return;
            }
            Companion.getInstance().clientConnected((WebSocketClient)client, id2);
        }

        @Override
        public void disconnected(@NotNull Client client) {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            if (client instanceof WebSocketClient) {
                Companion.getInstance().clientDisconnected((WebSocketClient)client);
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0017J\u0016\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ&\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0 0\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0 J\u0006\u0010\"\u001a\u00020\nJ\u000e\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\nJ\u0016\u0010%\u001a\u00020\u00042\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0 J\u0012\u0010&\u001a\u00020\u00042\b\u0010'\u001a\u0004\u0018\u00010\u000eH\u0002J\u001c\u0010(\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\n2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000e0 J\u001e\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020.J\u0016\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u0002012\u0006\u0010,\u001a\u00020\u000eJ\u0018\u00102\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u0015H\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$RequestedPagesState;", "", "()V", "isEmpty", "", "()Z", "myDocumentListenerDisposable", "Lcom/intellij/openapi/Disposable;", "myFileListenerDisposable", "myLastClientId", "", "myLinkedFilesToReload", "", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "myMessageId", "Ljava/util/concurrent/atomic/AtomicInteger;", "myRequestedFilesWithoutReferrer", "myRequestedPages", "Lcom/intellij/util/containers/MultiMap;", "", "Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$RequestedPage;", "cleanupIfEmpty", "", "clear", "clientConnected", "client", "Lorg/jetbrains/io/webSocket/WebSocketClient;", "clientId", "clientDisconnected", "collectAffectedPages", "", "", "files", "getNextMessageId", "isAllLinkedFilesReloaded", "messageId", "isRequestedFileWithoutReferrerModified", "isTrackedFile", "virtualFile", "linkedFilesRequested", "affectedFiles", "pageRequested", "uri", "file", "reloadMode", "Lcom/intellij/ide/browsers/ReloadMode;", "resourceRequested", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "stopWaitingForClient", "page", "intellij.platform.builtInServer.impl"})
    private static final class RequestedPagesState {
        private int myLastClientId;
        private final Set<VirtualFile> myRequestedFilesWithoutReferrer = new HashSet();
        private final MultiMap<String, RequestedPage> myRequestedPages = new MultiMap();
        private Disposable myFileListenerDisposable;
        private Disposable myDocumentListenerDisposable;
        private final AtomicInteger myMessageId = new AtomicInteger(0);
        private final Map<Integer, Set<VirtualFile>> myLinkedFilesToReload = new HashMap();

        public final synchronized void clear() {
            LOGGER.debug("Requested pages cleared");
            Iterator iterator2 = this.myRequestedPages.values().iterator();
            while (iterator2.hasNext()) {
                RequestedPage requestedPage2;
                RequestedPage requestedPage3 = requestedPage2 = (RequestedPage)iterator2.next();
                Intrinsics.checkNotNull((Object)requestedPage3);
                requestedPage3.getMyClient().cancel(false);
            }
            this.myRequestedPages.clear();
            this.cleanupIfEmpty();
        }

        public final synchronized void resourceRequested(@NotNull FullHttpRequest request, @NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            String referer = request.headers().get("Referer");
            boolean associatedPageFound = false;
            try {
                URI refererUri = URI.create(referer);
                StringBuilder stringBuilder = new StringBuilder();
                URI uRI = refererUri;
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"refererUri");
                String refererWithoutHost = stringBuilder.append(uRI.getPath()).append("?").append(refererUri.getQuery()).toString();
                Collection collection = this.myRequestedPages.get((Object)refererWithoutHost);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"myRequestedPages[refererWithoutHost]");
                Collection pages = collection;
                Object object = pages.iterator();
                while (object.hasNext()) {
                    RequestedPage page;
                    RequestedPage requestedPage2 = page = (RequestedPage)object.next();
                    Intrinsics.checkNotNull((Object)requestedPage2);
                    requestedPage2.getMyFiles().add(file2);
                }
                associatedPageFound = !pages.isEmpty();
                List messageIds = (List)new QueryStringDecoder(request.uri()).parameters().get(WebServerPageConnectionService.UPDATE_LINKS_ID_URL_PARAMETER);
                if (messageIds != null && messageIds.size() == 1) {
                    Object e = messageIds.get(0);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"messageIds[0]");
                    object = (String)e;
                    boolean bl = false;
                    Set<VirtualFile> set2 = this.myLinkedFilesToReload.get(Integer.parseInt((String)object));
                    if (set2 != null) {
                        set2.remove(file2);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!associatedPageFound) {
                this.myRequestedFilesWithoutReferrer.add(file2);
            }
        }

        public final synchronized int pageRequested(@NotNull String uri, @NotNull VirtualFile file2, @NotNull ReloadMode reloadMode) {
            Disposable disposable2;
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)reloadMode, (String)"reloadMode");
            LOGGER.assertTrue(this.myRequestedPages.isEmpty() == (this.myFileListenerDisposable == null), (Object)("isEmpty: " + this.myRequestedPages.isEmpty() + ", disposable is null: " + (this.myFileListenerDisposable == null)));
            if (this.myFileListenerDisposable == null) {
                Disposable disposable3 = Disposer.newDisposable((Disposable)((Disposable)ApplicationManager.getApplication()), (String)"RequestedPagesState.myFileListenerDisposable");
                Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"Disposer.newDisposable(A\u2026yFileListenerDisposable\")");
                disposable2 = disposable3;
                VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)new WebServerFileContentListener(), disposable2);
                this.myFileListenerDisposable = disposable2;
            }
            if (reloadMode == ReloadMode.RELOAD_ON_CHANGE && this.myDocumentListenerDisposable == null) {
                Disposable disposable4 = Disposer.newDisposable((Disposable)((Disposable)ApplicationManager.getApplication()), (String)"RequestedPagesState.myDocumentListenerDisposable");
                Intrinsics.checkNotNullExpressionValue((Object)disposable4, (String)"Disposer.newDisposable(A\u2026umentListenerDisposable\")");
                disposable2 = disposable4;
                EditorFactory editorFactory = EditorFactory.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
                editorFactory.getEventMulticaster().addDocumentListener(new DocumentListener(this){
                    final /* synthetic */ RequestedPagesState this$0;

                    public void documentChanged(@NotNull DocumentEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(event.getDocument());
                        if (RequestedPagesState.access$isTrackedFile(this.this$0, virtualFile2)) {
                            FileDocumentManager.getInstance().saveDocument(event.getDocument());
                        }
                    }
                    {
                        this.this$0 = this$0;
                    }
                }, disposable2);
                this.myDocumentListenerDisposable = disposable2;
            }
            RequestedPagesState requestedPagesState = this;
            ++requestedPagesState.myLastClientId;
            int clientId = requestedPagesState.myLastClientId;
            LOGGER.debug("Page is requested for " + uri + ", clientId = " + clientId);
            RequestedPage newPage = new RequestedPage(clientId, file2, reloadMode);
            this.myRequestedPages.putValue((Object)uri, (Object)newPage);
            JobScheduler.getScheduler().schedule(new Runnable(this, uri, newPage){
                final /* synthetic */ RequestedPagesState this$0;
                final /* synthetic */ String $uri;
                final /* synthetic */ RequestedPage $newPage;

                public final void run() {
                    RequestedPagesState.access$stopWaitingForClient(this.this$0, this.$uri, this.$newPage);
                }
                {
                    this.this$0 = requestedPagesState;
                    this.$uri = string;
                    this.$newPage = requestedPage2;
                }
            }, 30L, TimeUnit.SECONDS);
            return clientId;
        }

        private final boolean isTrackedFile(VirtualFile virtualFile2) {
            return this.myRequestedFilesWithoutReferrer.contains(virtualFile2) || this.myRequestedPages.values().stream().filter(isTrackedFile.1.INSTANCE).anyMatch(new Predicate(virtualFile2){
                final /* synthetic */ VirtualFile $virtualFile;

                public final boolean test(@Nullable RequestedPage it) {
                    RequestedPage requestedPage2 = it;
                    Intrinsics.checkNotNull((Object)requestedPage2);
                    return requestedPage2.getMyFiles().contains(this.$virtualFile);
                }
                {
                    this.$virtualFile = virtualFile2;
                }
            });
        }

        private final synchronized void stopWaitingForClient(String uri, RequestedPage page) {
            if (page.getMyClient().isDone()) {
                return;
            }
            page.getMyClient().cancel(false);
            this.myRequestedPages.remove((Object)uri, (Object)page);
            this.cleanupIfEmpty();
            LOGGER.error("Timeout on waiting for WebSocket client for " + uri + ", clientId = " + page.getMyClientId());
        }

        public final synchronized void clientConnected(@NotNull WebSocketClient client, int clientId) {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            RequestedPage requestedPage2 = (RequestedPage)ContainerUtil.find((Iterable)this.myRequestedPages.values(), (Condition)new Condition(clientId){
                final /* synthetic */ int $clientId;

                public final boolean value(@Nullable RequestedPage it) {
                    RequestedPage requestedPage2 = it;
                    return requestedPage2 != null && requestedPage2.getMyClientId() == this.$clientId;
                }
                {
                    this.$clientId = n;
                }
            });
            if (requestedPage2 != null) {
                requestedPage2.getMyClient().complete(client);
            } else {
                LOGGER.info("Cannot find client for clientId = " + clientId);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final synchronized void clientDisconnected(@NotNull WebSocketClient client) {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            String requestedPageKey = null;
            RequestedPage requestedPage2 = null;
            Iterator iterator2 = this.myRequestedPages.entrySet().iterator();
            block0: while (iterator2.hasNext()) {
                Map.Entry entry2;
                Map.Entry entry3 = entry2 = (Map.Entry)iterator2.next();
                boolean bl = false;
                String string = (String)entry3.getKey();
                entry3 = entry2;
                bl = false;
                Collection value2 = (Collection)entry3.getValue();
                Iterator iterator3 = value2.iterator();
                while (iterator3.hasNext()) {
                    void key;
                    RequestedPage page;
                    RequestedPage requestedPage3 = page = (RequestedPage)iterator3.next();
                    Intrinsics.checkNotNull((Object)requestedPage3);
                    if (!requestedPage3.getMyClient().isDone() || (WebSocketClient)page.getMyClient().getNow(null) != client) continue;
                    requestedPageKey = key;
                    requestedPage2 = page;
                    continue block0;
                }
            }
            LOGGER.debug("WebSocket client disconnected for URI " + requestedPageKey);
            if (requestedPageKey != null) {
                this.myRequestedPages.remove((Object)requestedPageKey, (Object)requestedPage2);
            }
            this.cleanupIfEmpty();
        }

        private final void cleanupIfEmpty() {
            if (this.myRequestedPages.isEmpty()) {
                this.myRequestedFilesWithoutReferrer.clear();
                if (this.myFileListenerDisposable != null) {
                    Disposable disposable2 = Objects.requireNonNull(this.myFileListenerDisposable);
                    Intrinsics.checkNotNull((Object)disposable2);
                    Disposer.dispose((Disposable)disposable2);
                    this.myFileListenerDisposable = null;
                }
                if (this.myDocumentListenerDisposable != null) {
                    Disposable disposable3 = Objects.requireNonNull(this.myDocumentListenerDisposable);
                    Intrinsics.checkNotNull((Object)disposable3);
                    Disposer.dispose((Disposable)disposable3);
                    this.myDocumentListenerDisposable = null;
                }
            }
        }

        public final synchronized boolean isRequestedFileWithoutReferrerModified(@NotNull List<? extends VirtualFile> files2) {
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            for (VirtualFile virtualFile2 : files2) {
                if (!this.myRequestedFilesWithoutReferrer.contains(virtualFile2)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public final synchronized Map<RequestedPage, List<VirtualFile>> collectAffectedPages(@NotNull List<? extends VirtualFile> files2) {
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            HashMap result2 = new HashMap();
            for (VirtualFile virtualFile2 : files2) {
                Iterator iterator2 = this.myRequestedPages.values().iterator();
                while (iterator2.hasNext()) {
                    RequestedPage requestedPage2;
                    RequestedPage requestedPage3 = requestedPage2 = (RequestedPage)iterator2.next();
                    Intrinsics.checkNotNull((Object)requestedPage3);
                    if (!requestedPage3.getMyFiles().contains(virtualFile2)) continue;
                    if (StringUtil.equalsIgnoreCase((CharSequence)virtualFile2.getExtension(), (CharSequence)"css")) {
                        if (!result2.containsKey(requestedPage2)) {
                            ((Map)result2).put(requestedPage2, CollectionsKt.mutableListOf((Object[])new VirtualFile[]{virtualFile2}));
                            continue;
                        }
                        Object v = result2.get(requestedPage2);
                        Intrinsics.checkNotNull(v);
                        Intrinsics.checkNotNullExpressionValue(v, (String)"result[requestedPage]!!");
                        Collection collection = (Collection)v;
                        boolean bl = false;
                        if (!(!collection.isEmpty())) continue;
                        Object v2 = result2.get(requestedPage2);
                        if (v2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.openapi.vfs.VirtualFile>");
                        }
                        TypeIntrinsics.asMutableList(v2).add(virtualFile2);
                        continue;
                    }
                    ((Map)result2).put(requestedPage2, CollectionsKt.emptyList());
                }
            }
            return result2;
        }

        public final int getNextMessageId() {
            return this.myMessageId.incrementAndGet();
        }

        public final synchronized void linkedFilesRequested(int messageId, @NotNull List<? extends VirtualFile> affectedFiles2) {
            Intrinsics.checkNotNullParameter(affectedFiles2, (String)"affectedFiles");
            this.myLinkedFilesToReload.put(messageId, new HashSet(affectedFiles2));
        }

        public final synchronized boolean isAllLinkedFilesReloaded(int messageId) {
            Set<VirtualFile> set2 = this.myLinkedFilesToReload.get(messageId);
            boolean isEmpty = set2 != null ? set2.isEmpty() : true;
            this.myLinkedFilesToReload.remove(messageId);
            return isEmpty;
        }

        public final synchronized boolean isEmpty() {
            return this.myRequestedPages.isEmpty();
        }

        public static final /* synthetic */ boolean access$isTrackedFile(RequestedPagesState $this, VirtualFile virtualFile2) {
            return $this.isTrackedFile(virtualFile2);
        }

        public static final /* synthetic */ void access$stopWaitingForClient(RequestedPagesState $this, String uri, RequestedPage page) {
            $this.stopWaitingForClient(uri, page);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$RequestedPage;", "", "myClientId", "", "requestedPageFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "reloadMode", "Lcom/intellij/ide/browsers/ReloadMode;", "(ILcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/ide/browsers/ReloadMode;)V", "myClient", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/io/webSocket/WebSocketClient;", "getMyClient", "()Ljava/util/concurrent/CompletableFuture;", "getMyClientId", "()I", "myFiles", "", "getMyFiles", "()Ljava/util/Set;", "getReloadMode", "()Lcom/intellij/ide/browsers/ReloadMode;", "intellij.platform.builtInServer.impl"})
    private static final class RequestedPage {
        @NotNull
        private final Set<VirtualFile> myFiles;
        @NotNull
        private final CompletableFuture<WebSocketClient> myClient;
        private final int myClientId;
        @NotNull
        private final ReloadMode reloadMode;

        @NotNull
        public final Set<VirtualFile> getMyFiles() {
            return this.myFiles;
        }

        @NotNull
        public final CompletableFuture<WebSocketClient> getMyClient() {
            return this.myClient;
        }

        public final int getMyClientId() {
            return this.myClientId;
        }

        @NotNull
        public final ReloadMode getReloadMode() {
            return this.reloadMode;
        }

        public RequestedPage(int myClientId, @NotNull VirtualFile requestedPageFile, @NotNull ReloadMode reloadMode) {
            Intrinsics.checkNotNullParameter((Object)requestedPageFile, (String)"requestedPageFile");
            Intrinsics.checkNotNullParameter((Object)reloadMode, (String)"reloadMode");
            this.myClientId = myClientId;
            this.reloadMode = reloadMode;
            this.myFiles = new HashSet();
            this.myClient = new CompletableFuture();
            this.myFiles.add(requestedPageFile);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$Companion;", "", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "RELOAD_CLIENT_ID_URL_PARAMETER", "", "RELOAD_URL_PARAM", "RELOAD_WS_REQUEST", "RELOAD_WS_URL_PREFIX", "SERVER_RELOAD_TOOLTIP_ID", "UPDATE_LINKS_ID_URL_PARAMETER", "UPDATE_LINK_WS_REQUEST_PREFIX", "instance", "Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService;", "getInstance", "()Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService;", "intellij.platform.builtInServer.impl"})
    public static final class Companion {
        @NotNull
        public final WebServerPageConnectionService getInstance() {
            Object object = ApplicationManager.getApplication().getService(WebServerPageConnectionService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026ctionService::class.java)");
            return (WebServerPageConnectionService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

