/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.xml.dom.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupValueFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Map;
import java.util.Set;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.resolve.DefinitionResolver;
import org.intellij.plugins.relaxNG.xml.dom.RngGrammar;
import org.intellij.plugins.relaxNG.xml.dom.RngParentRef;
import org.intellij.plugins.relaxNG.xml.dom.impl.CreatePatternFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefinitionReference
extends PsiReferenceBase.Poly<XmlAttributeValue>
implements LocalQuickFixProvider,
EmptyResolveMessageProvider,
Function<Define, ResolveResult> {
    private final boolean myIsParentRef;
    private final GenericAttributeValue<String> myValue;

    public DefinitionReference(GenericAttributeValue<String> value2) {
        super((PsiElement)value2.getXmlAttributeValue());
        this.myValue = value2;
        this.myIsParentRef = value2.getParent() instanceof RngParentRef;
    }

    public boolean isSoft() {
        return true;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        RngGrammar scope2 = this.getScope();
        if (scope2 == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                DefinitionReference.$$$reportNull$$$0(0);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        Set<Define> set2 = DefinitionResolver.resolve(scope2, (String)this.myValue.getValue());
        if (set2 == null || set2.size() == 0) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                DefinitionReference.$$$reportNull$$$0(1);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = (ResolveResult[])ContainerUtil.map2Array(set2, ResolveResult.class, (Function)this);
        if (resolveResultArray == null) {
            DefinitionReference.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    @Nullable
    public RngGrammar getScope() {
        RngGrammar scope2 = (RngGrammar)this.myValue.getParentOfType(RngGrammar.class, true);
        if (scope2 == null) {
            return null;
        }
        if (this.myIsParentRef) {
            scope2 = (RngGrammar)scope2.getParentOfType(RngGrammar.class, true);
        }
        return scope2;
    }

    public ResolveResult fun(Define define) {
        XmlElement xmlElement = (XmlElement)define.getPsiElement();
        assert (xmlElement != null);
        return new PsiElementResolveResult((PsiElement)xmlElement);
    }

    public Object @NotNull [] getVariants() {
        RngGrammar scope2 = this.getScope();
        if (scope2 == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                DefinitionReference.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        Map<String, Set<Define>> map2 = DefinitionResolver.getAllVariants(scope2);
        if (map2 == null || map2.size() == 0) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                DefinitionReference.$$$reportNull$$$0(4);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        Object[] objectArray = ContainerUtil.mapNotNull(map2.values(), defines -> {
            Define define = (Define)defines.iterator().next();
            if (defines.size() == 0) {
                return null;
            }
            Object element2 = define.getPsiElement();
            if (element2 != null) {
                PsiPresentableMetaData data2 = (PsiPresentableMetaData)((PsiMetaOwner)element2).getMetaData();
                if (data2 != null) {
                    return LookupValueFactory.createLookupValue(data2.getName(), data2.getIcon());
                }
                return define.getName();
            }
            return define.getName();
        }).toArray();
        if (objectArray == null) {
            DefinitionReference.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    public LocalQuickFix[] getQuickFixes() {
        XmlTag tag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlTag.class);
        assert (tag2 != null);
        RngGrammar scope2 = (RngGrammar)this.myValue.getParentOfType(RngGrammar.class, true);
        if (scope2 != null) {
            return new LocalQuickFix[]{new CreatePatternFix((PsiReference)this)};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = RelaxngBundle.message("relaxng.annotator.unresolved-pattern-reference", new Object[0]);
        if (string == null) {
            DefinitionReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/plugins/relaxNG/xml/dom/impl/DefinitionReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

