/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.validation;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.intellij.plugins.relaxNG.validation.RngParser;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RngSchemaValidator
extends ExternalAnnotator<MyValidationMessageConsumer, MyValidationMessageConsumer> {
    private static final Logger LOG = Logger.getInstance((String)RngSchemaValidator.class.getName());

    @Nullable
    public MyValidationMessageConsumer collectInformation(final @NotNull PsiFile file2) {
        FileType type;
        if (file2 == null) {
            RngSchemaValidator.$$$reportNull$$$0(0);
        }
        if ((type = file2.getFileType()) != XmlFileType.INSTANCE && type != RncFileType.getInstance()) {
            return null;
        }
        XmlFile xmlfile = (XmlFile)file2;
        XmlDocument document = xmlfile.getDocument();
        if (document == null) {
            return null;
        }
        if (type == XmlFileType.INSTANCE) {
            XmlTag rootTag = document.getRootTag();
            if (rootTag == null) {
                return null;
            }
            if (!"http://relaxng.org/ns/structure/1.0".equals(rootTag.getNamespace())) {
                return null;
            }
        } else if (!ApplicationManager.getApplication().isUnitTestMode() && MyErrorFinder.hasError((PsiElement)xmlfile)) {
            return null;
        }
        final Document doc = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        final MyValidationMessageConsumer consumer = new MyValidationMessageConsumer();
        DefaultHandler eh = new DefaultHandler(){

            @Override
            public void warning(SAXParseException e) {
                RngSchemaValidator.handleError(e, file2, doc, consumer.warning());
            }

            @Override
            public void error(SAXParseException e) {
                RngSchemaValidator.handleError(e, file2, doc, consumer.error());
            }
        };
        RngParser.parsePattern(file2, eh, true);
        return consumer;
    }

    @Nullable
    public MyValidationMessageConsumer doAnnotate(MyValidationMessageConsumer collectedInfo) {
        return collectedInfo;
    }

    public void apply(@NotNull PsiFile file2, MyValidationMessageConsumer annotationResult, @NotNull AnnotationHolder holder) {
        if (file2 == null) {
            RngSchemaValidator.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            RngSchemaValidator.$$$reportNull$$$0(2);
        }
        annotationResult.apply(holder);
    }

    public static void handleError(SAXParseException ex, PsiFile file2, Document document, ValidationMessageConsumer consumer) {
        PsiElement at;
        VirtualFile virtualFile2;
        String systemId2 = ex.getSystemId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("RNG Schema error: " + ex.getMessage() + " [" + systemId2 + "]");
        }
        if (systemId2 != null && !Comparing.equal((Object)(virtualFile2 = RngSchemaValidator.findVirtualFile(systemId2)), (Object)file2.getVirtualFile())) {
            return;
        }
        int line = ex.getLineNumber();
        if (line > 0) {
            PsiElement e;
            int column2 = ex.getColumnNumber();
            int startOffset = document.getLineStartOffset(line - 1);
            at = column2 > 0 ? (file2.getFileType() == RncFileType.getInstance() ? ((e = file2.findElementAt(startOffset + column2)) == null ? e : file2.findElementAt(startOffset + column2 - 1)) : file2.findElementAt(startOffset + column2 - 2)) : ((e = file2.findElementAt(startOffset)) != null ? PsiTreeUtil.nextLeaf((PsiElement)e) : null);
        } else {
            XmlDocument d = ((XmlFile)file2).getDocument();
            assert (d != null);
            XmlTag rootTag = d.getRootTag();
            assert (rootTag != null);
            at = rootTag.getFirstChild();
        }
        PsiElement host = file2 instanceof RncFile ? at : PsiTreeUtil.getParentOfType((PsiElement)at, (Class[])new Class[]{XmlAttribute.class, XmlTag.class});
        if (at != null && host != null) {
            consumer.onMessage(host, ex.getLocalizedMessage());
        } else {
            consumer.onMessage((PsiElement)file2, ex.getLocalizedMessage());
        }
    }

    public static VirtualFile findVirtualFile(String systemId2) {
        try {
            return VfsUtil.findFileByURL((URL)new URL(systemId2));
        }
        catch (Exception e) {
            LOG.warn("Failed to build file from uri <" + systemId2 + ">", (Throwable)e);
            return VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.fixURLforIDEA((String)systemId2));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/relaxNG/validation/RngSchemaValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInformation";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyErrorFinder
    extends PsiRecursiveElementVisitor {
        private static final MyErrorFinder INSTANCE = new MyErrorFinder();
        private static final HasError FOUND = new HasError();

        private MyErrorFinder() {
        }

        public void visitErrorElement(@NotNull PsiErrorElement element2) {
            if (element2 == null) {
                MyErrorFinder.$$$reportNull$$$0(0);
            }
            throw FOUND;
        }

        public static boolean hasError(PsiElement element2) {
            try {
                element2.accept((PsiElementVisitor)INSTANCE);
                return false;
            }
            catch (HasError e) {
                return true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/relaxNG/validation/RngSchemaValidator$MyErrorFinder", "visitErrorElement"));
        }

        private static final class HasError
        extends RuntimeException {
            private HasError() {
            }
        }
    }

    private static class WarningMessageConsumer
    extends MessageConsumerImpl {
        WarningMessageConsumer(AnnotationHolder holder) {
            super(holder);
        }

        @Override
        protected void createAnnotation(@NotNull ASTNode node, @NotNull String message2) {
            if (node == null) {
                WarningMessageConsumer.$$$reportNull$$$0(0);
            }
            if (message2 == null) {
                WarningMessageConsumer.$$$reportNull$$$0(1);
            }
            this.myHolder.newAnnotation(HighlightSeverity.WARNING, message2).range(node).create();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
            }
            objectArray[1] = "org/intellij/plugins/relaxNG/validation/RngSchemaValidator$WarningMessageConsumer";
            objectArray[2] = "createAnnotation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ErrorMessageConsumer
    extends MessageConsumerImpl {
        @NonNls
        private static final String MISSING_START_ELEMENT = "missing \"start\" element";
        private static final String UNDEFINED_PATTERN = "reference to undefined pattern ";

        ErrorMessageConsumer(AnnotationHolder holder) {
            super(holder);
        }

        @Override
        protected void createAnnotation(@NotNull ASTNode node, @NotNull String message2) {
            if (node == null) {
                ErrorMessageConsumer.$$$reportNull$$$0(0);
            }
            if (message2 == null) {
                ErrorMessageConsumer.$$$reportNull$$$0(1);
            }
            if (MISSING_START_ELEMENT.equals(message2)) {
                PsiFile psiFile = node.getPsi().getContainingFile();
                if (psiFile instanceof XmlFile) {
                    PsiElementProcessor.FindElement processor2 = new PsiElementProcessor.FindElement();
                    RelaxIncludeIndex.processBackwardDependencies((XmlFile)psiFile, (PsiElementProcessor<? super XmlFile>)processor2);
                    if (processor2.isFound()) {
                        this.myHolder.newAnnotation(HighlightSeverity.WEAK_WARNING, message2).range(node).create();
                        return;
                    }
                }
            } else if (message2.startsWith(UNDEFINED_PATTERN)) {
                return;
            }
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, message2).range(node).create();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
            }
            objectArray[1] = "org/intellij/plugins/relaxNG/validation/RngSchemaValidator$ErrorMessageConsumer";
            objectArray[2] = "createAnnotation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class MessageConsumerImpl
    implements ValidationMessageConsumer {
        protected final AnnotationHolder myHolder;

        MessageConsumerImpl(AnnotationHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void onMessage(@NotNull PsiElement host, @NotNull String message2) {
            if (host == null) {
                MessageConsumerImpl.$$$reportNull$$$0(0);
            }
            if (message2 == null) {
                MessageConsumerImpl.$$$reportNull$$$0(1);
            }
            ASTNode node = host.getNode();
            assert (node != null);
            if (host instanceof XmlAttribute) {
                ASTNode nameNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(node);
                if (nameNode != null) {
                    this.createAnnotation(nameNode, message2);
                }
            } else if (host instanceof XmlTag) {
                ASTNode end;
                ASTNode start2 = XmlChildRole.START_TAG_NAME_FINDER.findChild(node);
                if (start2 != null) {
                    this.createAnnotation(start2, message2);
                }
                if ((end = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(node)) != null) {
                    this.createAnnotation(end, message2);
                }
            } else {
                this.createAnnotation(node, message2);
            }
        }

        protected abstract void createAnnotation(@NotNull ASTNode var1, @NotNull @InspectionMessage String var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "host";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
            }
            objectArray[1] = "org/intellij/plugins/relaxNG/validation/RngSchemaValidator$MessageConsumerImpl";
            objectArray[2] = "onMessage";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ValidationMessageConsumer {
        public void onMessage(@NotNull PsiElement var1, @InspectionMessage @NotNull String var2);
    }

    static class MyValidationMessageConsumer {
        final List<Pair<PsiElement, @InspectionMessage String>> errors = new ArrayList<Pair<PsiElement, String>>();
        final List<Pair<PsiElement, @InspectionMessage String>> warnings = new ArrayList<Pair<PsiElement, String>>();

        MyValidationMessageConsumer() {
        }

        ValidationMessageConsumer error() {
            return new ValidationMessageConsumer(){

                @Override
                public void onMessage(@NotNull PsiElement context2, @NotNull String message2) {
                    if (context2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (message2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    errors.add((Pair<PsiElement, String>)Pair.create((Object)context2, (Object)message2));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "message";
                            break;
                        }
                    }
                    objectArray[1] = "org/intellij/plugins/relaxNG/validation/RngSchemaValidator$MyValidationMessageConsumer$1";
                    objectArray[2] = "onMessage";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        ValidationMessageConsumer warning() {
            return new ValidationMessageConsumer(){

                @Override
                public void onMessage(@NotNull PsiElement context2, @NotNull String message2) {
                    if (context2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (message2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    warnings.add((Pair<PsiElement, String>)Pair.create((Object)context2, (Object)message2));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "message";
                            break;
                        }
                    }
                    objectArray[1] = "org/intellij/plugins/relaxNG/validation/RngSchemaValidator$MyValidationMessageConsumer$2";
                    objectArray[2] = "onMessage";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        void apply(AnnotationHolder holder) {
            ErrorMessageConsumer errorc = new ErrorMessageConsumer(holder);
            WarningMessageConsumer warningc = new WarningMessageConsumer(holder);
            for (Pair<PsiElement, String> error2 : this.errors) {
                errorc.onMessage((PsiElement)error2.first, (String)error2.second);
            }
            for (Pair<PsiElement, String> warning : this.warnings) {
                warningc.onMessage((PsiElement)warning.first, (String)warning.second);
            }
        }
    }
}

