/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.inspections;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.compact.psi.RncDefine;
import org.intellij.plugins.relaxNG.compact.psi.RncElement;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInspection
extends XmlSuppressableInspectionTool {
    public boolean isSuppressedFor(@NotNull PsiElement element2) {
        if (element2 == null) {
            BaseInspection.$$$reportNull$$$0(0);
        }
        if (element2.getContainingFile() instanceof RncFile) {
            RncDefine define = (RncDefine)PsiTreeUtil.getParentOfType((PsiElement)element2, RncDefine.class, (boolean)false);
            if (define != null && this.isSuppressedAt(define)) {
                return true;
            }
            RncGrammar grammar = (RncGrammar)PsiTreeUtil.getParentOfType((PsiElement)define, RncGrammar.class);
            return grammar != null && this.isSuppressedAt(grammar);
        }
        return super.isSuppressedFor(element2);
    }

    private boolean isSuppressedAt(RncElement location) {
        PsiElement prev2 = location.getPrevSibling();
        while (prev2 instanceof PsiWhiteSpace || prev2 instanceof PsiComment) {
            String text2;
            if (prev2 instanceof PsiComment && (text2 = prev2.getText()).matches("\n*#\\s*suppress\\s.+") && (text2.contains(this.getID()) || "ALL".equals(text2))) {
                return true;
            }
            prev2 = prev2.getPrevSibling();
        }
        return false;
    }

    public SuppressQuickFix @NotNull [] getBatchSuppressActions(@Nullable PsiElement element2) {
        if (element2.getContainingFile() instanceof RncFile) {
            SuppressQuickFix[] suppressQuickFixArray = (SuppressQuickFix[])ArrayUtil.mergeArrays((Object[])new SuppressQuickFix[]{new SuppressAction("Define"){

                @Override
                protected PsiElement getTarget(PsiElement element2) {
                    return PsiTreeUtil.getParentOfType((PsiElement)element2, RncDefine.class, (boolean)false);
                }
            }, new SuppressAction("Grammar"){

                @Override
                protected PsiElement getTarget(PsiElement element2) {
                    RncDefine define = (RncDefine)PsiTreeUtil.getParentOfType((PsiElement)element2, RncDefine.class, (boolean)false);
                    RncGrammar target2 = define != null ? (RncGrammar)PsiTreeUtil.getParentOfType((PsiElement)define, RncGrammar.class, (boolean)false) : null;
                    return target2 != null && target2.getText().startsWith("grammar ") ? target2 : null;
                }
            }}, (Object[])this.getXmlOnlySuppressions(element2));
            if (suppressQuickFixArray == null) {
                BaseInspection.$$$reportNull$$$0(1);
            }
            return suppressQuickFixArray;
        }
        SuppressQuickFix[] suppressQuickFixArray = super.getBatchSuppressActions(element2);
        if (suppressQuickFixArray == null) {
            BaseInspection.$$$reportNull$$$0(2);
        }
        return suppressQuickFixArray;
    }

    private SuppressQuickFix[] getXmlOnlySuppressions(PsiElement element2) {
        return (SuppressQuickFix[])ContainerUtil.map((Object[])super.getBatchSuppressActions(element2), action2 -> new SuppressQuickFix((SuppressQuickFix)action2){
            final /* synthetic */ SuppressQuickFix val$action;
            {
                this.val$action = suppressQuickFix;
            }

            @NotNull
            public String getName() {
                String string = this.val$action.getName();
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context2) {
                if (project == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (context2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                return context2.isValid();
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                PsiElement element1;
                PsiFile file2;
                if (project == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (descriptor2 == null) {
                    3.$$$reportNull$$$0(4);
                }
                PsiFile psiFile = file2 = (element1 = descriptor2.getPsiElement()) == null ? null : element1.getContainingFile();
                if (file2 == null || file2.getFileType() != XmlFileType.INSTANCE) {
                    return;
                }
                this.val$action.applyFix(project, (CommonProblemDescriptor)descriptor2);
            }

            @NotNull
            public String getFamilyName() {
                String string = this.val$action.getFamilyName();
                if (string == null) {
                    3.$$$reportNull$$$0(5);
                }
                return string;
            }

            public boolean isSuppressAll() {
                return this.val$action.isSuppressAll();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/plugins/relaxNG/inspections/BaseInspection$3";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/plugins/relaxNG/inspections/BaseInspection$3";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, (Object[])SuppressQuickFix.EMPTY_ARRAY);
    }

    private void suppress(PsiFile file2, @NotNull PsiElement location) {
        if (location == null) {
            BaseInspection.$$$reportNull$$$0(3);
        }
        BaseInspection.suppress(file2, location, "#suppress " + this.getID(), (Function<? super String, String>)((Function)text2 -> text2 + ", " + this.getID()));
    }

    private static void suppress(PsiFile file2, @NotNull PsiElement location, String suppressComment, Function<? super String, String> replace) {
        if (location == null) {
            BaseInspection.$$$reportNull$$$0(4);
        }
        Project project = file2.getProject();
        VirtualFile vfile = file2.getVirtualFile();
        if (vfile == null || ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Collections.singletonList(vfile)).hasReadonlyFiles()) {
            return;
        }
        Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        assert (doc != null);
        PsiElement leaf = location.getPrevSibling();
        while (leaf instanceof PsiWhiteSpace) {
            leaf = leaf.getPrevSibling();
        }
        while (leaf instanceof PsiComment || leaf instanceof PsiWhiteSpace) {
            @NonNls String text2 = leaf.getText();
            if (text2.matches("\n*#\\s*suppress\\s.+")) {
                TextRange textRange = leaf.getTextRange();
                doc.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)replace.fun((Object)text2));
                return;
            }
            leaf = leaf.getPrevSibling();
        }
        int offset = location.getTextRange().getStartOffset();
        doc.insertString(offset, (CharSequence)(suppressComment + "\n"));
        CodeStyleManager.getInstance((Project)project).adjustLineIndent(doc, offset + suppressComment.length());
    }

    @NotNull
    public abstract RncElementVisitor buildVisitor(@NotNull ProblemsHolder var1, boolean var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/inspections/BaseInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/inspections/BaseInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suppress";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class SuppressAction
    implements SuppressQuickFix {
        private final String myLocation;

        SuppressAction(String location) {
            this.myLocation = location;
        }

        @NotNull
        public String getName() {
            String string = RelaxngBundle.message("relaxng.suppress.action.name", this.myLocation);
            if (string == null) {
                SuppressAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = BaseInspection.this.getDisplayName();
            if (string == null) {
                SuppressAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context2) {
            if (project == null) {
                SuppressAction.$$$reportNull$$$0(2);
            }
            if (context2 == null) {
                SuppressAction.$$$reportNull$$$0(3);
            }
            return context2.isValid();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element2;
            PsiElement target2;
            if (project == null) {
                SuppressAction.$$$reportNull$$$0(4);
            }
            if (descriptor2 == null) {
                SuppressAction.$$$reportNull$$$0(5);
            }
            if ((target2 = this.getTarget(element2 = descriptor2.getPsiElement())) == null) {
                return;
            }
            BaseInspection.this.suppress(element2.getContainingFile(), target2);
        }

        protected abstract PsiElement getTarget(PsiElement var1);

        public boolean isSuppressAll() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/relaxNG/inspections/BaseInspection$SuppressAction";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/relaxNG/inspections/BaseInspection$SuppressAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

