/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.EnumArrayValueWrapper;
import com.jetbrains.jsonSchema.impl.EnumObjectValueWrapper;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumValidation
implements JsonSchemaValidation {
    public static final EnumValidation INSTANCE = new EnumValidation();

    @Override
    public void validate(JsonValueAdapter propValue, JsonSchemaObject schema2, JsonSchemaType schemaType, JsonValidationHost consumer, JsonComplianceCheckerOptions options2) {
        List<Object> enumItems = schema2.getEnum();
        if (enumItems == null) {
            return;
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(propValue.getDelegate(), schema2);
        if (walker == null) {
            return;
        }
        String text2 = StringUtil.notNullize((String)walker.getNodeTextForValidation(propValue.getDelegate()));
        BiFunction<String, String, Boolean> eq = options2.isCaseInsensitiveEnumCheck() || schema2.isForceCaseInsensitive() ? String::equalsIgnoreCase : String::equals;
        for (Object object : enumItems) {
            if (!EnumValidation.checkEnumValue(object, walker, propValue, text2, eq)) continue;
            return;
        }
        consumer.error(JsonBundle.message("schema.validation.enum.mismatch", StringUtil.join(enumItems, o -> o.toString(), (String)", ")), propValue.getDelegate(), JsonValidationError.FixableIssueKind.NonEnumValue, null, JsonErrorPriority.MEDIUM_PRIORITY);
    }

    private static boolean checkEnumValue(@NotNull Object object, @NotNull JsonLikePsiWalker walker, @Nullable JsonValueAdapter adapter, @NotNull String text2, @NotNull BiFunction<String, String, Boolean> stringEq) {
        if (object == null) {
            EnumValidation.$$$reportNull$$$0(0);
        }
        if (walker == null) {
            EnumValidation.$$$reportNull$$$0(1);
        }
        if (text2 == null) {
            EnumValidation.$$$reportNull$$$0(2);
        }
        if (stringEq == null) {
            EnumValidation.$$$reportNull$$$0(3);
        }
        if (adapter != null && !adapter.shouldCheckAsValue()) {
            return true;
        }
        if (object instanceof EnumArrayValueWrapper) {
            if (adapter instanceof JsonArrayValueAdapter) {
                List<JsonValueAdapter> elements = ((JsonArrayValueAdapter)adapter).getElements();
                Object[] values2 = ((EnumArrayValueWrapper)object).getValues();
                if (elements.size() == values2.length) {
                    for (int i2 = 0; i2 < values2.length; ++i2) {
                        if (EnumValidation.checkEnumValue(values2[i2], walker, elements.get(i2), walker.getNodeTextForValidation(elements.get(i2).getDelegate()), stringEq)) continue;
                        return false;
                    }
                    return true;
                }
            }
        } else if (object instanceof EnumObjectValueWrapper) {
            if (adapter instanceof JsonObjectValueAdapter) {
                List<JsonPropertyAdapter> props = ((JsonObjectValueAdapter)adapter).getPropertyList();
                Map<String, Object> values3 = ((EnumObjectValueWrapper)object).getValues();
                if (props.size() == values3.size()) {
                    for (JsonPropertyAdapter prop : props) {
                        if (!values3.containsKey(prop.getName())) {
                            return false;
                        }
                        for (JsonValueAdapter value2 : prop.getValues()) {
                            if (EnumValidation.checkEnumValue(values3.get(prop.getName()), walker, value2, walker.getNodeTextForValidation(value2.getDelegate()), stringEq)) continue;
                            return false;
                        }
                    }
                    return true;
                }
            }
        } else if (!walker.allowsSingleQuotes() ? stringEq.apply(object.toString(), text2) != false : EnumValidation.equalsIgnoreQuotes(object.toString(), text2, walker.requiresValueQuotes(), stringEq)) {
            return true;
        }
        return false;
    }

    private static boolean equalsIgnoreQuotes(@NotNull String s1, @NotNull String s2, boolean requireQuotedValues, BiFunction<String, String, Boolean> eq) {
        if (s1 == null) {
            EnumValidation.$$$reportNull$$$0(4);
        }
        if (s2 == null) {
            EnumValidation.$$$reportNull$$$0(5);
        }
        boolean quoted1 = StringUtil.isQuotedString((String)s1);
        boolean quoted2 = StringUtil.isQuotedString((String)s2);
        if (requireQuotedValues && quoted1 != quoted2) {
            return false;
        }
        if (requireQuotedValues && !quoted1) {
            return eq.apply(s1, s2);
        }
        return eq.apply(StringUtil.unquoteString((String)s1), StringUtil.unquoteString((String)s2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "walker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringEq";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/validations/EnumValidation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkEnumValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "equalsIgnoreQuotes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

