/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.intellij.json.JsonBundle;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ArrayValidation
implements JsonSchemaValidation {
    public static final ArrayValidation INSTANCE = new ArrayValidation();

    @Override
    public void validate(JsonValueAdapter propValue, JsonSchemaObject schema2, JsonSchemaType schemaType, JsonValidationHost consumer, JsonComplianceCheckerOptions options2) {
        ArrayValidation.checkArray(propValue, schema2, consumer, options2);
    }

    private static void checkArray(JsonValueAdapter value2, JsonSchemaObject schema2, JsonValidationHost consumer, JsonComplianceCheckerOptions options2) {
        JsonArrayValueAdapter asArray = value2.getAsArray();
        if (asArray == null) {
            return;
        }
        List<JsonValueAdapter> elements = asArray.getElements();
        ArrayValidation.checkArrayItems(value2, elements, schema2, consumer, options2);
    }

    private static void checkArrayItems(@NotNull JsonValueAdapter array2, @NotNull List<JsonValueAdapter> list2, JsonSchemaObject schema2, JsonValidationHost consumer, JsonComplianceCheckerOptions options2) {
        if (array2 == null) {
            ArrayValidation.$$$reportNull$$$0(0);
        }
        if (list2 == null) {
            ArrayValidation.$$$reportNull$$$0(1);
        }
        if (schema2.isUniqueItems()) {
            MultiMap valueTexts = new MultiMap();
            JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(array2.getDelegate(), schema2);
            assert (walker != null);
            for (JsonValueAdapter adapter : list2) {
                valueTexts.putValue((Object)walker.getNodeTextForValidation(adapter.getDelegate()), (Object)adapter);
            }
            for (Map.Entry entry2 : valueTexts.entrySet()) {
                if (((Collection)entry2.getValue()).size() <= 1) continue;
                for (JsonValueAdapter item : (Collection)entry2.getValue()) {
                    if (!item.shouldCheckAsValue()) continue;
                    consumer.error(JsonBundle.message("schema.validation.not.unique", new Object[0]), item.getDelegate(), JsonErrorPriority.TYPE_MISMATCH);
                }
            }
        }
        if (schema2.getContainsSchema() != null) {
            boolean match = false;
            for (JsonValueAdapter item : list2) {
                JsonValidationHost checker = consumer.checkByMatchResult(item, consumer.resolve(schema2.getContainsSchema()), options2);
                if (checker != null && !checker.isValid()) continue;
                match = true;
                break;
            }
            if (!match) {
                consumer.error(JsonBundle.message("schema.validation.array.not.contains", new Object[0]), array2.getDelegate(), JsonErrorPriority.MEDIUM_PRIORITY);
            }
        }
        if (schema2.getItemsSchema() != null) {
            for (JsonValueAdapter item : list2) {
                consumer.checkObjectBySchemaRecordErrors(schema2.getItemsSchema(), item);
            }
        } else if (schema2.getItemsSchemaList() != null) {
            Iterator<JsonSchemaObject> iterator2 = schema2.getItemsSchemaList().iterator();
            for (JsonValueAdapter arrayValue : list2) {
                if (iterator2.hasNext()) {
                    consumer.checkObjectBySchemaRecordErrors(iterator2.next(), arrayValue);
                    continue;
                }
                if (!Boolean.TRUE.equals(schema2.getAdditionalItemsAllowed())) {
                    consumer.error(JsonBundle.message("schema.validation.array.no.extra", new Object[0]), arrayValue.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
                    continue;
                }
                if (schema2.getAdditionalItemsSchema() == null) continue;
                consumer.checkObjectBySchemaRecordErrors(schema2.getAdditionalItemsSchema(), arrayValue);
            }
        }
        if (schema2.getMinItems() != null && list2.size() < schema2.getMinItems()) {
            consumer.error(JsonBundle.message("schema.validation.array.shorter.than", schema2.getMinItems()), array2.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
        if (schema2.getMaxItems() != null && list2.size() > schema2.getMaxItems()) {
            consumer.error(JsonBundle.message("schema.validation.array.longer.than", schema2.getMaxItems()), array2.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
        if (schema2.getMinLength() != null && list2.size() < schema2.getMinLength()) {
            consumer.error(JsonBundle.message("schema.validation.array.shorter.than", schema2.getMinLength()), array2.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
        if (schema2.getMaxLength() != null && list2.size() > schema2.getMaxLength()) {
            consumer.error(JsonBundle.message("schema.validation.array.longer.than", schema2.getMaxLength()), array2.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "array";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "list";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/jsonSchema/impl/validations/ArrayValidation";
        objectArray[2] = "checkArrayItems";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

