/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaTreeNode;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaResolver {
    @NotNull
    private final Project myProject;
    @NotNull
    private final JsonSchemaObject mySchema;
    @NotNull
    private final JsonPointerPosition myPosition;

    public JsonSchemaResolver(@NotNull Project project, @NotNull JsonSchemaObject schema2, @NotNull JsonPointerPosition position) {
        if (project == null) {
            JsonSchemaResolver.$$$reportNull$$$0(0);
        }
        if (schema2 == null) {
            JsonSchemaResolver.$$$reportNull$$$0(1);
        }
        if (position == null) {
            JsonSchemaResolver.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.mySchema = schema2;
        this.myPosition = position;
    }

    public JsonSchemaResolver(@NotNull Project project, @NotNull JsonSchemaObject schema2) {
        if (project == null) {
            JsonSchemaResolver.$$$reportNull$$$0(3);
        }
        if (schema2 == null) {
            JsonSchemaResolver.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.mySchema = schema2;
        this.myPosition = new JsonPointerPosition();
    }

    public MatchResult detailedResolve() {
        JsonSchemaTreeNode node = JsonSchemaVariantsTreeBuilder.buildTree(this.myProject, this.mySchema, this.myPosition, false);
        return MatchResult.create(node);
    }

    @NotNull
    public Collection<JsonSchemaObject> resolve() {
        MatchResult result2 = this.detailedResolve();
        LinkedList<JsonSchemaObject> list2 = new LinkedList<JsonSchemaObject>();
        list2.addAll(result2.mySchemas);
        for (Collection<? extends JsonSchemaObject> myExcludingSchema : result2.myExcludingSchemas) {
            list2.addAll(myExcludingSchema);
        }
        LinkedList<JsonSchemaObject> linkedList = list2;
        if (linkedList == null) {
            JsonSchemaResolver.$$$reportNull$$$0(5);
        }
        return linkedList;
    }

    @Nullable
    public PsiElement findNavigationTarget(@Nullable PsiElement element2) {
        JsonSchemaTreeNode node = JsonSchemaVariantsTreeBuilder.buildTree(this.myProject, this.mySchema, this.myPosition, true);
        JsonSchemaObject schema2 = this.selectSchema(node, element2, this.myPosition.isEmpty());
        if (schema2 == null) {
            return null;
        }
        VirtualFile file2 = JsonSchemaService.Impl.get(this.myProject).resolveSchemaFile(schema2);
        if (file2 == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (psiFile == null) {
            return null;
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker((PsiElement)psiFile, schema2);
        return walker == null ? null : JsonSchemaResolver.resolvePosition(walker, (PsiElement)psiFile, JsonPointerPosition.parsePointer(schema2.getPointer()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private static PsiElement resolvePosition(@NotNull JsonLikePsiWalker walker, @Nullable PsiElement element2, @NotNull JsonPointerPosition position) {
        PsiElement psiElement;
        PsiElement psiElement2;
        if (walker == null) {
            JsonSchemaResolver.$$$reportNull$$$0(6);
        }
        if (position == null) {
            JsonSchemaResolver.$$$reportNull$$$0(7);
        }
        PsiElement psiElement3 = psiElement2 = element2 instanceof PsiFile ? (PsiElement)ContainerUtil.getFirstItem(walker.getRoots((PsiFile)element2)) : element2;
        if (psiElement2 == null) {
            return null;
        }
        JsonValueAdapter value2 = walker.createValueAdapter(psiElement2);
        while (position != null && !position.isEmpty()) {
            block14: {
                int index2;
                if (value2 instanceof JsonObjectValueAdapter) {
                    String name = position.getFirstName();
                    if (name == null) {
                        return null;
                    }
                    JsonPropertyAdapter property2 = JsonSchemaResolver.findProperty((JsonObjectValueAdapter)value2, name);
                    if (property2 != null) {
                        value2 = JsonSchemaResolver.getValue(property2);
                        if (value2 == null) {
                            return null;
                        }
                        break block14;
                    } else {
                        JsonPropertyAdapter props = JsonSchemaResolver.findProperty((JsonObjectValueAdapter)value2, "properties");
                        if (props != null) {
                            value2 = JsonSchemaResolver.getValue(props);
                            continue;
                        }
                        JsonPropertyAdapter defs = JsonSchemaResolver.findProperty((JsonObjectValueAdapter)value2, "definitions");
                        if (defs != null) {
                            value2 = JsonSchemaResolver.getValue(defs);
                            continue;
                        }
                        JsonPropertyAdapter defs9 = JsonSchemaResolver.findProperty((JsonObjectValueAdapter)value2, "$defs");
                        if (defs9 == null) return null;
                        value2 = JsonSchemaResolver.getValue(defs9);
                        continue;
                    }
                }
                if (value2 instanceof JsonArrayValueAdapter && (index2 = position.getFirstIndex()) >= 0) {
                    List<JsonValueAdapter> values2 = ((JsonArrayValueAdapter)value2).getElements();
                    if (values2.size() <= index2) return null;
                    value2 = values2.get(index2);
                }
            }
            position = position.skip(1);
        }
        if (value2 == null) {
            return null;
        }
        PsiElement delegate2 = value2.getDelegate();
        PsiElement propertyNameElement = walker.getPropertyNameElement(delegate2.getParent());
        if (propertyNameElement == null) {
            psiElement = delegate2;
            return psiElement;
        }
        psiElement = propertyNameElement;
        return psiElement;
    }

    @Nullable
    private static JsonValueAdapter getValue(@NotNull JsonPropertyAdapter property2) {
        Collection<JsonValueAdapter> values2;
        if (property2 == null) {
            JsonSchemaResolver.$$$reportNull$$$0(8);
        }
        return (values2 = property2.getValues()).size() == 1 ? values2.iterator().next() : null;
    }

    @Nullable
    private static JsonPropertyAdapter findProperty(@NotNull JsonObjectValueAdapter value2, @NotNull String name) {
        if (value2 == null) {
            JsonSchemaResolver.$$$reportNull$$$0(9);
        }
        if (name == null) {
            JsonSchemaResolver.$$$reportNull$$$0(10);
        }
        List<JsonPropertyAdapter> list2 = value2.getPropertyList();
        return list2.stream().filter(p -> name.equals(p.getName())).findFirst().orElse(null);
    }

    @Nullable
    private JsonSchemaObject selectSchema(@NotNull JsonSchemaTreeNode resolveRoot, @Nullable PsiElement element2, boolean topLevelSchema) {
        JsonValueAdapter parentAdapter;
        JsonValueAdapter adapter;
        if (resolveRoot == null) {
            JsonSchemaResolver.$$$reportNull$$$0(11);
        }
        MatchResult matchResult = MatchResult.create(resolveRoot);
        ArrayList<JsonSchemaObject> schemas = new ArrayList<JsonSchemaObject>(matchResult.mySchemas);
        schemas.addAll(matchResult.myExcludingSchemas.stream().flatMap(Collection::stream).collect(Collectors.toList()));
        JsonSchemaObject firstSchema = JsonSchemaResolver.getFirstValidSchema(schemas);
        if (element2 == null || schemas.size() == 1 || firstSchema == null) {
            return firstSchema;
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(element2, firstSchema);
        if (walker == null || (adapter = walker.createValueAdapter(element2)) == null) {
            return null;
        }
        if (topLevelSchema) {
            parentAdapter = null;
        } else {
            PsiElement parentValue = walker.getParentContainer(element2);
            if (parentValue == null || (parentAdapter = walker.createValueAdapter(parentValue)) == null) {
                return null;
            }
        }
        Ref schemaRef = new Ref();
        MatchResult.iterateTree(resolveRoot, (Processor<? super JsonSchemaTreeNode>)((Processor)node -> {
            JsonSchemaTreeNode parent = node.getParent();
            if (node.getSchema() == null || parentAdapter != null && parent != null && parent.isNothing()) {
                return true;
            }
            if (!this.isCorrect(adapter, node.getSchema())) {
                return true;
            }
            if (parentAdapter == null || parent == null || parent.getSchema() == null || parent.isAny() || this.isCorrect(parentAdapter, parent.getSchema())) {
                schemaRef.set((Object)node.getSchema());
                return false;
            }
            return true;
        }));
        return (JsonSchemaObject)schemaRef.get();
    }

    @Nullable
    private static JsonSchemaObject getFirstValidSchema(List<JsonSchemaObject> schemas) {
        return schemas.stream().findFirst().orElse(null);
    }

    private boolean isCorrect(@NotNull JsonValueAdapter value2, @NotNull JsonSchemaObject schema2) {
        JsonSchemaType type;
        if (value2 == null) {
            JsonSchemaResolver.$$$reportNull$$$0(12);
        }
        if (schema2 == null) {
            JsonSchemaResolver.$$$reportNull$$$0(13);
        }
        if ((type = JsonSchemaType.getType(value2)) == null) {
            return true;
        }
        if (!JsonSchemaAnnotatorChecker.areSchemaTypesCompatible(schema2, type)) {
            return false;
        }
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(this.myProject, JsonComplianceCheckerOptions.RELAX_ENUM_CHECK);
        checker.checkByScheme(value2, schema2);
        return checker.isCorrect();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "walker";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaResolver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolvePosition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findProperty";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "selectSchema";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isCorrect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

