/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import com.jetbrains.jsonSchema.JsonSchemaVfsListener;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.IfThenElse;
import com.jetbrains.jsonSchema.impl.JsonCachedValues;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonSchemaObject {
    private static final Logger LOG = Logger.getInstance(JsonSchemaObject.class);
    public static final String MOCK_URL = "mock:///";
    public static final String TEMP_URL = "temp:///";
    @NonNls
    public static final String DEFINITIONS = "definitions";
    @NonNls
    public static final String DEFINITIONS_v9 = "$defs";
    @NonNls
    public static final String PROPERTIES = "properties";
    @NonNls
    public static final String ITEMS = "items";
    @NonNls
    public static final String ADDITIONAL_ITEMS = "additionalItems";
    @NonNls
    public static final String X_INTELLIJ_HTML_DESCRIPTION = "x-intellij-html-description";
    @NonNls
    public static final String X_INTELLIJ_LANGUAGE_INJECTION = "x-intellij-language-injection";
    @NonNls
    public static final String X_INTELLIJ_CASE_INSENSITIVE = "x-intellij-case-insensitive";
    @NonNls
    public static final String X_INTELLIJ_ENUM_METADATA = "x-intellij-enum-metadata";
    @Nullable
    private final String myFileUrl;
    @Nullable
    private JsonSchemaObject myBackRef;
    @NotNull
    private final String myPointer;
    @Nullable
    private final VirtualFile myRawFile;
    @Nullable
    private Map<String, JsonSchemaObject> myDefinitionsMap;
    @NotNull
    public static final JsonSchemaObject NULL_OBJ = new JsonSchemaObject("$_NULL_$");
    @NotNull
    private final ConcurrentMap<String, JsonSchemaObject> myComputedRefs;
    @NotNull
    private final AtomicBoolean mySubscribed;
    @NotNull
    private Map<String, JsonSchemaObject> myProperties;
    @Nullable
    private PatternProperties myPatternProperties;
    @Nullable
    private PropertyNamePattern myPattern;
    @Nullable
    private String myId;
    @Nullable
    private String mySchema;
    @Nullable
    private String myTitle;
    @Nullable
    private String myDescription;
    @Nullable
    private String myHtmlDescription;
    @Nullable
    private String myLanguageInjection;
    @Nullable
    private String myLanguageInjectionPrefix;
    @Nullable
    private String myLanguageInjectionPostfix;
    @Nullable
    private JsonSchemaType myType;
    @Nullable
    private Object myDefault;
    @Nullable
    private String myRef;
    private boolean myRefIsRecursive;
    private boolean myIsRecursiveAnchor;
    @Nullable
    private String myFormat;
    @Nullable
    private Set<JsonSchemaType> myTypeVariants;
    @Nullable
    private Number myMultipleOf;
    @Nullable
    private Number myMaximum;
    private boolean myExclusiveMaximum;
    @Nullable
    private Number myExclusiveMaximumNumber;
    @Nullable
    private Number myMinimum;
    private boolean myExclusiveMinimum;
    @Nullable
    private Number myExclusiveMinimumNumber;
    @Nullable
    private Integer myMaxLength;
    @Nullable
    private Integer myMinLength;
    @Nullable
    private Boolean myAdditionalPropertiesAllowed;
    @Nullable
    private Set<String> myAdditionalPropertiesNotAllowedFor;
    @Nullable
    private JsonSchemaObject myAdditionalPropertiesSchema;
    @Nullable
    private JsonSchemaObject myPropertyNamesSchema;
    @Nullable
    private Boolean myAdditionalItemsAllowed;
    @Nullable
    private JsonSchemaObject myAdditionalItemsSchema;
    @Nullable
    private JsonSchemaObject myItemsSchema;
    @Nullable
    private JsonSchemaObject myContainsSchema;
    @Nullable
    private List<JsonSchemaObject> myItemsSchemaList;
    @Nullable
    private Integer myMaxItems;
    @Nullable
    private Integer myMinItems;
    @Nullable
    private Boolean myUniqueItems;
    @Nullable
    private Integer myMaxProperties;
    @Nullable
    private Integer myMinProperties;
    @Nullable
    private Set<String> myRequired;
    @Nullable
    private Map<String, List<String>> myPropertyDependencies;
    @Nullable
    private Map<String, JsonSchemaObject> mySchemaDependencies;
    @Nullable
    private List<Object> myEnum;
    @Nullable
    private List<JsonSchemaObject> myAllOf;
    @Nullable
    private List<JsonSchemaObject> myAnyOf;
    @Nullable
    private List<JsonSchemaObject> myOneOf;
    @Nullable
    private JsonSchemaObject myNot;
    @Nullable
    private List<IfThenElse> myIfThenElse;
    @Nullable
    private JsonSchemaObject myIf;
    @Nullable
    private JsonSchemaObject myThen;
    @Nullable
    private JsonSchemaObject myElse;
    private boolean myShouldValidateAgainstJSType;
    @Nullable
    private String myDeprecationMessage;
    @Nullable
    private Map<String, String> myIdsMap;
    @Nullable
    private Map<String, Map<String, String>> myEnumMetadata;
    private boolean myForceCaseInsensitive;
    private boolean myIsValidByExclusion;

    public boolean isValidByExclusion() {
        return this.myIsValidByExclusion;
    }

    public boolean isForceCaseInsensitive() {
        return this.myForceCaseInsensitive;
    }

    public void setForceCaseInsensitive(boolean forceCaseInsensitive) {
        this.myForceCaseInsensitive = forceCaseInsensitive;
    }

    public JsonSchemaObject(@Nullable VirtualFile file2, @NotNull String pointer) {
        if (pointer == null) {
            JsonSchemaObject.$$$reportNull$$$0(0);
        }
        this.myComputedRefs = new ConcurrentHashMap<String, JsonSchemaObject>();
        this.mySubscribed = new AtomicBoolean(false);
        this.myForceCaseInsensitive = false;
        this.myIsValidByExclusion = true;
        this.myFileUrl = file2 == null ? null : file2.getUrl();
        this.myRawFile = this.myFileUrl != null && JsonFileResolver.isTempOrMockUrl(this.myFileUrl) ? file2 : null;
        this.myPointer = pointer;
        this.myProperties = new HashMap<String, JsonSchemaObject>();
    }

    private JsonSchemaObject(@Nullable VirtualFile rawFile, @Nullable String fileUrl, @NotNull String pointer) {
        if (pointer == null) {
            JsonSchemaObject.$$$reportNull$$$0(1);
        }
        this.myComputedRefs = new ConcurrentHashMap<String, JsonSchemaObject>();
        this.mySubscribed = new AtomicBoolean(false);
        this.myForceCaseInsensitive = false;
        this.myIsValidByExclusion = true;
        this.myFileUrl = fileUrl;
        this.myRawFile = rawFile;
        this.myPointer = pointer;
        this.myProperties = new HashMap<String, JsonSchemaObject>();
    }

    private JsonSchemaObject(@NotNull String pointer) {
        if (pointer == null) {
            JsonSchemaObject.$$$reportNull$$$0(2);
        }
        this(null, pointer);
    }

    public void completeInitialization(JsonValueAdapter jsonObject) {
        if (this.myIf != null) {
            this.myIfThenElse = new ArrayList<IfThenElse>();
            this.myIfThenElse.add(new IfThenElse(this.myIf, this.myThen, this.myElse));
        }
        this.myIdsMap = JsonCachedValues.getOrComputeIdsMap(jsonObject.getDelegate().getContainingFile());
    }

    public String resolveId(@NotNull String id2) {
        if (id2 == null) {
            JsonSchemaObject.$$$reportNull$$$0(3);
        }
        return this.myIdsMap == null ? null : this.myIdsMap.get(id2);
    }

    @NotNull
    public String getPointer() {
        String string = this.myPointer;
        if (string == null) {
            JsonSchemaObject.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public String getFileUrl() {
        return this.myFileUrl;
    }

    @Nullable
    public VirtualFile getRawFile() {
        return this.myRawFile;
    }

    public void setLanguageInjection(@Nullable String injection) {
        this.myLanguageInjection = injection;
    }

    public void setLanguageInjectionPrefix(@Nullable String prefix2) {
        this.myLanguageInjectionPrefix = prefix2;
    }

    public void setLanguageInjectionPostfix(@Nullable String postfix) {
        this.myLanguageInjectionPostfix = postfix;
    }

    @Nullable
    public String getLanguageInjection() {
        return this.myLanguageInjection;
    }

    @Nullable
    public String getLanguageInjectionPrefix() {
        return this.myLanguageInjectionPrefix;
    }

    @Nullable
    public String getLanguageInjectionPostfix() {
        return this.myLanguageInjectionPostfix;
    }

    @Nullable
    private static JsonSchemaType getSubtypeOfBoth(@NotNull JsonSchemaType selfType, @NotNull JsonSchemaType otherType) {
        if (selfType == null) {
            JsonSchemaObject.$$$reportNull$$$0(5);
        }
        if (otherType == null) {
            JsonSchemaObject.$$$reportNull$$$0(6);
        }
        if (otherType == JsonSchemaType._any) {
            return selfType;
        }
        if (selfType == JsonSchemaType._any) {
            return otherType;
        }
        switch (selfType) {
            case _string: {
                return otherType == JsonSchemaType._string || otherType == JsonSchemaType._string_number ? JsonSchemaType._string : null;
            }
            case _number: {
                if (otherType == JsonSchemaType._integer) {
                    return JsonSchemaType._integer;
                }
                return otherType == JsonSchemaType._number || otherType == JsonSchemaType._string_number ? JsonSchemaType._number : null;
            }
            case _integer: {
                return otherType == JsonSchemaType._number || otherType == JsonSchemaType._string_number || otherType == JsonSchemaType._integer ? JsonSchemaType._integer : null;
            }
            case _object: {
                return otherType == JsonSchemaType._object ? JsonSchemaType._object : null;
            }
            case _array: {
                return otherType == JsonSchemaType._array ? JsonSchemaType._array : null;
            }
            case _boolean: {
                return otherType == JsonSchemaType._boolean ? JsonSchemaType._boolean : null;
            }
            case _null: {
                return otherType == JsonSchemaType._null ? JsonSchemaType._null : null;
            }
            case _string_number: {
                return otherType == JsonSchemaType._integer || otherType == JsonSchemaType._number || otherType == JsonSchemaType._string || otherType == JsonSchemaType._string_number ? otherType : null;
            }
        }
        return otherType;
    }

    @Nullable
    private JsonSchemaType mergeTypes(@Nullable JsonSchemaType selfType, @Nullable JsonSchemaType otherType, @Nullable Set<JsonSchemaType> otherTypeVariants) {
        if (selfType == null) {
            return otherType;
        }
        if (otherType == null) {
            if (otherTypeVariants != null && !otherTypeVariants.isEmpty()) {
                EnumSet<JsonSchemaType> filteredVariants = EnumSet.noneOf(JsonSchemaType.class);
                for (JsonSchemaType variant : otherTypeVariants) {
                    JsonSchemaType subtype = JsonSchemaObject.getSubtypeOfBoth(selfType, variant);
                    if (subtype == null) continue;
                    filteredVariants.add(subtype);
                }
                if (filteredVariants.size() == 0) {
                    this.myIsValidByExclusion = false;
                    return selfType;
                }
                if (filteredVariants.size() == 1) {
                    return (JsonSchemaType)((Object)filteredVariants.iterator().next());
                }
                return null;
            }
            return selfType;
        }
        JsonSchemaType subtypeOfBoth = JsonSchemaObject.getSubtypeOfBoth(selfType, otherType);
        if (subtypeOfBoth == null) {
            this.myIsValidByExclusion = false;
            return otherType;
        }
        return subtypeOfBoth;
    }

    private Set<JsonSchemaType> mergeTypeVariantSets(@Nullable Set<JsonSchemaType> self, @Nullable Set<JsonSchemaType> other) {
        if (self == null) {
            return other;
        }
        if (other == null) {
            return self;
        }
        EnumSet<JsonSchemaType> resultSet = EnumSet.noneOf(JsonSchemaType.class);
        for (JsonSchemaType type : self) {
            JsonSchemaType merged = this.mergeTypes(type, null, other);
            if (merged == null) continue;
            resultSet.add(merged);
        }
        if (resultSet.isEmpty()) {
            this.myIsValidByExclusion = false;
            return other;
        }
        return resultSet;
    }

    public void mergeValues(@NotNull JsonSchemaObject other) {
        if (other == null) {
            JsonSchemaObject.$$$reportNull$$$0(7);
        }
        JsonSchemaObject.mergeProperties(this, other);
        this.myDefinitionsMap = JsonSchemaObject.copyMap(this.myDefinitionsMap, other.myDefinitionsMap);
        Map<String, JsonSchemaObject> map2 = JsonSchemaObject.copyMap(this.myPatternProperties == null ? null : this.myPatternProperties.mySchemasMap, other.myPatternProperties == null ? null : other.myPatternProperties.mySchemasMap);
        PatternProperties patternProperties = this.myPatternProperties = map2 == null ? null : new PatternProperties(map2);
        if (!StringUtil.isEmptyOrSpaces((String)other.myTitle)) {
            this.myTitle = other.myTitle;
        }
        if (!StringUtil.isEmptyOrSpaces((String)other.myDescription)) {
            this.myDescription = other.myDescription;
        }
        if (!StringUtil.isEmptyOrSpaces((String)other.myHtmlDescription)) {
            this.myHtmlDescription = other.myHtmlDescription;
        }
        if (!StringUtil.isEmptyOrSpaces((String)other.myDeprecationMessage)) {
            this.myDeprecationMessage = other.myDeprecationMessage;
        }
        this.myType = this.mergeTypes(this.myType, other.myType, other.myTypeVariants);
        if (other.myDefault != null) {
            this.myDefault = other.myDefault;
        }
        if (other.myRef != null) {
            this.myRef = other.myRef;
        }
        if (other.myFormat != null) {
            this.myFormat = other.myFormat;
        }
        this.myTypeVariants = this.mergeTypeVariantSets(this.myTypeVariants, other.myTypeVariants);
        if (other.myMultipleOf != null) {
            this.myMultipleOf = other.myMultipleOf;
        }
        if (other.myMaximum != null) {
            this.myMaximum = other.myMaximum;
        }
        if (other.myExclusiveMaximumNumber != null) {
            this.myExclusiveMaximumNumber = other.myExclusiveMaximumNumber;
        }
        this.myExclusiveMaximum |= other.myExclusiveMaximum;
        if (other.myMinimum != null) {
            this.myMinimum = other.myMinimum;
        }
        if (other.myExclusiveMinimumNumber != null) {
            this.myExclusiveMinimumNumber = other.myExclusiveMinimumNumber;
        }
        this.myExclusiveMinimum |= other.myExclusiveMinimum;
        if (other.myMaxLength != null) {
            this.myMaxLength = other.myMaxLength;
        }
        if (other.myMinLength != null) {
            this.myMinLength = other.myMinLength;
        }
        if (other.myPattern != null) {
            this.myPattern = other.myPattern;
        }
        if (other.myAdditionalPropertiesAllowed != null) {
            this.myAdditionalPropertiesAllowed = other.myAdditionalPropertiesAllowed;
            if (other.myAdditionalPropertiesAllowed == Boolean.FALSE) {
                this.addAdditionalPropsNotAllowedFor(other.myFileUrl, other.myPointer);
            }
        }
        if (other.myAdditionalPropertiesSchema != null) {
            this.myAdditionalPropertiesSchema = other.myAdditionalPropertiesSchema;
        }
        if (other.myPropertyNamesSchema != null) {
            this.myPropertyNamesSchema = other.myPropertyNamesSchema;
        }
        if (other.myAdditionalItemsAllowed != null) {
            this.myAdditionalItemsAllowed = other.myAdditionalItemsAllowed;
        }
        if (other.myAdditionalItemsSchema != null) {
            this.myAdditionalItemsSchema = other.myAdditionalItemsSchema;
        }
        if (other.myItemsSchema != null) {
            this.myItemsSchema = other.myItemsSchema;
        }
        if (other.myContainsSchema != null) {
            this.myContainsSchema = other.myContainsSchema;
        }
        this.myItemsSchemaList = JsonSchemaObject.copyList(this.myItemsSchemaList, other.myItemsSchemaList);
        if (other.myMaxItems != null) {
            this.myMaxItems = other.myMaxItems;
        }
        if (other.myMinItems != null) {
            this.myMinItems = other.myMinItems;
        }
        if (other.myUniqueItems != null) {
            this.myUniqueItems = other.myUniqueItems;
        }
        if (other.myMaxProperties != null) {
            this.myMaxProperties = other.myMaxProperties;
        }
        if (other.myMinProperties != null) {
            this.myMinProperties = other.myMinProperties;
        }
        if (this.myRequired != null && other.myRequired != null) {
            HashSet<String> set2 = new HashSet<String>(this.myRequired.size() + other.myRequired.size());
            set2.addAll(this.myRequired);
            set2.addAll(other.myRequired);
            this.myRequired = set2;
        } else if (other.myRequired != null) {
            this.myRequired = other.myRequired;
        }
        this.myPropertyDependencies = JsonSchemaObject.copyMap(this.myPropertyDependencies, other.myPropertyDependencies);
        this.mySchemaDependencies = JsonSchemaObject.copyMap(this.mySchemaDependencies, other.mySchemaDependencies);
        this.myEnumMetadata = JsonSchemaObject.copyMap(this.myEnumMetadata, other.myEnumMetadata);
        if (other.myEnum != null) {
            this.myEnum = other.myEnum;
        }
        this.myAllOf = JsonSchemaObject.copyList(this.myAllOf, other.myAllOf);
        this.myAnyOf = JsonSchemaObject.copyList(this.myAnyOf, other.myAnyOf);
        this.myOneOf = JsonSchemaObject.copyList(this.myOneOf, other.myOneOf);
        if (other.myNot != null) {
            this.myNot = other.myNot;
        }
        if (other.myIfThenElse != null) {
            this.myIfThenElse = this.myIfThenElse == null ? other.myIfThenElse : ContainerUtil.concat(this.myIfThenElse, other.myIfThenElse);
        }
        this.myShouldValidateAgainstJSType |= other.myShouldValidateAgainstJSType;
        if (this.myLanguageInjection == null) {
            this.myLanguageInjection = other.myLanguageInjection;
        }
        this.myForceCaseInsensitive = this.myForceCaseInsensitive || other.myForceCaseInsensitive;
    }

    private static void mergeProperties(@NotNull JsonSchemaObject thisObject, @NotNull JsonSchemaObject otherObject) {
        if (thisObject == null) {
            JsonSchemaObject.$$$reportNull$$$0(8);
        }
        if (otherObject == null) {
            JsonSchemaObject.$$$reportNull$$$0(9);
        }
        for (Map.Entry<String, JsonSchemaObject> prop : otherObject.myProperties.entrySet()) {
            String key = prop.getKey();
            JsonSchemaObject otherProp = prop.getValue();
            if (!thisObject.myProperties.containsKey(key)) {
                thisObject.myProperties.put(key, otherProp);
                continue;
            }
            JsonSchemaObject existingProp = thisObject.myProperties.get(key);
            thisObject.myProperties.put(key, JsonSchemaObject.merge(existingProp, otherProp, otherProp));
        }
    }

    public void setShouldValidateAgainstJSType() {
        this.myShouldValidateAgainstJSType = true;
    }

    public boolean isShouldValidateAgainstJSType() {
        return this.myShouldValidateAgainstJSType;
    }

    @Nullable
    private static <T> List<T> copyList(@Nullable List<T> target2, @Nullable List<T> source) {
        if (source == null || source.isEmpty()) {
            return target2;
        }
        if (target2 == null) {
            target2 = new ArrayList<T>(source.size());
        }
        target2.addAll(source);
        return target2;
    }

    @Nullable
    private static <K, V> Map<K, V> copyMap(@Nullable Map<K, V> target2, @Nullable Map<K, V> source) {
        if (source == null || source.isEmpty()) {
            return target2;
        }
        if (target2 == null) {
            target2 = new HashMap(source.size());
        }
        target2.putAll(source);
        return target2;
    }

    @Nullable
    public Map<String, JsonSchemaObject> getDefinitionsMap() {
        return this.myDefinitionsMap;
    }

    public void setDefinitionsMap(@NotNull Map<String, JsonSchemaObject> definitionsMap) {
        if (definitionsMap == null) {
            JsonSchemaObject.$$$reportNull$$$0(10);
        }
        this.myDefinitionsMap = definitionsMap;
    }

    @NotNull
    public Map<String, JsonSchemaObject> getProperties() {
        Map<String, JsonSchemaObject> map2 = this.myProperties;
        if (map2 == null) {
            JsonSchemaObject.$$$reportNull$$$0(11);
        }
        return map2;
    }

    public void setProperties(@NotNull Map<String, JsonSchemaObject> properties) {
        if (properties == null) {
            JsonSchemaObject.$$$reportNull$$$0(12);
        }
        this.myProperties = properties;
    }

    public boolean hasPatternProperties() {
        return this.myPatternProperties != null;
    }

    public void setPatternProperties(@NotNull Map<String, JsonSchemaObject> patternProperties) {
        if (patternProperties == null) {
            JsonSchemaObject.$$$reportNull$$$0(13);
        }
        this.myPatternProperties = new PatternProperties(patternProperties);
    }

    @Nullable
    public JsonSchemaType getType() {
        return this.myType;
    }

    public void setType(@Nullable JsonSchemaType type) {
        this.myType = type;
    }

    @Nullable
    public Number getMultipleOf() {
        return this.myMultipleOf;
    }

    public void setMultipleOf(@Nullable Number multipleOf) {
        this.myMultipleOf = multipleOf;
    }

    @Nullable
    public Number getMaximum() {
        return this.myMaximum;
    }

    public void setMaximum(@Nullable Number maximum) {
        this.myMaximum = maximum;
    }

    public boolean isExclusiveMaximum() {
        return this.myExclusiveMaximum;
    }

    @Nullable
    public Number getExclusiveMaximumNumber() {
        return this.myExclusiveMaximumNumber;
    }

    public void setExclusiveMaximumNumber(@Nullable Number exclusiveMaximumNumber) {
        this.myExclusiveMaximumNumber = exclusiveMaximumNumber;
    }

    @Nullable
    public Number getExclusiveMinimumNumber() {
        return this.myExclusiveMinimumNumber;
    }

    public void setExclusiveMinimumNumber(@Nullable Number exclusiveMinimumNumber) {
        this.myExclusiveMinimumNumber = exclusiveMinimumNumber;
    }

    public void setExclusiveMaximum(boolean exclusiveMaximum) {
        this.myExclusiveMaximum = exclusiveMaximum;
    }

    @Nullable
    public Number getMinimum() {
        return this.myMinimum;
    }

    public void setMinimum(@Nullable Number minimum) {
        this.myMinimum = minimum;
    }

    public boolean isExclusiveMinimum() {
        return this.myExclusiveMinimum;
    }

    public void setExclusiveMinimum(boolean exclusiveMinimum) {
        this.myExclusiveMinimum = exclusiveMinimum;
    }

    @Nullable
    public Integer getMaxLength() {
        return this.myMaxLength;
    }

    public void setMaxLength(@Nullable Integer maxLength) {
        this.myMaxLength = maxLength;
    }

    @Nullable
    public Integer getMinLength() {
        return this.myMinLength;
    }

    public void setMinLength(@Nullable Integer minLength) {
        this.myMinLength = minLength;
    }

    @Nullable
    public String getPattern() {
        return this.myPattern == null ? null : this.myPattern.getPattern();
    }

    public void setPattern(@Nullable String pattern) {
        this.myPattern = pattern == null ? null : new PropertyNamePattern(pattern);
    }

    @Nullable
    public Boolean getAdditionalPropertiesAllowed() {
        return this.myAdditionalPropertiesAllowed == null || this.myAdditionalPropertiesAllowed != false;
    }

    public void setAdditionalPropertiesAllowed(@Nullable Boolean additionalPropertiesAllowed) {
        this.myAdditionalPropertiesAllowed = additionalPropertiesAllowed;
        if (additionalPropertiesAllowed == Boolean.FALSE) {
            this.addAdditionalPropsNotAllowedFor(this.myFileUrl, this.myPointer);
        }
    }

    public boolean hasOwnExtraPropertyProhibition() {
        return this.getAdditionalPropertiesAllowed() == Boolean.FALSE && (this.myAdditionalPropertiesNotAllowedFor == null || this.myAdditionalPropertiesNotAllowedFor.contains(this.myFileUrl + this.myPointer));
    }

    private void addAdditionalPropsNotAllowedFor(String url, String pointer) {
        HashSet<String> newSet = this.myAdditionalPropertiesNotAllowedFor == null ? new HashSet<String>() : new HashSet<String>(this.myAdditionalPropertiesNotAllowedFor);
        newSet.add(url + pointer);
        this.myAdditionalPropertiesNotAllowedFor = newSet;
    }

    @Nullable
    public JsonSchemaObject getPropertyNamesSchema() {
        return this.myPropertyNamesSchema;
    }

    public void setPropertyNamesSchema(@Nullable JsonSchemaObject propertyNamesSchema) {
        this.myPropertyNamesSchema = propertyNamesSchema;
    }

    @Nullable
    public JsonSchemaObject getAdditionalPropertiesSchema() {
        return this.myAdditionalPropertiesSchema;
    }

    public void setAdditionalPropertiesSchema(@Nullable JsonSchemaObject additionalPropertiesSchema) {
        this.myAdditionalPropertiesSchema = additionalPropertiesSchema;
    }

    @Nullable
    public Boolean getAdditionalItemsAllowed() {
        return this.myAdditionalItemsAllowed == null || this.myAdditionalItemsAllowed != false;
    }

    public void setAdditionalItemsAllowed(@Nullable Boolean additionalItemsAllowed) {
        this.myAdditionalItemsAllowed = additionalItemsAllowed;
    }

    @Nullable
    public String getDeprecationMessage() {
        return this.myDeprecationMessage;
    }

    public void setDeprecationMessage(@Nullable String deprecationMessage) {
        this.myDeprecationMessage = deprecationMessage;
    }

    @Nullable
    public JsonSchemaObject getAdditionalItemsSchema() {
        return this.myAdditionalItemsSchema;
    }

    public void setAdditionalItemsSchema(@Nullable JsonSchemaObject additionalItemsSchema) {
        this.myAdditionalItemsSchema = additionalItemsSchema;
    }

    @Nullable
    public JsonSchemaObject getItemsSchema() {
        return this.myItemsSchema;
    }

    public void setItemsSchema(@Nullable JsonSchemaObject itemsSchema) {
        this.myItemsSchema = itemsSchema;
    }

    @Nullable
    public JsonSchemaObject getContainsSchema() {
        return this.myContainsSchema;
    }

    public void setContainsSchema(@Nullable JsonSchemaObject containsSchema) {
        this.myContainsSchema = containsSchema;
    }

    @Nullable
    public List<JsonSchemaObject> getItemsSchemaList() {
        return this.myItemsSchemaList;
    }

    public void setItemsSchemaList(@Nullable List<JsonSchemaObject> itemsSchemaList) {
        this.myItemsSchemaList = itemsSchemaList;
    }

    @Nullable
    public Integer getMaxItems() {
        return this.myMaxItems;
    }

    public void setMaxItems(@Nullable Integer maxItems) {
        this.myMaxItems = maxItems;
    }

    @Nullable
    public Integer getMinItems() {
        return this.myMinItems;
    }

    public void setMinItems(@Nullable Integer minItems) {
        this.myMinItems = minItems;
    }

    public boolean isUniqueItems() {
        return Boolean.TRUE.equals(this.myUniqueItems);
    }

    public void setUniqueItems(boolean uniqueItems) {
        this.myUniqueItems = uniqueItems;
    }

    @Nullable
    public Integer getMaxProperties() {
        return this.myMaxProperties;
    }

    public void setMaxProperties(@Nullable Integer maxProperties) {
        this.myMaxProperties = maxProperties;
    }

    @Nullable
    public Integer getMinProperties() {
        return this.myMinProperties;
    }

    public void setMinProperties(@Nullable Integer minProperties) {
        this.myMinProperties = minProperties;
    }

    @Nullable
    public Set<String> getRequired() {
        return this.myRequired;
    }

    public void setRequired(@Nullable Set<String> required) {
        this.myRequired = required;
    }

    @Nullable
    public Map<String, List<String>> getPropertyDependencies() {
        return this.myPropertyDependencies;
    }

    public void setPropertyDependencies(@Nullable Map<String, List<String>> propertyDependencies) {
        this.myPropertyDependencies = propertyDependencies;
    }

    @Nullable
    public Map<String, JsonSchemaObject> getSchemaDependencies() {
        return this.mySchemaDependencies;
    }

    public void setSchemaDependencies(@Nullable Map<String, JsonSchemaObject> schemaDependencies) {
        this.mySchemaDependencies = schemaDependencies;
    }

    @Nullable
    public Map<String, Map<String, String>> getEnumMetadata() {
        return this.myEnumMetadata;
    }

    public void setEnumMetadata(@Nullable Map<String, Map<String, String>> enumMetadata) {
        this.myEnumMetadata = enumMetadata;
    }

    @Nullable
    public List<Object> getEnum() {
        return this.myEnum;
    }

    public void setEnum(@Nullable List<Object> anEnum) {
        this.myEnum = anEnum;
    }

    @Nullable
    public List<JsonSchemaObject> getAllOf() {
        return this.myAllOf;
    }

    public void setAllOf(@Nullable List<JsonSchemaObject> allOf2) {
        this.myAllOf = allOf2;
    }

    @Nullable
    public List<JsonSchemaObject> getAnyOf() {
        return this.myAnyOf;
    }

    public void setAnyOf(@Nullable List<JsonSchemaObject> anyOf) {
        this.myAnyOf = anyOf;
    }

    @Nullable
    public List<JsonSchemaObject> getOneOf() {
        return this.myOneOf;
    }

    public void setOneOf(@Nullable List<JsonSchemaObject> oneOf) {
        this.myOneOf = oneOf;
    }

    @Nullable
    public JsonSchemaObject getNot() {
        return this.myNot;
    }

    public void setNot(@Nullable JsonSchemaObject not) {
        this.myNot = not;
    }

    @Nullable
    public List<IfThenElse> getIfThenElse() {
        return this.myIfThenElse;
    }

    public void setIf(@Nullable JsonSchemaObject anIf) {
        this.myIf = anIf;
    }

    public void setThen(@Nullable JsonSchemaObject then) {
        this.myThen = then;
    }

    public void setElse(@Nullable JsonSchemaObject anElse) {
        this.myElse = anElse;
    }

    @Nullable
    public Set<JsonSchemaType> getTypeVariants() {
        return this.myTypeVariants;
    }

    public void setTypeVariants(@Nullable Set<JsonSchemaType> typeVariants) {
        this.myTypeVariants = typeVariants;
    }

    @Nullable
    public String getRef() {
        return this.myRef;
    }

    public void setRef(@Nullable String ref) {
        this.myRef = ref;
    }

    public void setRefRecursive(boolean isRecursive) {
        this.myRefIsRecursive = isRecursive;
    }

    public boolean isRefRecursive() {
        return this.myRefIsRecursive;
    }

    public void setRecursiveAnchor(boolean isRecursive) {
        this.myIsRecursiveAnchor = isRecursive;
    }

    public boolean isRecursiveAnchor() {
        return this.myIsRecursiveAnchor;
    }

    public void setBackReference(JsonSchemaObject object) {
        this.myBackRef = object;
    }

    @Nullable
    public Object getDefault() {
        if (JsonSchemaType._integer.equals((Object)this.myType)) {
            return this.myDefault instanceof Number ? Integer.valueOf(((Number)this.myDefault).intValue()) : this.myDefault;
        }
        return this.myDefault;
    }

    public void setDefault(@Nullable Object aDefault) {
        this.myDefault = aDefault;
    }

    @Nullable
    public String getFormat() {
        return this.myFormat;
    }

    public void setFormat(@Nullable String format) {
        this.myFormat = format;
    }

    @Nullable
    public String getId() {
        return this.myId;
    }

    public void setId(@Nullable String id2) {
        this.myId = id2;
    }

    @Nullable
    public String getSchema() {
        return this.mySchema;
    }

    public void setSchema(@Nullable String schema2) {
        this.mySchema = schema2;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@NotNull String description) {
        if (description == null) {
            JsonSchemaObject.$$$reportNull$$$0(14);
        }
        this.myDescription = JsonSchemaObject.unescapeJsonString(description);
    }

    @Nullable
    public String getHtmlDescription() {
        return this.myHtmlDescription;
    }

    public void setHtmlDescription(@NotNull String htmlDescription) {
        if (htmlDescription == null) {
            JsonSchemaObject.$$$reportNull$$$0(15);
        }
        this.myHtmlDescription = JsonSchemaObject.unescapeJsonString(htmlDescription);
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(@NotNull String title2) {
        if (title2 == null) {
            JsonSchemaObject.$$$reportNull$$$0(16);
        }
        this.myTitle = JsonSchemaObject.unescapeJsonString(title2);
    }

    private static String unescapeJsonString(@NotNull String text2) {
        if (text2 == null) {
            JsonSchemaObject.$$$reportNull$$$0(17);
        }
        return StringUtil.unescapeStringCharacters((String)text2);
    }

    @Nullable
    public JsonSchemaObject getMatchingPatternPropertySchema(@NotNull String name) {
        if (name == null) {
            JsonSchemaObject.$$$reportNull$$$0(18);
        }
        if (this.myPatternProperties == null) {
            return null;
        }
        return this.myPatternProperties.getPatternPropertySchema(name);
    }

    public boolean checkByPattern(@NotNull String value2) {
        if (value2 == null) {
            JsonSchemaObject.$$$reportNull$$$0(19);
        }
        return this.myPattern != null && this.myPattern.checkByPattern(value2);
    }

    @Nullable
    public String getPatternError() {
        return this.myPattern == null ? null : this.myPattern.getPatternError();
    }

    @Nullable
    public JsonSchemaObject findRelativeDefinition(@NotNull String ref) {
        if (ref == null) {
            JsonSchemaObject.$$$reportNull$$$0(20);
        }
        if (JsonPointerUtil.isSelfReference(ref)) {
            return this;
        }
        if (!ref.startsWith("#/")) {
            return null;
        }
        ref = ref.substring(2);
        List<String> parts = JsonPointerUtil.split(ref);
        JsonSchemaObject current2 = this;
        for (int i2 = 0; i2 < parts.size(); ++i2) {
            if (current2 == null) {
                return null;
            }
            String part = parts.get(i2);
            if (DEFINITIONS.equals(part) || DEFINITIONS_v9.equals(part)) {
                if (i2 == parts.size() - 1) {
                    return null;
                }
                String nextPart = parts.get(++i2);
                current2 = current2.getDefinitionsMap() == null ? null : current2.getDefinitionsMap().get(JsonPointerUtil.unescapeJsonPointerPart(nextPart));
                continue;
            }
            if (PROPERTIES.equals(part)) {
                if (i2 == parts.size() - 1) {
                    return null;
                }
                current2 = current2.getProperties().get(JsonPointerUtil.unescapeJsonPointerPart(parts.get(++i2)));
                continue;
            }
            if (ITEMS.equals(part)) {
                if (i2 == parts.size() - 1) {
                    current2 = current2.getItemsSchema();
                    continue;
                }
                Integer next = JsonSchemaObject.tryParseInt(parts.get(++i2));
                List<JsonSchemaObject> itemsSchemaList = current2.getItemsSchemaList();
                if (itemsSchemaList == null || next == null || next >= itemsSchemaList.size()) continue;
                current2 = itemsSchemaList.get(next);
                continue;
            }
            if (ADDITIONAL_ITEMS.equals(part)) {
                if (i2 != parts.size() - 1) continue;
                current2 = current2.getAdditionalItemsSchema();
                continue;
            }
            current2 = current2.getDefinitionsMap() == null ? null : current2.getDefinitionsMap().get(part);
        }
        return current2;
    }

    @Nullable
    private static Integer tryParseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception __) {
            return null;
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchemaObject object = (JsonSchemaObject)o;
        return Objects.equals(this.myFileUrl, object.myFileUrl) && Objects.equals(this.myPointer, object.myPointer);
    }

    public int hashCode() {
        return Objects.hash(this.myFileUrl, this.myPointer);
    }

    @NotNull
    private static String adaptSchemaPattern(String pattern) {
        pattern = pattern.startsWith("^") || pattern.startsWith("*") || pattern.startsWith(".") ? pattern : ".*" + pattern;
        pattern = pattern.endsWith("+") || pattern.endsWith("*") || pattern.endsWith("$") ? pattern : pattern + ".*";
        String string = pattern = pattern.replace("\\\\", "\\");
        if (string == null) {
            JsonSchemaObject.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static Pair<Pattern, String> compilePattern(@NotNull String pattern) {
        if (pattern == null) {
            JsonSchemaObject.$$$reportNull$$$0(22);
        }
        try {
            return Pair.create((Object)Pattern.compile(JsonSchemaObject.adaptSchemaPattern(pattern)), null);
        }
        catch (PatternSyntaxException e) {
            return Pair.create(null, (Object)e.getMessage());
        }
    }

    public static boolean matchPattern(@NotNull Pattern pattern, @NotNull String s) {
        if (pattern == null) {
            JsonSchemaObject.$$$reportNull$$$0(23);
        }
        if (s == null) {
            JsonSchemaObject.$$$reportNull$$$0(24);
        }
        try {
            return pattern.matcher(StringUtil.newBombedCharSequence((CharSequence)s, (long)300L)).matches();
        }
        catch (ProcessCanceledException e) {
            Logger.getInstance(JsonSchemaObject.class).info("Pattern matching canceled");
            return false;
        }
        catch (Exception e) {
            Logger.getInstance(JsonSchemaObject.class).info((Throwable)e);
            return false;
        }
    }

    @Nullable
    public String getTypeDescription(boolean shortDesc) {
        JsonSchemaType type = this.getType();
        if (type != null) {
            return type.getDescription();
        }
        Set<JsonSchemaType> possibleTypes = this.getTypeVariants();
        String description = JsonSchemaObject.getTypesDescription(shortDesc, possibleTypes);
        if (description != null) {
            return description;
        }
        List<Object> anEnum = this.getEnum();
        if (anEnum != null) {
            return shortDesc ? "enum" : anEnum.stream().map(o -> o.toString()).collect(Collectors.joining(" | "));
        }
        JsonSchemaType guessedType = this.guessType();
        if (guessedType != null) {
            return guessedType.getDescription();
        }
        return null;
    }

    @Nullable
    public JsonSchemaType guessType() {
        JsonSchemaType type = this.getType();
        if (type != null) {
            return type;
        }
        Set<JsonSchemaType> typeVariants = this.getTypeVariants();
        if (typeVariants != null) {
            int size = typeVariants.size();
            if (size == 1) {
                return typeVariants.iterator().next();
            }
            if (size >= 2) {
                return null;
            }
        }
        boolean hasObjectChecks = this.hasObjectChecks();
        boolean hasNumericChecks = this.hasNumericChecks();
        boolean hasStringChecks = this.hasStringChecks();
        boolean hasArrayChecks = this.hasArrayChecks();
        if (hasObjectChecks && !hasNumericChecks && !hasStringChecks && !hasArrayChecks) {
            return JsonSchemaType._object;
        }
        if (!hasObjectChecks && hasNumericChecks && !hasStringChecks && !hasArrayChecks) {
            return JsonSchemaType._number;
        }
        if (!hasObjectChecks && !hasNumericChecks && hasStringChecks && !hasArrayChecks) {
            return JsonSchemaType._string;
        }
        if (!hasObjectChecks && !hasNumericChecks && !hasStringChecks && hasArrayChecks) {
            return JsonSchemaType._array;
        }
        return null;
    }

    public boolean hasNumericChecks() {
        return this.getMultipleOf() != null || this.getExclusiveMinimumNumber() != null || this.getExclusiveMaximumNumber() != null || this.getMaximum() != null || this.getMinimum() != null;
    }

    public boolean hasStringChecks() {
        return this.getPattern() != null || this.getFormat() != null;
    }

    public boolean hasArrayChecks() {
        return this.isUniqueItems() || this.getContainsSchema() != null || this.getItemsSchema() != null || this.getItemsSchemaList() != null || this.getMinItems() != null || this.getMaxItems() != null;
    }

    public boolean hasObjectChecks() {
        return !this.getProperties().isEmpty() || this.getPropertyNamesSchema() != null || this.getPropertyDependencies() != null || this.hasPatternProperties() || this.getRequired() != null || this.getMinProperties() != null || this.getMaxProperties() != null;
    }

    @Nullable
    static String getTypesDescription(boolean shortDesc, @Nullable Collection<JsonSchemaType> possibleTypes) {
        if (possibleTypes == null || possibleTypes.size() == 0) {
            return null;
        }
        if (possibleTypes.size() == 1) {
            return possibleTypes.iterator().next().getDescription();
        }
        if (possibleTypes.contains((Object)JsonSchemaType._any)) {
            return JsonSchemaType._any.getDescription();
        }
        Stream<String> typeDescriptions = possibleTypes.stream().map(t -> t.getDescription()).distinct().sorted();
        boolean isShort = false;
        if (shortDesc) {
            typeDescriptions = typeDescriptions.limit(3L);
            if (possibleTypes.size() > 3) {
                isShort = true;
            }
        }
        return typeDescriptions.collect(Collectors.joining(" | ", "", isShort ? "| ..." : ""));
    }

    @Nullable
    public JsonSchemaObject resolveRefSchema(@NotNull JsonSchemaService service) {
        if (service == null) {
            JsonSchemaObject.$$$reportNull$$$0(25);
        }
        String ref = this.getRef();
        assert (!StringUtil.isEmptyOrSpaces((String)ref));
        JsonSchemaObject schemaObject = this.myComputedRefs.getOrDefault(ref, NULL_OBJ);
        if (schemaObject == NULL_OBJ) {
            VirtualFile virtualFile2;
            JsonSchemaObject value2 = JsonSchemaObject.fetchSchemaFromRefDefinition(ref, this, service, this.isRefRecursive());
            if (!this.mySubscribed.get()) {
                service.getProject().getMessageBus().connect().subscribe(JsonSchemaVfsListener.JSON_DEPS_CHANGED, () -> this.myComputedRefs.clear());
                this.mySubscribed.set(true);
            }
            if (!JsonFileResolver.isHttpPath(ref)) {
                service.registerReference(ref);
            } else if (value2 != null && (virtualFile2 = service.resolveSchemaFile(value2)) != null && !(virtualFile2 instanceof HttpVirtualFile)) {
                service.registerReference(virtualFile2.getName());
            }
            if (value2 != null && value2 != NULL_OBJ && !Objects.equals(value2.myFileUrl, this.myFileUrl)) {
                value2.setBackReference(this);
            }
            this.myComputedRefs.put(ref, value2 == null ? NULL_OBJ : value2);
            return value2;
        }
        return schemaObject;
    }

    @Nullable
    private static JsonSchemaObject fetchSchemaFromRefDefinition(@NotNull String ref, @NotNull JsonSchemaObject schema2, @NotNull JsonSchemaService service, boolean recursive) {
        VirtualFile schemaFile;
        if (ref == null) {
            JsonSchemaObject.$$$reportNull$$$0(26);
        }
        if (schema2 == null) {
            JsonSchemaObject.$$$reportNull$$$0(27);
        }
        if (service == null) {
            JsonSchemaObject.$$$reportNull$$$0(28);
        }
        if ((schemaFile = service.resolveSchemaFile(schema2)) == null) {
            return null;
        }
        JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter splitter = new JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter(ref);
        String schemaId = splitter.getSchemaId();
        if (schemaId != null) {
            JsonSchemaObject refSchema = JsonSchemaObject.resolveSchemaByReference(service, schemaFile, schemaId);
            if (refSchema == null) {
                return null;
            }
            return JsonSchemaObject.findRelativeDefinition(refSchema, splitter, service);
        }
        JsonSchemaObject rootSchema = service.getSchemaObjectForSchemaFile(schemaFile);
        if (rootSchema == null) {
            LOG.debug(String.format("Schema object not found for %s", schemaFile.getPath()));
            return null;
        }
        if (recursive && ref.startsWith("#")) {
            JsonSchemaObject backRef;
            while (rootSchema.isRecursiveAnchor() && (backRef = rootSchema.myBackRef) != null) {
                VirtualFile file2 = (VirtualFile)ObjectUtils.coalesce((Object)backRef.myRawFile, backRef.myFileUrl == null ? null : JsonFileResolver.urlToFile(backRef.myFileUrl));
                if (file2 == null) break;
                try {
                    rootSchema = JsonSchemaReader.readFromFile(service.getProject(), file2);
                }
                catch (Exception e) {
                    break;
                }
            }
        }
        return JsonSchemaObject.findRelativeDefinition(rootSchema, splitter, service);
    }

    @Nullable
    private static JsonSchemaObject resolveSchemaByReference(@NotNull JsonSchemaService service, @NotNull VirtualFile schemaFile, @NotNull String schemaId) {
        JsonSchemaObject refSchema;
        RemoteFileInfo info2;
        VirtualFile refFile;
        if (service == null) {
            JsonSchemaObject.$$$reportNull$$$0(29);
        }
        if (schemaFile == null) {
            JsonSchemaObject.$$$reportNull$$$0(30);
        }
        if (schemaId == null) {
            JsonSchemaObject.$$$reportNull$$$0(31);
        }
        if ((refFile = service.findSchemaFileByReference(schemaId, schemaFile)) == null) {
            LOG.debug(String.format("Schema file not found by reference: '%s' from %s", schemaId, schemaFile.getPath()));
            return null;
        }
        if (refFile instanceof HttpVirtualFile && (info2 = ((HttpVirtualFile)refFile).getFileInfo()) != null) {
            RemoteFileState state = info2.getState();
            if (state == RemoteFileState.DOWNLOADING_NOT_STARTED) {
                JsonFileResolver.startFetchingHttpFileIfNeeded(refFile, service.getProject());
                return NULL_OBJ;
            }
            if (state == RemoteFileState.DOWNLOADING_IN_PROGRESS) {
                return NULL_OBJ;
            }
        }
        if ((refSchema = service.getSchemaObjectForSchemaFile(refFile)) == null) {
            LOG.debug(String.format("Schema object not found by reference: '%s' from %s", schemaId, schemaFile.getPath()));
            return null;
        }
        return refSchema;
    }

    private static JsonSchemaObject findRelativeDefinition(@NotNull JsonSchemaObject schema2, @NotNull JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter splitter, @NotNull JsonSchemaService service) {
        String path2;
        if (schema2 == null) {
            JsonSchemaObject.$$$reportNull$$$0(32);
        }
        if (splitter == null) {
            JsonSchemaObject.$$$reportNull$$$0(33);
        }
        if (service == null) {
            JsonSchemaObject.$$$reportNull$$$0(34);
        }
        if (StringUtil.isEmptyOrSpaces((String)(path2 = splitter.getRelativePath()))) {
            String id2 = splitter.getSchemaId();
            if (JsonPointerUtil.isSelfReference(id2)) {
                return schema2;
            }
            if (id2 != null && id2.startsWith("#")) {
                String resolvedId = schema2.resolveId(id2);
                if (resolvedId == null || id2.equals("#" + resolvedId)) {
                    return null;
                }
                return JsonSchemaObject.findRelativeDefinition(schema2, new JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter("#" + resolvedId), service);
            }
            return schema2;
        }
        JsonSchemaObject definition = schema2.findRelativeDefinition(path2);
        if (definition == null) {
            VirtualFile schemaFile = service.resolveSchemaFile(schema2);
            LOG.debug(String.format("Definition not found by reference: '%s' in file %s", path2, schemaFile == null ? "(no file)" : schemaFile.getPath()));
        }
        return definition;
    }

    @NotNull
    public static JsonSchemaObject merge(@NotNull JsonSchemaObject base, @NotNull JsonSchemaObject other, @NotNull JsonSchemaObject pointTo) {
        if (base == null) {
            JsonSchemaObject.$$$reportNull$$$0(35);
        }
        if (other == null) {
            JsonSchemaObject.$$$reportNull$$$0(36);
        }
        if (pointTo == null) {
            JsonSchemaObject.$$$reportNull$$$0(37);
        }
        JsonSchemaObject object = new JsonSchemaObject(pointTo.myRawFile, pointTo.myFileUrl, pointTo.getPointer());
        object.mergeValues(other);
        object.mergeValues(base);
        object.setRef(other.getRef());
        JsonSchemaObject jsonSchemaObject = object;
        if (jsonSchemaObject == null) {
            JsonSchemaObject.$$$reportNull$$$0(38);
        }
        return jsonSchemaObject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 11: 
            case 21: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 11: 
            case 21: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 11: 
            case 21: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selfType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherType";
                break;
            }
            case 7: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisObject";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherObject";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionsMap";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROPERTIES;
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternProperties";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlDescription";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 25: 
            case 28: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaId";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitter";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptSchemaPattern";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveId";
                break;
            }
            case 4: 
            case 11: 
            case 21: 
            case 38: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSubtypeOfBoth";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mergeValues";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mergeProperties";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setDefinitionsMap";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setProperties";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setPatternProperties";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setHtmlDescription";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setTitle";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "unescapeJsonString";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingPatternPropertySchema";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkByPattern";
                break;
            }
            case 20: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findRelativeDefinition";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "compilePattern";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "matchPattern";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveRefSchema";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fetchSchemaFromRefDefinition";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveSchemaByReference";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 11: 
            case 21: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PatternProperties {
        @NotNull
        private final Map<String, JsonSchemaObject> mySchemasMap;
        @NotNull
        private final Map<String, Pattern> myCachedPatterns;
        @NotNull
        private final Map<String, String> myCachedPatternProperties;

        PatternProperties(@NotNull Map<String, JsonSchemaObject> schemasMap) {
            if (schemasMap == null) {
                PatternProperties.$$$reportNull$$$0(0);
            }
            this.mySchemasMap = new HashMap<String, JsonSchemaObject>();
            schemasMap.keySet().forEach(key -> this.mySchemasMap.put(StringUtil.unescapeBackSlashes((String)key), (JsonSchemaObject)schemasMap.get(key)));
            this.myCachedPatterns = new HashMap<String, Pattern>();
            this.myCachedPatternProperties = CollectionFactory.createConcurrentWeakKeyWeakValueMap();
            this.mySchemasMap.keySet().forEach(key -> {
                Pair<Pattern, String> pair = JsonSchemaObject.compilePattern(key);
                if (pair.getSecond() == null) {
                    assert (pair.getFirst() != null);
                    this.myCachedPatterns.put((String)key, (Pattern)pair.getFirst());
                }
            });
        }

        @Nullable
        public JsonSchemaObject getPatternPropertySchema(@NotNull String name) {
            String value2;
            if (name == null) {
                PatternProperties.$$$reportNull$$$0(1);
            }
            if ((value2 = this.myCachedPatternProperties.get(name)) != null) {
                assert (this.mySchemasMap.containsKey(value2));
                return this.mySchemasMap.get(value2);
            }
            value2 = this.myCachedPatterns.keySet().stream().filter(key -> JsonSchemaObject.matchPattern(this.myCachedPatterns.get(key), name)).findFirst().orElse(null);
            if (value2 != null) {
                this.myCachedPatternProperties.put(name, value2);
                assert (this.mySchemasMap.containsKey(value2));
                return this.mySchemasMap.get(value2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schemasMap";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternProperties";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPatternPropertySchema";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PropertyNamePattern {
        @NotNull
        private final String myPattern;
        @Nullable
        private final Pattern myCompiledPattern;
        @Nullable
        private final String myPatternError;
        @NotNull
        private final Map<String, Boolean> myValuePatternCache;

        PropertyNamePattern(@NotNull String pattern) {
            if (pattern == null) {
                PropertyNamePattern.$$$reportNull$$$0(0);
            }
            this.myPattern = StringUtil.unescapeBackSlashes((String)pattern);
            Pair<Pattern, String> pair = JsonSchemaObject.compilePattern(pattern);
            this.myPatternError = (String)pair.getSecond();
            this.myCompiledPattern = (Pattern)pair.getFirst();
            this.myValuePatternCache = CollectionFactory.createConcurrentWeakKeyWeakValueMap();
        }

        @Nullable
        public String getPatternError() {
            return this.myPatternError;
        }

        boolean checkByPattern(@NotNull String name) {
            if (name == null) {
                PropertyNamePattern.$$$reportNull$$$0(1);
            }
            if (this.myPatternError != null) {
                return true;
            }
            if (Boolean.TRUE.equals(this.myValuePatternCache.get(name))) {
                return true;
            }
            assert (this.myCompiledPattern != null);
            boolean matches = JsonSchemaObject.matchPattern(this.myCompiledPattern, name);
            this.myValuePatternCache.put(name, matches);
            return matches;
        }

        @NotNull
        public String getPattern() {
            String string = this.myPattern;
            if (string == null) {
                PropertyNamePattern.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PropertyNamePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PropertyNamePattern";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "checkByPattern";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

