/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.JsonBundle;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.util.ObjectUtils;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonPointerReferenceProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element2, PsiElement originalElement) {
        return JsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(element2, originalElement, true, null);
    }

    @Nullable
    public String generateDoc(PsiElement element2, @Nullable PsiElement originalElement) {
        String forcedPropName = null;
        if (element2 instanceof FakeDocElement) {
            forcedPropName = ((FakeDocElement)element2).myAltName;
            element2 = ((FakeDocElement)element2).myContextElement;
        }
        return JsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(element2, originalElement, false, forcedPropName);
    }

    @Nullable
    public static String findSchemaAndGenerateDoc(PsiElement element2, @Nullable PsiElement originalElement, boolean preferShort, @Nullable String forcedPropName) {
        VirtualFile virtualFile2;
        if (element2 instanceof FakePsiElement) {
            return null;
        }
        PsiElement psiElement = element2 = JsonSchemaDocumentationProvider.isWhitespaceOrComment(originalElement) ? element2 : (PsiElement)ObjectUtils.coalesce((Object)originalElement, (Object)element2);
        if (originalElement != null && JsonSchemaDocumentationProvider.hasFileOrPointerReferences(originalElement.getReferences())) {
            return null;
        }
        PsiFile containingFile = element2.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        JsonSchemaService service = JsonSchemaService.Impl.get(element2.getProject());
        if (!service.isApplicableToFile(virtualFile2 = containingFile.getViewProvider().getVirtualFile())) {
            return null;
        }
        JsonSchemaObject rootSchema = service.getSchemaObject(containingFile);
        if (rootSchema == null) {
            return null;
        }
        return JsonSchemaDocumentationProvider.generateDoc(element2, rootSchema, preferShort, forcedPropName);
    }

    private static boolean hasFileOrPointerReferences(PsiReference[] references) {
        for (PsiReference reference2 : references) {
            if (!(reference2 instanceof PsiFileReference) && !(reference2 instanceof JsonPointerReferenceProvider.JsonSchemaIdReference) && !(reference2 instanceof JsonPointerReferenceProvider.JsonPointerReference)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWhitespaceOrComment(@Nullable PsiElement originalElement) {
        return originalElement instanceof PsiWhiteSpace || originalElement instanceof PsiComment;
    }

    @Nullable
    public static String generateDoc(@NotNull PsiElement element2, @NotNull JsonSchemaObject rootSchema, boolean preferShort, @Nullable String forcedPropName) {
        JsonLikePsiWalker walker;
        if (element2 == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (rootSchema == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(1);
        }
        if ((walker = JsonLikePsiWalker.getWalker(element2, rootSchema)) == null) {
            return null;
        }
        PsiElement checkable = walker.findElementToCheck(element2);
        if (checkable == null) {
            return null;
        }
        JsonPointerPosition position = walker.findPosition(checkable, true);
        if (position == null) {
            return null;
        }
        if (forcedPropName != null) {
            if (JsonSchemaDocumentationProvider.isWhitespaceOrComment(element2)) {
                position.addFollowingStep(forcedPropName);
            } else {
                if (position.isEmpty()) {
                    return null;
                }
                if (position.isArray(position.size() - 1)) {
                    return null;
                }
                position.replaceStep(position.size() - 1, forcedPropName);
            }
        }
        Collection<JsonSchemaObject> schemas = new JsonSchemaResolver(element2.getProject(), rootSchema, position).resolve();
        Object htmlDescription = null;
        boolean deprecated = false;
        ArrayList<JsonSchemaType> possibleTypes = new ArrayList<JsonSchemaType>();
        for (JsonSchemaObject schema2 : schemas) {
            if (htmlDescription == null) {
                htmlDescription = JsonSchemaDocumentationProvider.getBestDocumentation(preferShort, schema2);
                String message2 = schema2.getDeprecationMessage();
                if (message2 != null) {
                    htmlDescription = htmlDescription == null ? message2 : message2 + "<br/>" + (String)htmlDescription;
                    deprecated = true;
                }
            }
            if (schema2.getType() != null && schema2.getType() != JsonSchemaType._any) {
                possibleTypes.add(schema2.getType());
                continue;
            }
            if (schema2.getTypeVariants() != null) {
                possibleTypes.addAll(schema2.getTypeVariants());
                continue;
            }
            JsonSchemaType guessedType = schema2.guessType();
            if (guessedType == null) continue;
            possibleTypes.add(guessedType);
        }
        return JsonSchemaDocumentationProvider.appendNameTypeAndApi(position, JsonSchemaDocumentationProvider.getThirdPartyApiInfo(element2, rootSchema), possibleTypes, htmlDescription, deprecated, preferShort);
    }

    @Nullable
    private static String appendNameTypeAndApi(@NotNull JsonPointerPosition position, @NotNull String apiInfo, @NotNull List<JsonSchemaType> possibleTypes, @Nullable String htmlDescription, boolean deprecated, boolean preferShort) {
        String deprecationComment;
        if (position == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (apiInfo == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(3);
        }
        if (possibleTypes == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (position.size() == 0) {
            return htmlDescription;
        }
        String name = position.getLastName();
        if (name == null) {
            return htmlDescription;
        }
        Object type = "";
        String schemaType = JsonSchemaObject.getTypesDescription(false, possibleTypes);
        if (schemaType != null) {
            type = ": " + schemaType;
        }
        String string = deprecationComment = deprecated ? JsonBundle.message("schema.documentation.deprecated.postfix", new Object[0]) : "";
        htmlDescription = preferShort ? "<b>" + name + "</b>" + (String)type + apiInfo + deprecationComment + (String)(htmlDescription == null ? "" : "<br/>" + (String)htmlDescription) : "<div class='definition'><pre>" + name + (String)type + apiInfo + deprecationComment + "</pre></div>" + (String)(htmlDescription == null ? "" : "<div class='content'>" + (String)htmlDescription + "</div>");
        return htmlDescription;
    }

    @NotNull
    private static String getThirdPartyApiInfo(@NotNull PsiElement element2, @NotNull JsonSchemaObject rootSchema) {
        String information;
        if (element2 == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (rootSchema == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(6);
        }
        JsonSchemaService service = JsonSchemaService.Impl.get(element2.getProject());
        Object apiInfo = "";
        JsonSchemaFileProvider provider2 = service.getSchemaProvider(rootSchema);
        if (provider2 != null && (information = provider2.getThirdPartyApiInformation()) != null) {
            apiInfo = "&nbsp;&nbsp;<i>(" + information + ")</i>";
        }
        String string = apiInfo;
        if (string == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static String getBestDocumentation(boolean preferShort, @NotNull JsonSchemaObject schema2) {
        if (schema2 == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(8);
        }
        String htmlDescription = schema2.getHtmlDescription();
        String description = schema2.getDescription();
        String title2 = schema2.getTitle();
        if (preferShort && !StringUtil.isEmptyOrSpaces((String)title2)) {
            return JsonSchemaDocumentationProvider.plainTextPostProcess(title2);
        }
        if (!StringUtil.isEmptyOrSpaces((String)htmlDescription)) {
            Object desc = htmlDescription;
            if (!StringUtil.isEmptyOrSpaces((String)title2)) {
                desc = JsonSchemaDocumentationProvider.plainTextPostProcess(title2) + "<br/>" + (String)desc;
            }
            return desc;
        }
        if (!StringUtil.isEmptyOrSpaces((String)description)) {
            Object desc = JsonSchemaDocumentationProvider.plainTextPostProcess(description);
            if (!StringUtil.isEmptyOrSpaces((String)title2)) {
                desc = JsonSchemaDocumentationProvider.plainTextPostProcess(title2) + "<br/>" + (String)desc;
            }
            return desc;
        }
        return null;
    }

    @NotNull
    private static String plainTextPostProcess(@NotNull String text2) {
        if (text2 == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(9);
        }
        String string = StringUtil.escapeXmlEntities((String)text2).replace("\\n", "<br/>");
        if (string == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element2) {
        if ((element2 instanceof JsonProperty || JsonSchemaDocumentationProvider.isWhitespaceOrComment(element2) && element2.getParent() instanceof JsonObject) && object instanceof String) {
            return new FakeDocElement(element2 instanceof JsonProperty ? ((JsonProperty)element2).getNameElement() : element2, StringUtil.unquoteString((String)((String)object)));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSchema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apiInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleTypes";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaDocumentationProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaDocumentationProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getThirdPartyApiInfo";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "plainTextPostProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateDoc";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendNameTypeAndApi";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getThirdPartyApiInfo";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBestDocumentation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "plainTextPostProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FakeDocElement
    extends FakePsiElement {
        private final PsiElement myContextElement;
        private final String myAltName;

        private FakeDocElement(PsiElement context2, String name) {
            this.myContextElement = context2;
            this.myAltName = name;
        }

        public PsiElement getParent() {
            return this.myContextElement;
        }

        @NotNull
        public TextRange getTextRangeInParent() {
            TextRange textRange = this.myContextElement.getTextRange().shiftLeft(this.myContextElement.getTextOffset());
            if (textRange == null) {
                FakeDocElement.$$$reportNull$$$0(0);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaDocumentationProvider$FakeDocElement", "getTextRangeInParent"));
        }
    }
}

