/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.json.JsonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import com.jetbrains.jsonSchema.impl.MatchResult;
import com.jetbrains.jsonSchema.impl.validations.ArrayValidation;
import com.jetbrains.jsonSchema.impl.validations.EnumValidation;
import com.jetbrains.jsonSchema.impl.validations.IfThenElseValidation;
import com.jetbrains.jsonSchema.impl.validations.NotValidation;
import com.jetbrains.jsonSchema.impl.validations.NumericValidation;
import com.jetbrains.jsonSchema.impl.validations.ObjectValidation;
import com.jetbrains.jsonSchema.impl.validations.StringValidation;
import com.jetbrains.jsonSchema.impl.validations.TypeValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonSchemaAnnotatorChecker
implements JsonValidationHost {
    private static final Set<JsonSchemaType> PRIMITIVE_TYPES = ContainerUtil.set((Object[])new JsonSchemaType[]{JsonSchemaType._integer, JsonSchemaType._number, JsonSchemaType._boolean, JsonSchemaType._string, JsonSchemaType._null});
    private final Map<PsiElement, JsonValidationError> myErrors;
    @NotNull
    private final Project myProject;
    @NotNull
    private final JsonComplianceCheckerOptions myOptions;
    private boolean myHadTypeError;
    private static final JsonSchemaType[] NO_TYPES = new JsonSchemaType[0];

    JsonSchemaAnnotatorChecker(@NotNull Project project, @NotNull JsonComplianceCheckerOptions options2) {
        if (project == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(0);
        }
        if (options2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myOptions = options2;
        this.myErrors = new HashMap<PsiElement, JsonValidationError>();
    }

    public Map<PsiElement, JsonValidationError> getErrors() {
        return this.myErrors;
    }

    public boolean isHadTypeError() {
        return this.myHadTypeError;
    }

    public static JsonSchemaAnnotatorChecker checkByMatchResult(@NotNull Project project, @NotNull JsonValueAdapter elementToCheck, @NotNull MatchResult result2, @NotNull JsonComplianceCheckerOptions options2) {
        if (project == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(2);
        }
        if (elementToCheck == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(4);
        }
        if (options2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(5);
        }
        ArrayList<JsonSchemaAnnotatorChecker> checkers = new ArrayList<JsonSchemaAnnotatorChecker>();
        if (result2.myExcludingSchemas.isEmpty() && result2.mySchemas.size() == 1) {
            JsonSchemaAnnotatorChecker checker2 = new JsonSchemaAnnotatorChecker(project, options2);
            checker2.checkByScheme(elementToCheck, result2.mySchemas.iterator().next());
            checkers.add(checker2);
        } else {
            if (!result2.mySchemas.isEmpty()) {
                checkers.add((JsonSchemaAnnotatorChecker)JsonSchemaAnnotatorChecker.processSchemasVariants(project, result2.mySchemas, elementToCheck, false, options2).getSecond());
            }
            if (!result2.myExcludingSchemas.isEmpty()) {
                List list2 = ContainerUtil.map(result2.myExcludingSchemas, group2 -> (JsonSchemaAnnotatorChecker)JsonSchemaAnnotatorChecker.processSchemasVariants(project, group2, elementToCheck, true, options2).getSecond());
                checkers.add(JsonSchemaAnnotatorChecker.mergeErrors(project, list2, options2, result2.myExcludingSchemas));
            }
        }
        if (checkers.isEmpty()) {
            return null;
        }
        if (checkers.size() == 1) {
            return (JsonSchemaAnnotatorChecker)checkers.get(0);
        }
        return checkers.stream().filter(checker -> !checker.isHadTypeError()).findFirst().orElse((JsonSchemaAnnotatorChecker)checkers.get(0));
    }

    private static JsonSchemaAnnotatorChecker mergeErrors(@NotNull Project project, @NotNull List<JsonSchemaAnnotatorChecker> list2, @NotNull JsonComplianceCheckerOptions options2, @NotNull List<Collection<? extends JsonSchemaObject>> excludingSchemas) {
        if (project == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(6);
        }
        if (list2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(7);
        }
        if (options2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(8);
        }
        if (excludingSchemas == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(9);
        }
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(project, options2);
        for (JsonSchemaAnnotatorChecker ch : list2) {
            for (Map.Entry<PsiElement, JsonValidationError> element2 : ch.myErrors.entrySet()) {
                JsonValidationError error2 = element2.getValue();
                if (error2.getFixableIssueKind() == JsonValidationError.FixableIssueKind.ProhibitedProperty) {
                    String propertyName = ((JsonValidationError.ProhibitedPropertyIssueData)error2.getIssueData()).propertyName;
                    boolean skip = false;
                    for (Collection<? extends JsonSchemaObject> objects : excludingSchemas) {
                        Set keys2 = objects.stream().filter(o -> !o.hasOwnExtraPropertyProhibition()).map(o -> o.getProperties().keySet()).flatMap(Collection::stream).collect(Collectors.toSet());
                        if (!keys2.contains(propertyName)) continue;
                        skip = true;
                    }
                    if (skip) continue;
                }
                checker.myErrors.put(element2.getKey(), error2);
            }
        }
        return checker;
    }

    @Override
    public void error(@InspectionMessage String error2, PsiElement holder, JsonErrorPriority priority) {
        this.error(error2, holder, JsonValidationError.FixableIssueKind.None, null, priority);
    }

    @Override
    public void error(PsiElement newHolder, JsonValidationError error2) {
        this.error(error2.getMessage(), newHolder, error2.getFixableIssueKind(), error2.getIssueData(), error2.getPriority());
    }

    @Override
    public void error(@InspectionMessage String error2, PsiElement holder, JsonValidationError.FixableIssueKind fixableIssueKind, JsonValidationError.IssueData data2, JsonErrorPriority priority) {
        if (this.myErrors.containsKey(holder)) {
            return;
        }
        this.myErrors.put(holder, new JsonValidationError(error2, fixableIssueKind, data2, priority));
    }

    @Override
    public void typeError(@NotNull PsiElement value2, @Nullable JsonSchemaType currentType, JsonSchemaType ... allowedTypes) {
        if (value2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(10);
        }
        if (allowedTypes == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(11);
        }
        if (allowedTypes.length == 0) {
            return;
        }
        String currentTypeDesc = currentType == null ? "" : " " + JsonBundle.message("schema.validation.actual", new Object[0]) + currentType.getName() + ".";
        String prefix2 = JsonBundle.message("schema.validation.incompatible.types", new Object[0]) + "\n";
        if (allowedTypes.length == 1) {
            this.error(prefix2 + " " + JsonBundle.message("schema.validation.required.one", allowedTypes[0].getName(), currentTypeDesc), value2, JsonValidationError.FixableIssueKind.ProhibitedType, new JsonValidationError.TypeMismatchIssueData(allowedTypes), JsonErrorPriority.TYPE_MISMATCH);
        } else {
            String typesText = Arrays.stream(allowedTypes).map(JsonSchemaType::getName).distinct().sorted(Comparator.naturalOrder()).collect(Collectors.joining(", "));
            this.error(prefix2 + " " + JsonBundle.message("schema.validation.required.one.of", typesText, currentTypeDesc), value2, JsonValidationError.FixableIssueKind.ProhibitedType, new JsonValidationError.TypeMismatchIssueData(allowedTypes), JsonErrorPriority.TYPE_MISMATCH);
        }
        this.myHadTypeError = true;
    }

    @Override
    public MatchResult resolve(JsonSchemaObject schemaObject) {
        return new JsonSchemaResolver(this.myProject, schemaObject).detailedResolve();
    }

    @Override
    @Nullable
    public JsonValidationHost checkByMatchResult(JsonValueAdapter adapter, MatchResult result2, JsonComplianceCheckerOptions options2) {
        return JsonSchemaAnnotatorChecker.checkByMatchResult(this.myProject, adapter, result2, options2);
    }

    @Override
    public boolean isValid() {
        return this.myErrors.size() == 0 && !this.myHadTypeError;
    }

    private static Collection<JsonSchemaValidation> getAllValidations(@NotNull JsonSchemaObject schema2, JsonSchemaType type, @NotNull JsonValueAdapter value2) {
        if (schema2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(12);
        }
        if (value2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(13);
        }
        LinkedHashSet<JsonSchemaValidation> validations = new LinkedHashSet<JsonSchemaValidation>();
        validations.add(EnumValidation.INSTANCE);
        if (type != null) {
            validations.add(TypeValidation.INSTANCE);
            if (JsonSchemaType._string_number.equals((Object)type)) {
                validations.add(NumericValidation.INSTANCE);
                validations.add(StringValidation.INSTANCE);
            } else if (JsonSchemaType._number.equals((Object)type) || JsonSchemaType._integer.equals((Object)type)) {
                validations.add(NumericValidation.INSTANCE);
            } else if (JsonSchemaType._string.equals((Object)type)) {
                validations.add(StringValidation.INSTANCE);
            } else if (JsonSchemaType._array.equals((Object)type)) {
                validations.add(ArrayValidation.INSTANCE);
            } else if (JsonSchemaType._object.equals((Object)type)) {
                validations.add(ObjectValidation.INSTANCE);
            }
        }
        if (!value2.isShouldBeIgnored()) {
            if (schema2.hasNumericChecks() && value2.isNumberLiteral()) {
                validations.add(NumericValidation.INSTANCE);
            }
            if (schema2.hasStringChecks() && value2.isStringLiteral()) {
                validations.add(StringValidation.INSTANCE);
            }
            if (schema2.hasArrayChecks() && value2.isArray()) {
                validations.add(ArrayValidation.INSTANCE);
            }
            if (JsonSchemaAnnotatorChecker.hasMinMaxLengthChecks(schema2)) {
                if (value2.isStringLiteral()) {
                    validations.add(StringValidation.INSTANCE);
                } else if (value2.isArray()) {
                    validations.add(ArrayValidation.INSTANCE);
                }
            }
            if (schema2.hasObjectChecks() && value2.isObject()) {
                validations.add(ObjectValidation.INSTANCE);
            }
        }
        if (schema2.getNot() != null) {
            validations.add(NotValidation.INSTANCE);
        }
        if (schema2.getIfThenElse() != null) {
            validations.add(IfThenElseValidation.INSTANCE);
        }
        return validations;
    }

    public void checkByScheme(@NotNull JsonValueAdapter value2, @NotNull JsonSchemaObject schema2) {
        if (value2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(14);
        }
        if (schema2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(15);
        }
        JsonSchemaType type = JsonSchemaType.getType(value2);
        for (JsonSchemaValidation validation : JsonSchemaAnnotatorChecker.getAllValidations(schema2, type, value2)) {
            validation.validate(value2, schema2, type, this, this.myOptions);
        }
    }

    @Override
    public void checkObjectBySchemaRecordErrors(@NotNull JsonSchemaObject schema2, @NotNull JsonValueAdapter object) {
        JsonSchemaAnnotatorChecker checker;
        if (schema2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(16);
        }
        if (object == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(17);
        }
        if ((checker = JsonSchemaAnnotatorChecker.checkByMatchResult(this.myProject, object, new JsonSchemaResolver(this.myProject, schema2).detailedResolve(), this.myOptions)) != null) {
            this.myHadTypeError = checker.isHadTypeError();
            this.myErrors.putAll(checker.getErrors());
        }
    }

    @Override
    public void addErrorsFrom(JsonValidationHost otherHost) {
        this.myErrors.putAll(((JsonSchemaAnnotatorChecker)otherHost).myErrors);
    }

    @NotNull
    private static Pair<JsonSchemaObject, JsonSchemaAnnotatorChecker> processSchemasVariants(@NotNull Project project, @NotNull Collection<? extends JsonSchemaObject> collection, @NotNull JsonValueAdapter value2, boolean isOneOf, JsonComplianceCheckerOptions options2) {
        if (project == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(18);
        }
        if (collection == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(19);
        }
        if (value2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(20);
        }
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(project, options2);
        JsonSchemaType type = JsonSchemaType.getType(value2);
        JsonSchemaObject selected2 = null;
        if (type == null) {
            if (!value2.isShouldBeIgnored()) {
                checker.typeError(value2.getDelegate(), null, JsonSchemaAnnotatorChecker.getExpectedTypes(collection));
            }
        } else {
            ArrayList<JsonSchemaObject> filtered2 = new ArrayList<JsonSchemaObject>(collection.size());
            JsonSchemaType altType = value2.getAlternateType(type);
            for (JsonSchemaObject jsonSchemaObject : collection) {
                if (!JsonSchemaAnnotatorChecker.areSchemaTypesCompatible(jsonSchemaObject, type) && !JsonSchemaAnnotatorChecker.areSchemaTypesCompatible(jsonSchemaObject, altType)) continue;
                filtered2.add(jsonSchemaObject);
            }
            if (filtered2.isEmpty()) {
                checker.typeError(value2.getDelegate(), altType, JsonSchemaAnnotatorChecker.getExpectedTypes(collection));
            } else if (filtered2.size() == 1) {
                selected2 = (JsonSchemaObject)filtered2.get(0);
                checker.checkByScheme(value2, selected2);
            } else {
                selected2 = isOneOf ? checker.processOneOf(value2, filtered2) : checker.processAnyOf(value2, filtered2);
            }
        }
        Pair pair = Pair.create(selected2, (Object)checker);
        if (pair == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(21);
        }
        return pair;
    }

    public static JsonSchemaType[] getExpectedTypes(Collection<? extends JsonSchemaObject> schemas) {
        ArrayList<JsonSchemaType> list2 = new ArrayList<JsonSchemaType>();
        for (JsonSchemaObject jsonSchemaObject : schemas) {
            JsonSchemaType type = jsonSchemaObject.getType();
            if (type != null) {
                list2.add(type);
                continue;
            }
            Set<JsonSchemaType> variants = jsonSchemaObject.getTypeVariants();
            if (variants == null) continue;
            list2.addAll(variants);
        }
        return list2.isEmpty() ? NO_TYPES : list2.toArray(NO_TYPES);
    }

    public static boolean areSchemaTypesCompatible(@NotNull JsonSchemaObject schema2, @NotNull JsonSchemaType type) {
        JsonSchemaType matchingSchemaType;
        if (schema2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(22);
        }
        if (type == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(23);
        }
        if ((matchingSchemaType = JsonSchemaAnnotatorChecker.getMatchingSchemaType(schema2, type)) != null) {
            return matchingSchemaType.equals((Object)type);
        }
        if (schema2.getEnum() != null) {
            return PRIMITIVE_TYPES.contains((Object)type);
        }
        return true;
    }

    @Nullable
    public static JsonSchemaType getMatchingSchemaType(@NotNull JsonSchemaObject schema2, @NotNull JsonSchemaType input) {
        JsonSchemaType matchType;
        if (schema2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(24);
        }
        if (input == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(25);
        }
        if (schema2.getType() != null && (matchType = schema2.getType()) != null) {
            if (JsonSchemaType._integer.equals((Object)input) && JsonSchemaType._number.equals((Object)matchType)) {
                return input;
            }
            if (JsonSchemaType._string_number.equals((Object)input) && (JsonSchemaType._number.equals((Object)matchType) || JsonSchemaType._integer.equals((Object)matchType) || JsonSchemaType._string.equals((Object)matchType))) {
                return input;
            }
            return matchType;
        }
        if (schema2.getTypeVariants() != null) {
            Set<JsonSchemaType> matchTypes = schema2.getTypeVariants();
            if (matchTypes.contains((Object)input)) {
                return input;
            }
            if (JsonSchemaType._integer.equals((Object)input) && matchTypes.contains((Object)JsonSchemaType._number)) {
                return input;
            }
            if (JsonSchemaType._string_number.equals((Object)input) && (matchTypes.contains((Object)JsonSchemaType._number) || matchTypes.contains((Object)JsonSchemaType._integer) || matchTypes.contains((Object)JsonSchemaType._string))) {
                return input;
            }
            return matchTypes.iterator().next();
        }
        if (!schema2.getProperties().isEmpty() && JsonSchemaType._object.equals((Object)input)) {
            return JsonSchemaType._object;
        }
        return null;
    }

    private static boolean hasMinMaxLengthChecks(JsonSchemaObject schema2) {
        return schema2.getMinLength() != null || schema2.getMaxLength() != null;
    }

    @Nullable
    public static String getValue(PsiElement propValue, JsonSchemaObject schema2) {
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(propValue, schema2);
        assert (walker != null);
        JsonValueAdapter adapter = walker.createValueAdapter(propValue);
        if (adapter != null && !adapter.shouldCheckAsValue()) {
            return null;
        }
        return walker.getNodeTextForValidation(propValue);
    }

    private JsonSchemaObject processOneOf(@NotNull JsonValueAdapter value2, List<JsonSchemaObject> oneOf) {
        if (value2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(26);
        }
        ArrayList<JsonSchemaAnnotatorChecker> candidateErroneousCheckers = new ArrayList<JsonSchemaAnnotatorChecker>();
        ArrayList<JsonSchemaObject> candidateErroneousSchemas = new ArrayList<JsonSchemaObject>();
        SmartList correct = new SmartList();
        for (JsonSchemaObject object : oneOf) {
            if (object.isShouldValidateAgainstJSType()) continue;
            JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(this.myProject, this.myOptions);
            checker.checkByScheme(value2, object);
            if (checker.isCorrect()) {
                candidateErroneousCheckers.clear();
                candidateErroneousSchemas.clear();
                correct.add(object);
                continue;
            }
            candidateErroneousCheckers.add(checker);
            candidateErroneousSchemas.add(object);
        }
        if (correct.size() == 1) {
            return (JsonSchemaObject)correct.get(0);
        }
        if (correct.size() > 0) {
            JsonSchemaType type = JsonSchemaType.getType(value2);
            if (type != null && new HashSet(correct).size() > 1 && !JsonSchemaAnnotatorChecker.schemesDifferWithNotCheckedProperties((List<JsonSchemaObject>)correct)) {
                this.error(JsonBundle.message("schema.validation.to.more.than.one", new Object[0]), value2.getDelegate(), JsonErrorPriority.MEDIUM_PRIORITY);
            }
            return (JsonSchemaObject)ContainerUtil.getLastItem((List)correct);
        }
        return this.showErrorsAndGetLeastErroneous(candidateErroneousCheckers, candidateErroneousSchemas, true);
    }

    private static boolean schemesDifferWithNotCheckedProperties(@NotNull List<JsonSchemaObject> list2) {
        if (list2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(27);
        }
        return list2.stream().anyMatch(s -> !StringUtil.isEmptyOrSpaces((String)s.getFormat()));
    }

    @NotNull
    private static AverageFailureAmount getAverageFailureAmount(@NotNull JsonSchemaAnnotatorChecker checker) {
        if (checker == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(28);
        }
        int lowPriorityCount = 0;
        boolean hasMedium = false;
        boolean hasMissing = false;
        boolean hasHard = false;
        Collection<JsonValidationError> values2 = checker.getErrors().values();
        for (JsonValidationError value2 : values2) {
            switch (value2.getPriority()) {
                case LOW_PRIORITY: {
                    ++lowPriorityCount;
                    break;
                }
                case MISSING_PROPS: {
                    hasMissing = true;
                    break;
                }
                case MEDIUM_PRIORITY: {
                    hasMedium = true;
                    break;
                }
                case TYPE_MISMATCH: {
                    hasHard = true;
                    break;
                }
                case NOT_SCHEMA: {
                    AverageFailureAmount averageFailureAmount = AverageFailureAmount.NotSchema;
                    if (averageFailureAmount == null) {
                        JsonSchemaAnnotatorChecker.$$$reportNull$$$0(29);
                    }
                    return averageFailureAmount;
                }
            }
        }
        if (hasHard) {
            AverageFailureAmount averageFailureAmount = AverageFailureAmount.Hard;
            if (averageFailureAmount == null) {
                JsonSchemaAnnotatorChecker.$$$reportNull$$$0(30);
            }
            return averageFailureAmount;
        }
        if (hasMissing) {
            AverageFailureAmount averageFailureAmount = AverageFailureAmount.MissingItems;
            if (averageFailureAmount == null) {
                JsonSchemaAnnotatorChecker.$$$reportNull$$$0(31);
            }
            return averageFailureAmount;
        }
        if (hasMedium) {
            AverageFailureAmount averageFailureAmount = AverageFailureAmount.Medium;
            if (averageFailureAmount == null) {
                JsonSchemaAnnotatorChecker.$$$reportNull$$$0(32);
            }
            return averageFailureAmount;
        }
        AverageFailureAmount averageFailureAmount = lowPriorityCount <= 3 ? AverageFailureAmount.Light : AverageFailureAmount.Medium;
        if (averageFailureAmount == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(33);
        }
        return averageFailureAmount;
    }

    private JsonSchemaObject processAnyOf(@NotNull JsonValueAdapter value2, List<JsonSchemaObject> anyOf) {
        if (value2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(34);
        }
        ArrayList<JsonSchemaAnnotatorChecker> candidateErroneousCheckers = new ArrayList<JsonSchemaAnnotatorChecker>();
        ArrayList<JsonSchemaObject> candidateErroneousSchemas = new ArrayList<JsonSchemaObject>();
        for (JsonSchemaObject object : anyOf) {
            JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(this.myProject, this.myOptions);
            checker.checkByScheme(value2, object);
            if (checker.isCorrect()) {
                return object;
            }
            candidateErroneousCheckers.add(checker);
            candidateErroneousSchemas.add(object);
        }
        return this.showErrorsAndGetLeastErroneous(candidateErroneousCheckers, candidateErroneousSchemas, false);
    }

    @Nullable
    private JsonSchemaObject showErrorsAndGetLeastErroneous(@NotNull List<JsonSchemaAnnotatorChecker> candidateErroneousCheckers, @NotNull List<JsonSchemaObject> candidateErroneousSchemas, boolean isOneOf) {
        if (candidateErroneousCheckers == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(35);
        }
        if (candidateErroneousSchemas == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(36);
        }
        JsonSchemaObject current2 = null;
        JsonSchemaObject currentWithMinAverage = null;
        Optional<AverageFailureAmount> minAverage = candidateErroneousCheckers.stream().map(c -> JsonSchemaAnnotatorChecker.getAverageFailureAmount(c)).min(Comparator.comparingInt(c -> c.ordinal()));
        int min = minAverage.orElse(AverageFailureAmount.Hard).ordinal();
        int minErrorCount = candidateErroneousCheckers.stream().map(c -> c.getErrors().size()).min(Integer::compareTo).orElse(Integer.MAX_VALUE);
        MultiMap errorsWithMinAverage = new MultiMap();
        MultiMap allErrors = new MultiMap();
        for (int i2 = 0; i2 < candidateErroneousCheckers.size(); ++i2) {
            boolean isMoreThanAverage;
            JsonSchemaAnnotatorChecker checker = candidateErroneousCheckers.get(i2);
            boolean isMoreThanMinErrors = checker.getErrors().size() > minErrorCount;
            boolean bl = isMoreThanAverage = JsonSchemaAnnotatorChecker.getAverageFailureAmount(checker).ordinal() > min;
            if (isMoreThanMinErrors) continue;
            if (isMoreThanAverage) {
                currentWithMinAverage = candidateErroneousSchemas.get(i2);
            } else {
                current2 = candidateErroneousSchemas.get(i2);
            }
            for (Map.Entry<Object, JsonValidationError> entry2 : checker.getErrors().entrySet()) {
                (isMoreThanAverage ? errorsWithMinAverage : allErrors).putValue((Object)((PsiElement)entry2.getKey()), (Object)entry2.getValue());
            }
        }
        if (allErrors.isEmpty()) {
            allErrors = errorsWithMinAverage;
        }
        for (Map.Entry entry3 : allErrors.entrySet()) {
            Collection value2 = (Collection)entry3.getValue();
            if (value2.size() == 0) continue;
            if (value2.size() == 1) {
                this.error((PsiElement)entry3.getKey(), (JsonValidationError)value2.iterator().next());
                continue;
            }
            JsonValidationError error2 = JsonSchemaAnnotatorChecker.tryMergeErrors(value2, isOneOf);
            if (error2 != null) {
                this.error((PsiElement)entry3.getKey(), error2);
                continue;
            }
            for (JsonValidationError jsonValidationError : value2) {
                this.error((PsiElement)entry3.getKey(), jsonValidationError);
            }
        }
        if (current2 == null) {
            current2 = currentWithMinAverage;
        }
        if (current2 == null) {
            current2 = (JsonSchemaObject)ContainerUtil.getLastItem(candidateErroneousSchemas);
        }
        return current2;
    }

    @Nullable
    private static JsonValidationError tryMergeErrors(@NotNull Collection<JsonValidationError> errors, boolean isOneOf) {
        if (errors == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(37);
        }
        JsonValidationError.FixableIssueKind commonIssueKind = null;
        for (JsonValidationError error2 : errors) {
            JsonValidationError.FixableIssueKind currentIssueKind = error2.getFixableIssueKind();
            if (currentIssueKind == JsonValidationError.FixableIssueKind.None) {
                return null;
            }
            if (commonIssueKind == null) {
                commonIssueKind = currentIssueKind;
                continue;
            }
            if (currentIssueKind == commonIssueKind) continue;
            return null;
        }
        if (commonIssueKind == JsonValidationError.FixableIssueKind.NonEnumValue) {
            String prefix2 = JsonBundle.message("schema.validation.enum.mismatch", "");
            @NlsSafe String text2 = errors.stream().map(e -> StringUtil.trimEnd((String)StringUtil.trimStart((String)e.getMessage(), (String)prefix2), (String)prefix2)).map(e -> StringUtil.split((String)e, (String)", ")).flatMap(e -> e.stream()).distinct().collect(Collectors.joining(", "));
            return new JsonValidationError(prefix2 + text2, commonIssueKind, null, errors.iterator().next().getPriority());
        }
        if (commonIssueKind == JsonValidationError.FixableIssueKind.MissingProperty) {
            String sets = (String)errors.stream().map(e -> (JsonValidationError.MissingMultiplePropsIssueData)e.getIssueData()).map(d -> d.getMessage(false)).collect(NlsMessages.joiningOr());
            return new JsonValidationError(JsonBundle.message(isOneOf ? "schema.validation.one.of.property.sets.required" : "schema.validation.at.least.one.of.property.sets.required", sets), isOneOf ? JsonValidationError.FixableIssueKind.MissingOneOfProperty : JsonValidationError.FixableIssueKind.MissingAnyOfProperty, new JsonValidationError.MissingOneOfPropsIssueData(ContainerUtil.map(errors, e -> (JsonValidationError.MissingMultiplePropsIssueData)e.getIssueData())), errors.iterator().next().getPriority());
        }
        if (commonIssueKind == JsonValidationError.FixableIssueKind.ProhibitedType) {
            Set allTypes = errors.stream().map(e -> (JsonValidationError.TypeMismatchIssueData)e.getIssueData()).flatMap(d -> Arrays.stream(d.expectedTypes)).collect(Collectors.toSet());
            if (allTypes.size() == 1) {
                return errors.iterator().next();
            }
            List actualInfos = errors.stream().map(e -> e.getMessage()).map(JsonSchemaAnnotatorChecker::fetchActual).distinct().collect(Collectors.toList());
            String actualInfo = actualInfos.size() == 1 ? " " + JsonBundle.message("schema.validation.actual", new Object[0]) + (String)actualInfos.get(0) + "." : "";
            String commonTypeMessage = JsonBundle.message("schema.validation.incompatible.types", new Object[0]) + "\n" + JsonBundle.message("schema.validation.required.one.of", allTypes.stream().map(t -> t.getDescription()).sorted().collect(Collectors.joining(", ")), actualInfo);
            return new JsonValidationError(commonTypeMessage, JsonValidationError.FixableIssueKind.TypeMismatch, new JsonValidationError.TypeMismatchIssueData((JsonSchemaType[])ContainerUtil.toArray(allTypes, JsonSchemaType[]::new)), errors.iterator().next().getPriority());
        }
        return null;
    }

    private static String fetchActual(String message2) {
        String actualMessage = JsonBundle.message("schema.validation.actual", new Object[0]);
        int actual = message2.indexOf(actualMessage);
        if (actual == -1) {
            return null;
        }
        String substring = message2.endsWith(actualMessage) ? message2.substring(0, actual) : message2.substring(actual + actualMessage.length());
        return StringUtil.trimEnd((String)substring, (String)".");
    }

    public boolean isCorrect() {
        return this.myErrors.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCheck";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludingSchemas";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 20: 
            case 26: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedTypes";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateErroneousCheckers";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateErroneousSchemas";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "processSchemasVariants";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAverageFailureAmount";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkByMatchResult";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mergeErrors";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "typeError";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAllValidations";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkByScheme";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkObjectBySchemaRecordErrors";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processSchemasVariants";
                break;
            }
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "areSchemaTypesCompatible";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingSchemaType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processOneOf";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "schemesDifferWithNotCheckedProperties";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAverageFailureAmount";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processAnyOf";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "showErrorsAndGetLeastErroneous";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "tryMergeErrors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum AverageFailureAmount {
        Light,
        MissingItems,
        Medium,
        Hard,
        NotSchema;

    }
}

