/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.UriUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.XmlTagFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.html.HtmlDocumentImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.xml.XmlEntityCache;
import com.intellij.psi.scope.processor.FilterElementProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlFileNSInfoProvider;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.XmlCharsetDetector;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.impl.schema.XmlSchemaTagsProcessor;
import com.intellij.xml.index.IndexedRelevantResource;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import com.intellij.xml.psi.XmlPsiBundle;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlPsiUtil;
import com.intellij.xml.util.XmlTagUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlUtil {
    @NonNls
    public static final String XML_SCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    @NonNls
    public static final String XML_SCHEMA_URI2 = "http://www.w3.org/1999/XMLSchema";
    @NonNls
    public static final String XML_SCHEMA_URI3 = "http://www.w3.org/2000/10/XMLSchema";
    public static final String[] SCHEMA_URIS = new String[]{"http://www.w3.org/2001/XMLSchema", "http://www.w3.org/1999/XMLSchema", "http://www.w3.org/2000/10/XMLSchema"};
    @NonNls
    public static final String XML_SCHEMA_INSTANCE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    @NonNls
    public static final String XML_SCHEMA_VERSIONING_URI = "http://www.w3.org/2007/XMLSchema-versioning";
    @NonNls
    public static final String XSLT_URI = "http://www.w3.org/1999/XSL/Transform";
    @NonNls
    public static final String XINCLUDE_URI = "http://www.w3.org/2001/XInclude";
    @NonNls
    public static final String ANT_URI = "http://ant.apache.org/schema.xsd";
    @NonNls
    public static final String XHTML_URI = "http://www.w3.org/1999/xhtml";
    @NonNls
    public static final String HTML_URI = "http://www.w3.org/1999/html";
    @NonNls
    public static final String EMPTY_URI = "";
    @NonNls
    public static final Key<String> TEST_PATH = Key.create((String)"TEST PATH");
    @NonNls
    public static final String TAGLIB_1_2_URI = "http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd";
    @NonNls
    public static final String JSP_URI = "http://java.sun.com/JSP/Page";
    @NonNls
    public static final String JSTL_CORE_URI = "http://java.sun.com/jsp/jstl/core";
    @NonNls
    public static final String JSTL_CORE_URI2 = "http://java.sun.com/jstl/core";
    @NonNls
    public static final String JSTL_CORE_URI3 = "http://java.sun.com/jstl/core_rt";
    @NonNls
    public static final String JSTL_CORE_URI_JAVAEE_7 = "http://xmlns.jcp.org/jsp/jstl/core";
    @NonNls
    public static final String[] JSTL_CORE_URIS = new String[]{"http://java.sun.com/jsp/jstl/core", "http://java.sun.com/jstl/core", "http://java.sun.com/jstl/core_rt", "http://xmlns.jcp.org/jsp/jstl/core"};
    @NonNls
    public static final String JSF_HTML_URI = "http://java.sun.com/jsf/html";
    @NonNls
    public static final String JSF_HTML_URI_JAVAEE_7 = "http://xmlns.jcp.org/jsf/html";
    @NonNls
    public static final String[] JSF_HTML_URIS = new String[]{"http://java.sun.com/jsf/html", "http://xmlns.jcp.org/jsf/html"};
    @NonNls
    public static final String JSF_CORE_URI = "http://java.sun.com/jsf/core";
    @NonNls
    public static final String JSF_CORE_URI_JAVAEE_7 = "http://xmlns.jcp.org/jsf/core";
    @NonNls
    public static final String[] JSF_CORE_URIS = new String[]{"http://java.sun.com/jsf/core", "http://xmlns.jcp.org/jsf/core"};
    @NonNls
    public static final String JSF_PASS_THROUGH_ATTR_URI_JAVAEE7 = "http://xmlns.jcp.org/jsf";
    @NonNls
    public static final String JSF_PASSTHROUGH_URI = "http://xmlns.jcp.org/jsf/passthrough";
    @NonNls
    public static final String JSTL_FORMAT_URI = "http://java.sun.com/jsp/jstl/fmt";
    @NonNls
    public static final String JSTL_FORMAT_URI2 = "http://java.sun.com/jstl/fmt";
    @NonNls
    public static final String SPRING_URI = "http://www.springframework.org/tags";
    @NonNls
    public static final String SPRING_FORMS_URI = "http://www.springframework.org/tags/form";
    @NonNls
    public static final String STRUTS_BEAN_URI = "http://struts.apache.org/tags-bean";
    @NonNls
    public static final String STRUTS_BEAN_URI2 = "http://jakarta.apache.org/struts/tags-bean";
    @NonNls
    public static final String APACHE_I18N_URI = "http://jakarta.apache.org/taglibs/i18n-1.0";
    @NonNls
    public static final String STRUTS_LOGIC_URI = "http://struts.apache.org/tags-logic";
    @NonNls
    public static final String STRUTS_HTML_URI = "http://struts.apache.org/tags-html";
    @NonNls
    public static final String STRUTS_HTML_URI2 = "http://jakarta.apache.org/struts/tags-html";
    @NonNls
    public static final String APACHE_TRINIDAD_URI = "http://myfaces.apache.org/trinidad";
    @NonNls
    public static final String APACHE_TRINIDAD_HTML_URI = "http://myfaces.apache.org/trinidad/html";
    @NonNls
    public static final String XSD_SIMPLE_CONTENT_TAG = "simpleContent";
    @NonNls
    public static final String NO_NAMESPACE_SCHEMA_LOCATION_ATT = "noNamespaceSchemaLocation";
    @NonNls
    public static final String SCHEMA_LOCATION_ATT = "schemaLocation";
    @NonNls
    public static final String[] WEB_XML_URIS = new String[]{"http://java.sun.com/xml/ns/j2ee", "http://java.sun.com/xml/ns/javaee", "http://xmlns.jcp.org/xml/ns/javaee", "http://java.sun.com/dtd/web-app_2_3.dtd", "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd"};
    @NonNls
    public static final String FACELETS_URI = "http://java.sun.com/jsf/facelets";
    @NonNls
    public static final String FACELETS_URI_JAVAEE_7 = "http://xmlns.jcp.org/jsf/facelets";
    @NonNls
    public static final String[] FACELETS_URIS = new String[]{"http://java.sun.com/jsf/facelets", "http://xmlns.jcp.org/jsf/facelets"};
    @NonNls
    public static final String JSTL_FUNCTIONS_URI = "http://java.sun.com/jsp/jstl/functions";
    @NonNls
    public static final String JSTL_FUNCTIONS_URI2 = "http://java.sun.com/jstl/functions";
    @NonNls
    public static final String JSTL_FUNCTIONS_JAVAEE_7 = "http://xmlns.jcp.org/jsp/jstl/functions";
    @NonNls
    public static final String[] JSTL_FUNCTIONS_URIS = new String[]{"http://java.sun.com/jsp/jstl/functions", "http://java.sun.com/jstl/functions"};
    @NonNls
    public static final String JSTL_FN_FACELET_URI = "com.sun.facelets.tag.jstl.fn.JstlFnLibrary";
    @NonNls
    public static final String JSTL_CORE_FACELET_URI = "com.sun.facelets.tag.jstl.core.JstlCoreLibrary";
    @NonNls
    public static final String TARGET_NAMESPACE_ATTR_NAME = "targetNamespace";
    @NonNls
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final List<String> ourSchemaUrisList = List.of(SCHEMA_URIS);
    public static final Key<Boolean> ANT_FILE_SIGN = new Key("FORCED ANT FILE");
    @NonNls
    public static final String TAG_DIR_NS_PREFIX = "urn:jsptagdir:";
    @NonNls
    public static final String VALUE_ATTR_NAME = "value";
    @NonNls
    public static final String ENUMERATION_TAG_NAME = "enumeration";
    @NonNls
    public static final String HTML4_LOOSE_URI = "http://www.w3.org/TR/html4/loose.dtd";
    @NonNls
    public static final String WSDL_SCHEMA_URI = "http://schemas.xmlsoap.org/wsdl/";
    public static final String XHTML4_SCHEMA_LOCATION;
    public static final ThreadLocal<Boolean> BUILDING_DOM_STUBS;
    private static final Logger LOG;
    @NonNls
    private static final String JSTL_FORMAT_URI3 = "http://java.sun.com/jstl/fmt_rt";
    @NonNls
    public static final String[] JSTL_FORMAT_URIS;
    @NonNls
    private static final String FILE = "file:";
    @NonNls
    private static final String CLASSPATH = "classpath:/";
    @NonNls
    private static final String URN = "urn:";
    private static final Set<String> doNotVisitTags;

    private XmlUtil() {
    }

    @NotNull
    public static String getSchemaLocation(XmlTag tag2, @NotNull String namespace) {
        if (namespace == null) {
            XmlUtil.$$$reportNull$$$0(0);
        }
        while (tag2 != null) {
            String schemaLocation = tag2.getAttributeValue(SCHEMA_LOCATION_ATT, XML_SCHEMA_INSTANCE_URI);
            if (schemaLocation != null) {
                StringTokenizer tokenizer = new StringTokenizer(schemaLocation);
                int i2 = 0;
                while (tokenizer.hasMoreTokens()) {
                    String token2 = tokenizer.nextToken();
                    if (i2 % 2 == 0 && namespace.equals(token2) && tokenizer.hasMoreTokens()) {
                        String string = tokenizer.nextToken();
                        if (string == null) {
                            XmlUtil.$$$reportNull$$$0(1);
                        }
                        return string;
                    }
                    ++i2;
                }
            }
            tag2 = tag2.getParentTag();
        }
        String string = namespace;
        if (string == null) {
            XmlUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public static String findNamespacePrefixByURI(@NotNull XmlFile file2, @NotNull @NonNls String uri) {
        XmlTag tag2;
        if (file2 == null) {
            XmlUtil.$$$reportNull$$$0(3);
        }
        if (uri == null) {
            XmlUtil.$$$reportNull$$$0(4);
        }
        if ((tag2 = file2.getRootTag()) == null) {
            return null;
        }
        for (XmlAttribute attribute : tag2.getAttributes()) {
            if (attribute.getName().startsWith("xmlns:") && uri.equals(attribute.getValue())) {
                return attribute.getName().substring("xmlns:".length());
            }
            if (!"xmlns".equals(attribute.getName()) || !uri.equals(attribute.getValue())) continue;
            return EMPTY_URI;
        }
        return null;
    }

    @Nullable
    public static XmlFile findNamespace(@NotNull PsiFile base, @NotNull String nsLocation) {
        String location;
        if (base == null) {
            XmlUtil.$$$reportNull$$$0(5);
        }
        if (nsLocation == null) {
            XmlUtil.$$$reportNull$$$0(6);
        }
        if (!(location = ExternalResourceManager.getInstance().getResourceLocation(nsLocation, base.getProject())).equals(nsLocation)) {
            return XmlUtil.findXmlFile(base, location);
        }
        XmlFile xmlFile = XmlSchemaProvider.findSchema((String)location, (PsiFile)base);
        return xmlFile == null ? XmlUtil.findXmlFile(base, location) : xmlFile;
    }

    @Nullable
    public static XmlFile findNamespaceByLocation(@NotNull PsiFile base, @NotNull String nsLocation) {
        if (base == null) {
            XmlUtil.$$$reportNull$$$0(7);
        }
        if (nsLocation == null) {
            XmlUtil.$$$reportNull$$$0(8);
        }
        String location = ExternalResourceManager.getInstance().getResourceLocation(nsLocation, base.getProject());
        return XmlUtil.findXmlFile(base, location);
    }

    @NotNull
    public static Collection<XmlFile> findNSFilesByURI(@NotNull String namespace, @NotNull Project project, @Nullable Module module) {
        if (namespace == null) {
            XmlUtil.$$$reportNull$$$0(9);
        }
        if (project == null) {
            XmlUtil.$$$reportNull$$$0(10);
        }
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources = XmlNamespaceIndex.getResourcesByNamespace(namespace, project, module);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        List list2 = ContainerUtil.mapNotNull(resources, (Function)((NullableFunction)resource -> {
            PsiFile file2 = psiManager.findFile(resource.getFile());
            return file2 instanceof XmlFile ? (XmlFile)file2 : null;
        }));
        if (list2 == null) {
            XmlUtil.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Nullable
    public static XmlFile findXmlFile(@NotNull PsiFile base, @NotNull String uri) {
        String data2;
        if (base == null) {
            XmlUtil.$$$reportNull$$$0(12);
        }
        if (uri == null) {
            XmlUtil.$$$reportNull$$$0(13);
        }
        PsiFile result2 = null;
        if (ApplicationManager.getApplication().isUnitTestMode() && (data2 = (String)base.getOriginalFile().getUserData(TEST_PATH)) != null) {
            String filePath = data2 + "/" + uri;
            VirtualFile path2 = StandardFileSystems.local().findFileByPath(filePath.replace(File.separatorChar, '/'));
            if (path2 != null) {
                result2 = base.getManager().findFile(path2);
            }
        }
        if (result2 == null) {
            result2 = XmlUtil.findRelativeFile(uri, (PsiElement)base);
        }
        if (result2 instanceof XmlFile) {
            return (XmlFile)result2;
        }
        return null;
    }

    public static boolean isXmlToken(PsiElement element2, @NotNull IElementType tokenType) {
        if (tokenType == null) {
            XmlUtil.$$$reportNull$$$0(14);
        }
        return element2 instanceof XmlToken && ((XmlToken)element2).getTokenType() == tokenType;
    }

    @Nullable
    public static XmlToken getTokenOfType(PsiElement element2, @NotNull IElementType type) {
        PsiElement[] children2;
        if (type == null) {
            XmlUtil.$$$reportNull$$$0(15);
        }
        if (element2 == null) {
            return null;
        }
        for (PsiElement child2 : children2 = element2.getChildren()) {
            XmlToken token2;
            if (!(child2 instanceof XmlToken) || (token2 = (XmlToken)child2).getTokenType() != type) continue;
            return token2;
        }
        return null;
    }

    public static boolean processXmlElements(@NotNull XmlElement element2, @NotNull PsiElementProcessor<? super PsiElement> processor2, boolean deepFlag) {
        if (element2 == null) {
            XmlUtil.$$$reportNull$$$0(16);
        }
        if (processor2 == null) {
            XmlUtil.$$$reportNull$$$0(17);
        }
        return XmlPsiUtil.processXmlElements(element2, processor2, deepFlag);
    }

    public static boolean processXmlElements(@NotNull XmlElement element2, @NotNull PsiElementProcessor<? super PsiElement> processor2, boolean deepFlag, boolean wideFlag) {
        if (element2 == null) {
            XmlUtil.$$$reportNull$$$0(18);
        }
        if (processor2 == null) {
            XmlUtil.$$$reportNull$$$0(19);
        }
        return XmlPsiUtil.processXmlElements(element2, processor2, deepFlag, wideFlag);
    }

    public static boolean processXmlElements(@NotNull XmlElement element2, @NotNull PsiElementProcessor<? super PsiElement> processor2, boolean deepFlag, boolean wideFlag, PsiFile baseFile) {
        if (element2 == null) {
            XmlUtil.$$$reportNull$$$0(20);
        }
        if (processor2 == null) {
            XmlUtil.$$$reportNull$$$0(21);
        }
        return XmlPsiUtil.processXmlElements(element2, processor2, deepFlag, wideFlag, baseFile);
    }

    public static boolean processXmlElements(@NotNull XmlElement element2, @NotNull PsiElementProcessor<? super PsiElement> processor2, boolean deepFlag, boolean wideFlag, PsiFile baseFile, boolean processIncludes) {
        if (element2 == null) {
            XmlUtil.$$$reportNull$$$0(22);
        }
        if (processor2 == null) {
            XmlUtil.$$$reportNull$$$0(23);
        }
        return XmlPsiUtil.processXmlElements(element2, processor2, deepFlag, wideFlag, baseFile, processIncludes);
    }

    public static boolean processXmlElementChildren(@NotNull XmlElement element2, @NotNull PsiElementProcessor<? super PsiElement> processor2, boolean deepFlag) {
        if (element2 == null) {
            XmlUtil.$$$reportNull$$$0(24);
        }
        if (processor2 == null) {
            XmlUtil.$$$reportNull$$$0(25);
        }
        return XmlPsiUtil.processXmlElementChildren(element2, processor2, deepFlag);
    }

    public static boolean tagFromTemplateFramework(@NotNull XmlTag tag2) {
        if (tag2 == null) {
            XmlUtil.$$$reportNull$$$0(26);
        }
        String ns = tag2.getNamespace();
        return XmlUtil.nsFromTemplateFramework(ns);
    }

    public static boolean nsFromTemplateFramework(String ns) {
        return XSLT_URI.equals(ns) || XINCLUDE_URI.equals(ns);
    }

    public static char getCharFromEntityRef(@NonNls @NotNull String text2) {
        if (text2 == null) {
            XmlUtil.$$$reportNull$$$0(27);
        }
        try {
            if (text2.charAt(1) != '#') {
                char c = XmlTagUtil.getCharacterByEntityName((String)(text2 = text2.substring(1, text2.length() - 1)));
                if (c == '\u0000') {
                    LOG.error("Unknown entity: " + text2);
                }
                return c == '\u0000' ? (char)' ' : (char)c;
            }
            text2 = text2.substring(2, text2.length() - 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            LOG.error("Cannot parse ref: '" + text2 + "'", (Throwable)e);
        }
        try {
            int code;
            if (StringUtil.startsWithChar((CharSequence)text2, (char)'x')) {
                text2 = text2.substring(1);
                code = Integer.parseInt(text2, 16);
            } else {
                code = Integer.parseInt(text2);
            }
            return (char)code;
        }
        catch (NumberFormatException e) {
            return '\u0000';
        }
    }

    public static boolean attributeFromTemplateFramework(@NonNls String name, XmlTag tag2) {
        return "jsfc".equals(name) && XmlUtil.isJsfHtmlScheme(tag2);
    }

    @Nullable
    public static String getTargetSchemaNsFromTag(@Nullable XmlTag xmlTag) {
        if (xmlTag == null) {
            return null;
        }
        String targetNamespace = xmlTag.getAttributeValue(TARGET_NAMESPACE_ATTR_NAME, XML_SCHEMA_URI);
        if (targetNamespace == null) {
            targetNamespace = xmlTag.getAttributeValue(TARGET_NAMESPACE_ATTR_NAME, XML_SCHEMA_URI2);
        }
        if (targetNamespace == null) {
            targetNamespace = xmlTag.getAttributeValue(TARGET_NAMESPACE_ATTR_NAME, XML_SCHEMA_URI3);
        }
        return targetNamespace;
    }

    @Nullable
    public static XmlTag getSchemaSimpleContent(@NotNull XmlTag tag2) {
        TypeDescriptor type;
        XmlElementDescriptor descriptor2;
        if (tag2 == null) {
            XmlUtil.$$$reportNull$$$0(28);
        }
        if ((descriptor2 = tag2.getDescriptor()) instanceof XmlElementDescriptorImpl && (type = ((XmlElementDescriptorImpl)descriptor2).getType((XmlElement)tag2)) instanceof ComplexTypeDescriptor) {
            XmlTag[] simpleContent = new XmlTag[1];
            XmlUtil.processXmlElements((XmlElement)((ComplexTypeDescriptor)type).getDeclaration(), (PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)element2 -> {
                if (element2 instanceof XmlTag) {
                    XmlTag tag1 = (XmlTag)element2;
                    @NonNls String s = ((XmlTag)element2).getLocalName();
                    if ((s.equals(XSD_SIMPLE_CONTENT_TAG) || s.equals("restriction") && "string".equals(XmlUtil.findLocalNameByQualifiedName(tag1.getAttributeValue("base")))) && tag1.getNamespace().equals(XML_SCHEMA_URI)) {
                        simpleContent[0] = tag1;
                        return false;
                    }
                }
                return true;
            }), true);
            return simpleContent[0];
        }
        return null;
    }

    public static <T extends PsiElement> void doDuplicationCheckForElements(T[] elements, Map<String, T> presentNames, DuplicationInfoProvider<? super T> provider2, Validator.ValidationHost host) {
        for (T t : elements) {
            String name = provider2.getName((PsiElement)t);
            if (name == null) continue;
            String nameKey = provider2.getNameKey((PsiElement)t, name);
            if (presentNames.containsKey(nameKey)) {
                PsiElement psiElement = (PsiElement)presentNames.get(nameKey);
                String message2 = XmlPsiBundle.message((String)"xml.inspections.duplicate.declaration", (Object[])new Object[]{nameKey});
                if (psiElement != null) {
                    presentNames.put(nameKey, null);
                    host.addMessage(provider2.getNodeForMessage(psiElement), message2, Validator.ValidationHost.ErrorType.ERROR);
                }
                host.addMessage(provider2.getNodeForMessage((PsiElement)t), message2, Validator.ValidationHost.ErrorType.ERROR);
                continue;
            }
            presentNames.put(nameKey, t);
        }
    }

    public static boolean isAntFile(PsiFile file2) {
        XmlTag tag2;
        XmlFile xmlFile;
        XmlDocument document;
        if (file2 instanceof XmlFile && (document = (xmlFile = (XmlFile)file2).getDocument()) != null && (tag2 = document.getRootTag()) != null && "project".equals(tag2.getName()) && tag2.getContext() instanceof XmlDocument) {
            if (tag2.getAttributeValue("default") != null) {
                return true;
            }
            VirtualFile vFile = xmlFile.getOriginalFile().getVirtualFile();
            if (vFile != null && vFile.getUserData(ANT_FILE_SIGN) != null) {
                return true;
            }
        }
        return false;
    }

    private static boolean isJsfHtmlScheme(XmlTag tag2) {
        for (String jsfHtmlUri : JSF_HTML_URIS) {
            if (tag2.getNSDescriptor(jsfHtmlUri, true) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiFile findRelativeFile(String uri, PsiElement base) {
        if (base instanceof PsiFile) {
            PsiFile baseFile = (PsiFile)base;
            VirtualFile file2 = UriUtil.findRelative((String)uri, (PsiFileSystemItem)baseFile.getOriginalFile());
            if (file2 == null) {
                return null;
            }
            return base.getManager().findFile(file2);
        }
        if (base instanceof PsiDirectory) {
            PsiDirectory baseDir = (PsiDirectory)base;
            VirtualFile file3 = UriUtil.findRelative((String)uri, (PsiFileSystemItem)baseDir);
            if (file3 == null) {
                return null;
            }
            return base.getManager().findFile(file3);
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static String getCommentText(XmlComment comment) {
        String string = comment.getCommentText();
        if (string == null) {
            XmlUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    public static void reformatTagStart(XmlTag tag2) {
        ASTNode child2 = XmlChildRole.START_TAG_END_FINDER.findChild(tag2.getNode());
        if (child2 == null) {
            CodeStyleManager.getInstance((Project)tag2.getProject()).reformat((PsiElement)tag2);
        } else {
            CodeStyleManager.getInstance((Project)tag2.getProject()).reformatRange((PsiElement)tag2, tag2.getTextRange().getStartOffset(), child2.getTextRange().getEndOffset());
        }
    }

    @Nullable
    public static XmlElementDescriptor getDescriptorFromContext(@NotNull XmlTag tag2) {
        XmlTag parentTag;
        XmlElementDescriptor parentDescriptor;
        PsiElement parent;
        if (tag2 == null) {
            XmlUtil.$$$reportNull$$$0(30);
        }
        if ((parent = tag2.getParent()) instanceof XmlTag && (parentDescriptor = (parentTag = (XmlTag)parent).getDescriptor()) != null) {
            return XmlExtension.getExtension(tag2.getContainingFile()).getElementDescriptor(tag2, parentTag, parentDescriptor);
        }
        return null;
    }

    public static void expandTag(@NotNull XmlTag tag2) {
        if (tag2 == null) {
            XmlUtil.$$$reportNull$$$0(31);
        }
        XmlTag newTag = XmlElementFactory.getInstance((Project)tag2.getProject()).createTagFromText((CharSequence)("<" + tag2.getName() + "></" + tag2.getName() + ">"));
        ASTNode node = tag2.getNode();
        if (!(node instanceof CompositeElement)) {
            return;
        }
        CompositeElement compositeElement = (CompositeElement)node;
        LeafElement emptyTagEnd = (LeafElement)XmlChildRole.EMPTY_TAG_END_FINDER.findChild(compositeElement);
        if (emptyTagEnd == null) {
            return;
        }
        if (XmlTokenType.WHITESPACES.contains(emptyTagEnd.getTreePrev().getElementType())) {
            compositeElement.removeChild(emptyTagEnd.getTreePrev());
        }
        compositeElement.removeChild(emptyTagEnd);
        PsiElement[] children2 = newTag.getChildren();
        compositeElement.addChildren(children2[2].getNode(), null, null);
    }

    public static String getDefaultXhtmlNamespace(Project project) {
        String doctype = ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(project);
        return Html5SchemaProvider.getHtml5SchemaLocation().equals(doctype) ? Html5SchemaProvider.getXhtml5SchemaLocation() : doctype;
    }

    public static CharSequence getLocalName(CharSequence tagName) {
        int pos = StringUtil.indexOf((CharSequence)tagName, (char)':');
        if (pos == -1) {
            return tagName;
        }
        return tagName.subSequence(pos + 1, tagName.length());
    }

    public static boolean isStubBuilding() {
        return BUILDING_DOM_STUBS.get();
    }

    public static XmlTag addChildTag(XmlTag parent, XmlTag child2, int index2) throws IncorrectOperationException {
        if (parent.getSubTags().length == 0 && parent.getText().endsWith("/>")) {
            XmlElementFactory factory2 = XmlElementFactory.getInstance((Project)parent.getProject());
            String name = parent.getName();
            String text2 = parent.getText();
            XmlTag tag2 = factory2.createTagFromText((CharSequence)(text2.substring(0, text2.length() - 2) + "></" + name + ">"));
            parent = (XmlTag)parent.replace((PsiElement)tag2);
        }
        XmlElementDescriptor parentDescriptor = parent.getDescriptor();
        XmlTag[] subTags = parent.getSubTags();
        if (parentDescriptor == null || subTags.length == 0) {
            return (XmlTag)parent.add((PsiElement)child2);
        }
        int subTagNum = -1;
        for (XmlElementDescriptor childElementDescriptor : parentDescriptor.getElementsDescriptors(parent)) {
            String childElementName = childElementDescriptor.getName();
            int prevSubTagNum = subTagNum;
            while (subTagNum < subTags.length - 1 && subTags[subTagNum + 1].getName().equals(childElementName)) {
                ++subTagNum;
            }
            if (!childElementName.equals(child2.getLocalName())) continue;
            subTagNum = index2 == -1 || index2 > subTagNum - prevSubTagNum ? subTagNum : prevSubTagNum + index2;
            return (XmlTag)(subTagNum == -1 ? parent.addBefore((PsiElement)child2, (PsiElement)subTags[0]) : parent.addAfter((PsiElement)child2, (PsiElement)subTags[subTagNum]));
        }
        return (XmlTag)parent.add((PsiElement)child2);
    }

    public static @NonNls String[] @Nullable [] getDefaultNamespaces(XmlDocument document) {
        Language language;
        String namespace;
        XmlFile file2 = XmlUtil.getContainingFile((PsiElement)document);
        XmlTag tag2 = document.getRootTag();
        if (tag2 == null) {
            return null;
        }
        @NotNull List nsProviders = XmlFileNSInfoProvider.EP_NAME.getExtensionList();
        if (file2 != null) {
            block2: for (XmlFileNSInfoProvider nsProvider : nsProviders) {
                String[][] pairs = nsProvider.getDefaultNamespaces(file2);
                if (pairs == null || pairs.length <= 0) continue;
                for (String[] nsMapping : pairs) {
                    if (nsMapping != null && nsMapping.length == 2 && nsMapping[0] != null && nsMapping[1] != null) continue;
                    LOG.debug("NSInfoProvider " + nsProvider + " gave wrong info about " + file2.getVirtualFile());
                    continue block2;
                }
                return pairs;
            }
        }
        if ((namespace = XmlUtil.getDtdUri(document)) != null) {
            boolean overrideNamespaceFromDocType = false;
            if (file2 != null) {
                for (XmlFileNSInfoProvider provider2 : nsProviders) {
                    try {
                        if (!provider2.overrideNamespaceFromDocType(file2)) continue;
                        overrideNamespaceFromDocType = true;
                        break;
                    }
                    catch (AbstractMethodError abstractMethodError) {
                    }
                }
            }
            if (!overrideNamespaceFromDocType) {
                return new String[][]{{EMPTY_URI, namespace}};
            }
        }
        if ("taglib".equals(tag2.getName())) {
            return new String[][]{{EMPTY_URI, TAGLIB_1_2_URI}};
        }
        if (file2 != null && ((language = file2.getLanguage()).isKindOf((Language)HTMLLanguage.INSTANCE) || language == XHTMLLanguage.INSTANCE)) {
            return new String[][]{{EMPTY_URI, XHTML_URI}};
        }
        return null;
    }

    @Nullable
    public static String getDtdUri(XmlDocument document) {
        XmlProlog prolog = document.getProlog();
        if (prolog != null) {
            return XmlUtil.getDtdUri(prolog.getDoctype());
        }
        return null;
    }

    @Nullable
    public static String getDtdUri(XmlDoctype doctype) {
        if (doctype != null) {
            String docType = doctype.getDtdUri();
            if (docType == null) {
                String publicId = doctype.getPublicId();
                if (PsiTreeUtil.getParentOfType((PsiElement)doctype, XmlDocument.class) instanceof HtmlDocumentImpl && publicId != null && publicId.contains("-//W3C//DTD ")) {
                    return XmlUtil.guessDtdByPublicId(publicId);
                }
                if (HtmlUtil.isHtml5Doctype(doctype)) {
                    docType = doctype.getLanguage() instanceof HTMLLanguage ? Html5SchemaProvider.getHtml5SchemaLocation() : Html5SchemaProvider.getXhtml5SchemaLocation();
                }
            }
            return docType;
        }
        return null;
    }

    private static String guessDtdByPublicId(String id2) {
        if (id2.contains("XHTML")) {
            if (id2.contains("1.1")) {
                if (id2.contains("Basic")) {
                    return "http://www.w3.org/TR/xhtml-basic/xhtml-basic11.dtd";
                }
                return "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd";
            }
            if (id2.contains("Strict")) {
                return "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
            }
            if (id2.contains("Frameset")) {
                return "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd";
            }
            if (id2.contains("Transitional")) {
                return "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
            }
        } else if (id2.contains("HTML")) {
            if (id2.contains("Strict")) {
                return "http://www.w3.org/TR/html4/strict.dtd";
            }
            if (id2.contains("Frameset")) {
                return "http://www.w3.org/TR/html4/frameset.dtd";
            }
            return HTML4_LOOSE_URI;
        }
        return null;
    }

    private static void computeTag(XmlTag tag2, final Map<String, List<String>> tagsMap, final Map<String, List<MyAttributeInfo>> attributesMap, final boolean processIncludes) {
        XmlAttribute[] attributes2;
        if (tag2 == null) {
            return;
        }
        String tagName = tag2.getName();
        List<MyAttributeInfo> list2 = attributesMap.get(tagName);
        if (list2 == null) {
            list2 = new ArrayList<MyAttributeInfo>();
            for (XmlAttribute attribute : attributes2 = tag2.getAttributes()) {
                list2.add(new MyAttributeInfo(attribute.getName()));
            }
        } else {
            attributes2 = (XmlAttribute[])tag2.getAttributes().clone();
            ContainerUtil.sort(list2);
            Arrays.sort(attributes2, Comparator.comparing(XmlAttribute::getName));
            Iterator<MyAttributeInfo> iter = list2.iterator();
            list2 = new ArrayList<MyAttributeInfo>();
            int index2 = 0;
            while (iter.hasNext()) {
                MyAttributeInfo info2 = iter.next();
                boolean requiredFlag = false;
                while (attributes2.length > index2) {
                    if (info2.compareTo(attributes2[index2]) != 0) {
                        if (info2.compareTo(attributes2[index2]) < 0) break;
                        if (attributes2[index2].getValue() != null) {
                            list2.add(new MyAttributeInfo(attributes2[index2].getName(), false));
                        }
                        ++index2;
                        continue;
                    }
                    requiredFlag = true;
                    ++index2;
                    break;
                }
                info2.myRequired &= requiredFlag;
                list2.add(info2);
            }
            while (attributes2.length > index2) {
                if (attributes2[index2].getValue() != null) {
                    list2.add(new MyAttributeInfo(attributes2[index2++].getName(), false));
                    continue;
                }
                ++index2;
            }
        }
        attributesMap.put(tagName, list2);
        final List<Object> tags = tagsMap.get(tagName) != null ? tagsMap.get(tagName) : new ArrayList();
        tagsMap.put(tagName, tags);
        PsiFile file2 = tag2.isValid() ? tag2.getContainingFile() : null;
        XmlUtil.processXmlElements((XmlElement)tag2, new FilterElementProcessor(XmlTagFilter.INSTANCE){

            @Override
            public void add(PsiElement element2) {
                XmlTag tag2 = (XmlTag)element2;
                if (!tags.contains(tag2.getName())) {
                    tags.add(tag2.getName());
                }
                XmlUtil.computeTag(tag2, tagsMap, attributesMap, processIncludes);
            }
        }, false, false, file2, processIncludes);
    }

    @Nullable
    public static XmlElementDescriptor findXmlDescriptorByType(XmlTag xmlTag) {
        return XmlUtil.findXmlDescriptorByType(xmlTag, null);
    }

    @Nullable
    public static XmlElementDescriptor findXmlDescriptorByType(XmlTag xmlTag, @Nullable XmlTag context2) {
        String ns;
        String type = xmlTag.getAttributeValue("type", XML_SCHEMA_INSTANCE_URI);
        if (type == null && ourSchemaUrisList.contains(ns = xmlTag.getNamespace())) {
            type = xmlTag.getAttributeValue("type", null);
        }
        XmlElementDescriptor elementDescriptor = null;
        if (type != null) {
            String namespaceByPrefix = XmlUtil.findNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(type), xmlTag);
            XmlNSDescriptor typeDecr = xmlTag.getNSDescriptor(namespaceByPrefix, true);
            if (typeDecr == null && namespaceByPrefix.isEmpty()) {
                XmlDocument document;
                PsiFile containingFile;
                if (context2 != null) {
                    typeDecr = context2.getNSDescriptor(EMPTY_URI, true);
                }
                if (typeDecr == null && (containingFile = xmlTag.getContainingFile()) instanceof XmlFile && (document = ((XmlFile)containingFile).getDocument()) != null) {
                    typeDecr = (XmlNSDescriptor)document.getMetaData();
                }
            }
            if (typeDecr instanceof XmlNSDescriptorImpl) {
                XmlNSDescriptorImpl schemaDescriptor = (XmlNSDescriptorImpl)typeDecr;
                elementDescriptor = schemaDescriptor.getDescriptorByType(type, xmlTag);
            }
        }
        return elementDescriptor;
    }

    public static boolean collectEnumerationValues(XmlTag element2, HashSet<? super String> variants) {
        return XmlUtil.processEnumerationValues(element2, (Processor<? super XmlTag>)((Processor)xmlTag -> {
            variants.add(xmlTag.getAttributeValue(VALUE_ATTR_NAME));
            return true;
        }));
    }

    public static boolean processEnumerationValues(XmlTag element2, Processor<? super XmlTag> tagProcessor) {
        return XmlUtil.processEnumerationValues(element2, tagProcessor, new HashSet());
    }

    private static boolean processEnumerationValues(XmlTag element2, Processor<? super XmlTag> tagProcessor, Set<? super XmlTag> visited) {
        if (!visited.add((XmlTag)element2)) {
            return true;
        }
        boolean exhaustiveEnum = true;
        for (XmlTag tag2 : element2.getSubTags()) {
            @NonNls String localName = tag2.getLocalName();
            if (localName.equals(ENUMERATION_TAG_NAME)) {
                String attributeValue = tag2.getAttributeValue(VALUE_ATTR_NAME);
                if (attributeValue == null || tagProcessor.process((Object)tag2)) continue;
                return exhaustiveEnum;
            }
            if (localName.equals("union")) {
                exhaustiveEnum = false;
                XmlUtil.processEnumerationValues(tag2, tagProcessor, visited);
                XmlAttribute attribute = tag2.getAttribute("memberTypes");
                if (attribute == null || attribute.getValueElement() == null) continue;
                for (PsiReference reference2 : attribute.getValueElement().getReferences()) {
                    PsiElement resolve2 = reference2.resolve();
                    if (!(resolve2 instanceof XmlTag)) continue;
                    XmlUtil.processEnumerationValues((XmlTag)resolve2, tagProcessor, visited);
                }
                continue;
            }
            if (localName.equals("extension")) {
                XmlTag base = XmlSchemaTagsProcessor.resolveTagReference(tag2.getAttribute("base"));
                if (base == null) continue;
                return XmlUtil.processEnumerationValues(base, tagProcessor, visited);
            }
            if (doNotVisitTags.contains(localName)) continue;
            exhaustiveEnum &= XmlUtil.processEnumerationValues(tag2, tagProcessor, visited);
        }
        return exhaustiveEnum;
    }

    public static XmlTag createChildTag(XmlTag xmlTag, String localName, String namespace, @Nullable String bodyText, boolean enforceNamespacesDeep) {
        final String prefix2 = xmlTag.getPrefixByNamespace(namespace);
        Object qname = prefix2 != null && !prefix2.isEmpty() ? prefix2 + ":" + localName : localName;
        try {
            XmlTag retTag;
            String tagStart = (String)qname + (String)(!StringUtil.isEmpty((String)namespace) && xmlTag.getPrefixByNamespace(namespace) == null && (!StringUtil.isEmpty((String)xmlTag.getNamespacePrefix()) || !namespace.equals(xmlTag.getNamespace())) ? " xmlns=\"" + namespace + "\"" : EMPTY_URI);
            Language language = xmlTag.getLanguage();
            if (!(language instanceof HTMLLanguage)) {
                language = XMLLanguage.INSTANCE;
            }
            if (bodyText != null) {
                retTag = XmlElementFactory.getInstance((Project)xmlTag.getProject()).createTagFromText((CharSequence)("<" + tagStart + ">" + bodyText + "</" + (String)qname + ">"), language);
                if (enforceNamespacesDeep) {
                    retTag.acceptChildren((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                        public void visitXmlTag(XmlTag tag2) {
                            String namespacePrefix = tag2.getNamespacePrefix();
                            if (namespacePrefix.isEmpty()) {
                                Object qname = prefix2 != null && !prefix2.isEmpty() ? prefix2 + ":" + tag2.getLocalName() : tag2.getLocalName();
                                try {
                                    tag2.setName((String)qname);
                                }
                                catch (IncorrectOperationException e) {
                                    LOG.error((Throwable)e);
                                }
                            }
                            super.visitXmlTag(tag2);
                        }
                    });
                }
            } else {
                retTag = XmlElementFactory.getInstance((Project)xmlTag.getProject()).createTagFromText((CharSequence)("<" + tagStart + "/>"), language);
            }
            return retTag;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static Pair<XmlTagChild, XmlTagChild> findTagChildrenInRange(PsiFile file2, int startOffset, int endOffset) {
        PsiElement elementAt;
        PsiElement elementAt2;
        PsiElement elementAtStart = file2.findElementAt(startOffset);
        PsiElement elementAtEnd = file2.findElementAt(endOffset - 1);
        if (elementAtStart instanceof PsiWhiteSpace) {
            startOffset = elementAtStart.getTextRange().getEndOffset();
            elementAtStart = file2.findElementAt(startOffset);
        }
        if (elementAtEnd instanceof PsiWhiteSpace) {
            endOffset = elementAtEnd.getTextRange().getStartOffset();
            elementAtEnd = file2.findElementAt(endOffset - 1);
        }
        if (elementAtStart == null || elementAtEnd == null) {
            return null;
        }
        XmlTagChild first = (XmlTagChild)PsiTreeUtil.getParentOfType((PsiElement)elementAtStart, XmlTagChild.class);
        if (first == null) {
            return null;
        }
        if (!(first.getTextRange().getStartOffset() == startOffset || (elementAt2 = file2.findElementAt(first.getTextRange().getStartOffset())) instanceof PsiWhiteSpace && elementAt2.getTextRange().getEndOffset() == startOffset)) {
            return null;
        }
        XmlTagChild last = first;
        while (last != null && last.getTextRange().getEndOffset() < endOffset) {
            last = (XmlTagChild)PsiTreeUtil.getNextSiblingOfType((PsiElement)last, XmlTagChild.class);
        }
        if (last == null) {
            return null;
        }
        if (!(last.getTextRange().getEndOffset() == elementAtEnd.getTextRange().getEndOffset() || (elementAt = file2.findElementAt(last.getTextRange().getEndOffset() - 1)) instanceof PsiWhiteSpace && elementAt.getTextRange().getStartOffset() == endOffset)) {
            return null;
        }
        return Pair.create((Object)first, (Object)last);
    }

    public static boolean isSimpleValue(@NotNull String unquotedValue, PsiElement context2) {
        if (unquotedValue == null) {
            XmlUtil.$$$reportNull$$$0(32);
        }
        for (int i2 = 0; i2 < unquotedValue.length(); ++i2) {
            XmlFile file2;
            char ch = unquotedValue.charAt(i2);
            if (Character.isJavaIdentifierPart(ch) || ch == ':' || ch == '-' || (file2 = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)context2, XmlFile.class)) == null) continue;
            XmlTag tag2 = file2.getRootTag();
            return tag2 != null && !XmlUtil.tagFromTemplateFramework(tag2);
        }
        return true;
    }

    public static boolean toCode(@NotNull String str) {
        if (str == null) {
            XmlUtil.$$$reportNull$$$0(33);
        }
        for (int i2 = 0; i2 < str.length(); ++i2) {
            if (!XmlUtil.toCode(str.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static boolean toCode(char ch) {
        return "<&>\u00a0".indexOf(ch) >= 0;
    }

    @Nullable
    public static PsiNamedElement findRealNamedElement(@NotNull PsiNamedElement _element) {
        if (_element == null) {
            XmlUtil.$$$reportNull$$$0(34);
        }
        PsiNamedElement currentElement = _element;
        XmlEntityRef lastEntityRef = (XmlEntityRef)PsiTreeUtil.getParentOfType((PsiElement)currentElement, XmlEntityRef.class);
        while (!(currentElement instanceof XmlFile)) {
            PsiElement dependingElement = (PsiElement)currentElement.getUserData(XmlElement.DEPENDING_ELEMENT);
            if (dependingElement == null) {
                dependingElement = currentElement.getContext();
            }
            currentElement = dependingElement;
            if (dependingElement != null) continue;
            break;
        }
        if (currentElement != null) {
            XmlEntityDecl cachedEntity;
            String name = _element.getName();
            if (_element instanceof XmlEntityDecl && (cachedEntity = XmlEntityCache.getCachedEntity((PsiFile)currentElement, name)) != null) {
                return cachedEntity;
            }
            PsiNamedElement[] result2 = new PsiNamedElement[1];
            XmlUtil.processXmlElements((XmlElement)((XmlFile)currentElement), (PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)element2 -> {
                String elementName;
                if (element2 instanceof PsiNamedElement && ((elementName = ((PsiNamedElement)element2).getName()).equals(name) && _element.getClass().isInstance(element2) || lastEntityRef != null && element2 instanceof XmlEntityDecl && elementName.equals(lastEntityRef.getText().substring(1, lastEntityRef.getTextLength() - 1)))) {
                    result2[0] = (PsiNamedElement)element2;
                    return false;
                }
                return true;
            }), true);
            return result2[0];
        }
        return null;
    }

    public static int getPrefixLength(@NotNull String s) {
        if (s == null) {
            XmlUtil.$$$reportNull$$$0(35);
        }
        if (s.startsWith(TAG_DIR_NS_PREFIX)) {
            return TAG_DIR_NS_PREFIX.length();
        }
        if (s.startsWith(FILE)) {
            return FILE.length();
        }
        if (s.startsWith(CLASSPATH)) {
            return CLASSPATH.length();
        }
        return 0;
    }

    public static boolean isUrlText(String s, Project project) {
        boolean surelyUrl;
        boolean bl = surelyUrl = HtmlUtil.hasHtmlPrefix(s) || s.startsWith(URN);
        if (surelyUrl) {
            return true;
        }
        int protocolIndex = s.indexOf(":/");
        if (protocolIndex > 1 && !s.regionMatches(0, "classpath", 0, protocolIndex)) {
            return true;
        }
        return ExternalResourceManager.getInstance().getResourceLocation(s, project) != s;
    }

    public static String generateDocumentDTD(XmlDocument doc, boolean full) {
        PsiElement element2;
        LinkedHashMap<String, List<String>> tags = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, List<MyAttributeInfo>> attributes2 = new LinkedHashMap<String, List<MyAttributeInfo>>();
        XmlTag rootTag = doc.getRootTag();
        XmlUtil.computeTag(rootTag, tags, attributes2, full);
        PsiElement psiElement = element2 = rootTag != null ? rootTag.getNextSibling() : null;
        while (element2 != null) {
            if (element2 instanceof XmlTag) {
                XmlUtil.computeTag((XmlTag)element2, tags, attributes2, full);
            }
            element2 = element2.getNextSibling();
        }
        StringBuilder buffer = new StringBuilder();
        for (String tagName : tags.keySet()) {
            buffer.append(XmlUtil.generateElementDTD(tagName, (List)tags.get(tagName), (List)attributes2.get(tagName)));
        }
        return buffer.toString();
    }

    public static String generateElementDTD(String name, List<String> tags, List<? extends MyAttributeInfo> attributes2) {
        if (name == null || name.isEmpty()) {
            return EMPTY_URI;
        }
        if (name.contains("IntellijIdeaRulezzz")) {
            return EMPTY_URI;
        }
        @NonNls StringBuilder buffer = new StringBuilder();
        buffer.append("<!ELEMENT ").append(name).append(" ");
        if (tags.isEmpty()) {
            buffer.append("(#PCDATA)>\n");
        } else {
            buffer.append("(");
            Iterator<String> iter = tags.iterator();
            while (iter.hasNext()) {
                String string = iter.next();
                buffer.append(string);
                if (iter.hasNext()) {
                    buffer.append("|");
                    continue;
                }
                buffer.append(")*");
            }
            buffer.append(">\n");
        }
        if (!attributes2.isEmpty()) {
            buffer.append("<!ATTLIST ").append(name);
            for (MyAttributeInfo myAttributeInfo : attributes2) {
                buffer.append("\n    ").append(XmlUtil.generateAttributeDTD(myAttributeInfo));
            }
            buffer.append(">\n");
        }
        return buffer.toString();
    }

    private static String generateAttributeDTD(MyAttributeInfo info2) {
        if (info2.myName.contains("IntellijIdeaRulezzz")) {
            return EMPTY_URI;
        }
        return info2.myName + " CDATA" + (info2.myRequired ? " #REQUIRED" : " #IMPLIED");
    }

    public static String findNamespaceByPrefix(String prefix2, XmlTag contextTag) {
        return contextTag.getNamespaceByPrefix(prefix2);
    }

    @NotNull
    public static String findPrefixByQualifiedName(@NotNull String name) {
        int prefixEnd;
        if (name == null) {
            XmlUtil.$$$reportNull$$$0(36);
        }
        if ((prefixEnd = name.indexOf(58)) > 0) {
            String string = name.substring(0, prefixEnd);
            if (string == null) {
                XmlUtil.$$$reportNull$$$0(37);
            }
            return string;
        }
        return EMPTY_URI;
    }

    @Nullable
    public static String findLocalNameByQualifiedName(String name) {
        return name == null ? null : name.substring(name.indexOf(58) + 1);
    }

    public static XmlFile getContainingFile(PsiElement element2) {
        while (!(element2 instanceof XmlFile) && element2 != null) {
            PsiElement context2 = element2.getContext();
            if (context2 == null) {
                XmlExtension extension2 = XmlExtension.getExtensionByElement(element2);
                if (extension2 == null) continue;
                element2 = extension2.getContainingFile(element2);
                continue;
            }
            if (element2 == context2) {
                LOG.error("Context==element: " + element2.getClass());
                return null;
            }
            element2 = context2;
        }
        return (XmlFile)element2;
    }

    @NotNull
    public static String unescape(@NotNull String text2) {
        if (text2 == null) {
            XmlUtil.$$$reportNull$$$0(38);
        }
        String string = StringUtil.unescapeXmlEntities((String)text2);
        if (string == null) {
            XmlUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    public static String escape(@NotNull String text2) {
        if (text2 == null) {
            XmlUtil.$$$reportNull$$$0(40);
        }
        String string = StringUtil.escapeXmlEntities((String)text2);
        if (string == null) {
            XmlUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    public static boolean isValidTagNameChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == ':' || c == '_' || c == '-' || c == '.';
    }

    @Nullable
    public static String extractXmlEncodingFromProlog(byte @NotNull [] content2) {
        if (content2 == null) {
            XmlUtil.$$$reportNull$$$0(42);
        }
        return XmlCharsetDetector.extractXmlEncodingFromProlog((byte[])content2);
    }

    @Nullable
    public static String extractXmlEncodingFromProlog(@NotNull CharSequence text2) {
        if (text2 == null) {
            XmlUtil.$$$reportNull$$$0(43);
        }
        return XmlCharsetDetector.extractXmlEncodingFromProlog((CharSequence)text2);
    }

    public static void registerXmlAttributeValueReferenceProvider(PsiReferenceRegistrar registrar, @NonNls String @Nullable [] attributeNames, @Nullable ElementFilter elementFilter, @NotNull PsiReferenceProvider provider2) {
        if (provider2 == null) {
            XmlUtil.$$$reportNull$$$0(44);
        }
        XmlUtil.registerXmlAttributeValueReferenceProvider(registrar, attributeNames, elementFilter, true, provider2);
    }

    public static void registerXmlAttributeValueReferenceProvider(PsiReferenceRegistrar registrar, @NonNls String @Nullable [] attributeNames, @Nullable ElementFilter elementFilter, boolean caseSensitive, @NotNull PsiReferenceProvider provider2) {
        if (provider2 == null) {
            XmlUtil.$$$reportNull$$$0(45);
        }
        XmlUtil.registerXmlAttributeValueReferenceProvider(registrar, attributeNames, elementFilter, caseSensitive, provider2, 0.0);
    }

    public static void registerXmlAttributeValueReferenceProvider(PsiReferenceRegistrar registrar, @NonNls String @Nullable [] attributeNames, @Nullable ElementFilter elementFilter, boolean caseSensitive, @NotNull PsiReferenceProvider provider2, double priority) {
        if (provider2 == null) {
            XmlUtil.$$$reportNull$$$0(46);
        }
        if (attributeNames == null) {
            registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().and((ElementPattern)new FilterPattern(elementFilter)), provider2, priority);
            return;
        }
        StringPattern namePattern = caseSensitive ? StandardPatterns.string().oneOf(attributeNames) : StandardPatterns.string().oneOfIgnoreCase(attributeNames);
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().withLocalName((ElementPattern)namePattern).and((ElementPattern)new FilterPattern(elementFilter)), provider2, priority);
    }

    public static void registerXmlTagReferenceProvider(PsiReferenceRegistrar registrar, @NonNls String[] names2, @Nullable ElementFilter elementFilter, boolean caseSensitive, @NotNull PsiReferenceProvider provider2) {
        if (provider2 == null) {
            XmlUtil.$$$reportNull$$$0(47);
        }
        if (names2 == null) {
            registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlTag().and((ElementPattern)new FilterPattern(elementFilter)), provider2, 0.0);
            return;
        }
        StringPattern namePattern = caseSensitive ? StandardPatterns.string().oneOf(names2) : StandardPatterns.string().oneOfIgnoreCase(names2);
        registrar.registerReferenceProvider((ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName((ElementPattern)namePattern)).and((ElementPattern)new FilterPattern(elementFilter)), provider2, 0.0);
    }

    public static XmlFile findDescriptorFile(@NotNull XmlTag tag2, @NotNull XmlFile containingFile) {
        XmlFile descriptorFile;
        XmlElementDescriptor descriptor2;
        XmlNSDescriptor nsDescriptor;
        if (tag2 == null) {
            XmlUtil.$$$reportNull$$$0(48);
        }
        if (containingFile == null) {
            XmlUtil.$$$reportNull$$$0(49);
        }
        XmlNSDescriptor xmlNSDescriptor = nsDescriptor = (descriptor2 = tag2.getDescriptor()) != null ? descriptor2.getNSDescriptor() : null;
        Object object = nsDescriptor != null ? nsDescriptor.getDescriptorFile() : (descriptorFile = containingFile.getDocument().getProlog().getDoctype() != null ? containingFile : null);
        if (nsDescriptor != null && (descriptorFile == null || descriptorFile.getName().equals(containingFile.getName() + ".dtd"))) {
            descriptorFile = containingFile;
        }
        return descriptorFile;
    }

    public static boolean isTagDefinedByNamespace(@NotNull XmlTag xmlTag) {
        XmlNSDescriptor nsDescriptor;
        if (xmlTag == null) {
            XmlUtil.$$$reportNull$$$0(50);
        }
        XmlElementDescriptor descriptor2 = (nsDescriptor = xmlTag.getNSDescriptor(xmlTag.getNamespace(), false)) != null ? nsDescriptor.getElementDescriptor(xmlTag) : null;
        return descriptor2 != null && !(descriptor2 instanceof AnyXmlElementDescriptor);
    }

    @Nullable
    public static XmlComment findPreviousComment(PsiElement element2) {
        PsiElement curElement = element2;
        while (curElement != null && !(curElement instanceof XmlComment)) {
            if ((curElement = curElement.getPrevSibling()) instanceof XmlText && StringUtil.isEmptyOrSpaces((String)curElement.getText()) || curElement instanceof PsiWhiteSpace || curElement instanceof XmlProlog || curElement instanceof XmlComment) continue;
            curElement = null;
            break;
        }
        return (XmlComment)curElement;
    }

    public static boolean hasNonEditableInjectionFragmentAt(@NotNull XmlAttribute attribute, int offset) {
        InjectedLanguageManager manager2;
        PsiLanguageInjectionHost host;
        if (attribute == null) {
            XmlUtil.$$$reportNull$$$0(51);
        }
        if ((host = (manager2 = InjectedLanguageManager.getInstance((Project)attribute.getProject())).getInjectionHost((PsiElement)attribute)) == null) {
            return false;
        }
        Document doc = PsiDocumentManager.getInstance((Project)attribute.getProject()).getDocument(attribute.getContainingFile());
        if (!(doc instanceof DocumentWindow)) {
            return false;
        }
        return ContainerUtil.exists((Iterable)manager2.getNonEditableFragments((DocumentWindow)doc), range2 -> range2.getStartOffset() <= offset && offset <= range2.getEndOffset() + 1);
    }

    static {
        BUILDING_DOM_STUBS = ThreadLocal.withInitial(() -> Boolean.FALSE);
        LOG = Logger.getInstance(XmlUtil.class);
        JSTL_FORMAT_URIS = new String[]{JSTL_FORMAT_URI, JSTL_FORMAT_URI2, JSTL_FORMAT_URI3};
        doNotVisitTags = ContainerUtil.set((Object[])new String[]{"annotation", "element", "attribute"});
        URL xhtml4SchemaLocationUrl = XmlUtil.class.getResource("/standardSchemas/xhtml1-transitional.xsd");
        XHTML4_SCHEMA_LOCATION = VfsUtilCore.urlToPath((String)VfsUtilCore.toIdeaUrl((String)FileUtil.unquote((String)xhtml4SchemaLocationUrl.toExternalForm()), (boolean)false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 29: 
            case 37: 
            case 39: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 29: 
            case 37: 
            case 39: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 29: 
            case 37: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/XmlUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nsLocation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 27: 
            case 38: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedValue";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_element";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTag";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/XmlUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaLocation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findNSFilesByURI";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentText";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "findPrefixByQualifiedName";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "unescape";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "escape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaLocation";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 29: 
            case 37: 
            case 39: 
            case 41: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findNamespacePrefixByURI";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findNamespace";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findNamespaceByLocation";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findNSFilesByURI";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findXmlFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isXmlToken";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTokenOfType";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processXmlElements";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processXmlElementChildren";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "tagFromTemplateFramework";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCharFromEntityRef";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaSimpleContent";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorFromContext";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "expandTag";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleValue";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "toCode";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findRealNamedElement";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixLength";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findPrefixByQualifiedName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "unescape";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "extractXmlEncodingFromProlog";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "registerXmlAttributeValueReferenceProvider";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "registerXmlTagReferenceProvider";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findDescriptorFile";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isTagDefinedByNamespace";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "hasNonEditableInjectionFragmentAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 29: 
            case 37: 
            case 39: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyAttributeInfo
    implements Comparable {
        boolean myRequired = true;
        String myName;

        MyAttributeInfo(String name) {
            this.myName = name;
        }

        MyAttributeInfo(String name, boolean flag) {
            this.myName = name;
            this.myRequired = flag;
        }

        public int compareTo(Object o) {
            if (o instanceof MyAttributeInfo) {
                return this.myName.compareTo(((MyAttributeInfo)o).myName);
            }
            if (o instanceof XmlAttribute) {
                return this.myName.compareTo(((XmlAttribute)o).getName());
            }
            return -1;
        }
    }

    public static interface DuplicationInfoProvider<T extends PsiElement> {
        @Nullable
        public String getName(@NotNull T var1);

        @NotNull
        public String getNameKey(@NotNull T var1, @NotNull String var2);

        @NotNull
        public PsiElement getNodeForMessage(@NotNull T var1);
    }
}

