/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class XmlIncludeHandler {
    @NonNls
    private static final String INCLUDE_TAG_NAME = "include";

    public static boolean isXInclude(PsiElement element2) {
        if (element2 instanceof XmlTag) {
            XmlTag xmlTag = (XmlTag)element2;
            if (xmlTag.getParent() instanceof XmlDocument) {
                return false;
            }
            if (xmlTag.getLocalName().equals(INCLUDE_TAG_NAME) && xmlTag.getAttributeValue("href") != null && xmlTag.getNamespace().equals("http://www.w3.org/2001/XInclude")) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static XmlFile resolveXIncludeFile(XmlTag xincludeTag) {
        XmlAttribute hrefAttribute = xincludeTag.getAttribute("href", null);
        if (hrefAttribute == null) {
            return null;
        }
        XmlAttributeValue xmlAttributeValue = hrefAttribute.getValueElement();
        if (xmlAttributeValue == null) {
            return null;
        }
        List<PsiReference> references = Arrays.asList(xmlAttributeValue.getReferences());
        if (references.size() > 0) {
            references.sort((reference1, reference2) -> reference2.getRangeInElement().getStartOffset() - reference1.getRangeInElement().getStartOffset());
            PsiElement target2 = references.get(0).resolve();
            if (target2 instanceof XmlFile) {
                return (XmlFile)target2;
            }
        }
        return null;
    }
}

