/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.xdebugger.XNamedTreeNode;
import com.intellij.xdebugger.evaluation.InlineDebuggerHelper;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.pinned.items.XDebuggerPinToTopManager;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueGroupNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XValueContainerNode<ValueContainer extends XValueContainer>
extends XDebuggerTreeNode
implements XCompositeNode,
TreeNode {
    private List<XValueNodeImpl> myValueChildren;
    private List<MessageTreeNode> myMessageChildren;
    private List<MessageTreeNode> myTemporaryMessageChildren;
    private MessageTreeNode myTemporaryEditorNode;
    private List<XValueGroupNodeImpl> myTopGroups;
    private List<XValueGroupNodeImpl> myBottomGroups;
    private List<TreeNode> myCachedAllChildren;
    protected final ValueContainer myValueContainer;
    private volatile boolean myObsolete;
    private volatile boolean myAlreadySorted;

    protected XValueContainerNode(XDebuggerTree tree, XDebuggerTreeNode parent, boolean leaf, @NotNull ValueContainer valueContainer) {
        if (valueContainer == null) {
            XValueContainerNode.$$$reportNull$$$0(0);
        }
        super(tree, parent, leaf);
        this.myValueContainer = valueContainer;
    }

    private void loadChildren() {
        if (this.myValueChildren != null || this.myMessageChildren != null || this.myTemporaryMessageChildren != null) {
            return;
        }
        this.startComputingChildren();
    }

    private void prepareForComputingChildren() {
        this.myCachedAllChildren = null;
        this.setTemporaryMessageNode(this.createLoadingMessageNode());
    }

    public void startComputingChildren() {
        this.prepareForComputingChildren();
        this.myValueContainer.computeChildren((XCompositeNode)this);
    }

    protected MessageTreeNode createLoadingMessageNode() {
        return MessageTreeNode.createLoadingMessage(this.myTree, this);
    }

    public void setAlreadySorted(boolean alreadySorted) {
        this.myAlreadySorted = alreadySorted;
    }

    public void addChildren(@NotNull XValueChildrenList children2, boolean last) {
        if (children2 == null) {
            XValueContainerNode.$$$reportNull$$$0(1);
        }
        if (this.myObsolete) {
            return;
        }
        this.invokeNodeUpdate(() -> {
            Object newChildren;
            if (this.myObsolete) {
                return;
            }
            if (children2.size() > 0) {
                newChildren = new ArrayList(children2.size());
                if (this.myValueChildren == null) {
                    this.myValueChildren = this.initChildrenList(children2.size());
                }
                boolean valuesInline = XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowValuesInline();
                InlineDebuggerHelper inlineHelper = this.getTree().getEditorsProvider().getInlineDebuggerHelper();
                for (int i2 = 0; i2 < children2.size(); ++i2) {
                    XValueNodeImpl node = new XValueNodeImpl(this.myTree, (XDebuggerTreeNode)this, children2.getName(i2), children2.getValue(i2));
                    this.myValueChildren.add(node);
                    newChildren.add(node);
                    if (!valuesInline || !inlineHelper.shouldEvaluateChildrenByDefault((XNamedTreeNode)node) || !XValueContainerNode.isUseGetChildrenHack(this.myTree)) continue;
                    node.getChildren();
                }
            } else {
                newChildren = new SmartList();
                if (this.myValueChildren == null) {
                    this.myValueChildren = new SmartList();
                }
            }
            this.myTopGroups = this.createGroupNodes(children2.getTopGroups(), this.myTopGroups, (List<? super XValueContainerNode<?>>)newChildren);
            this.myBottomGroups = this.createGroupNodes(children2.getBottomGroups(), this.myBottomGroups, (List<? super XValueContainerNode<?>>)newChildren);
            this.myCachedAllChildren = null;
            this.fireNodesInserted((Collection<? extends TreeNode>)newChildren);
            if (last && this.myTemporaryMessageChildren != null) {
                int[] ints = this.getNodesIndices(this.myTemporaryMessageChildren);
                TreeNode[] removed = this.myTemporaryMessageChildren.toArray(new TreeNode[0]);
                this.myCachedAllChildren = null;
                this.myTemporaryMessageChildren = null;
                this.fireNodesRemoved(ints, removed);
            }
            this.myTree.childrenLoaded(this, (List<? extends XValueContainerNode<?>>)newChildren, last);
        });
    }

    private List<XValueNodeImpl> initChildrenList(int initialSize) {
        boolean isPinToTopSupported;
        XDebuggerPinToTopManager pinToTopManager = XDebuggerPinToTopManager.Companion.getInstance(this.myTree.getProject());
        boolean needBaseSorting = !this.myAlreadySorted && XDebuggerSettingsManager.getInstance().getDataViewSettings().isSortValues();
        boolean bl = isPinToTopSupported = pinToTopManager.isEnabled() && pinToTopManager.isPinToTopSupported(this);
        if (!needBaseSorting && !isPinToTopSupported) {
            return new ArrayList<XValueNodeImpl>(initialSize);
        }
        Comparator<XValueNodeImpl> comparator2 = needBaseSorting ? (isPinToTopSupported ? pinToTopManager.getCompoundComparator() : XValueNodeImpl.COMPARATOR) : pinToTopManager.getPinToTopComparator();
        return new SortedList(comparator2);
    }

    private static boolean isUseGetChildrenHack(@NotNull XDebuggerTree tree) {
        if (tree == null) {
            XValueContainerNode.$$$reportNull$$$0(2);
        }
        return !tree.isUnderRemoteDebug();
    }

    @Nullable
    private List<XValueGroupNodeImpl> createGroupNodes(List<? extends XValueGroup> groups2, @Nullable List<XValueGroupNodeImpl> prevNodes, List<? super XValueContainerNode<?>> newChildren) {
        if (groups2.isEmpty()) {
            return prevNodes;
        }
        SmartList nodes = prevNodes != null ? prevNodes : new SmartList();
        for (XValueGroup xValueGroup : groups2) {
            XValueGroupNodeImpl node = new XValueGroupNodeImpl(this.myTree, (XDebuggerTreeNode)this, xValueGroup);
            nodes.add(node);
            newChildren.add(node);
        }
        return nodes;
    }

    public void tooManyChildren(int remaining) {
        this.tooManyChildren(remaining, () -> this.myValueContainer.computeChildren((XCompositeNode)this));
    }

    public void tooManyChildren(int remaining, @NotNull Runnable childrenSupplier) {
        if (childrenSupplier == null) {
            XValueContainerNode.$$$reportNull$$$0(3);
        }
        this.invokeNodeUpdate(() -> this.setTemporaryMessageNode(MessageTreeNode.createEllipsisNode(this.myTree, this, remaining, () -> {
            this.myTree.selectNodeOnLoad((Condition<? super TreeNode>)((Condition)n -> n.getParent() == this), (Condition<? super TreeNode>)((Condition)n -> this.isObsolete()));
            this.prepareForComputingChildren();
            childrenSupplier.run();
        })));
    }

    public boolean isObsolete() {
        return this.myObsolete;
    }

    @Override
    public void clearChildren() {
        this.myCachedAllChildren = null;
        this.myMessageChildren = null;
        this.myTemporaryMessageChildren = null;
        this.myTemporaryEditorNode = null;
        this.myValueChildren = null;
        this.myTopGroups = null;
        this.myBottomGroups = null;
        this.fireNodeStructureChanged();
    }

    public void setErrorMessage(@NotNull String errorMessage) {
        if (errorMessage == null) {
            XValueContainerNode.$$$reportNull$$$0(4);
        }
        this.setErrorMessage(errorMessage, null);
    }

    public void setErrorMessage(@NotNull String errorMessage, @Nullable XDebuggerTreeNodeHyperlink link2) {
        if (errorMessage == null) {
            XValueContainerNode.$$$reportNull$$$0(5);
        }
        this.setMessage(errorMessage, XDebuggerUIConstants.ERROR_MESSAGE_ICON, XDebuggerUIConstants.ERROR_MESSAGE_ATTRIBUTES, link2);
        this.invokeNodeUpdate(() -> this.setMessageNodes(Collections.emptyList(), true));
    }

    public void setMessage(@NotNull String message2, Icon icon2, @NotNull SimpleTextAttributes attributes2, @Nullable XDebuggerTreeNodeHyperlink link2) {
        if (message2 == null) {
            XValueContainerNode.$$$reportNull$$$0(6);
        }
        if (attributes2 == null) {
            XValueContainerNode.$$$reportNull$$$0(7);
        }
        this.invokeNodeUpdate(() -> this.setMessageNodes(MessageTreeNode.createMessages(this.myTree, this, message2, link2, icon2, attributes2), false));
    }

    public void setInfoMessage(@NotNull @Nls String message2, @Nullable HyperlinkListener hyperlinkListener) {
        if (message2 == null) {
            XValueContainerNode.$$$reportNull$$$0(8);
        }
        this.invokeNodeUpdate(() -> this.setMessageNodes(Collections.singletonList(MessageTreeNode.createInfoMessage(this.myTree, message2, hyperlinkListener)), false));
    }

    private void setTemporaryMessageNode(MessageTreeNode messageNode) {
        this.setMessageNodes(Collections.singletonList(messageNode), true);
    }

    private void setMessageNodes(List<MessageTreeNode> messages, boolean temporary) {
        List<MessageTreeNode> toDelete;
        this.myCachedAllChildren = null;
        List<MessageTreeNode> list2 = toDelete = temporary ? this.myTemporaryMessageChildren : this.myMessageChildren;
        if (toDelete != null) {
            this.fireNodesRemoved(this.getNodesIndices(toDelete), toDelete.toArray(new TreeNode[0]));
        }
        if (temporary) {
            this.myTemporaryMessageChildren = messages;
        } else {
            this.myMessageChildren = messages;
        }
        this.myCachedAllChildren = null;
        this.fireNodesInserted(messages);
    }

    @NotNull
    public XDebuggerTreeNode addTemporaryEditorNode(@Nullable Icon icon2, @Nullable @Nls String text2) {
        if (this.isLeaf()) {
            this.setLeaf(false);
        }
        this.myTree.expandPath(this.getPath());
        MessageTreeNode node = new MessageTreeNode(this.myTree, this, true);
        node.setIcon(icon2);
        if (!StringUtil.isEmpty((String)text2)) {
            node.getText().append(text2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        this.myTemporaryEditorNode = node;
        this.myCachedAllChildren = null;
        this.fireNodesInserted(Collections.singleton(node));
        MessageTreeNode messageTreeNode = node;
        if (messageTreeNode == null) {
            XValueContainerNode.$$$reportNull$$$0(9);
        }
        return messageTreeNode;
    }

    public void removeTemporaryEditorNode(XDebuggerTreeNode node) {
        if (this.myTemporaryEditorNode != null) {
            int index2 = this.getIndex(this.myTemporaryEditorNode);
            this.myTemporaryEditorNode = null;
            this.myCachedAllChildren = null;
            this.fireNodesRemoved(new int[]{index2}, new TreeNode[]{node});
        }
    }

    protected int removeChildNode(List children2, XDebuggerTreeNode node) {
        int index2 = children2.indexOf(node);
        if (index2 != -1) {
            children2.remove(node);
            this.fireNodesRemoved(new int[]{index2}, new TreeNode[]{node});
        }
        return index2;
    }

    @Override
    @NotNull
    public List<? extends TreeNode> getChildren() {
        this.loadChildren();
        if (this.myCachedAllChildren == null) {
            this.myCachedAllChildren = new ArrayList<TreeNode>();
            if (this.myTemporaryEditorNode != null) {
                this.myCachedAllChildren.add(this.myTemporaryEditorNode);
            }
            if (this.myMessageChildren != null) {
                this.myCachedAllChildren.addAll(this.myMessageChildren);
            }
            if (this.myTopGroups != null) {
                this.myCachedAllChildren.addAll(this.myTopGroups);
            }
            if (this.myValueChildren != null) {
                this.myCachedAllChildren.addAll(this.myValueChildren);
            }
            if (this.myBottomGroups != null) {
                this.myCachedAllChildren.addAll(this.myBottomGroups);
            }
            if (this.myTemporaryMessageChildren != null) {
                this.myCachedAllChildren.addAll(this.myTemporaryMessageChildren);
            }
        }
        List<TreeNode> list2 = this.myCachedAllChildren;
        if (list2 == null) {
            XValueContainerNode.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public ValueContainer getValueContainer() {
        ValueContainer ValueContainer2 = this.myValueContainer;
        if (ValueContainer2 == null) {
            XValueContainerNode.$$$reportNull$$$0(11);
        }
        return ValueContainer2;
    }

    @NotNull
    public List<? extends XValueContainerNode<?>> getLoadedChildren() {
        List empty = Collections.emptyList();
        List list2 = ContainerUtil.concat((List[])new List[]{(List)ObjectUtils.notNull(this.myTopGroups, empty), (List)ObjectUtils.notNull(this.myValueChildren, empty), (List)ObjectUtils.notNull(this.myBottomGroups, empty)});
        if (list2 == null) {
            XValueContainerNode.$$$reportNull$$$0(12);
        }
        return list2;
    }

    public void setObsolete() {
        this.myObsolete = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueContainer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenSupplier";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/nodes/XValueContainerNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/XValueContainerNode";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addTemporaryEditorNode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueContainer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addChildren";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUseGetChildrenHack";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tooManyChildren";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setErrorMessage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setMessage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setInfoMessage";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

