/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorMouseHoverPopupControl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionPointHighlighter {
    private final Project myProject;
    private RangeHighlighter myRangeHighlighter;
    private Editor myEditor;
    private XSourcePosition mySourcePosition;
    private OpenFileDescriptor myOpenFileDescriptor;
    private boolean myNotTopFrame;
    private GutterIconRenderer myGutterIconRenderer;
    public static final Key<Boolean> EXECUTION_POINT_HIGHLIGHTER_TOP_FRAME_KEY = Key.create((String)"EXECUTION_POINT_HIGHLIGHTER_TOP_FRAME_KEY");
    private final AtomicBoolean updateRequested;

    public ExecutionPointHighlighter(@NotNull Project project) {
        if (project == null) {
            ExecutionPointHighlighter.$$$reportNull$$$0(0);
        }
        this.updateRequested = new AtomicBoolean();
        this.myProject = project;
        project.getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, scheme2 -> this.update(false));
    }

    public void show(@NotNull XSourcePosition position, boolean notTopFrame, @Nullable GutterIconRenderer gutterIconRenderer) {
        if (position == null) {
            ExecutionPointHighlighter.$$$reportNull$$$0(1);
        }
        this.updateRequested.set(false);
        ((AppUIExecutor)AppUIExecutor.onWriteThread((ModalityState)ModalityState.NON_MODAL).expireWith((Disposable)this.myProject)).submit(() -> {
            this.updateRequested.set(false);
            this.mySourcePosition = position;
            this.clearDescriptor();
            this.myOpenFileDescriptor = XSourcePositionImpl.createOpenFileDescriptor(this.myProject, position);
            this.myOpenFileDescriptor.setUsePreviewTab(true);
            if (!XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isScrollToCenter()) {
                this.myOpenFileDescriptor.setScrollType(notTopFrame ? ScrollType.CENTER : ScrollType.MAKE_VISIBLE);
            }
            this.myGutterIconRenderer = gutterIconRenderer;
            this.myNotTopFrame = notTopFrame;
        }).thenAsync(ignored -> ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.myProject)).submit(() -> this.doShow(true)));
    }

    public void hide() {
        AppUIUtil.invokeOnEdt(() -> {
            this.updateRequested.set(false);
            this.removeHighlighter();
            this.clearDescriptor();
            this.myEditor = null;
            this.myGutterIconRenderer = null;
        });
    }

    private void clearDescriptor() {
        if (this.myOpenFileDescriptor != null) {
            this.myOpenFileDescriptor.dispose();
            this.myOpenFileDescriptor = null;
        }
    }

    public void navigateTo() {
        if (this.myOpenFileDescriptor != null && this.myOpenFileDescriptor.getFile().isValid()) {
            this.myOpenFileDescriptor.navigateInEditor(this.myProject, true);
        }
    }

    @Nullable
    public VirtualFile getCurrentFile() {
        return this.myOpenFileDescriptor != null ? this.myOpenFileDescriptor.getFile() : null;
    }

    public void update(boolean navigate2) {
        if (this.updateRequested.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.updateRequested.compareAndSet(true, false)) {
                    this.doShow(navigate2);
                }
            }, this.myProject.getDisposed());
        }
    }

    public void updateGutterIcon(@Nullable GutterIconRenderer renderer) {
        AppUIUtil.invokeOnEdt(() -> {
            if (this.myRangeHighlighter != null && this.myGutterIconRenderer != null) {
                this.myRangeHighlighter.setGutterIconRenderer(renderer);
            }
        });
    }

    private void doShow(boolean navigate2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.removeHighlighter();
        this.myEditor = null;
        if (this.myOpenFileDescriptor != null) {
            FileEditor editor;
            if (!navigate2 && (editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(this.myOpenFileDescriptor.getFile())) instanceof TextEditor) {
                this.myEditor = ((TextEditor)editor).getEditor();
            }
            if (this.myEditor == null) {
                this.myEditor = XDebuggerUtilImpl.createEditor(this.myOpenFileDescriptor);
            }
        }
        if (this.myEditor != null) {
            this.addHighlighter();
        }
    }

    private void removeHighlighter() {
        if (this.myEditor != null) {
            ExecutionPointHighlighter.disableMouseHoverPopups(this.myEditor, false);
        }
        if (this.myRangeHighlighter != null) {
            this.myRangeHighlighter.dispose();
            this.myRangeHighlighter = null;
        }
    }

    private void addHighlighter() {
        TextRange lineRange;
        TextRange range2;
        ExecutionPointHighlighter.disableMouseHoverPopups(this.myEditor, true);
        int line = this.mySourcePosition.getLine();
        Document document = this.myEditor.getDocument();
        if (line < 0 || line >= document.getLineCount()) {
            return;
        }
        if (this.myRangeHighlighter != null) {
            return;
        }
        TextAttributesKey attributesKey = this.myNotTopFrame ? DebuggerColors.NOT_TOP_FRAME_ATTRIBUTES : DebuggerColors.EXECUTIONPOINT_ATTRIBUTES;
        MarkupModel markupModel = DocumentMarkupModel.forDocument(document, this.myProject, true);
        if (this.mySourcePosition instanceof HighlighterProvider && (range2 = ((HighlighterProvider)this.mySourcePosition).getHighlightRange()) != null && !range2.equals((Object)(lineRange = DocumentUtil.getLineTextRange(document, line)))) {
            this.myRangeHighlighter = markupModel.addRangeHighlighter(attributesKey, range2.getStartOffset(), range2.getEndOffset(), 5999, HighlighterTargetArea.EXACT_RANGE);
        }
        if (this.myRangeHighlighter == null) {
            this.myRangeHighlighter = markupModel.addLineHighlighter(attributesKey, line, 5999);
        }
        this.myRangeHighlighter.putUserData(EXECUTION_POINT_HIGHLIGHTER_TOP_FRAME_KEY, (Object)(!this.myNotTopFrame ? 1 : 0));
        this.myRangeHighlighter.setEditorFilter(editor -> editor.getEditorKind() == EditorKind.MAIN_EDITOR);
        this.myRangeHighlighter.setGutterIconRenderer(this.myGutterIconRenderer);
    }

    public boolean isFullLineHighlighter() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myRangeHighlighter != null && this.myRangeHighlighter.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE;
    }

    private static void disableMouseHoverPopups(@NotNull Editor editor, boolean disable) {
        if (editor == null) {
            ExecutionPointHighlighter.$$$reportNull$$$0(2);
        }
        Project project = editor.getProject();
        if (ApplicationManager.getApplication().isUnitTestMode() || project == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            if (disable) {
                EditorMouseHoverPopupControl.disablePopups(project);
            } else {
                EditorMouseHoverPopupControl.enablePopups(project);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/ui/ExecutionPointHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "disableMouseHoverPopups";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface HighlighterProvider {
        @Nullable
        public TextRange getHighlightRange();
    }
}

