/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialogFactory;
import com.intellij.xdebugger.impl.breakpoints.ui.XLightBreakpointPropertiesPanel;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.BreakpointEditor;
import com.intellij.xdebugger.impl.ui.TextViewer;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.XValueTextProvider;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseEvent;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public final class DebuggerUIUtil {
    @NonNls
    public static final String FULL_VALUE_POPUP_DIMENSION_KEY = "XDebugger.FullValuePopup";

    private DebuggerUIUtil() {
    }

    public static void enableEditorOnCheck(JCheckBox checkbox, JComponent textfield) {
        checkbox.addActionListener(e -> {
            boolean selected2 = checkbox.isSelected();
            textfield.setEnabled(selected2);
        });
        textfield.setEnabled(checkbox.isSelected());
    }

    public static void focusEditorOnCheck(JCheckBox checkbox, JComponent component2) {
        Runnable runnable2 = () -> IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)component2, true));
        checkbox.addActionListener(e -> {
            if (checkbox.isSelected()) {
                SwingUtilities.invokeLater(runnable2);
            }
        });
    }

    public static void invokeLater(Runnable runnable2) {
        ApplicationManager.getApplication().invokeLater(runnable2);
    }

    @Nullable
    public static RelativePoint getPositionForPopup(@NotNull Editor editor, int line) {
        if (editor == null) {
            DebuggerUIUtil.$$$reportNull$$$0(0);
        }
        if (line > -1) {
            Point p = editor.logicalPositionToXY(new LogicalPosition(line + 1, 0));
            if (editor.getScrollingModel().getVisibleArea().contains(p)) {
                return new RelativePoint((Component)editor.getContentComponent(), p);
            }
        }
        return null;
    }

    public static void showPopupForEditorLine(final @NotNull JBPopup popup2, final @NotNull Editor editor, int line) {
        RelativePoint point;
        if (popup2 == null) {
            DebuggerUIUtil.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            DebuggerUIUtil.$$$reportNull$$$0(2);
        }
        if ((point = DebuggerUIUtil.getPositionForPopup(editor, line)) != null) {
            popup2.addListener(new JBPopupListener(){

                public void beforeShown(@NotNull LightweightWindowEvent event) {
                    Window window;
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Window window2 = window = popup2.isDisposed() ? null : ComponentUtil.getWindow((Component)popup2.getContent());
                    if (window != null) {
                        Point expected = point.getScreenPoint();
                        Rectangle screen = ScreenUtil.getScreenRectangle((Point)expected);
                        int y = expected.y - window.getHeight() - editor.getLineHeight();
                        if (screen.y < y) {
                            window.setLocation(window.getX(), y);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$1", "beforeShown"));
                }
            });
            popup2.show(point);
        } else {
            Project project = editor.getProject();
            if (project != null) {
                popup2.showCenteredInCurrentWindow(project);
            } else {
                popup2.showInFocusCenter();
            }
        }
    }

    public static void showValuePopup(@NotNull XFullValueEvaluator evaluator, @NotNull MouseEvent event, @NotNull Project project, @Nullable Editor editor) {
        if (evaluator == null) {
            DebuggerUIUtil.$$$reportNull$$$0(3);
        }
        if (event == null) {
            DebuggerUIUtil.$$$reportNull$$$0(4);
        }
        if (project == null) {
            DebuggerUIUtil.$$$reportNull$$$0(5);
        }
        TextViewer textArea2 = new TextViewer(XDebuggerUIConstants.getEvaluatingExpressionMessage(), project);
        textArea2.setBackground(HintUtil.getInformationColor());
        textArea2.addSettingsProvider(e -> {
            e.getScrollPane().setBorder((Border)JBUI.Borders.empty());
            e.getScrollPane().setViewportBorder((Border)JBUI.Borders.empty());
        });
        FullValueEvaluationCallbackImpl callback2 = new FullValueEvaluationCallbackImpl(textArea2);
        evaluator.startEvaluation((XFullValueEvaluator.XFullValueEvaluationCallback)callback2);
        Dimension size = DimensionService.getInstance().getSize(FULL_VALUE_POPUP_DIMENSION_KEY, project);
        if (size == null) {
            Dimension frameSize = WindowManager.getInstance().getFrame(project).getSize();
            size = new Dimension(frameSize.width / 2, frameSize.height / 2);
        }
        textArea2.setPreferredSize(size);
        JBPopup popup2 = DebuggerUIUtil.createValuePopup(project, (JComponent)((Object)textArea2), callback2);
        if (editor == null) {
            Rectangle bounds2 = new Rectangle(event.getLocationOnScreen(), size);
            ScreenUtil.fitToScreenVertical((Rectangle)bounds2, (int)5, (int)5, (boolean)true);
            if (size.width != bounds2.width || size.height != bounds2.height) {
                size = bounds2.getSize();
                textArea2.setPreferredSize(size);
            }
            popup2.showInScreenCoordinates(event.getComponent(), bounds2.getLocation());
        } else {
            popup2.showInBestPositionFor(editor);
        }
    }

    public static JBPopup createValuePopup(Project project, JComponent component2, @Nullable FullValueEvaluationCallbackImpl callback2) {
        ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder(component2, null);
        builder2.setResizable(true).setMovable(true).setDimensionServiceKey(project, FULL_VALUE_POPUP_DIMENSION_KEY, false).setRequestFocus(true);
        if (callback2 != null) {
            builder2.setCancelCallback(() -> {
                callback2.setObsolete();
                return true;
            });
        }
        return builder2.createPopup();
    }

    public static void showXBreakpointEditorBalloon(Project project, @Nullable Point point, JComponent component2, boolean showAllOptions, final XBreakpoint breakpoint) {
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        final XLightBreakpointPropertiesPanel propertiesPanel = new XLightBreakpointPropertiesPanel(project, breakpointManager, (XBreakpointBase)breakpoint, showAllOptions);
        Ref balloonRef = Ref.create(null);
        Ref isLoading = Ref.create((Object)Boolean.FALSE);
        Ref moreOptionsRequested = Ref.create((Object)Boolean.FALSE);
        propertiesPanel.setDelegate(() -> {
            if (!((Boolean)isLoading.get()).booleanValue()) {
                propertiesPanel.saveProperties();
            }
            if (!balloonRef.isNull()) {
                ((Balloon)balloonRef.get()).hide();
            }
            propertiesPanel.dispose();
            DebuggerUIUtil.showXBreakpointEditorBalloon(project, point, component2, true, breakpoint);
            moreOptionsRequested.set((Object)true);
        });
        isLoading.set((Object)Boolean.TRUE);
        propertiesPanel.loadProperties();
        isLoading.set((Object)Boolean.FALSE);
        if (((Boolean)moreOptionsRequested.get()).booleanValue()) {
            return;
        }
        Runnable showMoreOptions = () -> {
            propertiesPanel.saveProperties();
            propertiesPanel.dispose();
            BreakpointsDialogFactory.getInstance(project).showDialog(breakpoint);
        };
        JPanel mainPanel = propertiesPanel.getMainPanel();
        final Balloon balloon2 = DebuggerUIUtil.showBreakpointEditor(project, mainPanel, point, component2, showMoreOptions, breakpoint);
        balloonRef.set((Object)balloon2);
        final Disposable disposable2 = Disposer.newDisposable();
        balloon2.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                Disposer.dispose((Disposable)disposable2);
                propertiesPanel.saveProperties();
                propertiesPanel.dispose();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$2", "onClosed"));
            }
        });
        project.getMessageBus().connect(disposable2).subscribe(XBreakpointListener.TOPIC, (Object)new XBreakpointListener<XBreakpoint<?>>(){

            public void breakpointRemoved(@NotNull XBreakpoint<?> removedBreakpoint) {
                if (removedBreakpoint == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (removedBreakpoint.equals((Object)breakpoint)) {
                    balloon2.hide();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removedBreakpoint", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$3", "breakpointRemoved"));
            }
        });
        ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.findInstance().requestFocus((Component)mainPanel, true));
    }

    public static Balloon showBreakpointEditor(Project project, JComponent mainPanel, Point whereToShow, JComponent component2, final @Nullable Runnable showMoreOptions, Object breakpoint) {
        BreakpointEditor editor = new BreakpointEditor();
        editor.setPropertiesPanel(mainPanel);
        editor.setShowMoreOptionsLink(true);
        JPanel panel2 = editor.getMainPanel();
        BalloonBuilder builder2 = JBPopupFactory.getInstance().createDialogBalloonBuilder((JComponent)panel2, null).setHideOnClickOutside(true).setCloseButtonEnabled(false).setAnimationCycle(0).setBlockClicksThroughBalloon(true);
        Color borderColor = UIManager.getColor("DebuggerPopup.borderColor");
        if (borderColor != null) {
            builder2.setBorderColor(borderColor);
        }
        final Balloon balloon2 = builder2.createBalloon();
        editor.setDelegate(new BreakpointEditor.Delegate(){

            @Override
            public void done() {
                balloon2.hide();
            }

            @Override
            public void more() {
                assert (showMoreOptions != null);
                balloon2.hide();
                showMoreOptions.run();
            }
        });
        ComponentAdapter moveListener2 = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                balloon2.hide();
            }
        };
        component2.addComponentListener(moveListener2);
        Disposer.register((Disposable)balloon2, () -> component2.removeComponentListener(moveListener2));
        HierarchyBoundsAdapter hierarchyBoundsListener = new HierarchyBoundsAdapter(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                balloon2.hide();
            }
        };
        component2.addHierarchyBoundsListener(hierarchyBoundsListener);
        Disposer.register((Disposable)balloon2, () -> component2.removeHierarchyBoundsListener(hierarchyBoundsListener));
        if (whereToShow == null) {
            balloon2.showInCenterOf(component2);
        } else {
            Window window = SwingUtilities.windowForComponent(component2);
            RelativePoint p = new RelativePoint((Component)component2, whereToShow);
            if (window != null) {
                RelativePoint point = new RelativePoint((Component)window, new Point(0, 0));
                if (p.getScreenPoint().getX() - point.getScreenPoint().getX() < 40.0) {
                    p.getPoint().x += 40;
                }
            }
            balloon2.show(p, Balloon.Position.below);
        }
        BreakpointsDialogFactory.getInstance(project).setBalloonToHide(balloon2, breakpoint);
        return balloon2;
    }

    @NotNull
    public static EditorColorsScheme getColorScheme() {
        EditorColorsScheme editorColorsScheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
        if (editorColorsScheme == null) {
            DebuggerUIUtil.$$$reportNull$$$0(6);
        }
        return editorColorsScheme;
    }

    @NotNull
    public static EditorColorsScheme getColorScheme(@Nullable JComponent component2) {
        EditorColorsScheme editorColorsScheme = EditorColorsUtil.getColorSchemeForComponent((JComponent)component2);
        if (editorColorsScheme == null) {
            DebuggerUIUtil.$$$reportNull$$$0(7);
        }
        return editorColorsScheme;
    }

    @Nullable
    public static String getNodeRawValue(@NotNull XValueNodeImpl valueNode) {
        if (valueNode == null) {
            DebuggerUIUtil.$$$reportNull$$$0(8);
        }
        String res2 = null;
        if (valueNode.getValueContainer() instanceof XValueTextProvider) {
            res2 = ((XValueTextProvider)valueNode.getValueContainer()).getValueText();
        }
        if (res2 == null) {
            res2 = valueNode.getRawValue();
        }
        return res2;
    }

    public static boolean hasEvaluationExpression(@NotNull XValueNodeImpl value2) {
        if (value2 == null) {
            DebuggerUIUtil.$$$reportNull$$$0(9);
        }
        Promise<XExpression> promise = value2.calculateEvaluationExpression();
        try {
            return promise.getState() == Promise.State.PENDING || promise.blockingGet(0) != null;
        }
        catch (ExecutionException | TimeoutException e) {
            return true;
        }
    }

    @Deprecated
    public static boolean hasEvaluationExpression(@NotNull XValue value2) {
        if (value2 == null) {
            DebuggerUIUtil.$$$reportNull$$$0(10);
        }
        Promise promise = value2.calculateEvaluationExpression();
        try {
            return promise.getState() == Promise.State.PENDING || promise.blockingGet(0) != null;
        }
        catch (ExecutionException | TimeoutException e) {
            return true;
        }
    }

    public static void addToWatches(@NotNull XWatchesView watchesView, @NotNull XValueNodeImpl node) {
        if (watchesView == null) {
            DebuggerUIUtil.$$$reportNull$$$0(11);
        }
        if (node == null) {
            DebuggerUIUtil.$$$reportNull$$$0(12);
        }
        node.calculateEvaluationExpression().onSuccess(expression -> {
            if (expression != null) {
                DebuggerUIUtil.invokeLater(() -> watchesView.addWatchExpression((XExpression)expression, -1, false));
            }
        });
    }

    public static void registerActionOnComponent(String name, JComponent component2, Disposable parentDisposable) {
        AnAction action2 = ActionManager.getInstance().getAction(name);
        action2.registerCustomShortcutSet(action2.getShortcutSet(), component2, parentDisposable);
    }

    public static void registerExtraHandleShortcuts(final ListPopupImpl popup2, final Ref<Boolean> showAd, String ... actionNames) {
        for (String name : actionNames) {
            KeyStroke stroke = KeymapUtil.getKeyStroke((ShortcutSet)ActionManager.getInstance().getAction(name).getShortcutSet());
            if (stroke == null) continue;
            popup2.registerAction("handleSelection " + stroke, stroke, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    showAd.set((Object)false);
                    popup2.handleSelect(true);
                }
            });
        }
        if (((Boolean)showAd.get()).booleanValue()) {
            popup2.setAdText(DebuggerUIUtil.getSelectionShortcutsAdText(actionNames));
        }
    }

    @NotNull
    @NlsContexts.PopupAdvertisement
    public static String getSelectionShortcutsAdText(String ... actionNames) {
        String text2 = (String)StreamEx.of((Object[])actionNames).map(DebuggerUIUtil::getActionShortcutText).nonNull().collect(NlsMessages.joiningOr());
        String string = StringUtil.isEmpty((String)text2) ? "" : XDebuggerBundle.message((String)"ad.extra.selection.shortcut", (Object[])new Object[]{text2});
        if (string == null) {
            DebuggerUIUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public static String getActionShortcutText(String actionName) {
        KeyStroke stroke = KeymapUtil.getKeyStroke((ShortcutSet)ActionManager.getInstance().getAction(actionName).getShortcutSet());
        if (stroke != null) {
            return KeymapUtil.getKeystrokeText((KeyStroke)stroke);
        }
        return null;
    }

    public static boolean isObsolete(Object object) {
        return object instanceof Obsolescent && ((Obsolescent)object).isObsolete();
    }

    public static void setTreeNodeValue(XValueNodeImpl valueNode, XExpression text2, final Consumer<? super String> errorConsumer) {
        final XDebuggerTree tree = valueNode.getTree();
        final Project project = tree.getProject();
        XValueModifier modifier = ((XValue)valueNode.getValueContainer()).getModifier();
        if (modifier == null) {
            return;
        }
        final XDebuggerTreeState treeState = XDebuggerTreeState.saveState(tree);
        valueNode.setValueModificationStarted();
        modifier.setValue(text2, new XValueModifier.XModificationCallback(){

            public void valueModified() {
                AppUIUtil.invokeOnEdt(() -> {
                    if (tree.isDetached()) {
                        tree.rebuildAndRestore(treeState);
                    }
                });
                XDebuggerUtilImpl.rebuildAllSessionsViews(project);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    8.$$$reportNull$$$0(0);
                }
                AppUIUtil.invokeOnEdt(() -> {
                    tree.rebuildAndRestore(treeState);
                    errorConsumer.consume((Object)errorMessage);
                });
                XDebuggerUtilImpl.rebuildAllSessionsViews(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$8", "errorOccurred"));
            }
        });
    }

    public static boolean isInDetachedTree(AnActionEvent event) {
        return event.getData(XDebugSessionTab.TAB_KEY) == null;
    }

    public static XDebugSessionData getSessionData(AnActionEvent e) {
        XDebugSession session2;
        Project project;
        XDebugSessionData data2 = (XDebugSessionData)((Object)e.getData(XDebugSessionData.DATA_KEY));
        if (data2 == null && (project = e.getProject()) != null && (session2 = XDebuggerManager.getInstance((Project)project).getCurrentSession()) != null) {
            data2 = ((XDebugSessionImpl)session2).getSessionData();
        }
        return data2;
    }

    public static void repaintCurrentEditor(Project project) {
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null) {
            editor.getContentComponent().revalidate();
            editor.getContentComponent().repaint();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/DebuggerUIUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueNode";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchesView";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/DebuggerUIUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorScheme";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionShortcutsAdText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPositionForPopup";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showPopupForEditorLine";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showValuePopup";
                break;
            }
            case 6: 
            case 7: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNodeRawValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasEvaluationExpression";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addToWatches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FullValueEvaluationCallbackImpl
    implements XFullValueEvaluator.XFullValueEvaluationCallback {
        private final AtomicBoolean myObsolete = new AtomicBoolean(false);
        private final EditorTextField myTextArea;

        FullValueEvaluationCallbackImpl(EditorTextField textArea2) {
            this.myTextArea = textArea2;
        }

        public void evaluated(@NotNull String fullValue) {
            if (fullValue == null) {
                FullValueEvaluationCallbackImpl.$$$reportNull$$$0(0);
            }
            this.evaluated(fullValue, null);
        }

        public void evaluated(@NotNull String fullValue, @Nullable Font font) {
            if (fullValue == null) {
                FullValueEvaluationCallbackImpl.$$$reportNull$$$0(1);
            }
            AppUIUtil.invokeOnEdt(() -> {
                this.myTextArea.setText(fullValue);
                if (font != null) {
                    this.myTextArea.setFont(font);
                }
            });
        }

        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                FullValueEvaluationCallbackImpl.$$$reportNull$$$0(2);
            }
            AppUIUtil.invokeOnEdt(() -> {
                this.myTextArea.setForeground(XDebuggerUIConstants.ERROR_MESSAGE_ATTRIBUTES.getFgColor());
                this.myTextArea.setText(errorMessage);
            });
        }

        private void setObsolete() {
            this.myObsolete.set(true);
        }

        public boolean isObsolete() {
            return this.myObsolete.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$FullValueEvaluationCallbackImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

