/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.ui.WinFocusStealer;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class DebuggerFocusManager
implements XDebuggerManagerListener,
RegistryValueListener,
ProjectManagerListener {
    private final RegistryValue mySetting = Registry.get((String)"debugger.mayBringFrameToFrontOnBreakpoint");
    private boolean myFocusStealingEnabled;

    private DebuggerFocusManager() {
        this.mySetting.addListener((RegistryValueListener)this, (Disposable)ApplicationManager.getApplication());
    }

    public void processStarted(@NotNull XDebugProcess debugProcess) {
        if (debugProcess == null) {
            DebuggerFocusManager.$$$reportNull$$$0(0);
        }
        this.update(true);
    }

    public void processStopped(@NotNull XDebugProcess debugProcess) {
        if (debugProcess == null) {
            DebuggerFocusManager.$$$reportNull$$$0(1);
        }
        this.update(DebuggerFocusManager.getDebugSessionsCount() > 1L);
    }

    public void afterValueChanged(@NotNull RegistryValue value2) {
        if (value2 == null) {
            DebuggerFocusManager.$$$reportNull$$$0(2);
        }
        this.update(DebuggerFocusManager.getDebugSessionsCount() > 0L);
    }

    public void projectOpened(@NotNull Project project) {
        if (project == null) {
            DebuggerFocusManager.$$$reportNull$$$0(3);
        }
        project.getMessageBus().connect().subscribe(XDebuggerManager.TOPIC, (Object)this);
    }

    public void projectClosed(@NotNull Project project) {
        if (project == null) {
            DebuggerFocusManager.$$$reportNull$$$0(4);
        }
        this.update(DebuggerFocusManager.getDebugSessionsCount() > 0L);
    }

    private static long getDebugSessionsCount() {
        return Arrays.stream(ProjectManager.getInstance().getOpenProjects()).filter(p -> !p.isDisposed()).mapToInt(p -> XDebuggerManager.getInstance((Project)p).getDebugSessions().length).sum();
    }

    private synchronized void update(boolean enable2) {
        boolean shouldBeEnabled;
        boolean bl = shouldBeEnabled = enable2 && this.mySetting.asBoolean();
        if (shouldBeEnabled != this.myFocusStealingEnabled) {
            this.myFocusStealingEnabled = shouldBeEnabled;
            WinFocusStealer.setFocusStealingEnabled(this.myFocusStealingEnabled);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/ui/DebuggerFocusManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processStarted";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processStopped";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "afterValueChanged";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "projectOpened";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "projectClosed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

