/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.CompositeDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XDebuggerWatchesManager;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.inline.InlineWatch;
import com.intellij.xdebugger.impl.inline.InlineWatchNode;
import com.intellij.xdebugger.impl.inline.InlineWatchesRootNode;
import com.intellij.xdebugger.impl.inline.XInlineWatchesView;
import com.intellij.xdebugger.impl.ui.DebuggerSessionTabBase;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.XDebuggerEmbeddedComboBox;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.actions.XWatchTransferable;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XWatchesViewImpl
extends XVariablesView
implements DnDNativeTarget,
XWatchesView,
XInlineWatchesView {
    protected WatchesRootNode myRootNode;
    private XDebuggerExpressionComboBox myEvaluateComboBox;
    private final CompositeDisposable myDisposables;
    private final boolean myWatchesInVariables;
    private final boolean inlineWatchesEnabled;

    public XWatchesViewImpl(@NotNull XDebugSessionImpl session2, boolean watchesInVariables) {
        if (session2 == null) {
            XWatchesViewImpl.$$$reportNull$$$0(0);
        }
        this(session2, watchesInVariables, watchesInVariables);
    }

    protected XWatchesViewImpl(@NotNull XDebugSessionImpl session2, boolean watchesInVariables, boolean vertical) {
        if (session2 == null) {
            XWatchesViewImpl.$$$reportNull$$$0(1);
        }
        this(session2, watchesInVariables, vertical, true);
    }

    public XWatchesViewImpl(@NotNull XDebugSessionImpl session2, boolean watchesInVariables, boolean vertical, boolean withToolbar) {
        if (session2 == null) {
            XWatchesViewImpl.$$$reportNull$$$0(2);
        }
        super(session2);
        this.myDisposables = new CompositeDisposable();
        this.myWatchesInVariables = watchesInVariables;
        this.inlineWatchesEnabled = Registry.is((String)"debugger.watches.inline.enabled");
        XDebuggerTree tree = this.getTree();
        this.createNewRootNode(null);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.NewWatch", (JComponent)((Object)tree), (Disposable)this.myDisposables);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.RemoveWatch", (JComponent)((Object)tree), (Disposable)this.myDisposables);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.CopyWatch", (JComponent)((Object)tree), (Disposable)this.myDisposables);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.EditWatch", (JComponent)((Object)tree), (Disposable)this.myDisposables);
        EmptyAction.registerWithShortcutSet((String)"XDebugger.NewWatch", (ShortcutSet)CommonShortcuts.getNew(), (JComponent)((Object)tree));
        EmptyAction.registerWithShortcutSet((String)"XDebugger.RemoveWatch", (ShortcutSet)CommonShortcuts.getDelete(), (JComponent)((Object)tree));
        DnDManager.getInstance().registerTarget((DnDTarget)this, (JComponent)((Object)tree));
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Object contents;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((contents = CopyPasteManager.getInstance().getContents(XWatchTransferable.EXPRESSIONS_FLAVOR)) instanceof List) {
                    for (Object item : (List)contents) {
                        if (!(item instanceof XExpression)) continue;
                        XWatchesViewImpl.this.addWatchExpression((XExpression)item, -1, true);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$1", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.getPaste(), (JComponent)((Object)tree), (Disposable)this.myDisposables);
        if (withToolbar) {
            ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("DebuggerToolbar", DebuggerSessionTabBase.getCustomizedActionGroup("XDebugger.Watches.Tree.Toolbar"), !vertical);
            toolbar.setBorder((Border)new CustomLineBorder(CaptionPanel.CNT_ACTIVE_BORDER_COLOR, 0, 0, vertical ? 0 : 1, vertical ? 1 : 0));
            toolbar.setTargetComponent((JComponent)((Object)tree));
            this.getPanel().add((Component)toolbar.getComponent(), vertical ? "West" : "North");
        }
        if (!this.myWatchesInVariables) {
            this.getTree().getEmptyText().setText(XDebuggerBundle.message((String)"debugger.no.watches", (Object[])new Object[0]));
        }
        this.installEditListeners();
    }

    @Override
    JComponent createTopPanel() {
        if (Registry.is((String)"debugger.new.tool.window.layout")) {
            XDebuggerTree tree = this.getTree();
            this.myEvaluateComboBox = new XDebuggerExpressionComboBox(tree.getProject(), tree.getEditorsProvider(), "evaluateInVariables", null, false, true){

                @Override
                protected ComboBox<XExpression> createComboBox(CollectionComboBoxModel<XExpression> model2, int width) {
                    return new XDebuggerEmbeddedComboBox<XExpression>((ComboBoxModel<XExpression>)model2, width);
                }

                @Override
                protected void prepareEditor(EditorEx editor) {
                    super.prepareEditor(editor);
                    editor.setPlaceholder(XDebuggerBundle.message((String)"debugger.evaluate.expression.or.add.a.watch.hint", (Object[])new Object[0]));
                }
            };
            JComponent editorComponent = this.myEvaluateComboBox.getEditorComponent();
            editorComponent.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "enterStroke");
            editorComponent.getActionMap().put("enterStroke", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XWatchesViewImpl.this.myEvaluateComboBox.saveTextInHistory();
                    XDebugSession session2 = XDebugView.getSession((Component)((Object)XWatchesViewImpl.this.getTree()));
                    XWatchesViewImpl.this.myRootNode.addResultNode(session2 != null ? session2.getCurrentStackFrame() : null, XWatchesViewImpl.this.myEvaluateComboBox.getExpression());
                }
            });
            JComponent component2 = this.myEvaluateComboBox.getComponent();
            component2.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
            return component2;
        }
        return null;
    }

    @Override
    protected void buildTreeAndRestoreState(@NotNull XStackFrame stackFrame) {
        if (stackFrame == null) {
            XWatchesViewImpl.$$$reportNull$$$0(3);
        }
        super.buildTreeAndRestoreState(stackFrame);
        if (this.myEvaluateComboBox != null) {
            this.myEvaluateComboBox.setSourcePosition(stackFrame.getSourcePosition());
        }
    }

    private void installEditListeners() {
        final XDebuggerTree watchTree = this.getTree();
        final Alarm quitePeriod = new Alarm();
        final Alarm editAlarm = new Alarm();
        final ClickListener mouseListener = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!SwingUtilities.isLeftMouseButton(event) || (event.getModifiers() & 0xF) != 0) {
                    return false;
                }
                boolean sameRow = XWatchesViewImpl.isAboveSelectedItem(event, watchTree, false);
                if (!sameRow || clickCount > 1) {
                    editAlarm.cancelAllRequests();
                    return false;
                }
                AnAction editWatchAction = ActionManager.getInstance().getAction("XDebugger.EditWatch");
                Presentation presentation2 = editWatchAction.getTemplatePresentation().clone();
                DataContext context2 = DataManager.getInstance().getDataContext((Component)((Object)watchTree));
                AnActionEvent actionEvent = new AnActionEvent(null, context2, "WATCH_TREE", presentation2, ActionManager.getInstance(), 0);
                Runnable runnable2 = () -> editWatchAction.actionPerformed(actionEvent);
                if (editAlarm.isEmpty() && quitePeriod.isEmpty()) {
                    editAlarm.addRequest(runnable2, UIUtil.getMultiClickInterval());
                } else {
                    editAlarm.cancelAllRequests();
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$4", "onClick"));
            }
        };
        DoubleClickListener mouseEmptySpaceListener = new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (!XWatchesViewImpl.isAboveSelectedItem(event, watchTree, true)) {
                    XWatchesViewImpl.this.myRootNode.addNewWatch();
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$5", "onDoubleClick"));
            }
        };
        ListenerUtil.addClickListener((Component)((Object)watchTree), mouseListener);
        ListenerUtil.addClickListener((Component)((Object)watchTree), (ClickListener)mouseEmptySpaceListener);
        FocusListener focusListener2 = new FocusListener(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                quitePeriod.addRequest(EmptyRunnable.getInstance(), UIUtil.getMultiClickInterval());
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                editAlarm.cancelAllRequests();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusGained";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusLost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ListenerUtil.addFocusListener((Component)((Object)watchTree), focusListener2);
        TreeSelectionListener selectionListener2 = new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                quitePeriod.addRequest(EmptyRunnable.getInstance(), UIUtil.getMultiClickInterval());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$7", "valueChanged"));
            }
        };
        watchTree.addTreeSelectionListener(selectionListener2);
        this.myDisposables.add(new Disposable((ClickListener)mouseEmptySpaceListener, focusListener2, selectionListener2){
            final /* synthetic */ ClickListener val$mouseEmptySpaceListener;
            final /* synthetic */ FocusListener val$focusListener;
            final /* synthetic */ TreeSelectionListener val$selectionListener;
            {
                this.val$mouseEmptySpaceListener = clickListener2;
                this.val$focusListener = focusListener2;
                this.val$selectionListener = treeSelectionListener;
            }

            public void dispose() {
                ListenerUtil.removeClickListener((Component)((Object)watchTree), mouseListener);
                ListenerUtil.removeClickListener((Component)((Object)watchTree), this.val$mouseEmptySpaceListener);
                ListenerUtil.removeFocusListener((Component)((Object)watchTree), this.val$focusListener);
                watchTree.removeTreeSelectionListener(this.val$selectionListener);
            }
        });
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposables);
        DnDManager.getInstance().unregisterTarget((DnDTarget)this, (JComponent)((Object)this.getTree()));
        super.dispose();
    }

    private static boolean isAboveSelectedItem(MouseEvent event, XDebuggerTree watchTree, boolean fullWidth) {
        Rectangle bounds2 = watchTree.getRowBounds(watchTree.getLeadSelectionRow());
        if (bounds2 != null) {
            if (fullWidth) {
                bounds2.x = 0;
            }
            bounds2.width = watchTree.getWidth();
            if (bounds2.contains(event.getPoint())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void addWatchExpression(@NotNull XExpression expression, int index2, boolean navigateToWatchNode) {
        if (expression == null) {
            XWatchesViewImpl.$$$reportNull$$$0(4);
        }
        this.addWatchExpression(expression, index2, navigateToWatchNode, false);
    }

    public void addWatchExpression(@NotNull XExpression expression, int index2, boolean navigateToWatchNode, boolean noDuplicates) {
        if (expression == null) {
            XWatchesViewImpl.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        XDebugSession session2 = XWatchesViewImpl.getSession((Component)((Object)this.getTree()));
        boolean found = false;
        if (noDuplicates) {
            for (WatchNode watchNode : this.myRootNode.getWatchChildren()) {
                if (!watchNode.getExpression().equals(expression)) continue;
                TreeUtil.selectNode((JTree)((Object)this.getTree()), (TreeNode)watchNode);
                found = true;
            }
        }
        if (!found) {
            this.myRootNode.addWatchExpression(session2 != null ? session2.getCurrentStackFrame() : null, expression, index2, navigateToWatchNode);
            this.updateSessionData();
        }
        if (navigateToWatchNode && session2 != null) {
            XDebugSessionTab.showWatchesView((XDebugSessionImpl)session2);
        }
    }

    public void computeWatches() {
        this.myRootNode.computeWatches();
    }

    @Override
    protected XValueContainerNode doCreateNewRootNode(@Nullable XStackFrame stackFrame) {
        this.myRootNode = this.inlineWatchesEnabled ? new InlineWatchesRootNode(this.getTree(), this, this.getExpressions(), this.getInlineExpressions(), stackFrame, this.myWatchesInVariables) : new WatchesRootNode(this.getTree(), this, this.getExpressions(), stackFrame, this.myWatchesInVariables);
        return this.myRootNode;
    }

    @NotNull
    private List<InlineWatch> getInlineExpressions() {
        List<InlineWatch> list2 = this.getWatchesManager().getInlineWatches();
        if (list2 == null) {
            XWatchesViewImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private XDebuggerWatchesManager getWatchesManager() {
        return ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)this.getTree().getProject())).getWatchesManager();
    }

    @Override
    public void addInlineWatchExpression(@NotNull InlineWatch watch, int index2, boolean navigateToWatchNode) {
        if (watch == null) {
            XWatchesViewImpl.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        XDebugSession session2 = XWatchesViewImpl.getSession((Component)((Object)this.getTree()));
        ((InlineWatchesRootNode)this.myRootNode).addInlineWatchExpression(session2 != null ? session2.getCurrentStackFrame() : null, watch, index2, navigateToWatchNode);
        if (navigateToWatchNode && session2 != null) {
            XDebugSessionTab.showWatchesView((XDebugSessionImpl)session2);
        }
    }

    @Override
    public void removeInlineWatches(Collection<InlineWatch> watches) {
        InlineWatchesRootNode rootNode = (InlineWatchesRootNode)this.myRootNode;
        List nodesToRemove = ContainerUtil.filter(rootNode.getInlineWatchChildren(), node -> watches.contains(node.getWatch()));
        if (!nodesToRemove.isEmpty()) {
            this.removeInlineNodes(nodesToRemove, false);
        }
    }

    private void removeInlineNodes(List<? extends XDebuggerTreeNode> inlineWatches, boolean updateManager) {
        InlineWatchesRootNode rootNode = (InlineWatchesRootNode)this.myRootNode;
        List<? extends InlineWatchNode> inlineWatchChildren = rootNode.getInlineWatchChildren();
        int[] minIndex = new int[]{Integer.MAX_VALUE};
        ArrayList<InlineWatchNode> toRemoveInlines = new ArrayList<InlineWatchNode>();
        inlineWatches.forEach(node -> {
            int index2 = inlineWatchChildren.indexOf(node);
            if (index2 != -1) {
                toRemoveInlines.add((InlineWatchNode)((Object)node));
                minIndex[0] = Math.min(minIndex[0], index2);
            }
        });
        rootNode.removeInlineChildren(toRemoveInlines);
        List<? extends InlineWatchNode> newChildren = rootNode.getInlineWatchChildren();
        if (!newChildren.isEmpty()) {
            InlineWatchNode node2 = newChildren.get(Math.min(minIndex[0], newChildren.size() - 1));
            TreeUtil.selectNode((JTree)((Object)this.getTree()), (TreeNode)node2);
        }
        if (updateManager) {
            this.getWatchesManager().inlineWatchesRemoved(ContainerUtil.map(toRemoveInlines, node -> node.getWatch()), this);
        }
    }

    @Override
    protected void addEmptyMessage(XValueContainerNode root) {
        if (this.myWatchesInVariables) {
            super.addEmptyMessage(root);
        }
    }

    @NotNull
    protected List<XExpression> getExpressions() {
        SmartList expressions;
        XDebuggerTree tree = this.getTree();
        XDebugSession session2 = XWatchesViewImpl.getSession((Component)((Object)tree));
        if (session2 != null) {
            expressions = ((XDebugSessionImpl)session2).getSessionData().getWatchExpressions();
        } else {
            XDebuggerTreeNode root = tree.getRoot();
            List<WatchNode> current2 = root instanceof WatchesRootNode ? ((WatchesRootNode)tree.getRoot()).getWatchChildren() : Collections.emptyList();
            SmartList list2 = new SmartList();
            for (WatchNode child2 : current2) {
                list2.add(child2.getExpression());
            }
            expressions = list2;
        }
        SmartList smartList = expressions;
        if (smartList == null) {
            XWatchesViewImpl.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            XWatchesViewImpl.$$$reportNull$$$0(9);
        }
        if (XWatchesView.DATA_KEY.is(dataId)) {
            return this;
        }
        return super.getData(dataId);
    }

    @Override
    public void removeWatches(List<? extends XDebuggerTreeNode> nodes) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        List ordinaryWatches = ContainerUtil.filter(nodes, node -> !(node instanceof InlineWatchNode));
        List inlineWatches = ContainerUtil.filter(nodes, node -> node instanceof InlineWatchNode);
        if (!inlineWatches.isEmpty()) {
            this.removeInlineNodes(inlineWatches, true);
        }
        if (ordinaryWatches.isEmpty()) {
            return;
        }
        List<? extends WatchNode> children2 = this.myRootNode.getWatchChildren();
        int minIndex = Integer.MAX_VALUE;
        ArrayList<XDebuggerTreeNode> toRemove2 = new ArrayList<XDebuggerTreeNode>();
        for (TreeNode node2 : ordinaryWatches) {
            int index2 = children2.indexOf(node2);
            if (index2 == -1) continue;
            toRemove2.add((XDebuggerTreeNode)node2);
            minIndex = Math.min(minIndex, index2);
        }
        this.myRootNode.removeChildren(toRemove2);
        List<? extends WatchNode> newChildren = this.myRootNode.getWatchChildren();
        if (!newChildren.isEmpty()) {
            TreeNode node2;
            node2 = newChildren.get(Math.min(minIndex, newChildren.size() - 1));
            TreeUtil.selectNode((JTree)((Object)this.getTree()), (TreeNode)node2);
        }
        this.updateSessionData();
    }

    @Override
    public void removeAllWatches() {
        List<? extends InlineWatchNode> children2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.inlineWatchesEnabled && !(children2 = ((InlineWatchesRootNode)this.myRootNode).getInlineWatchChildren()).isEmpty()) {
            this.removeInlineNodes(children2, true);
        }
        this.myRootNode.removeAllChildren();
        this.updateSessionData();
    }

    public void moveWatchUp(WatchNode node) {
        this.myRootNode.moveUp(node);
        this.updateSessionData();
    }

    public void moveWatchDown(WatchNode node) {
        this.myRootNode.moveDown(node);
        this.updateSessionData();
    }

    public void updateSessionData() {
        SmartList expressions = new SmartList();
        List<? extends WatchNode> children2 = this.myRootNode.getWatchChildren();
        for (WatchNode watchNode : children2) {
            expressions.add(watchNode.getExpression());
        }
        XDebugSession session2 = XWatchesViewImpl.getSession((Component)((Object)this.getTree()));
        if (session2 != null) {
            ((XDebugSessionImpl)session2).setWatchExpressions((List<XExpression>)expressions);
        } else {
            XDebugSessionData xDebugSessionData = XWatchesViewImpl.getData(XDebugSessionData.DATA_KEY, (Component)((Object)this.getTree()));
            if (xDebugSessionData != null) {
                xDebugSessionData.setWatchExpressions((List<XExpression>)expressions);
            }
        }
    }

    public boolean update(DnDEvent aEvent) {
        Object object = aEvent.getAttachedObject();
        boolean possible = false;
        if (object instanceof XValueNodeImpl[]) {
            possible = true;
            if (((XValueNodeImpl[])object).length == 1) {
                Point point = aEvent.getPoint();
                XDebuggerTree tree = this.getTree();
                TreePath path2 = tree.getClosestPathForLocation(point.x, point.y);
                if (path2 != null && path2.getLastPathComponent() == ((XValueNodeImpl[])object)[0]) {
                    Rectangle pathBounds = tree.getPathBounds(path2);
                    possible = pathBounds != null && pathBounds.y + pathBounds.height < point.y;
                }
            }
        } else if (object instanceof DnDNativeTarget.EventInfo) {
            possible = ((DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor) != null;
        }
        aEvent.setDropPossible(possible, XDebuggerBundle.message((String)"xdebugger.drop.text.add.to.watches", (Object[])new Object[0]));
        return true;
    }

    public void drop(DnDEvent aEvent) {
        String text2;
        Object object = aEvent.getAttachedObject();
        if (object instanceof XValueNodeImpl[]) {
            for (XValueNodeImpl node : (XValueNodeImpl[])object) {
                DebuggerUIUtil.addToWatches(this, node);
            }
        } else if (object instanceof DnDNativeTarget.EventInfo && (text2 = ((DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor)) != null) {
            this.addWatchExpression(XExpressionImpl.fromText(text2), -1, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrame";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/frame/XWatchesViewImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watch";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/frame/XWatchesViewImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineExpressions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildTreeAndRestoreState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addWatchExpression";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addInlineWatchExpression";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

