/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XVariablesViewBase;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XVariablesView
extends XVariablesViewBase
implements DataProvider {
    protected BorderLayoutPanel myComponent;
    private final WeakReference<XDebugSessionImpl> mySession;

    public XVariablesView(@NotNull XDebugSessionImpl session2) {
        if (session2 == null) {
            XVariablesView.$$$reportNull$$$0(0);
        }
        super(session2.getProject(), session2.getDebugProcess().getEditorsProvider(), session2.getValueMarkers());
        this.mySession = new WeakReference<XDebugSessionImpl>(session2);
        this.myComponent = new BorderLayoutPanel();
        JComponent panel2 = super.getPanel();
        JComponent top = this.createTopPanel();
        if (top != null) {
            panel2 = new BorderLayoutPanel().addToTop((Component)top).addToCenter((Component)panel2);
        }
        this.myComponent.add((Component)panel2);
        DataManager.registerDataProvider((JComponent)this.myComponent, (DataProvider)this);
    }

    @Override
    public JPanel getPanel() {
        return this.myComponent;
    }

    JComponent createTopPanel() {
        return null;
    }

    @Override
    public void processSessionEvent(@NotNull XDebugView.SessionEvent event, @NotNull XDebugSession session2) {
        if (event == null) {
            XVariablesView.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            XVariablesView.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.getTree().markNodesObsolete();
        }
        if (event == XDebugView.SessionEvent.BEFORE_RESUME) {
            return;
        }
        XStackFrame stackFrame = session2.getCurrentStackFrame();
        ApplicationManager.getApplication().invokeLater(() -> {
            this.getTree().markNodesObsolete();
            if (stackFrame != null) {
                this.cancelClear();
                this.buildTreeAndRestoreState(stackFrame);
            } else {
                this.requestClear();
            }
        }, session2.getProject().getDisposed());
    }

    @Override
    public void dispose() {
        XVariablesView.clearInlineData(this.getTree());
        super.dispose();
    }

    private static void clearInlineData(XDebuggerTree tree) {
        InlineVariablesInfo.set(XVariablesView.getSession((Component)((Object)tree)), null);
        tree.updateEditor();
        XVariablesView.clearInlays(tree);
    }

    protected void addEmptyMessage(XValueContainerNode root) {
        XDebugSession session2 = XVariablesView.getSession(this.getPanel());
        if (session2 != null) {
            if (!session2.isStopped() && session2.isPaused()) {
                root.setInfoMessage(XDebuggerBundle.message((String)"message.frame.is.not.available", (Object[])new Object[0]), null);
            } else {
                XDebugProcess debugProcess = session2.getDebugProcess();
                root.setInfoMessage(debugProcess.getCurrentStateMessage(), debugProcess.getCurrentStateHyperlinkListener());
            }
        }
    }

    @Override
    protected void clear() {
        XDebuggerTree tree = this.getTree();
        tree.setSourcePosition(null);
        XVariablesView.clearInlineData(tree);
        XValueContainerNode root = this.createNewRootNode(null);
        this.addEmptyMessage(root);
        super.clear();
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        XSourcePosition position;
        XDebugSessionImpl session2;
        if (dataId == null) {
            XVariablesView.$$$reportNull$$$0(3);
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId) && (session2 = (XDebugSessionImpl)this.mySession.get()) != null && (position = session2.getCurrentPosition()) != null) {
            return position.getFile();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/frame/XVariablesView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processSessionEvent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class InlineVariablesInfo {
        private final Map<Pair<VirtualFile, Integer>, Set<Entry>> myData = new HashMap<Pair<VirtualFile, Integer>, Set<Entry>>();
        private final Object2LongMap<VirtualFile> myTimestamps = new Object2LongOpenHashMap();
        private static final Key<InlineVariablesInfo> DEBUG_VARIABLES = Key.create((String)"debug.variables");

        public InlineVariablesInfo() {
            this.myTimestamps.defaultReturnValue(-1L);
        }

        public static InlineVariablesInfo get(@Nullable XDebugSession session2) {
            if (session2 != null) {
                return (InlineVariablesInfo)DEBUG_VARIABLES.get((UserDataHolder)((XDebugSessionImpl)session2).getSessionData());
            }
            return null;
        }

        public static void set(@Nullable XDebugSession session2, InlineVariablesInfo info2) {
            if (session2 != null) {
                DEBUG_VARIABLES.set((UserDataHolder)((XDebugSessionImpl)session2).getSessionData(), (Object)info2);
            }
        }

        @Nullable
        public synchronized List<XValueNodeImpl> get(@NotNull VirtualFile file2, int line, long currentTimestamp) {
            long timestamp;
            if (file2 == null) {
                InlineVariablesInfo.$$$reportNull$$$0(0);
            }
            if ((timestamp = this.myTimestamps.getLong((Object)file2)) == -1L || timestamp < currentTimestamp) {
                return null;
            }
            Set<Entry> entries2 = this.myData.get(new Pair((Object)file2, (Object)line));
            if (entries2 == null) {
                return null;
            }
            return ContainerUtil.map(entries2, entry2 -> entry2.myNode);
        }

        public synchronized void put(@NotNull VirtualFile file2, @NotNull XSourcePosition position, @NotNull XValueNodeImpl node, long timestamp) {
            if (file2 == null) {
                InlineVariablesInfo.$$$reportNull$$$0(1);
            }
            if (position == null) {
                InlineVariablesInfo.$$$reportNull$$$0(2);
            }
            if (node == null) {
                InlineVariablesInfo.$$$reportNull$$$0(3);
            }
            this.myTimestamps.put((Object)file2, timestamp);
            Pair key = new Pair((Object)file2, (Object)position.getLine());
            this.myData.computeIfAbsent((Pair<VirtualFile, Integer>)key, k -> new TreeSet()).add(new Entry(position.getOffset(), node));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/frame/XVariablesView$InlineVariablesInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "put";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class Entry
        implements Comparable<Entry> {
            private final long myOffset;
            private final XValueNodeImpl myNode;

            /*
             * WARNING - void declaration
             */
            Entry(long offset, @NotNull XValueNodeImpl xValueNodeImpl) {
                void node;
                if (xValueNodeImpl == null) {
                    Entry.$$$reportNull$$$0(0);
                }
                this.myOffset = offset;
                this.myNode = node;
            }

            @Override
            public int compareTo(Entry o) {
                if (this.myNode == o.myNode) {
                    return 0;
                }
                int res2 = Comparing.compare((long)this.myOffset, (long)o.myOffset);
                if (res2 == 0) {
                    return XValueNodeImpl.COMPARATOR.compare(this.myNode, o.myNode);
                }
                return res2;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Entry entry2 = (Entry)o;
                return this.myNode.equals(entry2.myNode);
            }

            public int hashCode() {
                return this.myNode.hashCode();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/frame/XVariablesView$InlineVariablesInfo$Entry", "<init>"));
            }
        }
    }
}

