/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.project.ProjectRootManagerBridge;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ContentRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.CustomSourceRootPropertiesEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.JavaModuleSettingsEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.JavaResourceRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.JavaSourceRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryPropertiesEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleCustomImlDataEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleGroupPathEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.SourceRootEntity;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootsChangeListener;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "beforeChanged", "", "event", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "changed", "getRootsChangeType", "Lcom/intellij/openapi/roots/impl/ProjectRootManagerImpl$RootsChangeType;", "shouldFireRootsChanged", "", "events", "Companion", "intellij.platform.lang.impl"})
public final class ProjectRootsChangeListener {
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void beforeChanged(@NotNull VersionedStorageChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.project.isDisposed()) {
            return;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.project);
        if (!(projectRootManager instanceof ProjectRootManagerBridge)) {
            return;
        }
        boolean performUpdate = this.shouldFireRootsChanged(event, this.project);
        if (performUpdate && !((ProjectRootManagerBridge)projectRootManager).isFiringEvent()) {
            ((ProjectRootManagerBridge)projectRootManager).getRootsChanged().beforeRootsChanged();
        }
    }

    public final void changed(@NotNull VersionedStorageChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.project.isDisposed()) {
            return;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.project);
        if (!(projectRootManager instanceof ProjectRootManagerBridge)) {
            return;
        }
        boolean performUpdate = this.shouldFireRootsChanged(event, this.project);
        if (performUpdate && !((ProjectRootManagerBridge)projectRootManager).isFiringEvent()) {
            ProjectRootManagerImpl.RootsChangeType rootsChangeType = this.getRootsChangeType(event, this.project);
            ((ProjectRootManagerBridge)projectRootManager).getRootsChanged().rootsChanged(rootsChangeType);
        }
    }

    private final ProjectRootManagerImpl.RootsChangeType getRootsChangeType(VersionedStorageChange event, Project project) {
        ProjectRootManagerImpl.RootsChangeType rootsChangeType;
        ProjectRootManagerImpl.RootsChangeType result2 = null;
        for (EntityChange change : event.getAllChanges()) {
            ProjectRootManagerImpl.RootsChangeType currentRootsChangeType;
            ProjectRootManagerImpl.RootsChangeType rootsChangeType2;
            EntityChange entityChange = change;
            if (entityChange instanceof EntityChange.Added) {
                if (!Companion.shouldFireRootsChanged$intellij_platform_lang_impl((WorkspaceEntity)((EntityChange.Added)change).getEntity(), project)) continue;
                rootsChangeType2 = ProjectRootManagerImpl.RootsChangeType.ROOTS_ADDED;
            } else if (entityChange instanceof EntityChange.Removed) {
                if (!Companion.shouldFireRootsChanged$intellij_platform_lang_impl((WorkspaceEntity)((EntityChange.Removed)change).getEntity(), project)) continue;
                rootsChangeType2 = ProjectRootManagerImpl.RootsChangeType.ROOTS_REMOVED;
            } else if (entityChange instanceof EntityChange.Replaced) {
                Object oldEntity = ((EntityChange.Replaced)change).getOldEntity();
                Object newEntity2 = ((EntityChange.Replaced)change).getNewEntity();
                if (!Companion.shouldFireRootsChanged$intellij_platform_lang_impl((WorkspaceEntity)oldEntity, project) || !Companion.shouldFireRootsChanged$intellij_platform_lang_impl((WorkspaceEntity)newEntity2, project) || oldEntity instanceof ModuleEntity && newEntity2 instanceof ModuleEntity && CollectionsKt.toSet((Iterable)((ModuleEntity)oldEntity).getDependencies()).containsAll((Collection)((ModuleEntity)newEntity2).getDependencies())) continue;
                rootsChangeType2 = ProjectRootManagerImpl.RootsChangeType.GENERIC;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if ((result2 = Companion.calculateRootsChangeType$intellij_platform_lang_impl(result2, currentRootsChangeType = rootsChangeType2)) != ProjectRootManagerImpl.RootsChangeType.GENERIC) continue;
            break;
        }
        if ((rootsChangeType = result2) == null) {
            rootsChangeType = ProjectRootManagerImpl.RootsChangeType.ROOTS_REMOVED;
        }
        return rootsChangeType;
    }

    private final boolean shouldFireRootsChanged(VersionedStorageChange events, Project project) {
        boolean bl;
        block7: {
            Sequence<EntityChange<?>> $this$any$iv = events.getAllChanges();
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Object entity;
                Object t;
                EntityChange it = (EntityChange)element$iv;
                boolean bl2 = false;
                EntityChange entityChange = it;
                if (entityChange instanceof EntityChange.Added) {
                    t = ((EntityChange.Added)it).getEntity();
                } else if (entityChange instanceof EntityChange.Removed) {
                    t = ((EntityChange.Removed)it).getEntity();
                } else if (entityChange instanceof EntityChange.Replaced) {
                    t = ((EntityChange.Replaced)it).getNewEntity();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if (!Companion.shouldFireRootsChanged$intellij_platform_lang_impl((WorkspaceEntity)(entity = t), project)) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    public ProjectRootsChangeListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001d\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootsChangeListener$Companion;", "", "()V", "calculateRootsChangeType", "Lcom/intellij/openapi/roots/impl/ProjectRootManagerImpl$RootsChangeType;", "result", "change", "calculateRootsChangeType$intellij_platform_lang_impl", "libraryHasOrderEntry", "", "library", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryEntity;", "project", "Lcom/intellij/openapi/project/Project;", "shouldFireRootsChanged", "entity", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "shouldFireRootsChanged$intellij_platform_lang_impl", "intellij.platform.lang.impl"})
    public static final class Companion {
        @NotNull
        public final ProjectRootManagerImpl.RootsChangeType calculateRootsChangeType$intellij_platform_lang_impl(@Nullable ProjectRootManagerImpl.RootsChangeType result2, @NotNull ProjectRootManagerImpl.RootsChangeType change) {
            Intrinsics.checkNotNullParameter((Object)((Object)change), (String)"change");
            if (result2 == ProjectRootManagerImpl.RootsChangeType.GENERIC) {
                return result2;
            }
            if (result2 == null) {
                return change;
            }
            if (change == ProjectRootManagerImpl.RootsChangeType.GENERIC) {
                return ProjectRootManagerImpl.RootsChangeType.GENERIC;
            }
            if (change == ProjectRootManagerImpl.RootsChangeType.ROOTS_ADDED && result2 == ProjectRootManagerImpl.RootsChangeType.ROOTS_ADDED) {
                return result2;
            }
            if (change == ProjectRootManagerImpl.RootsChangeType.ROOTS_REMOVED && result2 == ProjectRootManagerImpl.RootsChangeType.ROOTS_REMOVED) {
                return result2;
            }
            return ProjectRootManagerImpl.RootsChangeType.GENERIC;
        }

        public final boolean shouldFireRootsChanged$intellij_platform_lang_impl(@NotNull WorkspaceEntity entity, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            WorkspaceEntity workspaceEntity = entity;
            return workspaceEntity instanceof LibraryEntity ? this.libraryHasOrderEntry((LibraryEntity)entity, project) : (workspaceEntity instanceof LibraryPropertiesEntity ? this.libraryHasOrderEntry(((LibraryPropertiesEntity)entity).getLibrary(), project) : workspaceEntity instanceof ModuleEntity || workspaceEntity instanceof JavaModuleSettingsEntity || workspaceEntity instanceof ModuleCustomImlDataEntity || workspaceEntity instanceof ModuleGroupPathEntity || workspaceEntity instanceof SourceRootEntity || workspaceEntity instanceof JavaSourceRootEntity || workspaceEntity instanceof JavaResourceRootEntity || workspaceEntity instanceof CustomSourceRootPropertiesEntity || workspaceEntity instanceof ContentRootEntity);
        }

        private final boolean libraryHasOrderEntry(LibraryEntity library2, Project project) {
            if (library2.getTableId() instanceof LibraryTableId.ModuleLibraryTableId) {
                return true;
            }
            String libraryName = library2.getName();
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
            Module[] moduleArray = moduleManager.getModules();
            Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
            Module[] $this$forEach$iv = moduleArray;
            boolean $i$f$forEach = false;
            Module[] moduleArray2 = $this$forEach$iv;
            int n = moduleArray2.length;
            for (int j = 0; j < n; ++j) {
                boolean exists;
                block3: {
                    boolean bl;
                    OrderEntry[] $this$any$iv;
                    Module element$iv;
                    Module module = element$iv = moduleArray2[j];
                    boolean bl2 = false;
                    ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                    Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                    Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager.getOrderEntries(), (String)"ModuleRootManager.getInstance(module).orderEntries");
                    boolean $i$f$any = false;
                    OrderEntry[] orderEntryArray = $this$any$iv;
                    int n2 = orderEntryArray.length;
                    for (int k = 0; k < n2; ++k) {
                        OrderEntry element$iv2;
                        OrderEntry it = element$iv2 = orderEntryArray[k];
                        boolean bl3 = false;
                        if (!(it instanceof LibraryOrderEntry && Intrinsics.areEqual((Object)((LibraryOrderEntry)it).getLibraryName(), (Object)libraryName))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = exists = false;
                }
                if (!exists) continue;
                return true;
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

