/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.ide.BuilderSnapshot;
import com.intellij.workspaceModel.ide.StorageReplacement;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.WorkspaceModelCache;
import com.intellij.workspaceModel.ide.WorkspaceModelPreUpdateHandler;
import com.intellij.workspaceModel.ide.WorkspaceModelTopics;
import com.intellij.workspaceModel.ide.impl.EntityTracingListener;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelInitialTestContent;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.FacetEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.FacetId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import com.intellij.workspaceModel.storage.impl.VersionedEntityStorageImpl;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 02\u00020\u00012\u00020\u0002:\u00010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020)H\u0002J'\u0010*\u001a\u0002H+\"\u0004\b\u0000\u0010+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u0002H+0-H\u0016\u00a2\u0006\u0002\u0010.J'\u0010/\u001a\u0002H+\"\u0004\b\u0000\u0010+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u0002H+0-H\u0016\u00a2\u0006\u0002\u0010.R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelImpl;", "Lcom/intellij/workspaceModel/ide/WorkspaceModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/intellij/workspaceModel/ide/WorkspaceModelCache;", "getCache", "()Lcom/intellij/workspaceModel/ide/WorkspaceModelCache;", "entityStorage", "Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageImpl;", "getEntityStorage", "()Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageImpl;", "entityToTrace", "Lcom/intellij/workspaceModel/storage/bridgeEntities/FacetId;", "<set-?>", "", "loadedFromCache", "getLoadedFromCache", "()Z", "blockDelayedLoading", "", "dispose", "getBuilderSnapshot", "Lcom/intellij/workspaceModel/ide/BuilderSnapshot;", "onBeforeChanged", "change", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "onChanged", "printInfoAboutTracedEntity", "storage", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "storageDescription", "", "replaceProjectModel", "replacement", "Lcom/intellij/workspaceModel/ide/StorageReplacement;", "startPreUpdateHandlers", "before", "builder", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "updateProjectModel", "R", "updater", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "updateProjectModelSilent", "Companion", "intellij.platform.projectModel.impl"})
public final class WorkspaceModelImpl
implements WorkspaceModel,
Disposable {
    private final FacetId entityToTrace;
    private volatile boolean loadedFromCache;
    @NotNull
    private final VersionedEntityStorageImpl entityStorage;
    private final Project project;
    private static final Logger log;
    private static final ExtensionPointName<WorkspaceModelPreUpdateHandler> PRE_UPDATE_HANDLERS;
    private static final int PRE_UPDATE_LOOP_BLOCK = 100;
    @NotNull
    public static final Companion Companion;

    @Override
    @Nullable
    public WorkspaceModelCache getCache() {
        return WorkspaceModelCache.Companion.getInstance(this.project);
    }

    public final boolean getLoadedFromCache() {
        return this.loadedFromCache;
    }

    @Override
    @NotNull
    public VersionedEntityStorageImpl getEntityStorage() {
        return this.entityStorage;
    }

    public final void blockDelayedLoading() {
        this.loadedFromCache = false;
    }

    public final void printInfoAboutTracedEntity(@NotNull WorkspaceEntityStorage storage2, @NotNull String storageDescription) {
        Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)storageDescription, (String)"storageDescription");
        if (this.entityToTrace != null) {
            FacetEntity facetEntity = (FacetEntity)storage2.resolve(this.entityToTrace);
            log.info("Traced entity from " + storageDescription + ": " + (facetEntity != null ? facetEntity.getConfigurationXmlTag() : null));
        }
    }

    @Override
    public <R> R updateProjectModel(@NotNull Function1<? super WorkspaceEntityStorageBuilder, ? extends R> updater) {
        Intrinsics.checkNotNullParameter(updater, (String)"updater");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        WorkspaceEntityStorage before = this.getEntityStorage().getCurrent();
        WorkspaceEntityStorageBuilder builder2 = WorkspaceEntityStorageBuilder.Companion.from(before);
        Object result2 = updater.invoke((Object)builder2);
        this.startPreUpdateHandlers(before, builder2);
        Map<Class<?>, List<EntityChange<?>>> changes = builder2.collectChanges(before);
        this.getEntityStorage().replace(builder2.toStorage(), changes, (Function1<? super VersionedStorageChange, Unit>)((Function1)new Function1<VersionedStorageChange, Unit>(this){

            public final void invoke(@NotNull VersionedStorageChange p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                WorkspaceModelImpl.access$onBeforeChanged((WorkspaceModelImpl)this.receiver, p1);
            }
        }), (Function1<? super VersionedStorageChange, Unit>)((Function1)new Function1<VersionedStorageChange, Unit>(this){

            public final void invoke(@NotNull VersionedStorageChange p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                WorkspaceModelImpl.access$onChanged((WorkspaceModelImpl)this.receiver, p1);
            }
        }));
        return (R)result2;
    }

    @Override
    public <R> R updateProjectModelSilent(@NotNull Function1<? super WorkspaceEntityStorageBuilder, ? extends R> updater) {
        Intrinsics.checkNotNullParameter(updater, (String)"updater");
        WorkspaceEntityStorageBuilder builder2 = WorkspaceEntityStorageBuilder.Companion.from(this.getEntityStorage().getCurrent());
        Object result2 = updater.invoke((Object)builder2);
        this.getEntityStorage().replaceSilently(builder2.toStorage());
        return (R)result2;
    }

    @Override
    @NotNull
    public BuilderSnapshot getBuilderSnapshot() {
        VersionedEntityStorageImpl.Current current2 = this.getEntityStorage().getPointer();
        return new BuilderSnapshot(current2.getVersion(), current2.getStorage());
    }

    @Override
    public boolean replaceProjectModel(@NotNull StorageReplacement replacement) {
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.getEntityStorage().getVersion() != replacement.getVersion()) {
            return false;
        }
        this.getEntityStorage().replace(replacement.getSnapshot(), replacement.getChanges(), (Function1<? super VersionedStorageChange, Unit>)((Function1)new Function1<VersionedStorageChange, Unit>(this){

            public final void invoke(@NotNull VersionedStorageChange p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                WorkspaceModelImpl.access$onBeforeChanged((WorkspaceModelImpl)this.receiver, p1);
            }
        }), (Function1<? super VersionedStorageChange, Unit>)((Function1)new Function1<VersionedStorageChange, Unit>(this){

            public final void invoke(@NotNull VersionedStorageChange p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                WorkspaceModelImpl.access$onChanged((WorkspaceModelImpl)this.receiver, p1);
            }
        }));
        return true;
    }

    public void dispose() {
    }

    private final void onBeforeChanged(VersionedStorageChange change) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.project.isDisposed()) {
            return;
        }
        WorkspaceModelTopics workspaceModelTopics = WorkspaceModelTopics.Companion.getInstance(this.project);
        MessageBus messageBus = this.project.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"project.messageBus");
        workspaceModelTopics.syncPublisher(messageBus).beforeChanged(change);
    }

    private final void onChanged(VersionedStorageChange change) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.project.isDisposed()) {
            return;
        }
        WorkspaceModelTopics workspaceModelTopics = WorkspaceModelTopics.Companion.getInstance(this.project);
        MessageBus messageBus = this.project.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"project.messageBus");
        workspaceModelTopics.syncPublisher(messageBus).changed(change);
    }

    private final void startPreUpdateHandlers(WorkspaceEntityStorage before, WorkspaceEntityStorageBuilder builder2) {
        boolean startUpdateLoop = true;
        int updatesStarted = 0;
        while (startUpdateLoop && updatesStarted < 100) {
            ++updatesStarted;
            startUpdateLoop = false;
            List list2 = PRE_UPDATE_HANDLERS.getExtensionsIfPointIsRegistered();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"PRE_UPDATE_HANDLERS.extensionsIfPointIsRegistered");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorkspaceModelPreUpdateHandler it = (WorkspaceModelPreUpdateHandler)element$iv;
                boolean bl = false;
                startUpdateLoop |= it.update(before, builder2);
            }
        }
        if (updatesStarted >= 100) {
            log.error("Loop workspace model updating");
        }
    }

    /*
     * WARNING - void declaration
     */
    public WorkspaceModelImpl(@NotNull Project project) {
        WorkspaceEntityStorage workspaceEntityStorage;
        WorkspaceEntityStorage projectEntities;
        WorkspaceEntityStorage workspaceEntityStorage2;
        WorkspaceEntityStorage workspaceEntityStorage3;
        Object object;
        Object object2;
        WorkspaceModelImpl workspaceModelImpl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        WorkspaceModelImpl workspaceModelImpl2 = this;
        String string = System.getProperty("idea.workspace.model.track.facet.id");
        if (string != null) {
            void moduleName;
            void facetTypeId;
            void it;
            List list2;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String string3 = string2;
            workspaceModelImpl = workspaceModelImpl2;
            boolean bl3 = false;
            List list3 = list2 = StringsKt.split$default((CharSequence)((CharSequence)it), (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null);
            boolean bl4 = false;
            String string4 = (String)list3.get(0);
            list3 = list2;
            bl4 = false;
            String string5 = (String)list3.get(1);
            list3 = list2;
            bl4 = false;
            String facetName = (String)list3.get(2);
            object2 = new FacetId(facetName, (String)facetTypeId, new ModuleId((String)moduleName));
            workspaceModelImpl2 = workspaceModelImpl;
            object = object2;
        } else {
            object = null;
        }
        workspaceModelImpl2.entityToTrace = object;
        Logger $this$debug$iv = log;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            workspaceModelImpl = $this$debug$iv;
            boolean bl = false;
            object2 = "Loading workspace model";
            workspaceModelImpl.debug((String)object2, e$iv);
        }
        WorkspaceEntityStorage initialContent = WorkspaceModelInitialTestContent.INSTANCE.pop$intellij_platform_projectModel_impl();
        WorkspaceModelCache cache2 = WorkspaceModelCache.Companion.getInstance(this.project);
        if (initialContent != null) {
            workspaceEntityStorage3 = initialContent;
        } else if (cache2 != null) {
            WorkspaceEntityStorage workspaceEntityStorage4;
            Activity activity = StartUpMeasurer.startActivity((String)"module cache loading", (ActivityCategory)ActivityCategory.DEFAULT);
            Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"startActivity(\"module ca\u2026ActivityCategory.DEFAULT)");
            Activity activity2 = activity;
            WorkspaceEntityStorage previousStorage = null;
            boolean $i$f$measureTimeMillis = false;
            boolean bl = false;
            long start$iv = System.currentTimeMillis();
            boolean bl5 = false;
            previousStorage = cache2.loadCache();
            long loadingCacheTime = System.currentTimeMillis() - start$iv;
            if (previousStorage != null) {
                log.info("Load workspace model from cache in " + loadingCacheTime + " ms");
                this.loadedFromCache = true;
                this.printInfoAboutTracedEntity(previousStorage, "cache");
                workspaceEntityStorage4 = previousStorage;
            } else {
                workspaceEntityStorage4 = WorkspaceEntityStorageBuilder.Companion.create();
            }
            WorkspaceEntityStorage storage2 = workspaceEntityStorage4;
            activity2.end();
            workspaceEntityStorage3 = storage2;
        } else {
            workspaceEntityStorage3 = WorkspaceEntityStorageBuilder.Companion.create();
        }
        if (!((workspaceEntityStorage2 = (projectEntities = workspaceEntityStorage3)) instanceof WorkspaceEntityStorageBuilder)) {
            workspaceEntityStorage2 = null;
        }
        if ((workspaceEntityStorage = (WorkspaceEntityStorageBuilder)workspaceEntityStorage2) == null || (workspaceEntityStorage = workspaceEntityStorage.toStorage()) == null) {
            workspaceEntityStorage = projectEntities;
        }
        this.entityStorage = new VersionedEntityStorageImpl(workspaceEntityStorage);
        if (this.entityToTrace != null) {
            WorkspaceModelTopics workspaceModelTopics = WorkspaceModelTopics.Companion.getInstance(this.project);
            MessageBusConnection messageBusConnection2 = this.project.getMessageBus().connect();
            Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection2, (String)"project.messageBus.connect()");
            workspaceModelTopics.subscribeImmediately(messageBusConnection2, new EntityTracingListener(this.entityToTrace));
        }
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WorkspaceModelImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        log = logger;
        ExtensionPointName extensionPointName = ExtensionPointName.create((String)"com.intellij.workspaceModel.preUpdateHandler");
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026eModel.preUpdateHandler\")");
        PRE_UPDATE_HANDLERS = extensionPointName;
    }

    public static final /* synthetic */ void access$onBeforeChanged(WorkspaceModelImpl $this, VersionedStorageChange change) {
        $this.onBeforeChanged(change);
    }

    public static final /* synthetic */ void access$onChanged(WorkspaceModelImpl $this, VersionedStorageChange change) {
        $this.onChanged(change);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelImpl$Companion;", "", "()V", "PRE_UPDATE_HANDLERS", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/workspaceModel/ide/WorkspaceModelPreUpdateHandler;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "PRE_UPDATE_LOOP_BLOCK", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

