/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u0016\u0010\u0017\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vfs/AsyncVfsEventsPostProcessorImpl;", "Lcom/intellij/vfs/AsyncVfsEventsPostProcessor;", "Lcom/intellij/openapi/Disposable;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "listeners", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/intellij/vfs/AsyncVfsEventsPostProcessorImpl$ListenerAndDisposable;", "kotlin.jvm.PlatformType", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "queue", "Lcom/intellij/util/concurrency/QueueProcessor;", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "addListener", "", "listener", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "disposable", "dispose", "processEvents", "events", "Companion", "ListenerAndDisposable", "intellij.platform.vcs.impl"})
public final class AsyncVfsEventsPostProcessorImpl
implements AsyncVfsEventsPostProcessor,
Disposable {
    private final Logger LOG;
    private final QueueProcessor<List<VFileEvent>> queue;
    private final MessageBus messageBus;
    private final ConcurrentList<ListenerAndDisposable> listeners;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void addListener(@NotNull AsyncVfsEventsListener listener2, @NotNull Disposable disposable2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
        ListenerAndDisposable element2 = new ListenerAndDisposable(listener2, disposable2);
        Disposer.register((Disposable)disposable2, (Disposable)new Disposable(this, element2){
            final /* synthetic */ AsyncVfsEventsPostProcessorImpl this$0;
            final /* synthetic */ ListenerAndDisposable $element;

            public final void dispose() {
                AsyncVfsEventsPostProcessorImpl.access$getListeners$p(this.this$0).remove((Object)this.$element);
            }
            {
                this.this$0 = asyncVfsEventsPostProcessorImpl;
                this.$element = listenerAndDisposable;
            }
        });
        this.listeners.add((Object)element2);
    }

    public void dispose() {
        this.queue.clear();
        this.listeners.clear();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    private final void processEvents(List<? extends VFileEvent> events) {
        for (ListenerAndDisposable listenerAndDisposable : this.listeners) {
            AsyncVfsEventsListener asyncVfsEventsListener = listenerAndDisposable.component1();
            Disposable parentDisposable = listenerAndDisposable.component2();
            try {
                void listener2;
                BackgroundTaskUtil.runUnderDisposeAwareIndicator(parentDisposable, new Runnable((AsyncVfsEventsListener)listener2, events){
                    final /* synthetic */ AsyncVfsEventsListener $listener;
                    final /* synthetic */ List $events;

                    public final void run() {
                        this.$listener.filesChanged(this.$events);
                    }
                    {
                        this.$listener = asyncVfsEventsListener;
                        this.$events = list2;
                    }
                });
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable e) {
                this.LOG.error(e);
            }
        }
    }

    public AsyncVfsEventsPostProcessorImpl() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AsyncVfsEventsPostProcessorImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.LOG = logger;
        this.queue = new QueueProcessor(new Consumer(this){
            final /* synthetic */ AsyncVfsEventsPostProcessorImpl this$0;

            public final void consume(List<? extends VFileEvent> events) {
                List<? extends VFileEvent> list2 = events;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"events");
                AsyncVfsEventsPostProcessorImpl.access$processEvents(this.this$0, list2);
            }
            {
                this.this$0 = asyncVfsEventsPostProcessorImpl;
            }
        });
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBus messageBus = application.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"ApplicationManager.getApplication().messageBus");
        this.messageBus = messageBus;
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"ContainerUtil.createConc\u2026<ListenerAndDisposable>()");
        this.listeners = concurrentList;
        this.messageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                queue.add(events);
            }
        });
    }

    public static final /* synthetic */ ConcurrentList access$getListeners$p(AsyncVfsEventsPostProcessorImpl $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ void access$processEvents(AsyncVfsEventsPostProcessorImpl $this, List events) {
        $this.processEvents(events);
    }

    @JvmStatic
    @TestOnly
    public static final void waitEventsProcessed() {
        Companion.waitEventsProcessed();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vfs/AsyncVfsEventsPostProcessorImpl$ListenerAndDisposable;", "", "listener", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/vfs/AsyncVfsEventsListener;Lcom/intellij/openapi/Disposable;)V", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "getListener", "()Lcom/intellij/vfs/AsyncVfsEventsListener;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.vcs.impl"})
    private static final class ListenerAndDisposable {
        @NotNull
        private final AsyncVfsEventsListener listener;
        @NotNull
        private final Disposable disposable;

        @NotNull
        public final AsyncVfsEventsListener getListener() {
            return this.listener;
        }

        @NotNull
        public final Disposable getDisposable() {
            return this.disposable;
        }

        public ListenerAndDisposable(@NotNull AsyncVfsEventsListener listener2, @NotNull Disposable disposable2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
            this.listener = listener2;
            this.disposable = disposable2;
        }

        @NotNull
        public final AsyncVfsEventsListener component1() {
            return this.listener;
        }

        @NotNull
        public final Disposable component2() {
            return this.disposable;
        }

        @NotNull
        public final ListenerAndDisposable copy(@NotNull AsyncVfsEventsListener listener2, @NotNull Disposable disposable2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
            return new ListenerAndDisposable(listener2, disposable2);
        }

        public static /* synthetic */ ListenerAndDisposable copy$default(ListenerAndDisposable listenerAndDisposable, AsyncVfsEventsListener asyncVfsEventsListener, Disposable disposable2, int n, Object object) {
            if ((n & 1) != 0) {
                asyncVfsEventsListener = listenerAndDisposable.listener;
            }
            if ((n & 2) != 0) {
                disposable2 = listenerAndDisposable.disposable;
            }
            return listenerAndDisposable.copy(asyncVfsEventsListener, disposable2);
        }

        @NotNull
        public String toString() {
            return "ListenerAndDisposable(listener=" + this.listener + ", disposable=" + this.disposable + ")";
        }

        public int hashCode() {
            AsyncVfsEventsListener asyncVfsEventsListener = this.listener;
            Disposable disposable2 = this.disposable;
            return (asyncVfsEventsListener != null ? asyncVfsEventsListener.hashCode() : 0) * 31 + (disposable2 != null ? disposable2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ListenerAndDisposable)) break block3;
                    ListenerAndDisposable listenerAndDisposable = (ListenerAndDisposable)object;
                    if (!Intrinsics.areEqual((Object)this.listener, (Object)listenerAndDisposable.listener) || !Intrinsics.areEqual((Object)this.disposable, (Object)listenerAndDisposable.disposable)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/vfs/AsyncVfsEventsPostProcessorImpl$Companion;", "", "()V", "waitEventsProcessed", "", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @JvmStatic
        @TestOnly
        public final void waitEventsProcessed() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            boolean bl = application.isUnitTestMode();
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            AsyncVfsEventsPostProcessor asyncVfsEventsPostProcessor = AsyncVfsEventsPostProcessor.getInstance();
            if (asyncVfsEventsPostProcessor == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.vfs.AsyncVfsEventsPostProcessorImpl");
            }
            ((AsyncVfsEventsPostProcessorImpl)asyncVfsEventsPostProcessor).queue.waitFor();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

