/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.history.FileHistoryPaths;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisiblePack
implements VcsLogDataPack {
    @NotNull
    public static final VisiblePack EMPTY = new VisiblePack((DataPackBase)DataPack.EMPTY, (VisibleGraph)EmptyVisibleGraph.getInstance(), false, VcsLogFilterObject.EMPTY_COLLECTION){

        @Override
        public String toString() {
            return "EmptyVisiblePack";
        }
    };
    @NotNull
    private final DataPackBase myDataPack;
    @NotNull
    private final VisibleGraph<Integer> myVisibleGraph;
    private final boolean myCanRequestMore;
    @NotNull
    private final VcsLogFilterCollection myFilters;
    @Nullable
    private final Object myAdditionalData;

    public VisiblePack(@NotNull DataPackBase dataPack, @NotNull VisibleGraph<Integer> graph2, boolean canRequestMore, @NotNull VcsLogFilterCollection filters) {
        if (dataPack == null) {
            VisiblePack.$$$reportNull$$$0(0);
        }
        if (graph2 == null) {
            VisiblePack.$$$reportNull$$$0(1);
        }
        if (filters == null) {
            VisiblePack.$$$reportNull$$$0(2);
        }
        this(dataPack, graph2, canRequestMore, filters, null);
    }

    public VisiblePack(@NotNull DataPackBase dataPack, @NotNull VisibleGraph<Integer> graph2, boolean canRequestMore, @NotNull VcsLogFilterCollection filters, @Nullable Object data2) {
        if (dataPack == null) {
            VisiblePack.$$$reportNull$$$0(3);
        }
        if (graph2 == null) {
            VisiblePack.$$$reportNull$$$0(4);
        }
        if (filters == null) {
            VisiblePack.$$$reportNull$$$0(5);
        }
        this.myDataPack = dataPack;
        this.myVisibleGraph = graph2;
        this.myCanRequestMore = canRequestMore;
        this.myFilters = filters;
        this.myAdditionalData = data2;
    }

    @NotNull
    public VisibleGraph<Integer> getVisibleGraph() {
        VisibleGraph<Integer> visibleGraph = this.myVisibleGraph;
        if (visibleGraph == null) {
            VisiblePack.$$$reportNull$$$0(6);
        }
        return visibleGraph;
    }

    @NotNull
    public DataPackBase getDataPack() {
        DataPackBase dataPackBase = this.myDataPack;
        if (dataPackBase == null) {
            VisiblePack.$$$reportNull$$$0(7);
        }
        return dataPackBase;
    }

    public boolean canRequestMore() {
        return this.myCanRequestMore;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        Map<VirtualFile, VcsLogProvider> map2 = this.myDataPack.getLogProviders();
        if (map2 == null) {
            VisiblePack.$$$reportNull$$$0(8);
        }
        return map2;
    }

    @NotNull
    public VcsLogRefs getRefs() {
        RefsModel refsModel = this.myDataPack.getRefsModel();
        if (refsModel == null) {
            VisiblePack.$$$reportNull$$$0(9);
        }
        return refsModel;
    }

    public boolean isFull() {
        return this.myDataPack.isFull();
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        VcsLogFilterCollection vcsLogFilterCollection = this.myFilters;
        if (vcsLogFilterCollection == null) {
            VisiblePack.$$$reportNull$$$0(10);
        }
        return vcsLogFilterCollection;
    }

    public boolean isEmpty() {
        return this.getVisibleGraph().getVisibleCommitCount() == 0;
    }

    public VirtualFile getRoot(int row2) {
        int head = (Integer)this.myVisibleGraph.getRowInfo(row2).getOneOfHeads();
        return this.myDataPack.getRefsModel().rootAtHead(head);
    }

    public <T> T getAdditionalData() {
        return (T)this.myAdditionalData;
    }

    @NonNls
    public String toString() {
        return "VisiblePack{size=" + this.myVisibleGraph.getVisibleCommitCount() + ", filters=" + this.myFilters + ", canRequestMore=" + this.myCanRequestMore + "}";
    }

    @NotNull
    public FilePath getFilePath(int index2) {
        FilePath path2;
        if (FileHistoryPaths.hasPathsInformation(this) && (path2 = FileHistoryPaths.filePathOrDefault(this, (Integer)this.myVisibleGraph.getRowInfo(index2).getCommit())) != null) {
            FilePath filePath = path2;
            if (filePath == null) {
                VisiblePack.$$$reportNull$$$0(11);
            }
            return filePath;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)this.getRoot(index2));
        if (filePath == null) {
            VisiblePack.$$$reportNull$$$0(12);
        }
        return filePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePack";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleGraph";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataPack";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogProviders";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefs";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ErrorVisiblePack
    extends VisiblePack {
        @NotNull
        private final Throwable myError;

        public ErrorVisiblePack(@NotNull DataPackBase dataPack, @NotNull VcsLogFilterCollection filters, @NotNull Throwable error2) {
            if (dataPack == null) {
                ErrorVisiblePack.$$$reportNull$$$0(0);
            }
            if (filters == null) {
                ErrorVisiblePack.$$$reportNull$$$0(1);
            }
            if (error2 == null) {
                ErrorVisiblePack.$$$reportNull$$$0(2);
            }
            super(dataPack, EmptyVisibleGraph.getInstance(), false, filters, null);
            this.myError = error2;
        }

        @NotNull
        public Throwable getError() {
            Throwable throwable = this.myError;
            if (throwable == null) {
                ErrorVisiblePack.$$$reportNull$$$0(3);
            }
            return throwable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataPack";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePack$ErrorVisiblePack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePack$ErrorVisiblePack";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getError";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

