/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogColorManagerImpl
implements VcsLogColorManager {
    private static final Logger LOG = Logger.getInstance(VcsLogColorManagerImpl.class);
    private static final Color[] ROOT_COLORS = new Color[]{JBColor.RED, JBColor.GREEN, JBColor.BLUE, JBColor.ORANGE, JBColor.CYAN, JBColor.YELLOW, JBColor.MAGENTA, JBColor.PINK};
    @NotNull
    private final Map<String, Color> myPaths2Colors;
    @NotNull
    private final List<FilePath> myPaths;

    public VcsLogColorManagerImpl(@NotNull Set<VirtualFile> roots) {
        if (roots == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(0);
        }
        this(ContainerUtil.map((Collection)ContainerUtil.sorted(roots, Comparator.comparing(VirtualFile::getName)), file2 -> VcsUtil.getFilePath((VirtualFile)file2)));
    }

    public VcsLogColorManagerImpl(@NotNull Collection<FilePath> paths) {
        if (paths == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(1);
        }
        this.myPaths = new ArrayList<FilePath>(paths);
        this.myPaths2Colors = new HashMap<String, Color>();
        for (int i2 = 0; i2 < this.myPaths.size(); ++i2) {
            this.myPaths2Colors.put(this.myPaths.get(i2).getPath(), VcsLogColorManagerImpl.getColor(i2, this.myPaths.size()));
        }
    }

    @NotNull
    private static Color getColor(int rootNumber, int rootsCount) {
        Color color;
        if (rootNumber >= ROOT_COLORS.length) {
            double balance = (double)(rootNumber / ROOT_COLORS.length) / (double)(rootsCount / ROOT_COLORS.length);
            Color mix = ColorUtil.mix((Color)ROOT_COLORS[rootNumber % ROOT_COLORS.length], (Color)ROOT_COLORS[(rootNumber + 1) % ROOT_COLORS.length], (double)balance);
            int tones = (int)(Math.abs(balance - 0.5) * 2.0 * (double)(rootsCount / ROOT_COLORS.length) + 1.0);
            color = new JBColor(ColorUtil.darker((Color)mix, (int)tones), ColorUtil.brighter((Color)mix, (int)(2 * tones)));
        } else {
            color = ROOT_COLORS[rootNumber];
        }
        Color color2 = color;
        if (color2 == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(2);
        }
        return color2;
    }

    @NotNull
    public static JBColor getBackgroundColor(@NotNull Color baseRootColor) {
        if (baseRootColor == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(3);
        }
        return new JBColor(() -> ColorUtil.mix((Color)baseRootColor, (Color)UIUtil.getTableBackground(), (double)0.75));
    }

    @Override
    @NotNull
    public Color getPathColor(@NotNull FilePath path2) {
        if (path2 == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(4);
        }
        return this.getColor(path2.getPath());
    }

    @Override
    @NotNull
    public Color getRootColor(@NotNull VirtualFile root) {
        if (root == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(5);
        }
        return this.getColor(root.getPath());
    }

    @NotNull
    private Color getColor(@NotNull String path2) {
        Color color;
        if (path2 == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(6);
        }
        if ((color = this.myPaths2Colors.get(path2)) == null) {
            LOG.error("No color record for path " + path2 + ". All paths: " + this.myPaths2Colors);
            color = VcsLogColorManagerImpl.getDefaultRootColor();
        }
        Color color2 = color;
        if (color2 == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(7);
        }
        return color2;
    }

    @NotNull
    private static Color getDefaultRootColor() {
        Color color = UIUtil.getTableBackground();
        if (color == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(8);
        }
        return color;
    }

    @Override
    @NotNull
    public Collection<FilePath> getPaths() {
        List<FilePath> list2 = this.myPaths;
        if (list2 == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/VcsLogColorManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseRootColor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/VcsLogColorManagerImpl";
                break;
            }
            case 2: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRootColor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundColor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPathColor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRootColor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

