/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.TabGroupId;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogEditorUtilKt;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.editor.VcsLogVirtualFileSystem;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogTabsManager {
    private static final Logger LOG = Logger.getInstance(VcsLogTabsManager.class);
    private static final TabGroupId TAB_GROUP_ID = new TabGroupId("Log", () -> VcsLogBundle.message((String)"vcs.log.tab.name", (Object[])new Object[0]), true);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogProjectTabsProperties myUiProperties;
    private boolean myIsLogDisposing;

    VcsLogTabsManager(final @NotNull Project project, @NotNull MessageBus messageBus, @NotNull VcsLogProjectTabsProperties uiProperties, @NotNull Disposable parent) {
        if (project == null) {
            VcsLogTabsManager.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            VcsLogTabsManager.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            VcsLogTabsManager.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            VcsLogTabsManager.$$$reportNull$$$0(3);
        }
        this.myIsLogDisposing = false;
        this.myProject = project;
        this.myUiProperties = uiProperties;
        messageBus.connect(parent).subscribe(VcsProjectLog.VCS_PROJECT_LOG_CHANGED, (Object)new VcsProjectLog.ProjectLogListener(){

            @Override
            public void logCreated(@NotNull VcsLogManager manager2) {
                if (manager2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                VcsLogTabsManager.this.myIsLogDisposing = false;
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (LOG.assertTrue(!Disposer.isDisposed((Disposable)manager2), (Object)"Attempting to open tabs on disposed VcsLogManager")) {
                        VcsLogTabsManager.this.reopenLogTabs(manager2);
                    }
                }, ModalityState.NON_MODAL, o -> manager2 != VcsProjectLog.getInstance(project).getLogManager());
            }

            @Override
            public void logDisposed(@NotNull VcsLogManager manager2) {
                if (manager2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                VcsLogTabsManager.this.myIsLogDisposing = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "manager";
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "logCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "logDisposed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private void reopenLogTabs(@NotNull VcsLogManager vcsLogManager) {
        void manager2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (manager2 == null) {
            VcsLogTabsManager.$$$reportNull$$$0(4);
        }
        this.myUiProperties.getTabs().forEach((arg_0, arg_1) -> this.lambda$reopenLogTabs$1((VcsLogManager)manager2, arg_0, arg_1));
    }

    @NotNull
    public Collection<String> getTabs() {
        Set<String> set2 = this.myUiProperties.getTabs().keySet();
        if (set2 == null) {
            VcsLogTabsManager.$$$reportNull$$$0(5);
        }
        return set2;
    }

    @NotNull
    MainVcsLogUi openAnotherLogTab(@NotNull VcsLogManager manager2, @NotNull VcsLogFilterCollection filters, @NotNull VcsLogManager.LogWindowKind kind) {
        if (manager2 == null) {
            VcsLogTabsManager.$$$reportNull$$$0(6);
        }
        if (filters == null) {
            VcsLogTabsManager.$$$reportNull$$$0(7);
        }
        if (kind == null) {
            VcsLogTabsManager.$$$reportNull$$$0(8);
        }
        String tabId = VcsLogTabsManager.generateTabId(this.myProject);
        this.myUiProperties.resetState(tabId);
        if (kind == VcsLogManager.LogWindowKind.EDITOR) {
            FileEditor[] editors2 = this.openEditorLogTab(tabId, true, filters);
            MainVcsLogUi mainVcsLogUi = Objects.requireNonNull(VcsLogEditorUtilKt.findVcsLogUi(editors2, MainVcsLogUi.class));
            if (mainVcsLogUi == null) {
                VcsLogTabsManager.$$$reportNull$$$0(9);
            }
            return mainVcsLogUi;
        }
        if (kind == VcsLogManager.LogWindowKind.TOOL_WINDOW) {
            return this.openToolWindowLogTab(manager2, tabId, true, filters);
        }
        throw new UnsupportedOperationException("Only log in editor or tool window is supported");
    }

    private FileEditor @NotNull [] openEditorLogTab(@NotNull String tabId, boolean focus, @Nullable VcsLogFilterCollection filters) {
        if (tabId == null) {
            VcsLogTabsManager.$$$reportNull$$$0(10);
        }
        VirtualFile file2 = VcsLogVirtualFileSystem.getInstance().createVcsLogFile(this.myProject, tabId, filters);
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.myProject).openFile(file2, focus, true);
        if (fileEditorArray == null) {
            VcsLogTabsManager.$$$reportNull$$$0(11);
        }
        return fileEditorArray;
    }

    @NotNull
    private MainVcsLogUi openToolWindowLogTab(@NotNull VcsLogManager manager2, @NotNull String tabId, boolean focus, @Nullable VcsLogFilterCollection filters) {
        if (manager2 == null) {
            VcsLogTabsManager.$$$reportNull$$$0(12);
        }
        if (tabId == null) {
            VcsLogTabsManager.$$$reportNull$$$0(13);
        }
        VcsLogManager.VcsLogUiFactory<MainVcsLogUi> factory2 = this.getPersistentVcsLogUiFactory(manager2, tabId, VcsLogManager.LogWindowKind.TOOL_WINDOW, filters);
        MainVcsLogUi ui2 = VcsLogContentUtil.openLogTab(this.myProject, manager2, TAB_GROUP_ID, u -> VcsLogTabsManager.generateShortDisplayName(u), factory2, focus);
        ui2.getFilterUi().addFilterListener(() -> VcsLogContentUtil.updateLogUiName(this.myProject, ui2));
        MainVcsLogUi mainVcsLogUi = ui2;
        if (mainVcsLogUi == null) {
            VcsLogTabsManager.$$$reportNull$$$0(14);
        }
        return mainVcsLogUi;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @ApiStatus.Internal
    public VcsLogManager.VcsLogUiFactory<MainVcsLogUi> getPersistentVcsLogUiFactory(@NotNull VcsLogManager vcsLogManager, @NotNull String string, @NotNull VcsLogManager.LogWindowKind logWindowKind, @Nullable VcsLogFilterCollection vcsLogFilterCollection) {
        void filters;
        void kind;
        void tabId;
        void manager2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (manager2 == null) {
            VcsLogTabsManager.$$$reportNull$$$0(15);
        }
        if (tabId == null) {
            VcsLogTabsManager.$$$reportNull$$$0(16);
        }
        if (kind == null) {
            VcsLogTabsManager.$$$reportNull$$$0(17);
        }
        return new PersistentVcsLogUiFactory(manager2.getMainLogUiFactory((String)tabId, (VcsLogFilterCollection)filters), (VcsLogManager.LogWindowKind)kind);
    }

    @NotNull
    @NlsContexts.TabTitle
    private static String generateShortDisplayName(@NotNull VcsLogUi ui2) {
        VcsLogFilterCollection filters;
        if (ui2 == null) {
            VcsLogTabsManager.$$$reportNull$$$0(18);
        }
        if ((filters = ui2.getFilterUi().getFilters()).isEmpty()) {
            return "";
        }
        String string = StringUtil.shortenTextWithEllipsis((String)VcsLogFiltersKt.getPresentation(filters), (int)150, (int)20);
        if (string == null) {
            VcsLogTabsManager.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    @NlsContexts.TabTitle
    public static String getFullName(@NotNull @NlsContexts.TabTitle String shortName) {
        if (shortName == null) {
            VcsLogTabsManager.$$$reportNull$$$0(20);
        }
        String string = ContentUtilEx.getFullName(VcsLogBundle.message((String)"vcs.log.tab.name", (Object[])new Object[0]), shortName);
        if (string == null) {
            VcsLogTabsManager.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    @NlsContexts.TabTitle
    public static String generateDisplayName(@NotNull VcsLogUi ui2) {
        if (ui2 == null) {
            VcsLogTabsManager.$$$reportNull$$$0(22);
        }
        return VcsLogTabsManager.getFullName(VcsLogTabsManager.generateShortDisplayName(ui2));
    }

    @NotNull
    @NonNls
    private static String generateTabId(@NotNull Project project) {
        String newId;
        if (project == null) {
            VcsLogTabsManager.$$$reportNull$$$0(23);
        }
        Set existingIds = ContainerUtil.union(VcsLogContentUtil.getExistingLogIds(project), VcsLogEditorUtilKt.getExistingLogIds(project));
        while (existingIds.contains(newId = UUID.randomUUID().toString())) {
        }
        String string = newId;
        if (string == null) {
            VcsLogTabsManager.$$$reportNull$$$0(24);
        }
        return string;
    }

    private /* synthetic */ void lambda$reopenLogTabs$1(VcsLogManager manager2, String id2, VcsLogManager.LogWindowKind kind) {
        if (kind == VcsLogManager.LogWindowKind.EDITOR) {
            this.openEditorLogTab(id2, false, null);
        } else if (kind == VcsLogManager.LogWindowKind.TOOL_WINDOW) {
            this.openToolWindowLogTab(manager2, id2, false, null);
        } else {
            LOG.warn("Unsupported log tab kind " + kind);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 19: 
            case 21: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 19: 
            case 21: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogTabsManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabId";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "openAnotherLogTab";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "openEditorLogTab";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "openToolWindowLogTab";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "generateShortDisplayName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "generateTabId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reopenLogTabs";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 19: 
            case 21: 
            case 24: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "openAnotherLogTab";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "openEditorLogTab";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "openToolWindowLogTab";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPersistentVcsLogUiFactory";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "generateShortDisplayName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFullName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "generateDisplayName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "generateTabId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 19: 
            case 21: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PersistentVcsLogUiFactory
    implements VcsLogManager.VcsLogUiFactory<MainVcsLogUi> {
        @NotNull
        private final VcsLogManager.VcsLogUiFactory<? extends MainVcsLogUi> myFactory;
        @NotNull
        private final VcsLogManager.LogWindowKind myLogWindowKind;

        PersistentVcsLogUiFactory(@NotNull VcsLogManager.VcsLogUiFactory<? extends MainVcsLogUi> factory2, VcsLogManager.LogWindowKind kind) {
            if (factory2 == null) {
                PersistentVcsLogUiFactory.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                PersistentVcsLogUiFactory.$$$reportNull$$$0(1);
            }
            this.myFactory = factory2;
            this.myLogWindowKind = kind;
        }

        @Override
        public MainVcsLogUi createLogUi(@NotNull Project project, @NotNull VcsLogData logData) {
            if (project == null) {
                PersistentVcsLogUiFactory.$$$reportNull$$$0(2);
            }
            if (logData == null) {
                PersistentVcsLogUiFactory.$$$reportNull$$$0(3);
            }
            MainVcsLogUi ui2 = this.myFactory.createLogUi(project, logData);
            VcsLogTabsManager.this.myUiProperties.addTab(ui2.getId(), this.myLogWindowKind);
            Disposer.register((Disposable)ui2, () -> {
                if (VcsLogTabsManager.this.myProject.isDisposed() || VcsLogTabsManager.this.myIsLogDisposing) {
                    return;
                }
                VcsLogTabsManager.this.myUiProperties.removeTab(ui2.getId());
            });
            return ui2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logData";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsManager$PersistentVcsLogUiFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createLogUi";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

