/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsUser;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFileRevision
extends VcsFileRevisionEx {
    @NotNull
    private final ContentRevision myRevision;
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final VcsUser myAuthor;
    @NotNull
    private final VcsUser myCommitter;
    private final long myAuthorTime;
    private final long myCommitTime;
    @NotNull
    private final String myFullMessage;
    private final boolean myIsDeleted;
    private byte @Nullable [] myContent;

    public VcsLogFileRevision(@NotNull VcsCommitMetadata commitMetadata, @NotNull ContentRevision revision, @NotNull FilePath path2, boolean isDeleted) {
        if (commitMetadata == null) {
            VcsLogFileRevision.$$$reportNull$$$0(0);
        }
        if (revision == null) {
            VcsLogFileRevision.$$$reportNull$$$0(1);
        }
        if (path2 == null) {
            VcsLogFileRevision.$$$reportNull$$$0(2);
        }
        this.myContent = null;
        this.myRevision = revision;
        this.myPath = path2;
        this.myAuthor = commitMetadata.getAuthor();
        this.myCommitter = commitMetadata.getCommitter();
        this.myAuthorTime = commitMetadata.getAuthorTime();
        this.myCommitTime = commitMetadata.getCommitTime();
        this.myFullMessage = commitMetadata.getFullMessage();
        this.myIsDeleted = isDeleted;
    }

    @Nullable
    public String getAuthor() {
        return this.myAuthor.getName();
    }

    @Nullable
    public String getAuthorEmail() {
        return this.myAuthor.getEmail();
    }

    @Nullable
    public String getCommitterName() {
        return this.myCommitter.getName();
    }

    @Nullable
    public String getCommitterEmail() {
        return this.myCommitter.getName();
    }

    @Nullable
    public String getCommitMessage() {
        return this.myFullMessage;
    }

    @NotNull
    public FilePath getPath() {
        FilePath filePath = this.myPath;
        if (filePath == null) {
            VcsLogFileRevision.$$$reportNull$$$0(3);
        }
        return filePath;
    }

    @Nullable
    public String getBranchName() {
        return null;
    }

    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    public byte[] loadContent() throws IOException, VcsException {
        if (this.myContent == null) {
            if (this.myRevision instanceof ByteBackedContentRevision) {
                this.myContent = ((ByteBackedContentRevision)this.myRevision).getContentAsBytes();
            } else {
                String content2 = this.myRevision.getContent();
                if (content2 != null) {
                    this.myContent = content2.getBytes(this.myPath.getCharset());
                }
            }
        }
        return this.myContent;
    }

    public byte @Nullable [] getContent() {
        return this.myContent;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber = this.myRevision.getRevisionNumber();
        if (vcsRevisionNumber == null) {
            VcsLogFileRevision.$$$reportNull$$$0(4);
        }
        return vcsRevisionNumber;
    }

    public Date getRevisionDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.myCommitTime);
        return cal.getTime();
    }

    @Nullable
    public Date getAuthorDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.myAuthorTime);
        return cal.getTime();
    }

    public boolean isDeleted() {
        return this.myIsDeleted;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitMetadata";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/history/VcsLogFileRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/history/VcsLogFileRevision";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

