/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.navigation.History;
import com.intellij.util.Consumer;
import com.intellij.util.PairFunction;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.history.FileHistoryColorManager;
import com.intellij.vcs.log.history.FileHistoryFilterUi;
import com.intellij.vcs.log.history.FileHistoryModel;
import com.intellij.vcs.log.history.FileHistoryPanel;
import com.intellij.vcs.log.history.FileHistoryUiProperties;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.highlighters.CurrentBranchHighlighter;
import com.intellij.vcs.log.ui.highlighters.MyCommitsHighlighter;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.column.TableColumnWidthProperty;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.awt.Color;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryUi
extends AbstractVcsLogUi {
    @NotNull
    @NonNls
    private static final String HELP_ID = "reference.versionControl.toolwindow.history";
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final VirtualFile myRoot;
    @Nullable
    private final Hash myRevision;
    @NotNull
    private final FileHistoryModel myFileHistoryModel;
    @NotNull
    private final FileHistoryUiProperties myUiProperties;
    @NotNull
    private final FileHistoryFilterUi myFilterUi;
    @NotNull
    private final FileHistoryPanel myFileHistoryPanel;
    @NotNull
    private final MyPropertiesChangeListener myPropertiesChangeListener;
    @NotNull
    private final History myHistory;

    public FileHistoryUi(@NotNull VcsLogData logData, @NotNull FileHistoryUiProperties uiProperties, @NotNull VisiblePackRefresher refresher, @NotNull FilePath path2, @Nullable Hash revision, @NotNull VirtualFile root) {
        if (logData == null) {
            FileHistoryUi.$$$reportNull$$$0(0);
        }
        if (uiProperties == null) {
            FileHistoryUi.$$$reportNull$$$0(1);
        }
        if (refresher == null) {
            FileHistoryUi.$$$reportNull$$$0(2);
        }
        if (path2 == null) {
            FileHistoryUi.$$$reportNull$$$0(3);
        }
        if (root == null) {
            FileHistoryUi.$$$reportNull$$$0(4);
        }
        super(FileHistoryUi.getFileHistoryLogId(path2, revision), logData, new FileHistoryColorManager(root, path2), refresher);
        assert (!path2.isDirectory());
        this.myPath = path2;
        this.myRoot = root;
        this.myRevision = revision;
        this.myUiProperties = uiProperties;
        this.myFileHistoryModel = new FileHistoryModel(logData, Objects.requireNonNull(logData.getLogProvider(root).getDiffHandler()), root){

            @Override
            @NotNull
            protected VisiblePack getVisiblePack() {
                VisiblePack visiblePack = FileHistoryUi.this.myVisiblePack;
                if (visiblePack == null) {
                    1.$$$reportNull$$$0(0);
                }
                return visiblePack;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/history/FileHistoryUi$1", "getVisiblePack"));
            }
        };
        this.myFilterUi = new FileHistoryFilterUi(path2, revision, root, uiProperties);
        this.myFileHistoryPanel = new FileHistoryPanel(this, this.myFileHistoryModel, logData, path2, this);
        this.getTable().addHighlighter(((MyCommitsHighlighter.Factory)LOG_HIGHLIGHTER_FACTORY_EP.findExtensionOrFail(MyCommitsHighlighter.Factory.class)).createHighlighter(this.getLogData(), this));
        if (this.myRevision != null) {
            this.getTable().addHighlighter(new RevisionHistoryHighlighter(this.myLogData.getStorage(), this.myRevision, this.myRoot));
        } else {
            this.getTable().addHighlighter(((CurrentBranchHighlighter.Factory)LOG_HIGHLIGHTER_FACTORY_EP.findExtensionOrFail(CurrentBranchHighlighter.Factory.class)).createHighlighter(this.getLogData(), this));
        }
        this.myPropertiesChangeListener = new MyPropertiesChangeListener();
        this.myUiProperties.addChangeListener(this.myPropertiesChangeListener);
        this.myHistory = VcsLogUiUtil.installNavigationHistory(this);
    }

    @NotNull
    public static String getFileHistoryLogId(@NotNull FilePath path2, @Nullable Hash revision) {
        if (path2 == null) {
            FileHistoryUi.$$$reportNull$$$0(5);
        }
        String string = path2.getPath() + (revision == null ? "" : revision.asString());
        if (string == null) {
            FileHistoryUi.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public void setVisiblePack(@NotNull VisiblePack pack) {
        if (pack == null) {
            FileHistoryUi.$$$reportNull$$$0(7);
        }
        super.setVisiblePack(pack);
        if (pack.canRequestMore()) {
            this.requestMore(EmptyRunnable.INSTANCE);
        }
    }

    @Nullable
    public VcsFileRevision createRevision(@Nullable VcsCommitMetadata commit2) {
        return this.myFileHistoryModel.createRevision(commit2);
    }

    @Nullable
    public FilePath getPathInCommit(@NotNull Hash hash) {
        if (hash == null) {
            FileHistoryUi.$$$reportNull$$$0(8);
        }
        return this.myFileHistoryModel.getPathInCommit(hash);
    }

    @Override
    protected <T> void handleCommitNotFound(@NotNull T commitId, boolean commitExists, @NotNull PairFunction<? super VisiblePack, ? super T, Integer> rowGetter) {
        if (commitId == null) {
            FileHistoryUi.$$$reportNull$$$0(9);
        }
        if (rowGetter == null) {
            FileHistoryUi.$$$reportNull$$$0(10);
        }
        if (!commitExists) {
            super.handleCommitNotFound(commitId, false, rowGetter);
            return;
        }
        if (this.getFilterUi().getFilters().get(VcsLogFilterCollection.BRANCH_FILTER) != null) {
            String text2 = VcsLogBundle.message((String)"file.history.commit.not.found.in.branch", (Object[])new Object[]{FileHistoryUi.getCommitPresentation(commitId), this.myPath.getName()});
            this.showWarningWithLink(text2, VcsLogBundle.message((String)"file.history.commit.not.found.view.and.show.all.branches.link", (Object[])new Object[0]), () -> {
                this.myUiProperties.set(FileHistoryUiProperties.SHOW_ALL_BRANCHES, true);
                this.invokeOnChange(() -> this.jumpTo(commitId, rowGetter, (SettableFuture<? super Boolean>)SettableFuture.create(), false, true));
            });
        } else {
            String text3 = VcsLogBundle.message((String)"file.history.commit.not.found", (Object[])new Object[]{FileHistoryUi.getCommitPresentation(commitId), this.myPath.getName()});
            this.showWarningWithLink(text3, VcsLogBundle.message((String)"file.history.commit.not.found.view.in.log.link", (Object[])new Object[0]), () -> VcsLogContentUtil.runInMainLog(this.myProject, (Consumer<? super MainVcsLogUi>)((Consumer)ui2 -> {
                if (commitId instanceof Hash) {
                    ui2.getVcsLog().jumpToCommit((Hash)commitId, this.myRoot);
                } else if (commitId instanceof String) {
                    ui2.getVcsLog().jumpToReference((String)commitId);
                }
            })));
        }
    }

    public boolean matches(@NotNull FilePath targetPath, @Nullable Hash targetRevision) {
        if (targetPath == null) {
            FileHistoryUi.$$$reportNull$$$0(11);
        }
        return this.myPath.equals(targetPath) && Objects.equals(this.myRevision, targetRevision);
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        FileHistoryFilterUi fileHistoryFilterUi = this.myFilterUi;
        if (fileHistoryFilterUi == null) {
            FileHistoryUi.$$$reportNull$$$0(12);
        }
        return fileHistoryFilterUi;
    }

    @Override
    protected void onVisiblePackUpdated(boolean permGraphChanged) {
        ((FileHistoryColorManager)this.myColorManager).update(this.myVisiblePack);
        this.myFileHistoryPanel.updateDataPack(this.myVisiblePack, permGraphChanged);
        this.myFileHistoryPanel.getGraphTable().rootColumnUpdated();
    }

    @Override
    @NotNull
    public VcsLogGraphTable getTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myFileHistoryPanel.getGraphTable();
        if (vcsLogGraphTable == null) {
            FileHistoryUi.$$$reportNull$$$0(13);
        }
        return vcsLogGraphTable;
    }

    @Override
    @NotNull
    public JComponent getMainComponent() {
        FileHistoryPanel fileHistoryPanel = this.myFileHistoryPanel;
        if (fileHistoryPanel == null) {
            FileHistoryUi.$$$reportNull$$$0(14);
        }
        return fileHistoryPanel;
    }

    @Override
    @Nullable
    public String getHelpId() {
        return HELP_ID;
    }

    private void updateFilter() {
        this.myRefresher.onFiltersChange(this.myFilterUi.getFilters());
    }

    @Override
    @NotNull
    public FileHistoryUiProperties getProperties() {
        FileHistoryUiProperties fileHistoryUiProperties = this.myUiProperties;
        if (fileHistoryUiProperties == null) {
            FileHistoryUi.$$$reportNull$$$0(15);
        }
        return fileHistoryUiProperties;
    }

    @Override
    @Nullable
    public History getNavigationHistory() {
        return this.myHistory;
    }

    @Override
    public void dispose() {
        this.myUiProperties.removeChangeListener(this.myPropertiesChangeListener);
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryUi";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowGetter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryUi";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileHistoryLogId";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterUi";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainComponent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileHistoryLogId";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setVisiblePack";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPathInCommit";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitNotFound";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RevisionHistoryHighlighter
    implements VcsLogHighlighter {
        @NotNull
        private final JBColor myBgColor;
        @NotNull
        private final VcsLogStorage myStorage;
        @NotNull
        private final Hash myRevision;
        @NotNull
        private final VirtualFile myRoot;
        @Nullable
        private Condition<Integer> myCondition;
        @NotNull
        private VcsLogDataPack myVisiblePack;

        RevisionHistoryHighlighter(@NotNull VcsLogStorage storage2, @NotNull Hash revision, @NotNull VirtualFile root) {
            if (storage2 == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(0);
            }
            if (revision == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(1);
            }
            if (root == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(2);
            }
            this.myBgColor = JBColor.namedColor((String)"VersionControl.FileHistory.Commit.selectedBranchBackground", (Color)new JBColor(new Color(0xFFFEE4), new Color(4802879)));
            this.myVisiblePack = VisiblePack.EMPTY;
            this.myStorage = storage2;
            this.myRevision = revision;
            this.myRoot = root;
        }

        @NotNull
        public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId, @NotNull VcsShortCommitDetails commitDetails2, boolean isSelected) {
            if (commitDetails2 == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(3);
            }
            if (isSelected) {
                VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
                if (vcsCommitStyle == null) {
                    RevisionHistoryHighlighter.$$$reportNull$$$0(4);
                }
                return vcsCommitStyle;
            }
            if (this.myCondition == null) {
                this.myCondition = this.getCondition();
            }
            if (this.myCondition.value((Object)commitId)) {
                VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.background((Color)this.myBgColor);
                if (vcsCommitStyle == null) {
                    RevisionHistoryHighlighter.$$$reportNull$$$0(5);
                }
                return vcsCommitStyle;
            }
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(6);
            }
            return vcsCommitStyle;
        }

        @NotNull
        private Condition<Integer> getCondition() {
            if (!(this.myVisiblePack instanceof VisiblePack)) {
                Condition condition = Conditions.alwaysFalse();
                if (condition == null) {
                    RevisionHistoryHighlighter.$$$reportNull$$$0(7);
                }
                return condition;
            }
            DataPackBase dataPack = ((VisiblePack)this.myVisiblePack).getDataPack();
            if (!(dataPack instanceof DataPack)) {
                Condition condition = Conditions.alwaysFalse();
                if (condition == null) {
                    RevisionHistoryHighlighter.$$$reportNull$$$0(8);
                }
                return condition;
            }
            Set<Integer> heads = Collections.singleton(this.myStorage.getCommitIndex(this.myRevision, this.myRoot));
            Condition condition = ((DataPack)dataPack).getPermanentGraph().getContainedInBranchCondition(heads);
            if (condition == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(9);
            }
            return condition;
        }

        public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
            if (dataPack == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(10);
            }
            this.myVisiblePack = dataPack;
            this.myCondition = this.myVisiblePack.getFilters().get(VcsLogFilterCollection.REVISION_FILTER) != null ? Conditions.alwaysFalse() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitDetails";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryUi$RevisionHistoryHighlighter";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataPack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryUi$RevisionHistoryHighlighter";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStyle";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getStyle";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyPropertiesChangeListener
    implements VcsLogUiProperties.PropertiesChangeListener {
        private MyPropertiesChangeListener() {
        }

        @Override
        public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property2) {
            if (property2 == null) {
                MyPropertiesChangeListener.$$$reportNull$$$0(0);
            }
            if (CommonUiProperties.SHOW_DETAILS.equals(property2)) {
                FileHistoryUi.this.myFileHistoryPanel.showDetails(FileHistoryUi.this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
            } else if (FileHistoryUiProperties.SHOW_ALL_BRANCHES.equals(property2)) {
                FileHistoryUi.this.updateFilter();
            } else if (CommonUiProperties.COLUMN_ID_ORDER.equals(property2)) {
                FileHistoryUi.this.getTable().onColumnOrderSettingChanged();
            } else if (property2 instanceof TableColumnWidthProperty) {
                FileHistoryUi.this.getTable().forceReLayout(((TableColumnWidthProperty)property2).getColumn());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/history/FileHistoryUi$MyPropertiesChangeListener", "onPropertyChanged"));
        }
    }
}

