/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.linearBek;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.BekBaseController;
import com.intellij.vcs.log.graph.impl.facade.CascadeController;
import com.intellij.vcs.log.graph.impl.facade.GraphChangesUtil;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import com.intellij.vcs.log.graph.linearBek.LinearBekController;
import com.intellij.vcs.log.graph.linearBek.LinearBekGraph;
import com.intellij.vcs.log.graph.linearBek.LinearBekGraphBuilder;
import com.intellij.vcs.log.graph.utils.BfsSearch;
import com.intellij.vcs.log.graph.utils.IntHashSetFlags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 52\u00020\u0001:\u000245B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0014H\u0014J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00142\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$2\u0006\u0010%\u001a\u00020\u0017H\u0002J\b\u0010&\u001a\u00020\fH\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\u00142\u0006\u0010!\u001a\u00020\"H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J3\u0010+\u001a\u0004\u0018\u0001H,\"\u0004\b\u0000\u0010,2\u0006\u0010-\u001a\u00020\u001c2\u0014\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u0001H,0/H\u0002\u00a2\u0006\u0002\u00100J\u0012\u00101\u001a\u0004\u0018\u00010\u00142\u0006\u00102\u001a\u000203H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/vcs/log/graph/linearBek/LinearBekController;", "Lcom/intellij/vcs/log/graph/impl/facade/CascadeController;", "controller", "Lcom/intellij/vcs/log/graph/impl/facade/BekBaseController;", "permanentGraphInfo", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "(Lcom/intellij/vcs/log/graph/impl/facade/BekBaseController;Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;)V", "bekGraphLayout", "Lcom/intellij/vcs/log/graph/linearBek/LinearBekController$BekGraphLayout;", "compiledGraph", "Lcom/intellij/vcs/log/graph/linearBek/LinearBekGraph;", "delegateGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "getDelegateGraph", "()Lcom/intellij/vcs/log/graph/api/LinearGraph;", "linearBekGraphBuilder", "Lcom/intellij/vcs/log/graph/linearBek/LinearBekGraphBuilder;", "mergeCommits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "collapseAll", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController$LinearGraphAnswer;", "collapseNode", "node", "Lcom/intellij/vcs/log/graph/api/elements/GraphNode;", "collectChildFragments", "", "Lcom/intellij/vcs/log/graph/linearBek/LinearBekGraphBuilder$MergeFragment;", "merge", "", "delegateGraphChanged", "delegateAnswer", "expandAll", "expandEdge", "edge", "Lcom/intellij/vcs/log/graph/api/elements/GraphEdge;", "getAllAdjacentDottedEdges", "", "graphElement", "getCompiledGraph", "highlightEdge", "highlightNode", "isCollapsed", "", "iterateMerges", "T", "start", "function", "Lkotlin/Function1;", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "performAction", "action", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController$LinearGraphAction;", "BekGraphLayout", "Companion", "intellij.platform.vcs.log.graph.impl"})
public final class LinearBekController
extends CascadeController {
    private final LinearBekGraph compiledGraph;
    private final BekGraphLayout bekGraphLayout;
    private final LinearBekGraphBuilder linearBekGraphBuilder;
    private final IntSet mergeCommits;
    private static final Logger LOG;
    private static final int MAX_COLLAPSED_MERGES = 10;
    @NotNull
    public static final Companion Companion;

    private final LinearGraph getDelegateGraph() {
        LinearGraphController linearGraphController = this.getDelegateController();
        Intrinsics.checkNotNullExpressionValue((Object)linearGraphController, (String)"delegateController");
        LinearGraph linearGraph = linearGraphController.getCompiledGraph();
        Intrinsics.checkNotNullExpressionValue((Object)linearGraph, (String)"delegateController.compiledGraph");
        return linearGraph;
    }

    @Override
    @NotNull
    protected LinearGraphController.LinearGraphAnswer delegateGraphChanged(@NotNull LinearGraphController.LinearGraphAnswer delegateAnswer) {
        Intrinsics.checkNotNullParameter((Object)delegateAnswer, (String)"delegateAnswer");
        return delegateAnswer;
    }

    @Override
    @Nullable
    protected LinearGraphController.LinearGraphAnswer performAction(@NotNull LinearGraphController.LinearGraphAction action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        if (action2.getType() == GraphAction.Type.BUTTON_COLLAPSE) {
            return this.collapseAll();
        }
        if (action2.getType() == GraphAction.Type.BUTTON_EXPAND) {
            return this.expandAll();
        }
        PrintElementWithGraphElement printElementWithGraphElement = action2.getAffectedElement();
        if (printElementWithGraphElement == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)printElementWithGraphElement, (String)"action.affectedElement ?: return null");
        PrintElementWithGraphElement affectedElement = printElementWithGraphElement;
        if (action2.getType() == GraphAction.Type.MOUSE_CLICK) {
            GraphElement graphElement = affectedElement.getGraphElement();
            Intrinsics.checkNotNullExpressionValue((Object)graphElement, (String)"affectedElement.graphElement");
            GraphElement graphElement2 = graphElement;
            if (graphElement2 instanceof GraphNode) {
                LinearGraphController.LinearGraphAnswer answer = this.collapseNode((GraphNode)graphElement2);
                if (answer != null) {
                    return answer;
                }
                for (GraphEdge dottedEdge : this.getAllAdjacentDottedEdges((GraphNode)graphElement2)) {
                    LinearGraphController.LinearGraphAnswer expandedAnswer = this.expandEdge(dottedEdge);
                    if (expandedAnswer == null) continue;
                    return expandedAnswer;
                }
            } else if (graphElement2 instanceof GraphEdge) {
                return this.expandEdge((GraphEdge)graphElement2);
            }
        } else if (action2.getType() == GraphAction.Type.MOUSE_OVER) {
            GraphElement graphElement = affectedElement.getGraphElement();
            Intrinsics.checkNotNullExpressionValue((Object)graphElement, (String)"affectedElement.graphElement");
            GraphElement graphElement3 = graphElement;
            if (graphElement3 instanceof GraphNode) {
                LinearGraphController.LinearGraphAnswer answer = this.highlightNode((GraphNode)graphElement3);
                if (answer != null) {
                    return answer;
                }
                for (GraphEdge dottedEdge : this.getAllAdjacentDottedEdges((GraphNode)graphElement3)) {
                    LinearGraphController.LinearGraphAnswer highlightAnswer = this.highlightEdge(dottedEdge);
                    if (highlightAnswer == null) continue;
                    return highlightAnswer;
                }
            } else if (graphElement3 instanceof GraphEdge) {
                return this.highlightEdge((GraphEdge)graphElement3);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<GraphEdge> getAllAdjacentDottedEdges(GraphNode graphElement) {
        void $this$filterTo$iv$iv;
        List<GraphEdge> list2 = this.compiledGraph.getAdjacentEdges(graphElement.getNodeIndex(), EdgeFilter.ALL);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"compiledGraph.getAdjacen\u2026odeIndex, EdgeFilter.ALL)");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GraphEdge graphEdge = (GraphEdge)element$iv$iv;
            boolean bl = false;
            if (!(graphEdge.getType() == GraphEdgeType.DOTTED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final LinearGraphController.LinearGraphAnswer expandAll() {
        return new LinearGraphController.LinearGraphAnswer(this, GraphChangesUtil.SOME_CHANGES){
            final /* synthetic */ LinearBekController this$0;

            @NotNull
            public Runnable getGraphUpdater() {
                return new Runnable(this){
                    final /* synthetic */ expandAll.1 this$0;

                    public final void run() {
                        LinearBekController.access$getCompiledGraph$p((LinearBekController)this.this$0.this$0).myDottedEdges.removeAll();
                        LinearBekController.access$getCompiledGraph$p((LinearBekController)this.this$0.this$0).myHiddenEdges.removeAll();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                };
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
    }

    private final LinearGraphController.LinearGraphAnswer collapseAll() {
        LinearBekGraph.WorkingLinearBekGraph workingGraph = new LinearBekGraph.WorkingLinearBekGraph(this.compiledGraph);
        new LinearBekGraphBuilder(workingGraph, this.bekGraphLayout).collapseAll();
        return new LinearGraphController.LinearGraphAnswer(this, workingGraph, GraphChangesUtil.edgesReplaced(workingGraph.getRemovedEdges(), workingGraph.getAddedEdges(), this.getDelegateGraph())){
            final /* synthetic */ LinearBekController this$0;
            final /* synthetic */ LinearBekGraph.WorkingLinearBekGraph $workingGraph;

            @NotNull
            public Runnable getGraphUpdater() {
                return new Runnable(this){
                    final /* synthetic */ collapseAll.1 this$0;

                    public final void run() {
                        this.this$0.$workingGraph.applyChanges();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                };
            }
            {
                this.this$0 = this$0;
                this.$workingGraph = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
    }

    private final <T> T iterateMerges(int start2, Function1<? super Integer, ? extends T> function) {
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph(this.getDelegateGraph());
        Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"LinearGraphUtils.asLiteLinearGraph(delegateGraph)");
        BfsSearch search2 = new BfsSearch<T>(this, start2, start2, liteLinearGraph, new IntHashSetFlags(this.getDelegateGraph().nodesCount()), false, 200){
            @NotNull
            private final Queue<Integer> queue;
            final /* synthetic */ LinearBekController this$0;
            final /* synthetic */ int $start;

            @NotNull
            protected Queue<Integer> getQueue() {
                return this.queue;
            }
            {
                void it;
                this.this$0 = this$0;
                this.$start = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
                PriorityQueue<T> priorityQueue = new PriorityQueue<T>(1, Collections.reverseOrder());
                boolean bl = false;
                boolean bl2 = false;
                PriorityQueue<T> priorityQueue2 = priorityQueue;
                iterateMerges.search.1 var13_12 = this;
                boolean bl3 = false;
                it.add(this.$start);
                Unit unit = Unit.INSTANCE;
                var13_12.queue = priorityQueue;
            }
        };
        return search2.find((Function1)new Function1<Integer, T>(this, function){
            final /* synthetic */ LinearBekController this$0;
            final /* synthetic */ Function1 $function;

            @Nullable
            public final T invoke(int it) {
                return (T)(LinearBekController.access$getMergeCommits$p(this.this$0).contains(it) ? this.$function.invoke((Object)it) : null);
            }
            {
                this.this$0 = linearBekController;
                this.$function = function1;
                super(1);
            }
        });
    }

    private final boolean isCollapsed(int merge) {
        return LinearGraphUtils.getDownNodes(this.compiledGraph, merge).size() == 1;
    }

    private final LinearGraphController.LinearGraphAnswer highlightNode(GraphNode node) {
        return (LinearGraphController.LinearGraphAnswer)this.iterateMerges(node.getNodeIndex(), (Function1)new Function1<Integer, LinearGraphController.LinearGraphAnswer>(this, node){
            final /* synthetic */ LinearBekController this$0;
            final /* synthetic */ GraphNode $node;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final LinearGraphController.LinearGraphAnswer invoke(int merge) {
                if (!LinearBekController.access$isCollapsed(this.this$0, merge)) {
                    void destination$iv;
                    void $this$flatMapTo$iv;
                    Set fragments = LinearBekController.access$collectChildFragments(this.this$0, merge);
                    if (fragments.isEmpty()) {
                        return null;
                    }
                    Iterable iterable = fragments;
                    boolean bl = false;
                    Collection collection = new LinkedHashSet<E>();
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv : $this$flatMapTo$iv) {
                        LinearBekGraphBuilder.MergeFragment it = (LinearBekGraphBuilder.MergeFragment)element$iv;
                        boolean bl2 = false;
                        Iterable list$iv = it.getAllNodes();
                        CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                    }
                    Set nodesToHighlight = (Set)destination$iv;
                    if (nodesToHighlight.contains(this.$node.getNodeIndex())) {
                        return LinearGraphUtils.createSelectedAnswer(LinearBekController.access$getCompiledGraph$p(this.this$0), nodesToHighlight);
                    }
                }
                return null;
            }
            {
                this.this$0 = linearBekController;
                this.$node = graphNode;
                super(1);
            }
        });
    }

    private final LinearGraphController.LinearGraphAnswer collapseNode(GraphNode node) {
        return (LinearGraphController.LinearGraphAnswer)this.iterateMerges(node.getNodeIndex(), (Function1)new Function1<Integer, LinearGraphController.LinearGraphAnswer>(this, node){
            final /* synthetic */ LinearBekController this$0;
            final /* synthetic */ GraphNode $node;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final LinearGraphController.LinearGraphAnswer invoke(int merge) {
                if (!LinearBekController.access$isCollapsed(this.this$0, merge)) {
                    void $this$flatMapTo$iv;
                    Set fragments = LinearBekController.access$collectChildFragments(this.this$0, merge);
                    if (fragments.isEmpty()) {
                        return null;
                    }
                    Iterable iterable = fragments;
                    Collection destination$iv = new TreeSet<T>(Comparator.reverseOrder());
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv : $this$flatMapTo$iv) {
                        LinearBekGraphBuilder.MergeFragment f = (LinearBekGraphBuilder.MergeFragment)element$iv;
                        boolean bl = false;
                        Set<Integer> set2 = f.getTailsAndBody();
                        Intrinsics.checkNotNullExpressionValue(set2, (String)"f.tailsAndBody");
                        Iterable list$iv = SetsKt.plus(set2, (Object)f.getParent());
                        CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                    }
                    TreeSet nodesToCollapse = (TreeSet)destination$iv;
                    if (!nodesToCollapse.contains(this.$node.getNodeIndex())) {
                        boolean bl;
                        block9: {
                            Iterable $this$any$iv = fragments;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    LinearBekGraphBuilder.MergeFragment it = (LinearBekGraphBuilder.MergeFragment)element$iv;
                                    boolean bl2 = false;
                                    if (!(it.getLeftChild() == this.$node.getNodeIndex())) continue;
                                    bl = true;
                                    break block9;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) {
                            return null;
                        }
                    }
                    for (Integer i2 : nodesToCollapse) {
                        LinearBekGraphBuilder linearBekGraphBuilder = LinearBekController.access$getLinearBekGraphBuilder$p(this.this$0);
                        Integer n = i2;
                        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"i");
                        linearBekGraphBuilder.collapseFragment(n);
                    }
                    return new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.SOME_CHANGES);
                }
                return null;
            }
            {
                this.this$0 = linearBekController;
                this.$node = graphNode;
                super(1);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Set<LinearBekGraphBuilder.MergeFragment> collectChildFragments(int merge) {
        boolean bl = false;
        Set result2 = new LinkedHashSet();
        LinkedHashSet toProcess = SetsKt.linkedSetOf((Object[])new Integer[]{merge});
        while (true) {
            Collection collection = toProcess;
            boolean bl2 = false;
            if (!(!collection.isEmpty())) return result2;
            Object object = CollectionsKt.first((Iterable)toProcess);
            boolean bl3 = false;
            boolean bl4 = false;
            int it = ((Number)object).intValue();
            boolean bl5 = false;
            toProcess.remove(it);
            int nextNode = ((Number)object).intValue();
            Object object2 = this.linearBekGraphBuilder.getFragment(nextNode);
            if (object2 == null) continue;
            object = object2;
            bl3 = false;
            bl4 = false;
            Object fragment2 = object;
            boolean bl6 = false;
            Object object3 = fragment2;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"fragment");
            result2.add(object3);
            toProcess.addAll((Collection)((LinearBekGraphBuilder.MergeFragment)fragment2).getTailsAndBody());
            object2 = object;
            if (object2 == null) {
                continue;
            }
            if (result2.size() > 10) return result2;
        }
    }

    private final LinearGraphController.LinearGraphAnswer highlightEdge(GraphEdge edge) {
        if (edge.getType() != GraphEdgeType.DOTTED) {
            return null;
        }
        return LinearGraphUtils.createSelectedAnswer(this.compiledGraph, SetsKt.setOf((Object[])new Integer[]{edge.getUpNodeIndex(), edge.getDownNodeIndex()}));
    }

    private final LinearGraphController.LinearGraphAnswer expandEdge(GraphEdge edge) {
        if (edge.getType() != GraphEdgeType.DOTTED) {
            return null;
        }
        return new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.edgesReplaced(SetsKt.setOf((Object)edge), this.compiledGraph.expandEdge(edge), this.getDelegateGraph()));
    }

    @Override
    @NotNull
    public LinearGraph getCompiledGraph() {
        return this.compiledGraph;
    }

    public LinearBekController(@NotNull BekBaseController controller, @NotNull PermanentGraphInfo<?> permanentGraphInfo) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(permanentGraphInfo, (String)"permanentGraphInfo");
        super(controller, permanentGraphInfo);
        this.compiledGraph = new LinearBekGraph(this.getDelegateGraph());
        GraphLayout graphLayout = permanentGraphInfo.getPermanentGraphLayout();
        Intrinsics.checkNotNullExpressionValue((Object)graphLayout, (String)"permanentGraphInfo.permanentGraphLayout");
        BekIntMap bekIntMap = controller.getBekIntMap();
        Intrinsics.checkNotNullExpressionValue((Object)bekIntMap, (String)"controller.bekIntMap");
        this.bekGraphLayout = new BekGraphLayout(graphLayout, bekIntMap);
        this.linearBekGraphBuilder = new LinearBekGraphBuilder(this.compiledGraph, this.bekGraphLayout);
        long start2 = System.currentTimeMillis();
        IntSet intSet = this.linearBekGraphBuilder.collapseAll();
        Intrinsics.checkNotNullExpressionValue((Object)intSet, (String)"linearBekGraphBuilder.collapseAll()");
        this.mergeCommits = intSet;
        LOG.debug("Linear bek took " + (double)(System.currentTimeMillis() - start2) / 1000.0 + " sec");
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(LinearBekController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Linea\u2026ekController::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ LinearBekGraph access$getCompiledGraph$p(LinearBekController $this) {
        return $this.compiledGraph;
    }

    public static final /* synthetic */ IntSet access$getMergeCommits$p(LinearBekController $this) {
        return $this.mergeCommits;
    }

    public static final /* synthetic */ boolean access$isCollapsed(LinearBekController $this, int merge) {
        return $this.isCollapsed(merge);
    }

    public static final /* synthetic */ Set access$collectChildFragments(LinearBekController $this, int merge) {
        return $this.collectChildFragments(merge);
    }

    public static final /* synthetic */ LinearBekGraphBuilder access$getLinearBekGraphBuilder$p(LinearBekController $this) {
        return $this.linearBekGraphBuilder;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/graph/linearBek/LinearBekController$BekGraphLayout;", "Lcom/intellij/vcs/log/graph/api/GraphLayout;", "graphLayout", "bekIntMap", "Lcom/intellij/vcs/log/graph/impl/facade/bek/BekIntMap;", "(Lcom/intellij/vcs/log/graph/api/GraphLayout;Lcom/intellij/vcs/log/graph/impl/facade/bek/BekIntMap;)V", "getHeadNodeIndex", "", "", "getLayoutIndex", "nodeIndex", "getOneOfHeadNodeIndex", "intellij.platform.vcs.log.graph.impl"})
    private static final class BekGraphLayout
    implements GraphLayout {
        private final GraphLayout graphLayout;
        private final BekIntMap bekIntMap;

        @Override
        public int getLayoutIndex(int nodeIndex) {
            return this.graphLayout.getLayoutIndex(this.bekIntMap.getUsualIndex(nodeIndex));
        }

        @Override
        public int getOneOfHeadNodeIndex(int nodeIndex) {
            int usualIndex = this.graphLayout.getOneOfHeadNodeIndex(this.bekIntMap.getUsualIndex(nodeIndex));
            return this.bekIntMap.getBekIndex(usualIndex);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Integer> getHeadNodeIndex() {
            void $this$mapTo$iv$iv;
            List<Integer> list2 = this.graphLayout.getHeadNodeIndex();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"graphLayout.headNodeIndex");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Integer n = (Integer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                Integer n2 = this.bekIntMap.getBekIndex(v1.intValue());
                collection.add(n2);
            }
            return (List)destination$iv$iv;
        }

        public BekGraphLayout(@NotNull GraphLayout graphLayout, @NotNull BekIntMap bekIntMap) {
            Intrinsics.checkNotNullParameter((Object)graphLayout, (String)"graphLayout");
            Intrinsics.checkNotNullParameter((Object)bekIntMap, (String)"bekIntMap");
            this.graphLayout = graphLayout;
            this.bekIntMap = bekIntMap;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/vcs/log/graph/linearBek/LinearBekController$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MAX_COLLAPSED_MERGES", "", "intellij.platform.vcs.log.graph.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

