/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.collapsing.CollapsedGraph;
import com.intellij.vcs.log.graph.collapsing.DottedFilterEdgesGenerator;
import com.intellij.vcs.log.graph.collapsing.DottedFilterEdgesGeneratorKt;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005R\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0014J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005R\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/vcs/log/graph/collapsing/InplaceFilterEdgesGenerator;", "Lcom/intellij/vcs/log/graph/collapsing/DottedFilterEdgesGenerator;", "collapsedGraph", "Lcom/intellij/vcs/log/graph/collapsing/CollapsedGraph;", "modification", "Lcom/intellij/vcs/log/graph/collapsing/CollapsedGraph$Modification;", "toHide", "", "", "(Lcom/intellij/vcs/log/graph/collapsing/CollapsedGraph;Lcom/intellij/vcs/log/graph/collapsing/CollapsedGraph$Modification;Ljava/util/Set;)V", "addDottedArrow", "", "nodeIndex", "isUp", "", "addDottedEdge", "nodeIndex1", "nodeIndex2", "hasDottedEdges", "nodeIsVisible", "intellij.platform.vcs.log.graph.impl"})
public final class InplaceFilterEdgesGenerator
extends DottedFilterEdgesGenerator {
    private final CollapsedGraph collapsedGraph;
    private final CollapsedGraph.Modification modification;
    private final Set<Integer> toHide;

    @Override
    protected boolean nodeIsVisible(int nodeIndex) {
        return !this.toHide.contains(nodeIndex);
    }

    @Override
    protected void addDottedEdge(int nodeIndex1, int nodeIndex2) {
        int delegateIndex1 = this.collapsedGraph.convertToDelegateNodeIndex(nodeIndex1);
        int delegateIndex2 = this.collapsedGraph.convertToDelegateNodeIndex(nodeIndex2);
        this.modification.createEdge(GraphEdge.createNormalEdge(delegateIndex1, delegateIndex2, GraphEdgeType.DOTTED));
    }

    @Override
    protected void addDottedArrow(int nodeIndex, boolean isUp) {
        int delegateIndex = this.collapsedGraph.convertToDelegateNodeIndex(nodeIndex);
        this.modification.createEdge(GraphEdge.createEdgeWithTargetId(delegateIndex, null, isUp ? GraphEdgeType.DOTTED_ARROW_UP : GraphEdgeType.DOTTED_ARROW_DOWN));
    }

    @Override
    protected boolean hasDottedEdges(int nodeIndex, boolean isUp) {
        int delegateIndex = this.collapsedGraph.convertToDelegateNodeIndex(nodeIndex);
        return DottedFilterEdgesGeneratorKt.access$hasDottedEdges(this.modification, delegateIndex, isUp);
    }

    public InplaceFilterEdgesGenerator(@NotNull CollapsedGraph collapsedGraph, @NotNull CollapsedGraph.Modification modification, @NotNull Set<Integer> toHide) {
        Intrinsics.checkNotNullParameter((Object)collapsedGraph, (String)"collapsedGraph");
        Intrinsics.checkNotNullParameter((Object)modification, (String)"modification");
        Intrinsics.checkNotNullParameter(toHide, (String)"toHide");
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph(collapsedGraph.getCompiledGraph());
        Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"LinearGraphUtils.asLiteL\u2026apsedGraph.compiledGraph)");
        super(liteLinearGraph, 0, collapsedGraph.getCompiledGraph().nodesCount() - 1);
        this.collapsedGraph = collapsedGraph;
        this.modification = modification;
        this.toHide = toHide;
    }
}

