/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.CollapsedActionManager;
import com.intellij.vcs.log.graph.collapsing.CollapsedGraph;
import com.intellij.vcs.log.graph.impl.facade.CascadeController;
import com.intellij.vcs.log.graph.impl.facade.GraphChanges;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.utils.GraphUtilKt;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollapsedController
extends CascadeController {
    @NotNull
    private CollapsedGraph myCollapsedGraph;

    public CollapsedController(@NotNull LinearGraphController delegateLinearGraphController, @NotNull PermanentGraphInfo<?> permanentGraphInfo, @Nullable Set<Integer> idsOfVisibleBranches) {
        if (delegateLinearGraphController == null) {
            CollapsedController.$$$reportNull$$$0(0);
        }
        if (permanentGraphInfo == null) {
            CollapsedController.$$$reportNull$$$0(1);
        }
        super(delegateLinearGraphController, permanentGraphInfo);
        UnsignedBitSet initVisibility = GraphUtilKt.getReachableNodes(permanentGraphInfo.getLinearGraph(), idsOfVisibleBranches);
        this.myCollapsedGraph = CollapsedGraph.newInstance(this.getDelegateController().getCompiledGraph(), initVisibility);
    }

    @Override
    @NotNull
    protected LinearGraphController.LinearGraphAnswer delegateGraphChanged(@NotNull LinearGraphController.LinearGraphAnswer delegateAnswer) {
        if (delegateAnswer == null) {
            CollapsedController.$$$reportNull$$$0(2);
        }
        if (delegateAnswer.getGraphChanges() != null) {
            LinearGraph delegateGraph = this.getDelegateController().getCompiledGraph();
            this.myCollapsedGraph = CollapsedGraph.updateInstance(this.myCollapsedGraph, delegateGraph);
            this.applyDelegateChanges(delegateGraph, delegateAnswer.getGraphChanges());
        }
        LinearGraphController.LinearGraphAnswer linearGraphAnswer = delegateAnswer;
        if (linearGraphAnswer == null) {
            CollapsedController.$$$reportNull$$$0(3);
        }
        return linearGraphAnswer;
    }

    private void applyDelegateChanges(LinearGraph graph2, GraphChanges<Integer> changes) {
        HashSet<Integer> nodesToShow = new HashSet<Integer>();
        for (GraphChanges.Edge<Integer> edge : changes.getChangedEdges()) {
            Integer downIndex;
            Integer downId;
            Integer upIndex;
            if (edge.removed()) continue;
            Integer upId = edge.upNodeId();
            if (upId != null && (upIndex = graph2.getNodeIndex(upId)) != null) {
                nodesToShow.add(upIndex);
            }
            if ((downId = edge.downNodeId()) == null || (downIndex = graph2.getNodeIndex(downId)) == null) continue;
            nodesToShow.add(downIndex);
        }
        for (GraphChanges.Node node : changes.getChangedNodes()) {
            Integer nodeIndex;
            if (node.removed() || (nodeIndex = graph2.getNodeIndex((Integer)node.getNodeId())) == null) continue;
            nodesToShow.add(nodeIndex);
        }
        CollapsedActionManager.expandNodes(this.myCollapsedGraph, nodesToShow);
    }

    @Override
    @Nullable
    protected LinearGraphController.LinearGraphAnswer performAction(@NotNull LinearGraphController.LinearGraphAction action2) {
        if (action2 == null) {
            CollapsedController.$$$reportNull$$$0(4);
        }
        return CollapsedActionManager.performAction(this, action2);
    }

    @Override
    @NotNull
    public LinearGraph getCompiledGraph() {
        LinearGraph linearGraph = this.myCollapsedGraph.getCompiledGraph();
        if (linearGraph == null) {
            CollapsedController.$$$reportNull$$$0(5);
        }
        return linearGraph;
    }

    @NotNull
    protected CollapsedGraph getCollapsedGraph() {
        CollapsedGraph collapsedGraph = this.myCollapsedGraph;
        if (collapsedGraph == null) {
            CollapsedController.$$$reportNull$$$0(6);
        }
        return collapsedGraph;
    }

    @Override
    @Nullable
    protected GraphElement convertToDelegate(@NotNull GraphElement graphElement) {
        if (graphElement == null) {
            CollapsedController.$$$reportNull$$$0(7);
        }
        return CollapsedController.convertToDelegate(graphElement, this.myCollapsedGraph);
    }

    @Nullable
    public static GraphElement convertToDelegate(@NotNull GraphElement graphElement, CollapsedGraph collapsedGraph) {
        if (graphElement == null) {
            CollapsedController.$$$reportNull$$$0(8);
        }
        if (graphElement instanceof GraphEdge) {
            Integer upIndex = ((GraphEdge)graphElement).getUpNodeIndex();
            Integer downIndex = ((GraphEdge)graphElement).getDownNodeIndex();
            if (upIndex != null && downIndex != null && collapsedGraph.isMyCollapsedEdge(upIndex, downIndex)) {
                return null;
            }
            Integer convertedUpIndex = upIndex == null ? null : Integer.valueOf(collapsedGraph.convertToDelegateNodeIndex(upIndex));
            Integer convertedDownIndex = downIndex == null ? null : Integer.valueOf(collapsedGraph.convertToDelegateNodeIndex(downIndex));
            return new GraphEdge(convertedUpIndex, convertedDownIndex, ((GraphEdge)graphElement).getTargetId(), ((GraphEdge)graphElement).getType());
        }
        if (graphElement instanceof GraphNode) {
            return new GraphNode(collapsedGraph.convertToDelegateNodeIndex(((GraphNode)graphElement).getNodeIndex()), ((GraphNode)graphElement).getType());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateLinearGraphController";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentGraphInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateAnswer";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/collapsing/CollapsedController";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/collapsing/CollapsedController";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "delegateGraphChanged";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompiledGraph";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollapsedGraph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "delegateGraphChanged";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertToDelegate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

