/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.history.EdgeData;
import com.intellij.vcs.log.history.FileHistoryData;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.VcsDirectoryRenamesProvider;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.util.IntCollectionUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogMultiplePatternsTextFilter;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IndexDataGetter {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<? extends VirtualFile> myRoots;
    @NotNull
    private final VcsLogPersistentIndex.IndexStorage myIndexStorage;
    @NotNull
    private final VcsLogStorage myLogStorage;
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;
    @NotNull
    private final VcsDirectoryRenamesProvider myDirectoryRenamesProvider;

    public IndexDataGetter(@NotNull Project project, @NotNull Set<? extends VirtualFile> roots, @NotNull VcsLogPersistentIndex.IndexStorage indexStorage, @NotNull VcsLogStorage logStorage, @NotNull FatalErrorHandler fatalErrorsConsumer) {
        if (project == null) {
            IndexDataGetter.$$$reportNull$$$0(0);
        }
        if (roots == null) {
            IndexDataGetter.$$$reportNull$$$0(1);
        }
        if (indexStorage == null) {
            IndexDataGetter.$$$reportNull$$$0(2);
        }
        if (logStorage == null) {
            IndexDataGetter.$$$reportNull$$$0(3);
        }
        if (fatalErrorsConsumer == null) {
            IndexDataGetter.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myRoots = roots;
        this.myIndexStorage = indexStorage;
        this.myLogStorage = logStorage;
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
        this.myDirectoryRenamesProvider = VcsDirectoryRenamesProvider.getInstance(this.myProject);
    }

    @Nullable
    public VcsUser getAuthor(int commit2) {
        return (VcsUser)this.executeAndCatch(() -> this.myIndexStorage.users.getAuthorForCommit(commit2));
    }

    @Nullable
    public VcsUser getCommitter(int commit2) {
        return (VcsUser)this.executeAndCatch(() -> {
            Integer committer = (Integer)this.myIndexStorage.committers.get((Object)commit2);
            if (committer != null) {
                return this.myIndexStorage.users.getUserById(committer);
            }
            if (this.myIndexStorage.commits.contains(commit2)) {
                return this.myIndexStorage.users.getAuthorForCommit(commit2);
            }
            return null;
        });
    }

    @Nullable
    public Long getAuthorTime(int commit2) {
        return (Long)this.executeAndCatch(() -> {
            Pair time = (Pair)this.myIndexStorage.timestamps.get((Object)commit2);
            if (time == null) {
                return null;
            }
            return (Long)time.first;
        });
    }

    @Nullable
    public Long getCommitTime(int commit2) {
        return (Long)this.executeAndCatch(() -> {
            Pair time = (Pair)this.myIndexStorage.timestamps.get((Object)commit2);
            if (time == null) {
                return null;
            }
            return (Long)time.second;
        });
    }

    @Nullable
    public String getFullMessage(int index2) {
        return (String)this.executeAndCatch(() -> (String)this.myIndexStorage.messages.get((Object)index2));
    }

    @Nullable
    public List<Hash> getParents(int index2) {
        return (List)this.executeAndCatch(() -> {
            List parentsIndexes = (List)this.myIndexStorage.parents.get((Object)index2);
            if (parentsIndexes == null) {
                return null;
            }
            ArrayList<Hash> result2 = new ArrayList<Hash>();
            Iterator iterator2 = parentsIndexes.iterator();
            while (iterator2.hasNext()) {
                int parentIndex = (Integer)iterator2.next();
                CommitId id2 = this.myLogStorage.getCommitId(parentIndex);
                if (id2 == null) {
                    return null;
                }
                result2.add(id2.getHash());
            }
            return result2;
        });
    }

    public boolean canFilter(@NotNull List<VcsLogDetailsFilter> filters) {
        if (filters == null) {
            IndexDataGetter.$$$reportNull$$$0(5);
        }
        if (filters.isEmpty()) {
            return false;
        }
        return ContainerUtil.all(filters, filter -> {
            if (filter instanceof VcsLogTextFilter || filter instanceof VcsLogUserFilter) {
                return true;
            }
            if (filter instanceof VcsLogStructureFilter) {
                Collection files2 = ((VcsLogStructureFilter)filter).getFiles();
                return ContainerUtil.find((Iterable)files2, file2 -> file2.isDirectory() && this.myRoots.contains(file2.getVirtualFile())) == null;
            }
            return false;
        });
    }

    @NotNull
    public Set<Integer> filter(@NotNull List<VcsLogDetailsFilter> detailsFilters) {
        if (detailsFilters == null) {
            IndexDataGetter.$$$reportNull$$$0(6);
        }
        IntSet intSet = this.filter(detailsFilters, null);
        if (intSet == null) {
            IndexDataGetter.$$$reportNull$$$0(7);
        }
        return intSet;
    }

    @NotNull
    public IntSet filter(@NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable IntSet candidates) {
        if (detailsFilters == null) {
            IndexDataGetter.$$$reportNull$$$0(8);
        }
        VcsLogTextFilter textFilter = (VcsLogTextFilter)ContainerUtil.findInstance(detailsFilters, VcsLogTextFilter.class);
        VcsLogUserFilter userFilter = (VcsLogUserFilter)ContainerUtil.findInstance(detailsFilters, VcsLogUserFilter.class);
        VcsLogStructureFilter pathFilter = (VcsLogStructureFilter)ContainerUtil.findInstance(detailsFilters, VcsLogStructureFilter.class);
        IntSet filteredByUser = null;
        if (userFilter != null) {
            HashSet users = new HashSet();
            for (VirtualFile virtualFile2 : this.myRoots) {
                users.addAll(userFilter.getUsers(virtualFile2));
            }
            filteredByUser = this.filterUsers(users);
        }
        IntSet filteredByPath = null;
        if (pathFilter != null) {
            filteredByPath = this.filterPaths(pathFilter.getFiles());
        }
        IntSet filteredByUserAndPath = IntCollectionUtil.intersect(filteredByUser, filteredByPath, candidates);
        if (textFilter == null) {
            Object object = filteredByUserAndPath == null ? IntSets.EMPTY_SET : filteredByUserAndPath;
            if (object == null) {
                IndexDataGetter.$$$reportNull$$$0(9);
            }
            return object;
        }
        return this.filterMessages(textFilter, filteredByUserAndPath);
    }

    @NotNull
    private IntSet filterUsers(@NotNull Set<? extends VcsUser> users) {
        if (users == null) {
            IndexDataGetter.$$$reportNull$$$0(10);
        }
        IntSet intSet = (IntSet)this.executeAndCatch(() -> this.myIndexStorage.users.getCommitsForUsers(users), new IntOpenHashSet());
        if (intSet == null) {
            IndexDataGetter.$$$reportNull$$$0(11);
        }
        return intSet;
    }

    @NotNull
    private IntSet filterPaths(@NotNull Collection<? extends FilePath> paths) {
        if (paths == null) {
            IndexDataGetter.$$$reportNull$$$0(12);
        }
        IntSet intSet = (IntSet)this.executeAndCatch(() -> {
            IntOpenHashSet result2 = new IntOpenHashSet();
            for (FilePath path2 : paths) {
                result2.addAll((IntCollection)this.createFileHistoryData(path2).build().getCommits());
            }
            return result2;
        }, new IntOpenHashSet());
        if (intSet == null) {
            IndexDataGetter.$$$reportNull$$$0(13);
        }
        return intSet;
    }

    @NotNull
    private IntSet filterMessages(@NotNull VcsLogTextFilter filter, @Nullable IntSet candidates) {
        if (filter == null) {
            IndexDataGetter.$$$reportNull$$$0(14);
        }
        IntOpenHashSet result2 = new IntOpenHashSet();
        this.filterMessages(filter, candidates, arg_0 -> ((IntSet)result2).add(arg_0));
        IntOpenHashSet intOpenHashSet = result2;
        if (intOpenHashSet == null) {
            IndexDataGetter.$$$reportNull$$$0(15);
        }
        return intOpenHashSet;
    }

    public void filterMessages(@NotNull VcsLogTextFilter filter, @NotNull IntConsumer consumer) {
        if (filter == null) {
            IndexDataGetter.$$$reportNull$$$0(16);
        }
        if (consumer == null) {
            IndexDataGetter.$$$reportNull$$$0(17);
        }
        this.filterMessages(filter, null, consumer);
    }

    private void filterMessages(@NotNull VcsLogTextFilter filter, @Nullable IntSet candidates, @NotNull IntConsumer consumer) {
        if (filter == null) {
            IndexDataGetter.$$$reportNull$$$0(18);
        }
        if (consumer == null) {
            IndexDataGetter.$$$reportNull$$$0(19);
        }
        if (!filter.isRegex() || filter instanceof VcsLogMultiplePatternsTextFilter) {
            this.executeAndCatch(() -> {
                List<String> trigramSources = filter instanceof VcsLogMultiplePatternsTextFilter ? ((VcsLogMultiplePatternsTextFilter)filter).getPatterns() : Collections.singletonList(filter.getText());
                ArrayList<String> noTrigramSources = new ArrayList<String>();
                for (String string : trigramSources) {
                    IntSet commits = this.myIndexStorage.trigrams.getCommitsForSubstring(string);
                    if (commits == null) {
                        noTrigramSources.add(string);
                        continue;
                    }
                    this.filter(this.myIndexStorage.messages, (IntIterable)IntCollectionUtil.intersect(candidates, commits), arg_0 -> ((VcsLogTextFilter)filter).matches(arg_0), consumer);
                }
                if (noTrigramSources.isEmpty()) {
                    return;
                }
                VcsLogTextFilter noTrigramFilter = VcsLogFilterObject.fromPatternsList(noTrigramSources, filter.matchesCase());
                this.filter(this.myIndexStorage.messages, (IntIterable)candidates, arg_0 -> ((VcsLogTextFilter)noTrigramFilter).matches(arg_0), consumer);
            });
        } else {
            this.executeAndCatch(() -> this.filter(this.myIndexStorage.messages, (IntIterable)candidates, arg_0 -> ((VcsLogTextFilter)filter).matches(arg_0), consumer));
        }
    }

    private <T> void filter(@NotNull PersistentMap<Integer, T> map2, @Nullable IntIterable candidates, @NotNull Condition<? super T> condition, @NotNull IntConsumer consumer) throws IOException {
        if (map2 == null) {
            IndexDataGetter.$$$reportNull$$$0(20);
        }
        if (condition == null) {
            IndexDataGetter.$$$reportNull$$$0(21);
        }
        if (consumer == null) {
            IndexDataGetter.$$$reportNull$$$0(22);
        }
        if (candidates == null) {
            IndexDataGetter.processKeys(map2, (Processor<? super Integer>)((Processor)commit2 -> this.filterCommit(map2, (int)commit2, condition, consumer)));
        } else {
            IntIterator iterator2 = candidates.iterator();
            while (iterator2.hasNext() && this.filterCommit(map2, iterator2.nextInt(), condition, consumer)) {
            }
        }
    }

    private <T> boolean filterCommit(@NotNull PersistentMap<Integer, T> map2, int commit2, @NotNull Condition<? super T> condition, @NotNull IntConsumer consumer) {
        if (map2 == null) {
            IndexDataGetter.$$$reportNull$$$0(23);
        }
        if (condition == null) {
            IndexDataGetter.$$$reportNull$$$0(24);
        }
        if (consumer == null) {
            IndexDataGetter.$$$reportNull$$$0(25);
        }
        try {
            Object value2 = map2.get((Object)commit2);
            if (value2 != null && condition.value(value2)) {
                consumer.accept(commit2);
            }
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return false;
        }
        return true;
    }

    @NotNull
    private Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>> getAffectedCommits(@NotNull FilePath path2) {
        if (path2 == null) {
            IndexDataGetter.$$$reportNull$$$0(26);
        }
        Int2ObjectOpenHashMap affectedCommits = new Int2ObjectOpenHashMap();
        VirtualFile root = VcsLogUtil.getActualRoot(this.myProject, path2);
        if (this.myRoots.contains(root) && root != null) {
            this.executeAndCatch(() -> this.lambda$getAffectedCommits$15(root, path2, (Int2ObjectMap)affectedCommits));
        }
        Int2ObjectOpenHashMap int2ObjectOpenHashMap = affectedCommits;
        if (int2ObjectOpenHashMap == null) {
            IndexDataGetter.$$$reportNull$$$0(27);
        }
        return int2ObjectOpenHashMap;
    }

    @NotNull
    public FileHistoryData createFileHistoryData(@NotNull FilePath path2) {
        if (path2 == null) {
            IndexDataGetter.$$$reportNull$$$0(28);
        }
        FileHistoryData fileHistoryData = this.createFileHistoryData(Collections.singletonList(path2));
        if (fileHistoryData == null) {
            IndexDataGetter.$$$reportNull$$$0(29);
        }
        return fileHistoryData;
    }

    @NotNull
    public FileHistoryData createFileHistoryData(@NotNull Collection<? extends FilePath> paths) {
        if (paths == null) {
            IndexDataGetter.$$$reportNull$$$0(30);
        }
        if (paths.size() == 1 && ((FilePath)ContainerUtil.getFirstItem(paths)).isDirectory()) {
            return new DirectoryHistoryData((FilePath)ContainerUtil.getFirstItem(paths));
        }
        return new FileHistoryDataImpl(paths);
    }

    @NotNull
    public VcsLogStorage getLogStorage() {
        VcsLogStorage vcsLogStorage = this.myLogStorage;
        if (vcsLogStorage == null) {
            IndexDataGetter.$$$reportNull$$$0(31);
        }
        return vcsLogStorage;
    }

    private static <T> void processKeys(@NotNull PersistentMap<Integer, T> map2, @NotNull Processor<? super Integer> processor2) throws IOException {
        if (map2 == null) {
            IndexDataGetter.$$$reportNull$$$0(32);
        }
        if (processor2 == null) {
            IndexDataGetter.$$$reportNull$$$0(33);
        }
        if (map2 instanceof PersistentHashMap) {
            ((PersistentHashMap)map2).processKeysWithExistingMapping(processor2);
        } else {
            map2.processKeys(processor2);
        }
    }

    private void executeAndCatch(@NotNull Throwable2Runnable<IOException, StorageException> runnable2) {
        if (runnable2 == null) {
            IndexDataGetter.$$$reportNull$$$0(34);
        }
        this.executeAndCatch(() -> {
            runnable2.run();
            return null;
        }, null);
    }

    @Nullable
    private <T> T executeAndCatch(@NotNull Throwable2Computable<T, IOException, StorageException> computable) {
        if (computable == null) {
            IndexDataGetter.$$$reportNull$$$0(35);
        }
        return this.executeAndCatch(computable, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    private <T> T executeAndCatch(@NotNull Throwable2Computable<? extends T, IOException, StorageException> computable, @Nullable T defaultValue) {
        if (computable == null) {
            IndexDataGetter.$$$reportNull$$$0(36);
        }
        try {
            return (T)computable.compute();
        }
        catch (StorageException | CorruptedDataException | IOException e) {
            this.myIndexStorage.markCorrupted();
            this.myFatalErrorsConsumer.consume(this, e);
        }
        catch (RuntimeException e) {
            this.processRuntimeException(e);
        }
        return defaultValue;
    }

    private void processRuntimeException(@NotNull RuntimeException e) {
        if (e == null) {
            IndexDataGetter.$$$reportNull$$$0(37);
        }
        if (e instanceof ProcessCanceledException) {
            throw e;
        }
        this.myIndexStorage.markCorrupted();
        if (!(e.getCause() instanceof IOException) && !(e.getCause() instanceof StorageException)) {
            throw new RuntimeException(e);
        }
        this.myFatalErrorsConsumer.consume(this, e);
    }

    private /* synthetic */ Object lambda$getAffectedCommits$15(VirtualFile root, FilePath path2, Int2ObjectMap affectedCommits) throws IOException, StorageException {
        this.myIndexStorage.paths.iterateCommits(root, path2, (changes, commit2) -> this.executeAndCatch(() -> {
            List parents2 = (List)this.myIndexStorage.parents.get((Object)commit2);
            if (parents2 == null) {
                throw new CorruptedDataException("No parents for commit " + commit2);
            }
            Int2ObjectOpenHashMap changesMap = new Int2ObjectOpenHashMap();
            if (parents2.size() == 0 && !changes.isEmpty()) {
                changesMap.put(commit2, (Object)((VcsLogPathsIndex.ChangeKind)((Object)((Object)((Object)ContainerUtil.getFirstItem((List)changes))))));
            } else {
                if (parents2.size() != changes.size()) {
                    throw new CorruptedDataException("Commit " + commit2 + " has " + parents2.size() + " parents, but " + changes.size() + " changes.");
                }
                for (Pair parentAndChanges : ContainerUtil.zip((Iterable)parents2, (Iterable)changes)) {
                    changesMap.put(((Integer)parentAndChanges.first).intValue(), (Object)((VcsLogPathsIndex.ChangeKind)((Object)((Object)((Object)parentAndChanges.second)))));
                }
            }
            affectedCommits.put(commit2, (Object)changesMap);
            return null;
        }));
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 27: 
            case 29: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 27: 
            case 29: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexStorage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logStorage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fatalErrorsConsumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsFilters";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/IndexDataGetter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "users";
                break;
            }
            case 12: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 17: 
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 20: 
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/IndexDataGetter";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUsers";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPaths";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMessages";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedCommits";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileHistoryData";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canFilter";
                break;
            }
            case 6: 
            case 8: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 27: 
            case 29: 
            case 31: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filterUsers";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterPaths";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "filterMessages";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "filterCommit";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedCommits";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createFileHistoryData";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "executeAndCatch";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processRuntimeException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 27: 
            case 29: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    private static interface Throwable2Runnable<E1 extends Throwable, E2 extends Throwable> {
        public void run() throws E1, E2;
    }

    private static class CorruptedDataException
    extends RuntimeException {
        CorruptedDataException(@NotNull String message2) {
            if (message2 == null) {
                CorruptedDataException.$$$reportNull$$$0(0);
            }
            super(message2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/vcs/log/data/index/IndexDataGetter$CorruptedDataException", "<init>"));
        }
    }

    private final class DirectoryHistoryData
    extends FileHistoryDataImpl {
        private final Map<EdgeData<Integer>, EdgeData<FilePath>> renamesMap;

        private DirectoryHistoryData(FilePath startPath) {
            if (startPath == null) {
                DirectoryHistoryData.$$$reportNull$$$0(0);
            }
            super(startPath);
            this.renamesMap = new HashMap<EdgeData<Integer>, EdgeData<FilePath>>();
            for (Map.Entry<EdgeData<CommitId>, EdgeData<FilePath>> entry2 : IndexDataGetter.this.myDirectoryRenamesProvider.getRenamesMap().entrySet()) {
                EdgeData<CommitId> commits = entry2.getKey();
                EdgeData<FilePath> rename2 = entry2.getValue();
                if (!VcsFileUtil.isAncestor(rename2.getChild(), startPath, false)) continue;
                FilePath renamedPath = VcsUtil.getFilePath((String)(rename2.getParent().getPath() + "/" + VcsFileUtil.relativePath(rename2.getChild(), startPath)), (boolean)true);
                this.renamesMap.put(new EdgeData<Integer>(IndexDataGetter.this.myLogStorage.getCommitIndex(commits.getParent().getHash(), commits.getParent().getRoot()), IndexDataGetter.this.myLogStorage.getCommitIndex(commits.getChild().getHash(), commits.getChild().getRoot())), new EdgeData<FilePath>(renamedPath, startPath));
            }
        }

        @Override
        @NotNull
        public Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>> getAffectedCommits(@NotNull FilePath path2) {
            if (path2 == null) {
                DirectoryHistoryData.$$$reportNull$$$0(1);
            }
            Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>> affectedCommits = super.getAffectedCommits(path2);
            if (!path2.isDirectory()) {
                Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>> int2ObjectMap = affectedCommits;
                if (int2ObjectMap == null) {
                    DirectoryHistoryData.$$$reportNull$$$0(2);
                }
                return int2ObjectMap;
            }
            this.hackAffectedCommits(path2, affectedCommits);
            Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>> int2ObjectMap = affectedCommits;
            if (int2ObjectMap == null) {
                DirectoryHistoryData.$$$reportNull$$$0(3);
            }
            return int2ObjectMap;
        }

        private void hackAffectedCommits(@NotNull FilePath path2, @NotNull Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>> affectedCommits) {
            if (path2 == null) {
                DirectoryHistoryData.$$$reportNull$$$0(4);
            }
            if (affectedCommits == null) {
                DirectoryHistoryData.$$$reportNull$$$0(5);
            }
            for (Map.Entry<EdgeData<Integer>, EdgeData<FilePath>> entry2 : this.renamesMap.entrySet()) {
                VcsLogPathsIndex.ChangeKind newKind;
                int childCommit = entry2.getKey().getChild();
                if (!affectedCommits.containsKey(childCommit)) continue;
                EdgeData<FilePath> rename2 = entry2.getValue();
                if (FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)rename2.getChild(), (Object)path2)) {
                    newKind = VcsLogPathsIndex.ChangeKind.ADDED;
                } else {
                    if (!FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)rename2.getParent(), (Object)path2)) continue;
                    newKind = VcsLogPathsIndex.ChangeKind.REMOVED;
                }
                Int2ObjectMap changesMap = (Int2ObjectMap)affectedCommits.get(childCommit);
                changesMap.keySet().forEach(key -> changesMap.put(key, (Object)newKind));
            }
        }

        @Override
        @Nullable
        public EdgeData<FilePath> findRename(int parent, int child2, @NotNull FilePath path2, boolean isChildPath) {
            if (path2 == null) {
                DirectoryHistoryData.$$$reportNull$$$0(6);
            }
            if (path2.isDirectory()) {
                return this.findFolderRename(parent, child2, path2, isChildPath);
            }
            return super.findRename(parent, child2, path2, isChildPath);
        }

        @Nullable
        private EdgeData<FilePath> findFolderRename(int parent, int child2, @NotNull FilePath path2, boolean isChildPath) {
            EdgeData<FilePath> rename2;
            if (path2 == null) {
                DirectoryHistoryData.$$$reportNull$$$0(7);
            }
            if ((rename2 = this.renamesMap.get(new EdgeData<Integer>(parent, child2))) == null) {
                return null;
            }
            return FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)(isChildPath ? rename2.getChild() : rename2.getParent()), (Object)path2) ? rename2 : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startPath";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/IndexDataGetter$DirectoryHistoryData";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "affectedCommits";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/IndexDataGetter$DirectoryHistoryData";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAffectedCommits";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getAffectedCommits";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "hackAffectedCommits";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findRename";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findFolderRename";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class FileHistoryDataImpl
    extends FileHistoryData {
        private FileHistoryDataImpl(FilePath startPath) {
            if (startPath == null) {
                FileHistoryDataImpl.$$$reportNull$$$0(0);
            }
            super(startPath);
        }

        private FileHistoryDataImpl(Collection<? extends FilePath> startPaths) {
            if (startPaths == null) {
                FileHistoryDataImpl.$$$reportNull$$$0(1);
            }
            super(startPaths);
        }

        @Override
        @NotNull
        public Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>> getAffectedCommits(@NotNull FilePath path2) {
            if (path2 == null) {
                FileHistoryDataImpl.$$$reportNull$$$0(2);
            }
            Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>> int2ObjectMap = IndexDataGetter.this.getAffectedCommits(path2);
            if (int2ObjectMap == null) {
                FileHistoryDataImpl.$$$reportNull$$$0(3);
            }
            return int2ObjectMap;
        }

        @Override
        @Nullable
        public EdgeData<FilePath> findRename(int parent, int child2, @NotNull FilePath path2, boolean isChildPath) {
            if (path2 == null) {
                FileHistoryDataImpl.$$$reportNull$$$0(4);
            }
            VirtualFile root = Objects.requireNonNull(VcsLogUtil.getActualRoot(IndexDataGetter.this.myProject, path2));
            return (EdgeData)IndexDataGetter.this.executeAndCatch(() -> IndexDataGetter.this.myIndexStorage.paths.findRename(parent, child2, root, path2, isChildPath));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startPaths";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/IndexDataGetter$FileHistoryDataImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/IndexDataGetter$FileHistoryDataImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAffectedCommits";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getAffectedCommits";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findRename";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

