/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractDataGetter<T extends VcsShortCommitDetails>
implements Disposable,
DataGetter<T> {
    private static final Logger LOG = Logger.getInstance(AbstractDataGetter.class);
    private static final int MAX_LOADING_TASKS = 10;
    @NotNull
    protected final VcsLogStorage myStorage;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    private final Cache<Integer, T> myCache;
    @NotNull
    private final SequentialLimitedLifoExecutor<TaskDescriptor> myLoader;
    private long myCurrentTaskIndex;
    @NotNull
    private final Collection<Runnable> myLoadingFinishedListeners;
    @NotNull
    protected final VcsLogIndex myIndex;

    AbstractDataGetter(@NotNull VcsLogStorage storage2, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsLogIndex index2, @NotNull Disposable parentDisposable) {
        if (storage2 == null) {
            AbstractDataGetter.$$$reportNull$$$0(0);
        }
        if (logProviders == null) {
            AbstractDataGetter.$$$reportNull$$$0(1);
        }
        if (index2 == null) {
            AbstractDataGetter.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            AbstractDataGetter.$$$reportNull$$$0(3);
        }
        this.myCache = Caffeine.newBuilder().maximumSize(10000L).build();
        this.myCurrentTaskIndex = 0L;
        this.myLoadingFinishedListeners = new ArrayList<Runnable>();
        this.myStorage = storage2;
        this.myLogProviders = logProviders;
        this.myIndex = index2;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myLoader = new SequentialLimitedLifoExecutor(this, 10, task2 -> {
            this.preLoadCommitData(task2.myCommits, EmptyConsumer.getInstance());
            this.notifyLoaded();
        });
    }

    protected void notifyLoaded() {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            for (Runnable loadingFinishedListener : this.myLoadingFinishedListeners) {
                loadingFinishedListener.run();
            }
        });
    }

    public void dispose() {
        this.myLoadingFinishedListeners.clear();
    }

    @Override
    @NotNull
    public T getCommitData(int hash, @NotNull Iterable<Integer> neighbourHashes) {
        if (neighbourHashes == null) {
            AbstractDataGetter.$$$reportNull$$$0(4);
        }
        if (!EventQueue.isDispatchThread()) {
            LOG.warn("Accessing AbstractDataGetter from background thread");
            T commitFromCache = this.getFromCache(hash);
            if (commitFromCache == null) {
                return this.createPlaceholderCommit(hash, 0L);
            }
            T t = commitFromCache;
            if (t == null) {
                AbstractDataGetter.$$$reportNull$$$0(5);
            }
            return t;
        }
        T details = this.getCommitDataIfAvailable(hash);
        if (details != null) {
            T t = details;
            if (t == null) {
                AbstractDataGetter.$$$reportNull$$$0(6);
            }
            return t;
        }
        this.runLoadCommitsData(neighbourHashes);
        T result2 = this.getFromCache(hash);
        assert (result2 != null);
        T t = result2;
        if (t == null) {
            AbstractDataGetter.$$$reportNull$$$0(7);
        }
        return t;
    }

    @Override
    public void loadCommitsData(@NotNull List<Integer> hashes, @NotNull Consumer<? super List<T>> consumer, @NotNull Consumer<? super Throwable> errorConsumer, @Nullable ProgressIndicator indicator2) {
        if (hashes == null) {
            AbstractDataGetter.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            AbstractDataGetter.$$$reportNull$$$0(9);
        }
        if (errorConsumer == null) {
            AbstractDataGetter.$$$reportNull$$$0(10);
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.loadCommitsData(AbstractDataGetter.getCommitsMap(hashes), consumer, errorConsumer, indicator2);
    }

    private void loadCommitsData(@NotNull Int2IntMap commits, @NotNull Consumer<? super List<T>> consumer, @NotNull Consumer<? super Throwable> errorConsumer, @Nullable ProgressIndicator indicator2) {
        if (commits == null) {
            AbstractDataGetter.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            AbstractDataGetter.$$$reportNull$$$0(12);
        }
        if (errorConsumer == null) {
            AbstractDataGetter.$$$reportNull$$$0(13);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        IntOpenHashSet toLoad = new IntOpenHashSet();
        long taskNumber = this.myCurrentTaskIndex++;
        IntIterator keyIterator = commits.keySet().iterator();
        while (keyIterator.hasNext()) {
            int id2 = keyIterator.nextInt();
            T details = this.getCommitDataIfAvailable(id2);
            if (details == null || details instanceof LoadingDetails) {
                toLoad.add(id2);
                this.cacheCommit(id2, taskNumber);
                continue;
            }
            result2.add(details);
        }
        if (toLoad.isEmpty()) {
            --this.myCurrentTaskIndex;
            Runnable process2 = () -> {
                this.sortCommitsByRow(result2, commits);
                consumer.consume((Object)result2);
            };
            if (indicator2 != null) {
                ProgressManager.getInstance().runProcess(process2, indicator2);
            } else {
                process2.run();
            }
        } else {
            Task.Backgroundable task2 = new Task.Backgroundable(null, VcsLogBundle.message((String)"vcs.log.loading.selected.details.process", (Object[])new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND, (IntSet)toLoad, result2, commits, consumer, errorConsumer){
                final /* synthetic */ IntSet val$toLoad;
                final /* synthetic */ List val$result;
                final /* synthetic */ Int2IntMap val$commits;
                final /* synthetic */ Consumer val$consumer;
                final /* synthetic */ Consumer val$errorConsumer;
                {
                    this.val$toLoad = intSet;
                    this.val$result = list2;
                    this.val$commits = int2IntMap;
                    this.val$consumer = consumer;
                    this.val$errorConsumer = consumer2;
                    super(arg0, arg1, arg2, arg3);
                }

                public void run(@NotNull ProgressIndicator indicator2) {
                    if (indicator2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator2.checkCanceled();
                    try {
                        AbstractDataGetter.this.preLoadCommitData(this.val$toLoad, new CollectConsumer((Collection)this.val$result));
                        AbstractDataGetter.this.sortCommitsByRow(this.val$result, this.val$commits);
                        AbstractDataGetter.this.notifyLoaded();
                    }
                    catch (VcsException e) {
                        LOG.warn((Throwable)e);
                        throw new RuntimeException(e);
                    }
                }

                public void onSuccess() {
                    this.val$consumer.consume((Object)this.val$result);
                }

                public void onThrowable(@NotNull Throwable error2) {
                    if (error2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.val$errorConsumer.consume((Object)error2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "error";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/vcs/log/data/AbstractDataGetter$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onThrowable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            if (indicator2 != null) {
                ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, indicator2);
            } else {
                ProgressManager.getInstance().run((Task)task2);
            }
        }
    }

    private void sortCommitsByRow(@NotNull List<? extends T> result2, @NotNull Int2IntMap rowsForCommits) {
        if (result2 == null) {
            AbstractDataGetter.$$$reportNull$$$0(14);
        }
        if (rowsForCommits == null) {
            AbstractDataGetter.$$$reportNull$$$0(15);
        }
        result2.sort((details1, details2) -> {
            int row1 = rowsForCommits.get(this.myStorage.getCommitIndex((Hash)details1.getId(), details1.getRoot()));
            int row2 = rowsForCommits.get(this.myStorage.getCommitIndex((Hash)details2.getId(), details2.getRoot()));
            return Comparing.compare((int)row1, (int)row2);
        });
    }

    @Override
    @Nullable
    public T getCommitDataIfAvailable(int hash) {
        T details = this.getFromCache(hash);
        if (details != null) {
            if (details instanceof LoadingDetails && ((LoadingDetails)details).getLoadingTaskIndex() <= this.myCurrentTaskIndex - 10L) {
                this.myCache.asMap().remove(hash, details);
                return null;
            }
            return details;
        }
        return this.getFromAdditionalCache(hash);
    }

    @Nullable
    protected T getFromCache(int hash) {
        return (T)((VcsShortCommitDetails)this.myCache.getIfPresent((Object)hash));
    }

    @Nullable
    protected abstract T getFromAdditionalCache(int var1);

    private void runLoadCommitsData(@NotNull Iterable<Integer> hashes) {
        if (hashes == null) {
            AbstractDataGetter.$$$reportNull$$$0(16);
        }
        long taskNumber = this.myCurrentTaskIndex++;
        Int2IntMap commits = AbstractDataGetter.getCommitsMap(hashes);
        IntOpenHashSet toLoad = new IntOpenHashSet();
        IntIterator iterator2 = commits.keySet().iterator();
        while (iterator2.hasNext()) {
            int id2 = iterator2.nextInt();
            this.cacheCommit(id2, taskNumber);
            toLoad.add(id2);
        }
        this.myLoader.queue(new TaskDescriptor((IntSet)toLoad));
    }

    private void cacheCommit(int commitId, long taskNumber) {
        if (this.getFromCache(commitId) == null) {
            this.myCache.put((Object)commitId, this.createPlaceholderCommit(commitId, taskNumber));
        }
    }

    @NotNull
    private T createPlaceholderCommit(int commitId, long taskNumber) {
        IndexDataGetter dataGetter = this.myIndex.getDataGetter();
        if (dataGetter != null && Registry.is((String)"vcs.log.use.indexed.details")) {
            return (T)new IndexedDetails(dataGetter, this.myStorage, commitId, taskNumber);
        }
        return (T)new LoadingDetails((Computable<? extends CommitId>)((Computable)() -> this.myStorage.getCommitId(commitId)), taskNumber);
    }

    @NotNull
    private static Int2IntMap getCommitsMap(@NotNull Iterable<Integer> hashes) {
        if (hashes == null) {
            AbstractDataGetter.$$$reportNull$$$0(17);
        }
        Int2IntOpenHashMap commits = new Int2IntOpenHashMap();
        int row2 = 0;
        for (Integer commitId : hashes) {
            commits.put(commitId.intValue(), row2);
            ++row2;
        }
        Int2IntOpenHashMap int2IntOpenHashMap = commits;
        if (int2IntOpenHashMap == null) {
            AbstractDataGetter.$$$reportNull$$$0(18);
        }
        return int2IntOpenHashMap;
    }

    protected void preLoadCommitData(@NotNull IntSet commits, @NotNull Consumer<? super T> consumer) throws VcsException {
        if (commits == null) {
            AbstractDataGetter.$$$reportNull$$$0(19);
        }
        if (consumer == null) {
            AbstractDataGetter.$$$reportNull$$$0(20);
        }
        MultiMap rootsAndHashes = MultiMap.create();
        commits.forEach(commit2 -> {
            CommitId commitId = this.myStorage.getCommitId(commit2);
            if (commitId != null) {
                rootsAndHashes.putValue((Object)commitId.getRoot(), (Object)commitId.getHash().asString());
            }
        });
        for (Map.Entry entry2 : rootsAndHashes.entrySet()) {
            VcsLogProvider logProvider = this.myLogProviders.get(entry2.getKey());
            if (logProvider != null) {
                this.readDetails(logProvider, (VirtualFile)entry2.getKey(), new ArrayList<String>((Collection)entry2.getValue()), details -> {
                    this.saveInCache(this.myStorage.getCommitIndex((Hash)details.getId(), details.getRoot()), details);
                    consumer.consume(details);
                });
                continue;
            }
            LOG.error("No log provider for root " + ((VirtualFile)entry2.getKey()).getPath() + ". All known log providers " + this.myLogProviders);
        }
    }

    protected abstract void readDetails(@NotNull VcsLogProvider var1, @NotNull VirtualFile var2, @NotNull List<String> var3, @NotNull Consumer<? super T> var4) throws VcsException;

    protected void saveInCache(int index2, @NotNull T details) {
        if (details == null) {
            AbstractDataGetter.$$$reportNull$$$0(21);
        }
        this.myCache.put((Object)index2, details);
    }

    protected void clear() {
        EdtInvocationManager.invokeAndWaitIfNeeded(() -> {
            Iterator iterator2 = this.myCache.asMap().entrySet().iterator();
            while (iterator2.hasNext()) {
                if (iterator2.next().getValue() instanceof LoadingDetails) continue;
                iterator2.remove();
            }
        });
    }

    public void addDetailsLoadedListener(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            AbstractDataGetter.$$$reportNull$$$0(22);
        }
        this.myLoadingFinishedListeners.add(runnable2);
    }

    public void removeDetailsLoadedListener(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            AbstractDataGetter.$$$reportNull$$$0(23);
        }
        this.myLoadingFinishedListeners.remove(runnable2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "neighbourHashes";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/AbstractDataGetter";
                break;
            }
            case 8: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 9: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorConsumer";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowsForCommits";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/AbstractDataGetter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitData";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCommitData";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadCommitsData";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sortCommitsByRow";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runLoadCommitsData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsMap";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "preLoadCommitData";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "saveInCache";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addDetailsLoadedListener";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeDetailsLoadedListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TaskDescriptor {
        @NotNull
        private final IntSet myCommits;

        private TaskDescriptor(@NotNull IntSet commits) {
            if (commits == null) {
                TaskDescriptor.$$$reportNull$$$0(0);
            }
            this.myCommits = commits;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/AbstractDataGetter$TaskDescriptor", "<init>"));
        }
    }
}

