/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs.builder;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Stubbed;
import com.intellij.util.xml.StubbedOccurrence;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.util.xml.stubs.AttributeStub;
import com.intellij.util.xml.stubs.ElementStub;
import com.intellij.util.xml.stubs.XIncludeStub;
import com.intellij.xml.util.XmlIncludeHandler;
import java.util.HashMap;

class DomStubBuilderVisitor {
    private final DomManagerImpl myManager;

    DomStubBuilderVisitor(DomManagerImpl manager2) {
        this.myManager = manager2;
    }

    void visitXmlElement(XmlElement element2, ElementStub parent, int index2) {
        String nsKey;
        if (XmlIncludeHandler.isXInclude((PsiElement)element2)) {
            XmlTag tag2 = (XmlTag)element2;
            new XIncludeStub(parent, tag2.getAttributeValue("href"), tag2.getAttributeValue("xpointer"));
            return;
        }
        DomInvocationHandler handler2 = this.myManager.getDomHandler(element2);
        if (handler2 == null || handler2.getAnnotation(Stubbed.class) == null && !handler2.getChildDescription().isStubbed()) {
            return;
        }
        AbstractDomChildDescriptionImpl description = handler2.getChildDescription();
        String string = nsKey = description instanceof DomChildrenDescription ? ((DomChildrenDescription)description).getXmlName().getNamespaceKey() : "";
        if (element2 instanceof XmlTag) {
            XmlTag tag3 = (XmlTag)element2;
            String elementClass = null;
            if (handler2.getAnnotation(StubbedOccurrence.class) != null) {
                elementClass = ((Class)description.getType()).getName();
            }
            ElementStub stub = new ElementStub(parent, tag3.getName(), StringUtil.notNullize((String)nsKey), index2, description instanceof CustomDomChildrenDescription, elementClass, tag3.getSubTags().length == 0 ? tag3.getValue().getTrimmedText() : "");
            for (XmlAttribute attribute : tag3.getAttributes()) {
                this.visitXmlElement((XmlElement)attribute, stub, 0);
            }
            HashMap<String, Integer> indices = new HashMap<String, Integer>();
            for (XmlTag subTag : tag3.getSubTags()) {
                String name = subTag.getName();
                Integer i2 = (Integer)indices.get(name);
                i2 = i2 == null ? 0 : i2 + 1;
                this.visitXmlElement((XmlElement)subTag, stub, i2);
                indices.put(name, i2);
            }
        } else if (element2 instanceof XmlAttribute) {
            new AttributeStub(parent, ((XmlAttribute)element2).getLocalName(), StringUtil.notNullize((String)nsKey), StringUtil.notNullize((String)((XmlAttribute)element2).getValue()));
        }
    }
}

