/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ClassMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomReflectionUtil;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;

public final class VisitorDescription {
    private final Class<? extends DomElementVisitor> myVisitorClass;
    private final ClassMap<Method> myMethods = new ClassMap(new ConcurrentHashMap());
    @NonNls
    private static final String VISIT = "visit";

    public VisitorDescription(Class<? extends DomElementVisitor> visitorClass) {
        this.myVisitorClass = visitorClass;
        for (Method method2 : ReflectionUtil.getClassPublicMethods(visitorClass)) {
            String methodName;
            Class<?>[] parameterTypes;
            Class<?> domClass;
            if (method2.getParameterCount() != 1 || !ReflectionUtil.isAssignable(DomElement.class, domClass = (parameterTypes = method2.getParameterTypes())[0]) || !(methodName = method2.getName()).startsWith(VISIT)) continue;
            method2.setAccessible(true);
            this.myMethods.put(domClass, (Object)method2);
        }
    }

    public void acceptElement(DomElementVisitor visitor, DomElement element2) {
        Method method2 = (Method)this.myMethods.get(element2.getClass());
        assert (method2 != null) : this.myVisitorClass + " can't accept element of type " + element2.getClass();
        DomReflectionUtil.invokeMethod((Method)method2, (Object)visitor, (Object[])new Object[]{element2});
    }
}

