/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.CustomChildren;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.PropertyAccessor;
import com.intellij.util.xml.SubTag;
import com.intellij.util.xml.SubTagList;
import com.intellij.util.xml.SubTagsList;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.CollectionChildDescriptionImpl;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.impl.InvocationCache;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StaticGenericInfoBuilder {
    private static final Set<Class<?>> ADDER_PARAMETER_TYPES = Set.of(Class.class, Integer.TYPE);
    private static final Logger LOG = Logger.getInstance(StaticGenericInfoBuilder.class);
    private final Class myClass;
    private final MultiValuesMap<XmlName, JavaMethod> myCollectionGetters = new MultiValuesMap();
    final MultiValuesMap<XmlName, JavaMethod> collectionAdders = new MultiValuesMap();
    final MultiValuesMap<XmlName, JavaMethod> collectionClassAdders = new MultiValuesMap();
    final MultiValuesMap<XmlName, JavaMethod> collectionIndexAdders = new MultiValuesMap();
    final MultiValuesMap<XmlName, JavaMethod> collectionIndexClassAdders = new MultiValuesMap();
    final MultiValuesMap<XmlName, JavaMethod> collectionClassIndexAdders = new MultiValuesMap();
    private final Map<XmlName, Type> myCollectionChildrenTypes = new HashMap<XmlName, Type>();
    private final Map<JavaMethodSignature, String[]> myCompositeCollectionGetters = new HashMap<JavaMethodSignature, String[]>();
    private final Map<JavaMethodSignature, Pair<String, String[]>> myCompositeCollectionAdders = new HashMap<JavaMethodSignature, Pair<String, String[]>>();
    private final Map<XmlName, Int2ObjectMap<Collection<JavaMethod>>> myFixedChildrenGetters = FactoryMap.create(key -> new Int2ObjectOpenHashMap());
    private final Map<JavaMethodSignature, AttributeChildDescriptionImpl> myAttributes = new HashMap<JavaMethodSignature, AttributeChildDescriptionImpl>();
    private boolean myValueElement;
    private JavaMethod myNameValueGetter;
    private JavaMethod myCustomChildrenGetter;
    private static final Set<JavaMethodSignature> ourDomElementMethods = ContainerUtil.map2Set((Object[])DomElement.class.getMethods(), method2 -> new JavaMethodSignature(method2));

    public StaticGenericInfoBuilder(Class aClass) {
        Class<? extends DomElement> implClass;
        this.myClass = aClass;
        LinkedHashSet<JavaMethod> methods = new LinkedHashSet<JavaMethod>();
        InvocationCache invocationCache = DomApplicationComponent.getInstance().getInvocationCache(this.myClass);
        for (Method method2 : ReflectionUtil.getClassPublicMethods((Class)this.myClass)) {
            methods.add(invocationCache.getInternedMethod(method2));
        }
        for (JavaMethod javaMethod : methods) {
            if (!DomImplUtil.isGetter(javaMethod) || javaMethod.getAnnotation(NameValue.class) == null) continue;
            this.myNameValueGetter = javaMethod;
            break;
        }
        if ((implClass = DomApplicationComponent.getInstance().getImplementation(this.myClass)) != null) {
            for (Method method3 : ReflectionUtil.getClassPublicMethods(implClass)) {
                int modifiers = method3.getModifiers();
                if (Modifier.isAbstract(modifiers) || Modifier.isVolatile(modifiers) || new JavaMethodSignature(method3).findMethod(this.myClass) == null) continue;
                methods.remove(invocationCache.getInternedMethod(method3));
            }
        }
        Iterator iterator2 = methods.iterator();
        while (iterator2.hasNext()) {
            JavaMethod javaMethod = (JavaMethod)iterator2.next();
            if (!StaticGenericInfoBuilder.isCoreMethod(javaMethod) && !DomImplUtil.isTagValueSetter(javaMethod) && javaMethod.getAnnotation(PropertyAccessor.class) == null) continue;
            iterator2.remove();
        }
        Iterator iterator3 = methods.iterator();
        while (iterator3.hasNext()) {
            JavaMethod javaMethod = (JavaMethod)iterator3.next();
            if (!DomImplUtil.isGetter(javaMethod) || !this.processGetterMethod(javaMethod)) continue;
            iterator3.remove();
        }
        iterator3 = methods.iterator();
        while (iterator3.hasNext()) {
            MultiValuesMap<XmlName, JavaMethod> adders;
            XmlName xmlName;
            JavaMethod javaMethod = (JavaMethod)iterator3.next();
            SubTagsList subTagsList = (SubTagsList)javaMethod.getAnnotation(SubTagsList.class);
            if (subTagsList != null && javaMethod.getName().startsWith("add")) {
                String localName = subTagsList.tagName();
                assert (StringUtil.isNotEmpty((String)localName));
                String[] set2 = subTagsList.value();
                assert (Arrays.asList(set2).contains(localName));
                this.myCompositeCollectionAdders.put(javaMethod.getSignature(), (Pair<String, String[]>)Pair.create((Object)localName, (Object)set2));
                iterator3.remove();
                continue;
            }
            if (!this.isAddMethod(javaMethod) || !this.myCollectionGetters.containsKey((Object)(xmlName = this.extractTagName(javaMethod, "add"))) || (adders = this.getAddersMap(javaMethod)) == null) continue;
            adders.put((Object)xmlName, (Object)javaMethod);
            iterator3.remove();
        }
    }

    @Nullable
    private MultiValuesMap<XmlName, JavaMethod> getAddersMap(JavaMethod method2) {
        Class[] parameterTypes = method2.getParameterTypes();
        switch (parameterTypes.length) {
            case 0: {
                return this.collectionAdders;
            }
            case 1: {
                if (Class.class.equals((Object)parameterTypes[0])) {
                    return this.collectionClassAdders;
                }
                if (!StaticGenericInfoBuilder.isInt(parameterTypes[0])) break;
                return this.collectionIndexAdders;
            }
            case 2: {
                if (StaticGenericInfoBuilder.isIndexClassAdder(parameterTypes[0], parameterTypes[1])) {
                    return this.collectionIndexClassAdders;
                }
                if (!StaticGenericInfoBuilder.isIndexClassAdder(parameterTypes[1], parameterTypes[0])) break;
                return this.collectionClassIndexAdders;
            }
        }
        return null;
    }

    private static boolean isIndexClassAdder(Class<?> first, Class<?> second) {
        return StaticGenericInfoBuilder.isInt(first) && second.equals(Class.class);
    }

    private static boolean isInt(Class<?> aClass) {
        return aClass.equals(Integer.TYPE) || aClass.equals(Integer.class);
    }

    private boolean isAddMethod(JavaMethod method2) {
        XmlName tagName = this.extractTagName(method2, "add");
        if (tagName == null) {
            return false;
        }
        Type type = this.myCollectionChildrenTypes.get(tagName);
        if (type == null || !ReflectionUtil.getRawType((Type)type).isAssignableFrom(method2.getReturnType())) {
            return false;
        }
        if (method2.getParameterCount() == 0) {
            return true;
        }
        return ADDER_PARAMETER_TYPES.containsAll(Arrays.asList(method2.getParameterTypes()));
    }

    @Nullable
    private XmlName extractTagName(JavaMethod method2, @NonNls String prefix2) {
        String name = method2.getName();
        if (!name.startsWith(prefix2)) {
            return null;
        }
        SubTagList subTagAnnotation = (SubTagList)method2.getAnnotation(SubTagList.class);
        if (subTagAnnotation != null && !StringUtil.isEmpty((String)subTagAnnotation.value())) {
            return DomImplUtil.createXmlName(subTagAnnotation.value(), method2);
        }
        String tagName = this.getNameStrategy(false).convertName(name.substring(prefix2.length()));
        return StringUtil.isEmpty((String)tagName) ? null : DomImplUtil.createXmlName(tagName, method2);
    }

    private static boolean isDomElement(Type type) {
        return type != null && DomElement.class.isAssignableFrom(ReflectionUtil.getRawType((Type)type));
    }

    private boolean processGetterMethod(JavaMethod method2) {
        String qname;
        boolean isAttributeMethod;
        if (DomImplUtil.isTagValueGetter(method2)) {
            this.myValueElement = true;
            return true;
        }
        Class returnType = method2.getReturnType();
        boolean isAttributeValueMethod = GenericAttributeValue.class.isAssignableFrom(returnType);
        JavaMethodSignature signature = method2.getSignature();
        Attribute annotation = (Attribute)method2.getAnnotation(Attribute.class);
        boolean bl = isAttributeMethod = annotation != null || isAttributeValueMethod;
        if (annotation != null) assert (isAttributeValueMethod || GenericAttributeValue.class.isAssignableFrom(returnType)) : method2 + " should return GenericAttributeValue";
        if (isAttributeMethod) {
            String attributeName;
            String s = annotation == null ? null : annotation.value();
            String string = attributeName = StringUtil.isEmpty((String)s) ? this.getNameFromMethod(method2, true) : s;
            assert (attributeName != null && StringUtil.isNotEmpty((String)attributeName)) : "Can't guess attribute name from method name: " + method2.getName();
            XmlName attrName = DomImplUtil.createXmlName(attributeName, method2);
            this.myAttributes.put(signature, new AttributeChildDescriptionImpl(attrName, method2));
            return true;
        }
        if (StaticGenericInfoBuilder.isDomElement(returnType) && (qname = this.getSubTagName(method2)) != null) {
            Int2ObjectMap<Collection<JavaMethod>> map2;
            Collection methods;
            XmlName xmlName = DomImplUtil.createXmlName(qname, method2);
            Type collectionType = this.myCollectionChildrenTypes.get(xmlName);
            if (collectionType != null) {
                LOG.error("Collection (" + collectionType + ") and fixed children cannot intersect: " + qname + " for " + this.myClass);
            }
            int index2 = 0;
            SubTag subTagAnnotation = (SubTag)method2.getAnnotation(SubTag.class);
            if (subTagAnnotation != null && subTagAnnotation.index() != 0) {
                index2 = subTagAnnotation.index();
            }
            if ((methods = (Collection)(map2 = this.myFixedChildrenGetters.get(xmlName)).get(index2)) == null) {
                methods = new SmartList();
                map2.put(index2, (Object)methods);
            }
            methods.add(method2);
            return true;
        }
        Type type = DomReflectionUtil.extractCollectionElementType((Type)method2.getGenericReturnType());
        if (StaticGenericInfoBuilder.isDomElement(type)) {
            CustomChildren customChildren = (CustomChildren)method2.getAnnotation(CustomChildren.class);
            if (customChildren != null) {
                this.myCustomChildrenGetter = method2;
                return true;
            }
            SubTagsList subTagsList = (SubTagsList)method2.getAnnotation(SubTagsList.class);
            if (subTagsList != null) {
                this.myCompositeCollectionGetters.put(signature, subTagsList.value());
                return true;
            }
            String qname2 = this.getSubTagNameForCollection(method2);
            if (qname2 != null) {
                XmlName xmlName = DomImplUtil.createXmlName(qname2, type, method2);
                assert (!this.myFixedChildrenGetters.containsKey(xmlName)) : "Collection and fixed children cannot intersect: " + qname2;
                this.myCollectionChildrenTypes.put(xmlName, type);
                this.myCollectionGetters.put((Object)xmlName, (Object)method2);
                return true;
            }
        }
        return false;
    }

    private static boolean isCoreMethod(JavaMethod method2) {
        if (ourDomElementMethods.contains(method2.getSignature())) {
            return true;
        }
        Class aClass = method2.getDeclaringClass();
        return aClass.equals(GenericAttributeValue.class) || aClass.equals(GenericDomValue.class) && "getConverter".equals(method2.getName());
    }

    @Nullable
    private String getSubTagName(JavaMethod method2) {
        SubTag subTagAnnotation = (SubTag)method2.getAnnotation(SubTag.class);
        if (subTagAnnotation == null || StringUtil.isEmpty((String)subTagAnnotation.value())) {
            return this.getNameFromMethod(method2, false);
        }
        return subTagAnnotation.value();
    }

    @Nullable
    private String getSubTagNameForCollection(JavaMethod method2) {
        SubTagList subTagList = (SubTagList)method2.getAnnotation(SubTagList.class);
        if (subTagList == null || StringUtil.isEmpty((String)subTagList.value())) {
            String propertyName = StaticGenericInfoBuilder.getPropertyName(method2);
            if (propertyName != null) {
                String singular = StringUtil.unpluralize((String)propertyName);
                assert (singular != null) : "Can't unpluralize: " + propertyName;
                return this.getNameStrategy(false).convertName(singular);
            }
            return null;
        }
        return subTagList.value();
    }

    @Nullable
    private String getNameFromMethod(JavaMethod method2, boolean isAttribute) {
        String propertyName = StaticGenericInfoBuilder.getPropertyName(method2);
        return propertyName == null ? null : this.getNameStrategy(isAttribute).convertName(propertyName);
    }

    @Nullable
    private static String getPropertyName(JavaMethod method2) {
        return StringUtil.getPropertyName((String)method2.getMethodName());
    }

    @NotNull
    private DomNameStrategy getNameStrategy(boolean isAttribute) {
        DomNameStrategy strategy = DomImplUtil.getDomNameStrategy(ReflectionUtil.getRawType((Type)this.myClass), isAttribute);
        DomNameStrategy domNameStrategy = strategy != null ? strategy : DomNameStrategy.HYPHEN_STRATEGY;
        if (domNameStrategy == null) {
            StaticGenericInfoBuilder.$$$reportNull$$$0(0);
        }
        return domNameStrategy;
    }

    JavaMethod getCustomChildrenGetter() {
        return this.myCustomChildrenGetter;
    }

    Map<JavaMethodSignature, AttributeChildDescriptionImpl> getAttributes() {
        return this.myAttributes;
    }

    Map<JavaMethodSignature, Pair<FixedChildDescriptionImpl, Integer>> getFixedGetters() {
        HashMap<JavaMethodSignature, Pair<FixedChildDescriptionImpl, Integer>> map2 = new HashMap<JavaMethodSignature, Pair<FixedChildDescriptionImpl, Integer>>();
        Set<XmlName> names2 = this.myFixedChildrenGetters.keySet();
        for (XmlName name : names2) {
            int i22;
            int[] ints;
            Int2ObjectMap<Collection<JavaMethod>> map1 = this.myFixedChildrenGetters.get(name);
            int max = 0;
            for (int i22 : ints = map1.keySet().toIntArray()) {
                max = Math.max(max, i22);
            }
            int count = max + 1;
            Collection[] getters = new Collection[count];
            int[] nArray = ints;
            i22 = nArray.length;
            for (int j = 0; j < i22; ++j) {
                int i3 = nArray[j];
                getters[i3] = (Collection)map1.get(i3);
            }
            FixedChildDescriptionImpl description = new FixedChildDescriptionImpl(name, ((JavaMethod)((Collection)map1.get(0)).iterator().next()).getGenericReturnType(), count, getters);
            for (i22 = 0; i22 < getters.length; ++i22) {
                Collection collection = getters[i22];
                for (JavaMethod method2 : collection) {
                    map2.put(method2.getSignature(), (Pair<FixedChildDescriptionImpl, Integer>)Pair.create((Object)description, (Object)i22));
                }
            }
        }
        return map2;
    }

    Map<JavaMethodSignature, CollectionChildDescriptionImpl> getCollectionGetters() {
        HashMap<JavaMethodSignature, CollectionChildDescriptionImpl> getters = new HashMap<JavaMethodSignature, CollectionChildDescriptionImpl>();
        for (XmlName xmlName : this.myCollectionGetters.keySet()) {
            Collection collGetters = this.myCollectionGetters.get((Object)xmlName);
            JavaMethod method2 = (JavaMethod)collGetters.iterator().next();
            CollectionChildDescriptionImpl description = new CollectionChildDescriptionImpl(xmlName, DomReflectionUtil.extractCollectionElementType((Type)method2.getGenericReturnType()), collGetters);
            for (JavaMethod getter : collGetters) {
                getters.put(getter.getSignature(), description);
            }
        }
        return getters;
    }

    Map<JavaMethodSignature, Pair<String, String[]>> getCompositeCollectionAdders() {
        return this.myCompositeCollectionAdders;
    }

    Map<JavaMethodSignature, String[]> getCompositeCollectionGetters() {
        return this.myCompositeCollectionGetters;
    }

    public JavaMethod getNameValueGetter() {
        return this.myNameValueGetter;
    }

    public boolean isValueElement() {
        return this.myValueElement;
    }

    private static /* synthetic */ String lambda$new$1(JavaMethod method2) {
        return "\n  " + method2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/StaticGenericInfoBuilder", "getNameStrategy"));
    }
}

