/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.highlighter.DomSupportEnabled;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.source.xml.XmlTagDelegate;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IdempotenceChecker;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.EvaluatedXmlNameImpl;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.AbstractCollectionChildDescription;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildInvocationHandler;
import com.intellij.util.xml.impl.CollectionElementInvocationHandler;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomFileMetaData;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.impl.IndexedElementInvocationHandler;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.stubs.DomStub;
import com.intellij.util.xml.stubs.ElementStub;
import com.intellij.util.xml.stubs.FileStub;
import com.intellij.xml.util.IncludedXmlTag;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DomCreator {
    DomCreator() {
    }

    @Nullable
    static DomInvocationHandler createTagHandler(@NotNull XmlTag tag2) {
        PsiElement candidate;
        if (tag2 == null) {
            DomCreator.$$$reportNull$$$0(0);
        }
        if (!((candidate = PhysicalDomParentStrategy.getParentTagCandidate((XmlElement)tag2)) instanceof XmlTag)) {
            return DomCreator.createRootHandler(tag2);
        }
        XmlTag parentTag = (XmlTag)candidate;
        DomInvocationHandler parent = DomCreator.getParentDom(parentTag);
        if (parent == null) {
            return null;
        }
        String localName = tag2.getLocalName();
        if (StringUtil.isEmpty((String)localName)) {
            return null;
        }
        DomGenericInfoEx info2 = parent.getGenericInfo();
        DomFixedChildDescription fixedDescription = (DomFixedChildDescription)DomCreator.findChildrenDescription(info2.getFixedChildrenDescriptions(), tag2, parent);
        if (fixedDescription != null) {
            return DomCreator.createIndexedHandler(parent, localName, tag2.getNamespace(), fixedDescription, tag2);
        }
        DomCollectionChildDescription collectionDescription = (DomCollectionChildDescription)DomCreator.findChildrenDescription(info2.getCollectionChildrenDescriptions(), tag2, parent);
        if (collectionDescription != null) {
            return DomCreator.createCollectionHandler(tag2, collectionDescription, parent, parentTag);
        }
        return DomCreator.createCustomHandler(tag2, parent, localName, info2);
    }

    @Nullable
    private static DomInvocationHandler createRootHandler(XmlTag xmlTag) {
        DomRootInvocationHandler handler2;
        DomFileElement element2;
        PsiFile file2 = xmlTag.getContainingFile();
        DomFileElement domFileElement = element2 = file2 instanceof XmlFile ? DomManagerImpl.getDomManager(file2.getProject()).getFileElement((XmlFile)file2) : null;
        if (element2 != null && (handler2 = element2.getRootHandler()).getXmlTag() == xmlTag) {
            return handler2;
        }
        return null;
    }

    @Nullable
    private static DomInvocationHandler createIndexedHandler(DomInvocationHandler parent, String localName, String namespace, DomFixedChildDescription description, XmlTag tag2) {
        int totalCount = description.getCount();
        int index2 = 0;
        XmlTag current2 = tag2;
        while ((current2 = current2.getPrevSibling()) != null) {
            XmlTag xmlTag;
            if (!(current2 instanceof XmlTag) || !localName.equals((xmlTag = current2).getLocalName()) || !namespace.equals(xmlTag.getNamespace()) || ++index2 < totalCount) continue;
            return null;
        }
        DomManagerImpl myDomManager = parent.getManager();
        return new IndexedElementInvocationHandler(parent.createEvaluatedXmlName(description.getXmlName()), (FixedChildDescriptionImpl)description, index2, new PhysicalDomParentStrategy((XmlElement)tag2, myDomManager), myDomManager, null);
    }

    @NotNull
    private static CollectionElementInvocationHandler createCollectionHandler(XmlTag tag2, DomCollectionChildDescription description, DomInvocationHandler parent, XmlTag parentTag) {
        DomStub parentStub = parent.getStub();
        if (parentStub != null) {
            int index2 = JBIterable.of((Object[])DomCreator.findSubTagsWithoutIncludes(parentTag, tag2.getName(), tag2.getNamespace())).filter(t -> !(t instanceof IncludedXmlTag)).indexOf(t -> t == tag2);
            ElementStub stub = parentStub.getElementStub(tag2.getLocalName(), index2);
            if (stub != null) {
                XmlName name = description.getXmlName();
                EvaluatedXmlNameImpl evaluatedXmlName = EvaluatedXmlNameImpl.createEvaluatedXmlName((XmlName)name, (String)name.getNamespaceKey(), (boolean)true);
                return new CollectionElementInvocationHandler((EvaluatedXmlName)evaluatedXmlName, (AbstractDomChildDescriptionImpl)description, parent.getManager(), stub);
            }
        }
        return new CollectionElementInvocationHandler(description.getType(), tag2, (AbstractCollectionChildDescription)description, parent, null);
    }

    private static XmlTag @NotNull [] findSubTagsWithoutIncludes(@NotNull XmlTag parentTag, @NlsSafe String localName, @Nullable @NlsSafe String namespace) {
        if (parentTag == null) {
            DomCreator.$$$reportNull$$$0(1);
        }
        XmlTag[] xmlTagArray = XmlTagDelegate.findSubTags(localName, namespace, parentTag instanceof XmlTagImpl ? ((XmlTagImpl)parentTag).getSubTags(false) : parentTag.getSubTags());
        if (xmlTagArray == null) {
            DomCreator.$$$reportNull$$$0(2);
        }
        return xmlTagArray;
    }

    @Nullable
    private static DomInvocationHandler createCustomHandler(XmlTag tag2, DomInvocationHandler parent, String localName, DomGenericInfoEx info2) {
        List customs = info2.getCustomNameChildrenDescription();
        if (customs.isEmpty()) {
            return null;
        }
        XmlFile file2 = parent.getFile();
        for (DomFixedChildDescription description : info2.getFixedChildrenDescriptions()) {
            XmlName xmlName = description.getXmlName();
            if (!localName.equals(xmlName.getLocalName()) || !DomImplUtil.isNameSuitable(xmlName, tag2, parent, file2)) continue;
            return null;
        }
        for (DomFixedChildDescription description : customs) {
            if (description.getTagNameDescriptor() == null) continue;
            AbstractCollectionChildDescription desc = (AbstractCollectionChildDescription)description;
            Type type = description.getType();
            return new CollectionElementInvocationHandler(type, tag2, desc, parent, null);
        }
        return null;
    }

    @Nullable
    static DomFileElementImpl<?> createFileElement(XmlFile xmlFile) {
        ObjectStubTree<?> stubTree;
        VirtualFile file2 = xmlFile.getVirtualFile();
        if (!(xmlFile.getFileType() instanceof DomSupportEnabled) || file2 != null && ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file2)) {
            IdempotenceChecker.logTrace("DOM unsupported");
            return null;
        }
        DomFileDescription<?> description = DomCreator.findFileDescription(xmlFile);
        if (IdempotenceChecker.isLoggingEnabled()) {
            IdempotenceChecker.logTrace("DOM file description: " + description);
        }
        if (description == null) {
            return null;
        }
        XmlName xmlName = DomImplUtil.createXmlName(description.getRootTagName(), description.getRootElementClass(), null);
        assert (xmlName != null);
        EvaluatedXmlNameImpl rootTagName1 = EvaluatedXmlNameImpl.createEvaluatedXmlName((XmlName)xmlName, (String)xmlName.getNamespaceKey(), (boolean)false);
        FileStub stub = null;
        DomFileMetaData meta = DomApplicationComponent.getInstance().findMeta(description);
        if (meta != null && meta.hasStubs() && file2 instanceof VirtualFileWithId && !DomCreator.isFileParsed(xmlFile) && FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() == null && (stubTree = StubTreeLoader.getInstance().readFromVFile(xmlFile.getProject(), file2)) != null) {
            stub = (FileStub)stubTree.getRoot();
        }
        DomFileElementImpl element2 = new DomFileElementImpl(xmlFile, rootTagName1, description, stub);
        xmlFile.putUserData(DomManagerImpl.CACHED_FILE_ELEMENT, new WeakReference(element2));
        return element2;
    }

    private static boolean isFileParsed(XmlFile myXmlFile) {
        return myXmlFile instanceof PsiFileEx && ((PsiFileEx)myXmlFile).isContentsLoaded();
    }

    @Nullable
    private static DomFileDescription<?> findFileDescription(XmlFile file2) {
        DomFileDescription mockDescription = (DomFileDescription)file2.getUserData(DomManagerImpl.MOCK_DESCRIPTION);
        if (mockDescription != null) {
            return mockDescription;
        }
        Project project = file2.getProject();
        XmlFile originalFile = (XmlFile)file2.getOriginalFile();
        DomManagerImpl domManager = DomManagerImpl.getDomManager(project);
        if (!originalFile.equals(file2)) {
            DomFileElement element2 = domManager.getFileElement(originalFile);
            if (IdempotenceChecker.isLoggingEnabled()) {
                IdempotenceChecker.logTrace("Copy DOM from original file: " + (DomFileElementImpl)element2);
            }
            return element2 == null ? null : element2.getFileDescription();
        }
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file2);
        Condition condition = d -> d.isMyFile(file2, module);
        String rootTagLocalName = DomService.getInstance().getXmlFileHeader(file2).getRootTagLocalName();
        DomFileDescription description = (DomFileDescription)ContainerUtil.find(domManager.getFileDescriptions(rootTagLocalName), (Condition)condition);
        return description != null ? description : (DomFileDescription)ContainerUtil.find(domManager.getAcceptingOtherRootTagNameDescriptions(), (Condition)condition);
    }

    @Nullable
    static DomInvocationHandler getParentDom(@NotNull XmlTag tag2) {
        if (tag2 == null) {
            DomCreator.$$$reportNull$$$0(3);
        }
        LinkedHashSet<XmlTag> allParents = new LinkedHashSet<XmlTag>();
        XmlTag each = tag2;
        while (each instanceof XmlTag && allParents.add(each)) {
            each = PhysicalDomParentStrategy.getParentTagCandidate((XmlElement)each);
        }
        ArrayList list2 = new ArrayList(allParents);
        Collections.reverse(list2);
        DomManagerImpl manager2 = DomManagerImpl.getDomManager(tag2.getProject());
        for (XmlTag xmlTag : list2) {
            manager2.getDomHandler((XmlElement)xmlTag);
        }
        return manager2.getDomHandler((XmlElement)tag2);
    }

    @Nullable
    private static <T extends DomChildrenDescription> T findChildrenDescription(List<T> descriptions, XmlTag tag2, DomInvocationHandler parent) {
        XmlFile file2 = parent.getFile();
        int size = descriptions.size();
        for (int i2 = 0; i2 < size; ++i2) {
            DomChildrenDescription description = (DomChildrenDescription)descriptions.get(i2);
            if (!DomImplUtil.isNameSuitable(description.getXmlName(), tag2, parent, file2)) continue;
            return (T)description;
        }
        return null;
    }

    @Nullable
    static AttributeChildInvocationHandler createAttributeHandler(@NotNull XmlAttribute attribute) {
        XmlTag tag2;
        DomInvocationHandler handler2;
        if (attribute == null) {
            DomCreator.$$$reportNull$$$0(4);
        }
        DomInvocationHandler domInvocationHandler = handler2 = (tag2 = PhysicalDomParentStrategy.getParentTag((XmlElement)attribute)) == null ? null : DomCreator.getParentDom(tag2);
        if (handler2 == null) {
            return null;
        }
        String localName = attribute.getLocalName();
        Ref result2 = Ref.create(null);
        handler2.getGenericInfo().processAttributeChildrenDescriptions((Processor<? super AttributeChildDescriptionImpl>)((Processor)description -> {
            EvaluatedXmlName evaluatedXmlName;
            String ns;
            if (description.getXmlName().getLocalName().equals(localName) && ((ns = (evaluatedXmlName = handler2.createEvaluatedXmlName(description.getXmlName())).getNamespace((XmlElement)tag2, handler2.getFile())).equals(tag2.getNamespace()) && localName.equals(attribute.getName()) || ns.equals(attribute.getNamespace()))) {
                DomManagerImpl manager2 = handler2.getManager();
                result2.set((Object)new AttributeChildInvocationHandler(evaluatedXmlName, (AttributeChildDescriptionImpl)description, manager2, new PhysicalDomParentStrategy((XmlElement)attribute, manager2), null));
                return false;
            }
            return true;
        }));
        return (AttributeChildInvocationHandler)((Object)result2.get());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentTag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/DomCreator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/DomCreator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findSubTagsWithoutIncludes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTagHandler";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findSubTagsWithoutIncludes";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParentDom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAttributeHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

