/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolderImpl;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManagerImpl;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import com.intellij.util.xml.impl.DomManagerImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDomAnnotator
implements Annotator {
    @Nullable
    private static DomElement getDomElement(PsiElement psiElement, DomManager myDomManager) {
        if (psiElement instanceof XmlTag) {
            return myDomManager.getDomElement((XmlTag)psiElement);
        }
        if (psiElement instanceof XmlAttribute) {
            return myDomManager.getDomElement((XmlAttribute)psiElement);
        }
        return null;
    }

    public <T extends DomElement> void runInspection(@Nullable DomElementsInspection<T> inspection, DomFileElement<T> fileElement, List<? super Annotation> toFill) {
        if (inspection == null) {
            return;
        }
        DomElementAnnotationsManagerImpl annotationsManager = this.getAnnotationsManager((DomElement)fileElement);
        if (annotationsManager.isHolderUpToDate((DomElement)fileElement) && annotationsManager.getProblemHolder((DomElement)fileElement).isInspectionCompleted(inspection)) {
            return;
        }
        DomElementAnnotationHolderImpl annotationHolder = new DomElementAnnotationHolderImpl(true, fileElement);
        inspection.checkFileElement(fileElement, (DomElementAnnotationHolder)annotationHolder);
        annotationsManager.appendProblems(fileElement, annotationHolder, inspection.getClass());
        Iterator iterator2 = annotationHolder.iterator();
        while (iterator2.hasNext()) {
            DomElementProblemDescriptor descriptor2 = (DomElementProblemDescriptor)iterator2.next();
            toFill.addAll(descriptor2.getAnnotations());
        }
        toFill.addAll((Collection<? super Annotation>)annotationHolder.getAnnotations());
    }

    protected DomElementAnnotationsManagerImpl getAnnotationsManager(DomElement element2) {
        return (DomElementAnnotationsManagerImpl)DomElementAnnotationsManager.getInstance((Project)element2.getManager().getProject());
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        DomElement domElement;
        if (psiElement == null) {
            DefaultDomAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            DefaultDomAnnotator.$$$reportNull$$$0(1);
        }
        if (!(psiElement instanceof XmlTag) && !(psiElement instanceof XmlAttribute)) {
            return;
        }
        PsiFile file2 = holder.getCurrentAnnotationSession().getFile();
        DomManagerImpl domManager = DomManagerImpl.getDomManager(file2.getProject());
        DomFileDescription<?> description = domManager.getDomFileDescription((PsiElement)file2);
        if (description != null && (domElement = DefaultDomAnnotator.getDomElement(psiElement, domManager)) != null) {
            DomFileElement root = DomUtil.getFileElement((DomElement)domElement);
            this.runInspection(this.getAnnotationsManager(domElement).getMockInspection(root), root, (List)holder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/xml/impl/DefaultDomAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

