/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.Intersect;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.PrimaryKey;
import com.intellij.util.xml.StableElement;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.sf.cglib.proxy.AdvancedProxy;
import net.sf.cglib.proxy.InvocationHandler;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelMergerImpl
implements ModelMerger {
    private final List<Pair<ModelMerger.InvocationStrategy, Class<?>>> myInvocationStrategies = new ArrayList();
    private final List<ModelMerger.MergingStrategy> myMergingStrategies = new ArrayList<ModelMerger.MergingStrategy>();
    private final List<Class<?>> myMergingStrategyClasses = new ArrayList();
    private static final Class<MergedObject> MERGED_OBJECT_CLASS = MergedObject.class;
    private final ConcurrentMap<Method, List<Pair<ModelMerger.InvocationStrategy, Class<?>>>> myAcceptsCache = ConcurrentFactoryMap.createMap(method2 -> {
        ArrayList result2 = new ArrayList();
        for (int i2 = this.myInvocationStrategies.size() - 1; i2 >= 0; --i2) {
            Pair<ModelMerger.InvocationStrategy, Class<?>> pair = this.myInvocationStrategies.get(i2);
            if (!((ModelMerger.InvocationStrategy)pair.first).accepts(method2)) continue;
            result2.add(pair);
        }
        return result2;
    });
    private static final Map<Class<?>, Method> ourPrimaryKeyMethods = new HashMap();

    public ModelMergerImpl() {
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method2) {
                return true;
            }

            public Object invokeMethod(JavaMethod javaMethod, Object proxy, Object[] args, List<?> implementations) throws IllegalAccessException, InvocationTargetException {
                Method method2 = javaMethod.getMethod();
                List<Object> results = ModelMergerImpl.this.getMergedImplementations(method2, args, method2.getReturnType(), implementations, ModelMergerImpl.isIntersectionMethod(javaMethod));
                return results.isEmpty() ? null : results.get(0);
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method2) {
                return Collection.class.isAssignableFrom(method2.getReturnType());
            }

            public Object invokeMethod(JavaMethod method2, Object proxy, Object[] args, List<?> implementations) throws IllegalAccessException, InvocationTargetException {
                Type type = DomReflectionUtil.extractCollectionElementType((Type)method2.getGenericReturnType());
                assert (type != null) : "No generic return type in method " + method2;
                return ModelMergerImpl.this.getMergedImplementations(method2.getMethod(), args, ReflectionUtil.getRawType((Type)type), implementations, ModelMergerImpl.isIntersectionMethod(method2));
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method2) {
                return Object.class.equals(method2.getDeclaringClass());
            }

            public Object invokeMethod(JavaMethod method2, Object proxy, Object[] args, List<?> implementations) {
                @NonNls String methodName = method2.getName();
                if ("toString".equals(methodName)) {
                    return "Merger: " + implementations;
                }
                if ("hashCode".equals(methodName)) {
                    int result2 = 1;
                    for (Object element2 : implementations) {
                        result2 = 31 * result2 + element2.hashCode();
                    }
                    return result2;
                }
                if ("equals".equals(methodName)) {
                    Object arg = args[0];
                    return arg instanceof MergedObject && implementations.equals(((MergedObject)arg).getImplementations());
                }
                return null;
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method2) {
                return "isValid".equals(method2.getName());
            }

            public Object invokeMethod(JavaMethod method2, Object proxy, Object[] args, List<?> implementations) {
                for (Object implementation : implementations) {
                    if (((Boolean)method2.invoke(implementation, args)).booleanValue()) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method2) {
                return Void.TYPE.equals(method2.getReturnType());
            }

            public Object invokeMethod(JavaMethod method2, Object proxy, Object[] args, List<?> implementations) {
                for (Object t : implementations) {
                    method2.invoke(t, args);
                }
                return null;
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method2) {
                return MERGED_OBJECT_CLASS.equals(method2.getDeclaringClass());
            }

            public Object invokeMethod(JavaMethod method2, Object proxy, Object[] args, List<?> implementations) {
                assert ("getImplementations".equals(method2.getName()));
                return implementations;
            }
        });
        this.addInvocationStrategy(DomElement.class, new ModelMerger.InvocationStrategy<DomElement>(){

            public boolean accepts(Method method2) {
                return DomInvocationHandler.ACCEPT_METHOD.equals(method2);
            }

            public Object invokeMethod(JavaMethod method2, DomElement proxy, Object[] args, List<? extends DomElement> implementations) {
                DomElementVisitor visitor = (DomElementVisitor)args[0];
                ((DomManagerImpl)implementations.get(0).getManager()).getApplicationComponent().getVisitorDescription(visitor.getClass()).acceptElement(visitor, proxy);
                return null;
            }
        });
        this.addInvocationStrategy(DomElement.class, new ModelMerger.InvocationStrategy<DomElement>(){

            public boolean accepts(Method method2) {
                return DomInvocationHandler.ACCEPT_CHILDREN_METHOD.equals(method2);
            }

            public Object invokeMethod(JavaMethod method2, DomElement proxy, Object[] args, List<? extends DomElement> implementations) {
                DomElementVisitor visitor = (DomElementVisitor)args[0];
                for (AbstractDomChildrenDescription description : implementations.get(0).getGenericInfo().getChildrenDescriptions()) {
                    for (DomElement value2 : description.getValues(proxy)) {
                        value2.accept(visitor);
                    }
                }
                return null;
            }
        });
    }

    private static boolean isIntersectionMethod(JavaMethod javaMethod) {
        return javaMethod.getMethod().getAnnotation(Intersect.class) != null;
    }

    public <T> void addInvocationStrategy(Class<T> aClass, ModelMerger.InvocationStrategy<T> strategy) {
        this.myInvocationStrategies.add(Pair.create(strategy, aClass));
    }

    public <T> void addMergingStrategy(Class<T> aClass, ModelMerger.MergingStrategy<T> strategy) {
        this.myMergingStrategies.add(strategy);
        this.myMergingStrategyClasses.add(aClass);
    }

    public <T> T mergeModels(Class<T> aClass, T ... implementations) {
        if (implementations.length == 1) {
            return implementations[0];
        }
        MergingInvocationHandler<T> handler2 = new MergingInvocationHandler<T>(aClass, Arrays.asList(implementations));
        return this._mergeModels(aClass, handler2, implementations);
    }

    public <T> T mergeModels(Class<T> aClass, Collection<? extends T> implementations) {
        return (T)this.mergeModels(aClass, implementations.toArray());
    }

    private <T> T _mergeModels(Class<? super T> aClass, MergingInvocationHandler<T> handler2, T ... implementations) {
        Set commonClasses = ModelMergerImpl.getCommonClasses(new HashSet(), implementations);
        commonClasses.add(MERGED_OBJECT_CLASS);
        commonClasses.add(aClass);
        return AdvancedProxy.createProxy(handler2, null, commonClasses.toArray(ArrayUtil.EMPTY_CLASS_ARRAY));
    }

    private static <T extends Collection<Class<?>>> T getCommonClasses(T result2, Object ... implementations) {
        if (implementations.length > 0) {
            DomUtil.getAllInterfaces(implementations[0].getClass(), result2);
            for (int i2 = 1; i2 < implementations.length; ++i2) {
                ArrayList list1 = new ArrayList();
                DomUtil.getAllInterfaces(implementations[i2].getClass(), list1);
                result2.retainAll(list1);
            }
        }
        return result2;
    }

    @Nullable
    private static Object getPrimaryKey(Object implementation, boolean singleValuedInvocation) {
        Method method2 = ModelMergerImpl.getPrimaryKeyMethod(implementation.getClass());
        if (method2 != null) {
            Object o = DomReflectionUtil.invokeMethod((Method)method2, (Object)implementation, (Object[])new Object[0]);
            return ReflectionUtil.isAssignable(GenericValue.class, method2.getReturnType()) ? ((GenericValue)o).getValue() : o;
        }
        if (implementation instanceof GenericValue) {
            return singleValuedInvocation ? Boolean.TRUE : ((GenericValue)implementation).getValue();
        }
        return null;
    }

    @Nullable
    private static Method getPrimaryKeyMethod(Class<?> aClass) {
        Method method2 = ourPrimaryKeyMethods.get(aClass);
        if (method2 == null) {
            Method method1;
            if (ourPrimaryKeyMethods.containsKey(aClass)) {
                return null;
            }
            Iterator iterator2 = ReflectionUtil.getClassPublicMethods(aClass).iterator();
            while (iterator2.hasNext() && (method2 = ModelMergerImpl.findPrimaryKeyAnnotatedMethod(method1 = (Method)iterator2.next(), aClass)) == null) {
            }
            ourPrimaryKeyMethods.put(aClass, method2);
        }
        return method2;
    }

    @Nullable
    private static Method findPrimaryKeyAnnotatedMethod(@NotNull Method sampleMethod, @NotNull Class<?> aClass) {
        if (sampleMethod == null) {
            ModelMergerImpl.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            ModelMergerImpl.$$$reportNull$$$0(1);
        }
        if (sampleMethod.getParameterCount() != 0 || sampleMethod.getReturnType() == Void.TYPE) {
            return null;
        }
        return JavaMethodSignature.findMethod((Method)sampleMethod, aClass, method2 -> method2.isAnnotationPresent(PrimaryKey.class));
    }

    private List<Object> getMergedImplementations(Method method2, Object[] args, Class returnType, List<?> implementations, boolean intersect) throws IllegalAccessException, InvocationTargetException {
        ArrayList<Object> results = new ArrayList<Object>();
        if (returnType.isInterface()) {
            SmartList orderedPrimaryKeys = new SmartList();
            Map map2 = FactoryMap.create(arg_0 -> ModelMergerImpl.lambda$getMergedImplementations$2((List)orderedPrimaryKeys, arg_0));
            Map counts = FactoryMap.create(key -> new int[implementations.size()]);
            for (int i2 = 0; i2 < implementations.size(); ++i2) {
                Object t = implementations.get(i2);
                Object o = method2.invoke(t, args);
                if (o instanceof Collection) {
                    for (Object o1 : (Collection)o) {
                        ModelMergerImpl.addToMaps(o1, counts, map2, i2, results, false, intersect);
                    }
                    continue;
                }
                if (o == null) continue;
                ModelMergerImpl.addToMaps(o, counts, map2, i2, results, true, intersect);
            }
            for (Object primaryKey : orderedPrimaryKeys) {
                for (Set objects : (List)map2.get(primaryKey)) {
                    results.add(this.mergeImplementations(returnType, new ArrayList<Object>(objects)));
                }
            }
        } else {
            HashSet<Object> map3 = new HashSet<Object>();
            for (Object t : implementations) {
                Object o = method2.invoke(t, args);
                if (o instanceof Collection) {
                    map3.addAll((Collection)o);
                    continue;
                }
                if (o == null) continue;
                map3.add(o);
                break;
            }
            results.addAll(map3);
        }
        return results;
    }

    private Object mergeImplementations(Class returnType, List<Object> implementations) {
        for (int i2 = this.myMergingStrategies.size() - 1; i2 >= 0; --i2) {
            Object o;
            if (!ReflectionUtil.isAssignable(this.myMergingStrategyClasses.get(i2), (Class)returnType) || (o = this.myMergingStrategies.get(i2).mergeChildren(returnType, implementations)) == null) continue;
            return o;
        }
        if (implementations.size() == 1) {
            return implementations.get(0);
        }
        return this.mergeModels((Class)returnType, (Collection)implementations);
    }

    private static boolean addToMaps(Object o, Map<Object, int[]> counts, Map<Object, List<Set<Object>>> map2, int index2, List<Object> results, boolean singleValuedInvocation, boolean intersect) {
        Object primaryKey = ModelMergerImpl.getPrimaryKey(o, singleValuedInvocation);
        if (primaryKey != null || singleValuedInvocation) {
            int n;
            List<Set<Object>> list2 = map2.get(primaryKey);
            int[] indices = counts.get(primaryKey);
            if (intersect) {
                n = indices[index2];
            } else {
                int n2 = index2;
                int n3 = indices[n2];
                n = n3;
                indices[n2] = n3 + 1;
            }
            int objIndex = n;
            if (list2.size() <= objIndex) {
                list2.add(new LinkedHashSet());
            }
            list2.get(objIndex).add(o);
            return false;
        }
        results.add(o);
        return true;
    }

    private static /* synthetic */ List lambda$getMergedImplementations$2(List orderedPrimaryKeys, Object key) {
        orderedPrimaryKeys.add(key);
        return new SmartList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sampleMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/xml/ModelMergerImpl";
        objectArray[2] = "findPrimaryKeyAnnotatedMethod";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class MergingInvocationHandler<T>
    implements InvocationHandler {
        private final Class<? super T> myClass;
        private List<? extends T> myImplementations;

        public MergingInvocationHandler(Class<T> aClass, List<? extends T> implementations) {
            this(aClass);
            for (T implementation : implementations) {
                if (implementation instanceof StableElement) {
                    throw new AssertionError((Object)("Stable values merging is prohibited: " + implementation));
                }
            }
            this.myImplementations = implementations;
        }

        public MergingInvocationHandler(Class<T> aClass) {
            this.myClass = aClass;
        }

        @NotNull
        private ModelMerger.InvocationStrategy findStrategy(Object proxy, Method method2) {
            for (Pair pair : (List)ModelMergerImpl.this.myAcceptsCache.get(method2)) {
                if (!Object.class.equals(pair.second) && !((Class)pair.second).isInstance(proxy)) continue;
                ModelMerger.InvocationStrategy invocationStrategy = (ModelMerger.InvocationStrategy)pair.first;
                if (invocationStrategy == null) {
                    MergingInvocationHandler.$$$reportNull$$$0(0);
                }
                return invocationStrategy;
            }
            throw new AssertionError((Object)"impossible");
        }

        public Object invoke(Object proxy, Method method2, Object[] args) throws Throwable {
            try {
                return this.findStrategy(proxy, method2).invokeMethod(this.getJavaMethod(method2), proxy, args, this.myImplementations);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private JavaMethod getJavaMethod(Method method2) {
            if (ReflectionUtil.isAssignable(MERGED_OBJECT_CLASS, method2.getDeclaringClass())) {
                return JavaMethod.getMethod(MERGED_OBJECT_CLASS, (Method)method2);
            }
            if (ReflectionUtil.isAssignable(method2.getDeclaringClass(), this.myClass)) {
                return JavaMethod.getMethod(this.myClass, (Method)method2);
            }
            return JavaMethod.getMethod(method2.getDeclaringClass(), (Method)method2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ModelMergerImpl$MergingInvocationHandler", "findStrategy"));
        }
    }
}

