/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ClickListener;
import com.intellij.ui.RelativeFont;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Advertiser {
    private final List<Item> myTexts = ContainerUtil.createLockFreeCopyOnWriteList();
    private final JPanel myComponent = new JPanel(new AdvertiserLayout());
    private final AtomicInteger myCurrentItem = new AtomicInteger(0);
    private final JLabel myTextPanel = this.createLabel();
    private final JLabel myNextLabel;
    private Color myForeground = JBUI.CurrentTheme.Advertiser.foreground();

    public Advertiser() {
        this.myNextLabel = new JLabel(CodeInsightBundle.message((String)"label.next.tip", (Object[])new Object[0]));
        this.myNextLabel.setFont(Advertiser.adFont());
        this.myNextLabel.setForeground(JBUI.CurrentTheme.Link.Foreground.ENABLED);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                Advertiser.this.myCurrentItem.incrementAndGet();
                Advertiser.this.updateAdvertisements();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/Advertiser$1", "onClick"));
            }
        }.installOn((Component)this.myNextLabel);
        this.myNextLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.myComponent.add(this.myTextPanel);
        this.myComponent.add(this.myNextLabel);
        this.myComponent.setOpaque(true);
        this.myComponent.setBackground(JBUI.CurrentTheme.Advertiser.background());
        this.myComponent.setBorder(JBUI.CurrentTheme.Advertiser.border());
    }

    private void updateAdvertisements() {
        this.myNextLabel.setVisible(this.myTexts.size() > 1);
        if (!this.myTexts.isEmpty()) {
            Item item = this.myTexts.get(this.myCurrentItem.get() % this.myTexts.size());
            item.setForLabel(this.myTextPanel);
        } else {
            this.myTextPanel.setText("");
            this.myTextPanel.setIcon(null);
            this.myTextPanel.setForeground(this.myForeground);
        }
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    private JLabel createLabel() {
        JLabel label2 = new JLabel();
        label2.setFont(Advertiser.adFont());
        label2.setForeground(this.myForeground);
        return label2;
    }

    public void showRandomText() {
        int count = this.myTexts.size();
        this.myCurrentItem.set(count > 0 ? new Random().nextInt(count) : 0);
        this.updateAdvertisements();
    }

    public void clearAdvertisements() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myTexts.clear();
        this.myCurrentItem.set(0);
        this.updateAdvertisements();
    }

    private static Font adFont() {
        Font font = UIUtil.getLabelFont();
        RelativeFont relativeFont = RelativeFont.NORMAL.fromResource("Popup.Advertiser.fontSizeOffset", -2);
        return relativeFont.derive(font);
    }

    public void addAdvertisement(@NlsContexts.PopupAdvertisement @NotNull String text2, @Nullable Icon icon2) {
        if (text2 == null) {
            Advertiser.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myTexts.add(new Item(text2, icon2));
        this.updateAdvertisements();
    }

    public void setBorder(@Nullable Border border) {
        this.myComponent.setBorder(border);
    }

    public void setForeground(@Nullable Color foreground) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (foreground != null) {
            this.myForeground = foreground;
        }
        if (!this.myTexts.isEmpty()) {
            this.updateAdvertisements();
        }
    }

    public void setBackground(@Nullable Color background) {
        this.myComponent.setBackground(background != null ? background : JBUI.CurrentTheme.Advertiser.background());
    }

    public JComponent getAdComponent() {
        return this.myComponent;
    }

    public List<String> getAdvertisements() {
        return ContainerUtil.map(this.myTexts, item -> item.text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/ui/Advertiser", "addAdvertisement"));
    }

    private class Item {
        private final @NlsContexts.PopupAdvertisement String text;
        private final Icon icon;

        private Item(@Nullable String text2, Icon icon2) {
            if (text2 == null) {
                Item.$$$reportNull$$$0(0);
            }
            this.text = text2;
            this.icon = icon2;
        }

        private void setForLabel(JLabel label2) {
            label2.setText(this.toString());
            label2.setIcon(this.icon);
            label2.setForeground(this.getForegroundColor());
        }

        private Color getForegroundColor() {
            return this.icon != null ? UIManager.getColor("Label.foreground") : Advertiser.this.myForeground;
        }

        @NlsContexts.PopupAdvertisement
        public String toString() {
            return this.text + "  ";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/ui/Advertiser$Item", "<init>"));
        }
    }

    private class AdvertiserLayout
    implements LayoutManager {
        private AdvertiserLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Insets i2 = parent.getInsets();
            Dimension size = new Dimension();
            Dimension nextButtonSize = Advertiser.this.myNextLabel.getPreferredSize();
            FontMetrics fm = Advertiser.this.myTextPanel.getFontMetrics(Advertiser.this.myTextPanel.getFont());
            for (Item item : Advertiser.this.myTexts) {
                int width = SwingUtilities.computeStringWidth(fm, item.toString());
                if (item.icon != null) {
                    width += Advertiser.this.myTextPanel.getIconTextGap() + item.icon.getIconWidth();
                }
                int height = Math.max(fm.getHeight(), item.icon != null ? item.icon.getIconHeight() : 0) + i2.top + i2.bottom;
                size.width = Math.max(size.width, width += nextButtonSize.width + i2.left + i2.right);
                size.height = Math.max(size.height, Math.max(height, nextButtonSize.height));
            }
            return size;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension minSize = Advertiser.this.myNextLabel.getPreferredSize();
            JBInsets.addTo((Dimension)minSize, (Insets)parent.getInsets());
            return minSize;
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets i2 = parent.getInsets();
            Dimension size = parent.getSize();
            Dimension textPrefSize = Advertiser.this.myTextPanel.getPreferredSize();
            Dimension nextPrefSize = Advertiser.this.myNextLabel.getPreferredSize();
            int textWidth = i2.left + i2.right + textPrefSize.width + nextPrefSize.width <= size.width ? textPrefSize.width : size.width - nextPrefSize.width - i2.left - i2.right;
            Advertiser.this.myTextPanel.setBounds(i2.left, (size.height - textPrefSize.height) / 2, textWidth, textPrefSize.height);
            Advertiser.this.myNextLabel.setBounds(i2.left + textWidth, (size.height - nextPrefSize.height) / 2, nextPrefSize.width, nextPrefSize.height);
        }
    }
}

