/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.roots.IndexableFilesIterationMethods;
import com.intellij.util.indexing.roots.LibraryIndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.LibraryOrigin;
import com.intellij.util.indexing.roots.kind.LibraryOriginImpl;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/indexing/roots/LibraryIndexableFilesIteratorImpl;", "Lcom/intellij/util/indexing/roots/LibraryIndexableFilesIterator;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "(Lcom/intellij/openapi/roots/libraries/Library;)V", "getDebugName", "", "getIndexingProgressText", "getOrigin", "Lcom/intellij/util/indexing/roots/kind/LibraryOrigin;", "getRootsScanningProgressText", "iterateFiles", "", "project", "Lcom/intellij/openapi/project/Project;", "fileIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "fileFilter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "intellij.platform.lang.impl"})
public final class LibraryIndexableFilesIteratorImpl
implements LibraryIndexableFilesIterator {
    private final Library library;

    @NotNull
    public String getDebugName() {
        return "Library " + this.library.getPresentableName();
    }

    @NotNull
    public String getIndexingProgressText() {
        String string = IndexingBundle.message((String)"indexable.files.provider.indexing.library.name", (Object[])new Object[]{this.library.getPresentableName()});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IndexingBundle.message(\"\u2026 library.presentableName)");
        return string;
    }

    @NotNull
    public String getRootsScanningProgressText() {
        String libraryName = this.library.getName();
        CharSequence charSequence = libraryName;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string = IndexingBundle.message((String)"indexable.files.provider.scanning.library.name", (Object[])new Object[]{libraryName});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IndexingBundle.message(\"\u2026brary.name\", libraryName)");
            return string;
        }
        String string = IndexingBundle.message((String)"indexable.files.provider.scanning.additional.dependencies", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IndexingBundle.message(\"\u2026additional.dependencies\")");
        return string;
    }

    @NotNull
    public LibraryOrigin getOrigin() {
        return new LibraryOriginImpl(this.library);
    }

    public boolean iterateFiles(@NotNull Project project, @NotNull ContentIterator fileIterator, @NotNull VirtualFileFilter fileFilter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileIterator, (String)"fileIterator");
        Intrinsics.checkNotNullParameter((Object)fileFilter, (String)"fileFilter");
        boolean $i$f$runReadAction = false;
        List roots = (List)ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ LibraryIndexableFilesIteratorImpl this$0;
            {
                this.this$0 = libraryIndexableFilesIteratorImpl;
            }

            public final T compute() {
                List list2;
                boolean bl = false;
                if (Disposer.isDisposed((Disposable)((Disposable)LibraryIndexableFilesIteratorImpl.access$getLibrary$p(this.this$0)))) {
                    boolean bl2 = false;
                    list2 = CollectionsKt.emptyList();
                } else {
                    RootProvider rootProvider = LibraryIndexableFilesIteratorImpl.access$getLibrary$p(this.this$0).getRootProvider();
                    Intrinsics.checkNotNullExpressionValue((Object)rootProvider, (String)"library.rootProvider");
                    RootProvider rootProvider2 = rootProvider;
                    Object[] objectArray = rootProvider2.getFiles(OrderRootType.SOURCES);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"rootProvider.getFiles(OrderRootType.SOURCES)");
                    Collection collection = ArraysKt.toList((Object[])objectArray);
                    Object[] objectArray2 = rootProvider2.getFiles(OrderRootType.CLASSES);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"rootProvider.getFiles(OrderRootType.CLASSES)");
                    list2 = CollectionsKt.plus((Collection)collection, (Object[])objectArray2);
                }
                return (T)list2;
            }
        });
        return IndexableFilesIterationMethods.iterateRoots$default(IndexableFilesIterationMethods.INSTANCE, project, roots, fileIterator, fileFilter, false, 16, null);
    }

    public LibraryIndexableFilesIteratorImpl(@NotNull Library library2) {
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        this.library = library2;
    }

    public static final /* synthetic */ Library access$getLibrary$p(LibraryIndexableFilesIteratorImpl $this) {
        return $this.library;
    }
}

