/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.projectFilter;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.projectFilter.IncrementalProjectIndexableFilesFilter;
import com.intellij.util.indexing.projectFilter.IncrementalProjectIndexableFilesFilterHolder;
import com.intellij.util.indexing.projectFilter.ProjectIndexableFilesFilterHolder;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\r0\fH\u0016J\u0018\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/indexing/projectFilter/IncrementalProjectIndexableFilesFilterHolder;", "Lcom/intellij/util/indexing/projectFilter/ProjectIndexableFilesFilterHolder;", "()V", "myProjectFilters", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/util/indexing/projectFilter/IncrementalProjectIndexableFilesFilter;", "addFileId", "", "fileId", "", "projects", "Lkotlin/Function0;", "", "", "project", "entireProjectUpdateFinished", "entireProjectUpdateStarted", "getProjectIndexableFiles", "Lcom/intellij/util/indexing/IdFilter;", "removeFile", "intellij.platform.lang.impl"})
public final class IncrementalProjectIndexableFilesFilterHolder
extends ProjectIndexableFilesFilterHolder {
    private final ConcurrentMap<Project, IncrementalProjectIndexableFilesFilter> myProjectFilters;

    @Override
    @Nullable
    public IdFilter getProjectIndexableFiles(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!UnindexedFilesUpdater.isProjectContentFullyScanned(project) || UnindexedFilesUpdater.isIndexUpdateInProgress(project)) {
            return null;
        }
        return (IdFilter)this.myProjectFilters.get(project);
    }

    @Override
    public void entireProjectUpdateStarted(@NotNull Project project) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            boolean bl = UnindexedFilesUpdater.isIndexUpdateInProgress(project);
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            IncrementalProjectIndexableFilesFilter incrementalProjectIndexableFilesFilter = (IncrementalProjectIndexableFilesFilter)((Object)this.myProjectFilters.get(project));
            if (incrementalProjectIndexableFilesFilter == null) break block1;
            incrementalProjectIndexableFilesFilter.memoizeAndResetFileIds();
        }
    }

    @Override
    public void entireProjectUpdateFinished(@NotNull Project project) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            boolean bl = UnindexedFilesUpdater.isIndexUpdateInProgress(project);
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            IncrementalProjectIndexableFilesFilter incrementalProjectIndexableFilesFilter = (IncrementalProjectIndexableFilesFilter)((Object)this.myProjectFilters.get(project));
            if (incrementalProjectIndexableFilesFilter == null) break block1;
            incrementalProjectIndexableFilesFilter.resetPreviousFileIds();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addFileId(int fileId, @NotNull Function0<? extends Set<? extends Project>> projects) {
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        KProperty kProperty = null;
        Lazy matchedProjects2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<? extends Project>>(projects){
            final /* synthetic */ Function0 $projects;

            @NotNull
            public final Set<Project> invoke() {
                return (Set)this.$projects.invoke();
            }
            {
                this.$projects = function0;
                super(0);
            }
        }));
        Map map2 = this.myProjectFilters;
        boolean bl = false;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void p;
            Map.Entry entry2;
            Map.Entry entry3 = entry2 = iterator2.next();
            boolean bl2 = false;
            map2 = (Project)entry3.getKey();
            entry3 = entry2;
            bl2 = false;
            IncrementalProjectIndexableFilesFilter filter = (IncrementalProjectIndexableFilesFilter)((Object)entry3.getValue());
            filter.ensureFileIdPresent(fileId, (Function0<Boolean>)((Function0)new Function0<Boolean>(matchedProjects2, kProperty, (Project)p){
                final /* synthetic */ Lazy $matchedProjects;
                final /* synthetic */ KProperty $matchedProjects$metadata;
                final /* synthetic */ Project $p;

                public final boolean invoke() {
                    Lazy lazy = this.$matchedProjects;
                    Object var2_2 = null;
                    KProperty kProperty = this.$matchedProjects$metadata;
                    boolean bl = false;
                    return ((Set)lazy.getValue()).contains(this.$p);
                }
                {
                    this.$matchedProjects = lazy;
                    this.$matchedProjects$metadata = kProperty;
                    this.$p = project;
                    super(0);
                }
            }));
        }
    }

    @Override
    public boolean addFileId(int fileId, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object v = this.myProjectFilters.get(project);
        Intrinsics.checkNotNull(v);
        return ((IncrementalProjectIndexableFilesFilter)((Object)v)).ensureFileIdPresent(fileId, (Function0<Boolean>)((Function0)addFileId.2.INSTANCE));
    }

    @Override
    public void removeFile(int fileId) {
        for (IncrementalProjectIndexableFilesFilter filter : this.myProjectFilters.values()) {
            filter.removeFileId(fileId);
        }
    }

    public IncrementalProjectIndexableFilesFilterHolder() {
        super(null);
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap((Function)myProjectFilters.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ConcurrentFactoryMap.cre\u2026tIndexableFilesFilter() }");
        this.myProjectFilters = concurrentMap;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                myProjectFilters.remove(project);
            }
        });
    }
}

