/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.internal.statistic.eventLog.events.ObjectListEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0004H\u0016Jj\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u001b2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001b0\u001dJ\u0016\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryFusReporter;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "averageContentLoadingSpeed", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "contentLoadingSpeedByFileType", "Lcom/intellij/internal/statistic/eventLog/events/ObjectListEventField;", "contentLoadingSpeedForFileType", "indexingFinished", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "indexingSessionId", "indexingStarted", "indexingTime", "numberOfFileProviders", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "numberOfFilesIndexedByExtensionsDuringScan", "numberOfFilesIndexedByExtensionsWithLoadingContent", "numberOfFilesIndexedWithLoadingContent", "numberOfScannedFiles", "scanningTime", "getGroup", "reportIndexingFinished", "", "project", "Lcom/intellij/openapi/project/Project;", "", "", "", "Lcom/intellij/openapi/fileTypes/FileType;", "reportIndexingStarted", "intellij.platform.lang.impl"})
public final class ProjectIndexingHistoryFusReporter
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP;
    private static final LongEventField indexingSessionId;
    private static final LongEventField indexingTime;
    private static final LongEventField scanningTime;
    private static final IntEventField numberOfFileProviders;
    private static final IntEventField numberOfScannedFiles;
    private static final IntEventField numberOfFilesIndexedByExtensionsDuringScan;
    private static final IntEventField numberOfFilesIndexedByExtensionsWithLoadingContent;
    private static final IntEventField numberOfFilesIndexedWithLoadingContent;
    private static final LongEventField averageContentLoadingSpeed;
    private static final LongEventField contentLoadingSpeedForFileType;
    private static final ObjectListEventField contentLoadingSpeedByFileType;
    private static final VarargEventId indexingStarted;
    private static final VarargEventId indexingFinished;
    @NotNull
    public static final ProjectIndexingHistoryFusReporter INSTANCE;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    public final void reportIndexingStarted(@NotNull Project project, long indexingSessionId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        indexingStarted.log(project, new EventPair[]{ProjectIndexingHistoryFusReporter.indexingSessionId.with((Object)indexingSessionId)});
    }

    /*
     * WARNING - void declaration
     */
    public final void reportIndexingFinished(@NotNull Project project, long indexingSessionId, long indexingTime, long scanningTime, int numberOfFileProviders, int numberOfScannedFiles, int numberOfFilesIndexedByExtensionsDuringScan, int numberOfFilesIndexedByExtensionsWithLoadingContent, int numberOfFilesIndexedWithLoadingContent, long averageContentLoadingSpeed, @NotNull Map<FileType, Long> contentLoadingSpeedByFileType) {
        Collection<ObjectEventData> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(contentLoadingSpeedByFileType, (String)"contentLoadingSpeedByFileType");
        EventPair[] eventPairArray = new EventPair[10];
        eventPairArray[0] = ProjectIndexingHistoryFusReporter.indexingSessionId.with((Object)indexingSessionId);
        eventPairArray[1] = ProjectIndexingHistoryFusReporter.indexingTime.with((Object)indexingTime);
        eventPairArray[2] = ProjectIndexingHistoryFusReporter.scanningTime.with((Object)scanningTime);
        eventPairArray[3] = ProjectIndexingHistoryFusReporter.numberOfFileProviders.with((Object)numberOfFileProviders);
        eventPairArray[4] = ProjectIndexingHistoryFusReporter.numberOfScannedFiles.with((Object)StatisticsUtil.roundToHighestDigit((int)numberOfScannedFiles));
        eventPairArray[5] = ProjectIndexingHistoryFusReporter.numberOfFilesIndexedByExtensionsDuringScan.with((Object)StatisticsUtil.roundToHighestDigit((int)numberOfFilesIndexedByExtensionsDuringScan));
        eventPairArray[6] = ProjectIndexingHistoryFusReporter.numberOfFilesIndexedByExtensionsWithLoadingContent.with((Object)StatisticsUtil.roundToHighestDigit((int)numberOfFilesIndexedByExtensionsWithLoadingContent));
        eventPairArray[7] = ProjectIndexingHistoryFusReporter.numberOfFilesIndexedWithLoadingContent.with((Object)StatisticsUtil.roundToHighestDigit((int)numberOfFilesIndexedWithLoadingContent));
        eventPairArray[8] = ProjectIndexingHistoryFusReporter.averageContentLoadingSpeed.with((Object)averageContentLoadingSpeed);
        Map<FileType, Long> map2 = contentLoadingSpeedByFileType;
        ObjectListEventField objectListEventField = ProjectIndexingHistoryFusReporter.contentLoadingSpeedByFileType;
        int n = 9;
        EventPair[] eventPairArray2 = eventPairArray;
        EventPair[] eventPairArray3 = eventPairArray;
        Project project2 = project;
        VarargEventId varargEventId = indexingFinished;
        boolean $i$f$map = false;
        void var18_20 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var21_23 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var21_23.entrySet().iterator();
        while (iterator2.hasNext()) {
            void entry2;
            Map.Entry item$iv$iv;
            Map.Entry entry3 = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            ObjectEventData objectEventData = new ObjectEventData(new EventPair[]{EventFields.FileType.with(entry2.getKey()), contentLoadingSpeedForFileType.with(entry2.getValue())});
            collection.add(objectEventData);
        }
        collection = (List)destination$iv$iv;
        eventPairArray2[n] = objectListEventField.with((Object)collection);
        varargEventId.log(project2, eventPairArray3);
    }

    private ProjectIndexingHistoryFusReporter() {
    }

    static {
        ProjectIndexingHistoryFusReporter projectIndexingHistoryFusReporter;
        INSTANCE = projectIndexingHistoryFusReporter = new ProjectIndexingHistoryFusReporter();
        GROUP = new EventLogGroup("indexing.statistics", 3);
        indexingSessionId = EventFields.Long((String)"indexing_session_id");
        indexingTime = EventFields.Long((String)"indexing_time");
        scanningTime = EventFields.Long((String)"scanning_time");
        numberOfFileProviders = EventFields.Int((String)"number_of_file_providers");
        numberOfScannedFiles = EventFields.Int((String)"number_of_scanned_files");
        numberOfFilesIndexedByExtensionsDuringScan = EventFields.Int((String)"number_of_files_indexed_by_extensions_during_scan");
        numberOfFilesIndexedByExtensionsWithLoadingContent = EventFields.Int((String)"number_of_files_indexed_by_extensions_with_loading_content");
        numberOfFilesIndexedWithLoadingContent = EventFields.Int((String)"number_of_files_indexed_with_loading_content");
        averageContentLoadingSpeed = EventFields.Long((String)"average_content_loading_speed_bps");
        contentLoadingSpeedForFileType = EventFields.Long((String)"average_content_loading_speed_for_file_type_bps");
        contentLoadingSpeedByFileType = new ObjectListEventField("average_content_loading_speeds_by_file_type", new EventField[]{(EventField)EventFields.FileType, (EventField)contentLoadingSpeedForFileType});
        indexingStarted = GROUP.registerVarargEvent("started", new EventField[]{(EventField)indexingSessionId});
        indexingFinished = GROUP.registerVarargEvent("finished", new EventField[]{(EventField)indexingSessionId, (EventField)indexingTime, (EventField)scanningTime, (EventField)numberOfFileProviders, (EventField)numberOfScannedFiles, (EventField)numberOfFilesIndexedByExtensionsDuringScan, (EventField)numberOfFilesIndexedByExtensionsWithLoadingContent, (EventField)numberOfFilesIndexedWithLoadingContent, (EventField)averageContentLoadingSpeed, (EventField)contentLoadingSpeedByFileType});
    }
}

