/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.PoweredProgressIndicator;
import com.intellij.util.indexing.UnindexedFileStatus;
import com.intellij.util.indexing.UnindexedFilesFinder;
import com.intellij.util.indexing.contentQueue.IndexUpdateRunner;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistory;
import com.intellij.util.indexing.diagnostic.ScanningStatistics;
import com.intellij.util.indexing.diagnostic.dto.JsonScanningStatistics;
import com.intellij.util.indexing.roots.IndexableFileScanner;
import com.intellij.util.indexing.roots.IndexableFilesDeduplicateFilter;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.kind.ModuleRootOrigin;
import com.intellij.util.indexing.roots.kind.SdkOrigin;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingsStatistics;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.progress.ConcurrentTasksProgressManager;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class UnindexedFilesUpdater
extends DumbModeTask {
    private static final Logger LOG = Logger.getInstance(UnindexedFilesUpdater.class);
    private static final int DEFAULT_MAX_INDEXER_THREADS = 4;
    @VisibleForTesting
    public static volatile TestMode ourTestMode;
    public static final ExecutorService GLOBAL_INDEXING_EXECUTOR;
    private static final int MINIMUM_NUMBER_OF_FILES_TO_RUN_CONCURRENT_INDEXING;
    @NotNull
    private static final Key<Boolean> CONTENT_SCANNED;
    @NotNull
    private static final Key<Boolean> INDEX_UPDATE_IN_PROGRESS;
    @NotNull
    private static final Key<UnindexedFilesUpdater> RUNNING_TASK;
    private static final Object ourLastRunningTaskLock;
    private final FileBasedIndexImpl myIndex;
    private final Project myProject;
    private final boolean myStartSuspended;
    @NonNls
    private final String myIndexingReason;
    private final PushedFilePropertiesUpdater myPusher;
    @Nullable
    private final List<IndexableFilesIterator> myPredefinedIndexableFilesIterators;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnindexedFilesUpdater(@NotNull Project project, boolean startSuspended, @Nullable List<IndexableFilesIterator> predefinedIndexableFilesIterators, @Nullable @NonNls String indexingReason) {
        if (project == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(0);
        }
        super((Object)project);
        this.myIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        this.myProject = project;
        this.myStartSuspended = startSuspended;
        this.myIndexingReason = indexingReason;
        this.myPusher = PushedFilePropertiesUpdater.getInstance((Project)this.myProject);
        this.myProject.putUserData(CONTENT_SCANNED, null);
        Object object = ourLastRunningTaskLock;
        synchronized (object) {
            UnindexedFilesUpdater runningTask = (UnindexedFilesUpdater)((Object)this.myProject.getUserData(RUNNING_TASK));
            if (runningTask == null || runningTask.myPredefinedIndexableFilesIterators == null || predefinedIndexableFilesIterators == null) {
                this.myProject.putUserData(RUNNING_TASK, (Object)this);
                if (runningTask != null) {
                    if (runningTask.myPredefinedIndexableFilesIterators == null && predefinedIndexableFilesIterators != null) {
                        predefinedIndexableFilesIterators = null;
                    }
                    DumbService.getInstance((Project)project).cancelTask((DumbModeTask)runningTask);
                }
            }
        }
        this.myPredefinedIndexableFilesIterators = predefinedIndexableFilesIterators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = ourLastRunningTaskLock;
        synchronized (object) {
            UnindexedFilesUpdater lastRunningTask = (UnindexedFilesUpdater)((Object)this.myProject.getUserData(RUNNING_TASK));
            if (lastRunningTask == this) {
                this.myProject.putUserData(RUNNING_TASK, null);
            }
        }
    }

    public UnindexedFilesUpdater(@NotNull Project project) {
        if (project == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(1);
        }
        this(project, false, null, null);
    }

    public UnindexedFilesUpdater(@NotNull Project project, @Nullable @NonNls String indexingReason) {
        if (project == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(2);
        }
        this(project, false, null, indexingReason);
    }

    public UnindexedFilesUpdater(@NotNull Project project, @Nullable List<IndexableFilesIterator> predefinedIndexableFilesIterators, @Nullable @NonNls String indexingReason) {
        if (project == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(3);
        }
        this(project, false, predefinedIndexableFilesIterators, indexingReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUnindexedFiles(@NotNull ProjectIndexingHistory projectIndexingHistory, @NotNull ProgressIndicator indicator2) {
        int totalFiles;
        Map<IndexableFilesIterator, List<VirtualFile>> providerToFiles;
        List<IndexableFilesIterator> orderedProviders;
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(4);
        }
        if (indicator2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(5);
        }
        if (!IndexInfrastructure.hasIndices()) {
            return;
        }
        LOG.info("Started indexing of " + this.myProject.getName() + (String)(this.myIndexingReason == null ? "" : ". Reason: " + this.myIndexingReason));
        ProgressSuspender suspender = ProgressSuspender.getSuspender(indicator2);
        if (suspender != null) {
            this.listenToProgressSuspenderForSuspendedTimeDiagnostic(suspender, projectIndexingHistory);
        }
        if (this.myStartSuspended) {
            if (suspender == null) {
                throw new IllegalStateException("Indexing progress indicator must be suspendable!");
            }
            if (!suspender.isSuspended()) {
                suspender.suspendProcess(IndexingBundle.message((String)"progress.indexing.started.as.suspended", (Object[])new Object[0]));
            }
        }
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        Instant pushPropertiesStart = Instant.now();
        try {
            if (this.myPusher instanceof PushedFilePropertiesUpdaterImpl) {
                ((PushedFilePropertiesUpdaterImpl)this.myPusher).performDelayedPushTasks();
            }
        }
        finally {
            projectIndexingHistory.getTimes().setPushPropertiesDuration(Duration.between(pushPropertiesStart, Instant.now()));
        }
        LOG.info(snapshot.getLogResponsivenessSinceCreationMessage("Performing delayed pushing properties tasks for " + this.myProject.getName()));
        indicator2.setIndeterminate(true);
        indicator2.setText(IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
        snapshot = PerformanceWatcher.takeSnapshot();
        Instant scanFilesStart = Instant.now();
        try {
            orderedProviders = this.getOrderedProviders();
            providerToFiles = this.collectIndexableFilesConcurrently(this.myProject, indicator2, orderedProviders, projectIndexingHistory);
            if (this.myPredefinedIndexableFilesIterators == null) {
                this.myProject.putUserData(CONTENT_SCANNED, (Object)true);
            }
        }
        finally {
            projectIndexingHistory.getTimes().setScanFilesDuration(Duration.between(scanFilesStart, Instant.now()));
        }
        String scanningCompletedMessage = UnindexedFilesUpdater.getLogScanningCompletedStageMessage(projectIndexingHistory);
        LOG.info(snapshot.getLogResponsivenessSinceCreationMessage(scanningCompletedMessage));
        this.myIndex.clearIndicesIfNecessary();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.scheduleInitialVfsRefresh();
        }
        if ((totalFiles = providerToFiles.values().stream().mapToInt(it -> it.size()).sum()) == 0) {
            LOG.info("Finished for " + this.myProject.getName() + ". No files to index with loading content.");
            return;
        }
        if (SystemProperties.getBooleanProperty((String)"idea.indexes.pretendNoFiles", (boolean)false)) {
            LOG.info("Finished for " + this.myProject.getName() + ". System property 'idea.indexes.pretendNoFiles' is enabled.");
            return;
        }
        snapshot = PerformanceWatcher.takeSnapshot();
        ProgressIndicator poweredIndicator = PoweredProgressIndicator.wrap(indicator2, UnindexedFilesUpdater.getPowerForSmoothProgressIndicator());
        poweredIndicator.setIndeterminate(false);
        poweredIndicator.setFraction(0.0);
        poweredIndicator.setText(IndexingBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]));
        this.myIndex.resetSnapshotInputMappingStatistics();
        Instant startIndexing = Instant.now();
        try {
            this.indexFiles(orderedProviders, providerToFiles, projectIndexingHistory, poweredIndicator);
        }
        finally {
            projectIndexingHistory.getTimes().setIndexingDuration(Duration.between(startIndexing, Instant.now()));
        }
        LOG.info(snapshot.getLogResponsivenessSinceCreationMessage("Finished for " + this.myProject.getName() + ". Unindexed files update"));
        List<SnapshotInputMappingsStatistics> snapshotInputMappingsStatistics = this.myIndex.dumpSnapshotInputMappingStatistics();
        projectIndexingHistory.addSnapshotInputMappingStatistics(snapshotInputMappingsStatistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexFiles(@NotNull List<IndexableFilesIterator> orderedProviders, @NotNull Map<IndexableFilesIterator, List<VirtualFile>> providerToFiles, @NotNull ProjectIndexingHistory projectIndexingHistory, @NotNull ProgressIndicator progressIndicator) {
        if (orderedProviders == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(6);
        }
        if (providerToFiles == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(7);
        }
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(8);
        }
        if (progressIndicator == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(9);
        }
        int totalFiles = providerToFiles.values().stream().mapToInt(it -> it.size()).sum();
        ConcurrentTasksProgressManager concurrentTasksProgressManager = new ConcurrentTasksProgressManager(progressIndicator, totalFiles);
        int numberOfIndexingThreads = UnindexedFilesUpdater.getNumberOfIndexingThreads();
        LOG.info("Use " + numberOfIndexingThreads + " indexing " + StringUtil.pluralize((String)"thread", (int)numberOfIndexingThreads) + " for indexing of " + this.myProject.getName());
        IndexUpdateRunner indexUpdateRunner = new IndexUpdateRunner(this.myIndex, GLOBAL_INDEXING_EXECUTOR, numberOfIndexingThreads);
        int index2 = 0;
        while (index2 < orderedProviders.size()) {
            List<VirtualFile> providerFiles;
            ArrayList<IndexUpdateRunner.FileSet> fileSets = new ArrayList<IndexUpdateRunner.FileSet>();
            int biggestProviderFiles = 0;
            IndexableFilesIterator biggestProvider = null;
            for (int takenFiles = 0; takenFiles < MINIMUM_NUMBER_OF_FILES_TO_RUN_CONCURRENT_INDEXING && index2 < orderedProviders.size(); takenFiles += providerFiles.size()) {
                IndexableFilesIterator provider2;
                if (!(providerFiles = providerToFiles.getOrDefault(provider2 = orderedProviders.get(index2++), Collections.emptyList())).isEmpty()) {
                    fileSets.add(new IndexUpdateRunner.FileSet(this.myProject, provider2.getDebugName(), providerFiles));
                }
                if (biggestProviderFiles >= providerFiles.size()) continue;
                biggestProviderFiles = providerFiles.size();
                biggestProvider = provider2;
            }
            if (fileSets.isEmpty() || biggestProvider == null) break;
            String indexingProgressText = biggestProvider.getIndexingProgressText();
            concurrentTasksProgressManager.setText(indexingProgressText);
            int setFilesNumber = fileSets.stream().mapToInt(b -> b.files.size()).sum();
            SubTaskProgressIndicator subTaskIndicator = concurrentTasksProgressManager.createSubTaskIndicator(setFilesNumber);
            try {
                IndexUpdateRunner.IndexingInterruptedException exception = null;
                try {
                    indexUpdateRunner.indexFiles(this.myProject, fileSets, subTaskIndicator);
                }
                catch (IndexUpdateRunner.IndexingInterruptedException e) {
                    exception = e;
                }
                try {
                    fileSets.forEach(b -> projectIndexingHistory.addProviderStatistics(b.statistics));
                }
                catch (Exception e) {
                    LOG.error("Failed to add indexing statistics", (Throwable)e);
                }
                if (exception == null) continue;
                ExceptionUtil.rethrow((Throwable)exception.getCause());
            }
            finally {
                subTaskIndicator.finished();
            }
        }
    }

    @NotNull
    private static String getLogScanningCompletedStageMessage(@NotNull ProjectIndexingHistory projectIndexingHistory) {
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(10);
        }
        ArrayList<JsonScanningStatistics> statistics = projectIndexingHistory.getScanningStatistics();
        int numberOfScannedFiles = statistics.stream().mapToInt(s -> s.getNumberOfScannedFiles()).sum();
        int numberOfFilesForIndexing = statistics.stream().mapToInt(s -> s.getNumberOfFilesForIndexing()).sum();
        String string = "Scanning completed for " + projectIndexingHistory.getProject().getName() + ". Number of scanned files: " + numberOfScannedFiles + "; Number of files for indexing: " + numberOfFilesForIndexing;
        if (string == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(11);
        }
        return string;
    }

    private void listenToProgressSuspenderForSuspendedTimeDiagnostic(final @NotNull ProgressSuspender suspender, final @NotNull ProjectIndexingHistory projectIndexingHistory) {
        if (suspender == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(12);
        }
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(13);
        }
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(ProgressSuspender.TOPIC, (Object)new ProgressSuspender.SuspenderListener(){
            private volatile Instant suspensionStart = null;

            @Override
            public void suspendedStatusChanged(@NotNull ProgressSuspender changedSuspender) {
                if (changedSuspender == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (suspender == changedSuspender) {
                    if (suspender.isSuspended()) {
                        this.suspensionStart = Instant.now();
                    } else {
                        Instant now = Instant.now();
                        Instant start2 = this.suspensionStart;
                        this.suspensionStart = null;
                        if (start2 != null && start2.compareTo(now) < 0) {
                            Duration thisDuration = Duration.between(start2, now);
                            Duration currentTotalDuration = projectIndexingHistory.getTimes().getSuspendedDuration();
                            Duration newTotalSuspendedDuration = currentTotalDuration.plus(thisDuration);
                            projectIndexingHistory.getTimes().setSuspendedDuration(newTotalSuspendedDuration);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedSuspender", "com/intellij/util/indexing/UnindexedFilesUpdater$1", "suspendedStatusChanged"));
            }
        });
    }

    public static boolean isIndexUpdateInProgress(@NotNull Project project) {
        if (project == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(14);
        }
        return project.getUserData(INDEX_UPDATE_IN_PROGRESS) == Boolean.TRUE;
    }

    public static boolean isProjectContentFullyScanned(@NotNull Project project) {
        if (project == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(15);
        }
        return Boolean.TRUE.equals(project.getUserData(CONTENT_SCANNED));
    }

    @NotNull
    private List<IndexableFilesIterator> getOrderedProviders() {
        if (this.myPredefinedIndexableFilesIterators != null) {
            List<IndexableFilesIterator> list2 = this.myPredefinedIndexableFilesIterators;
            if (list2 == null) {
                UnindexedFilesUpdater.$$$reportNull$$$0(16);
            }
            return list2;
        }
        List<IndexableFilesIterator> originalOrderedProviders = this.myIndex.getOrderedIndexableFilesProviders(this.myProject);
        ArrayList<IndexableFilesIterator> orderedProviders = new ArrayList<IndexableFilesIterator>();
        originalOrderedProviders.stream().filter(p -> !(p.getOrigin() instanceof SdkOrigin)).collect(Collectors.toCollection(() -> orderedProviders));
        originalOrderedProviders.stream().filter(p -> p.getOrigin() instanceof SdkOrigin).collect(Collectors.toCollection(() -> orderedProviders));
        ArrayList<IndexableFilesIterator> arrayList = orderedProviders;
        if (arrayList == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<IndexableFilesIterator, List<VirtualFile>> collectIndexableFilesConcurrently(@NotNull Project project, @NotNull ProgressIndicator indicator2, @NotNull List<IndexableFilesIterator> providers, @NotNull ProjectIndexingHistory projectIndexingHistory) {
        if (project == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(18);
        }
        if (indicator2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(19);
        }
        if (providers == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(20);
        }
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(21);
        }
        if (providers.isEmpty()) {
            Map<IndexableFilesIterator, List<VirtualFile>> map2 = Collections.emptyMap();
            if (map2 == null) {
                UnindexedFilesUpdater.$$$reportNull$$$0(22);
            }
            return map2;
        }
        List sessions = ContainerUtil.map((Collection)IndexableFileScanner.EP_NAME.getExtensionList(), scanner -> scanner.startSession(project));
        UnindexedFilesFinder unindexedFileFinder = new UnindexedFilesFinder(project, this.myIndex);
        IdentityHashMap<IndexableFilesIterator, List<VirtualFile>> providerToFiles = new IdentityHashMap<IndexableFilesIterator, List<VirtualFile>>();
        IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter = IndexableFilesDeduplicateFilter.create();
        indicator2.setText(IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
        indicator2.setIndeterminate(false);
        indicator2.setFraction(0.0);
        ConcurrentTasksProgressManager concurrentTasksProgressManager = new ConcurrentTasksProgressManager(indicator2, providers.size());
        Ref allTasksFinished = Ref.create((Object)false);
        List tasks = ContainerUtil.map(providers, provider2 -> {
            Object[] moduleValues;
            List pushers;
            SubTaskProgressIndicator subTaskIndicator = concurrentTasksProgressManager.createSubTaskIndicator(1);
            ArrayList files2 = new ArrayList();
            ScanningStatistics scanningStatistics = new ScanningStatistics(provider2.getDebugName());
            providerToFiles.put((IndexableFilesIterator)provider2, files2);
            IndexableSetOrigin origin = provider2.getOrigin();
            @NotNull List fileScannerVisitors = ContainerUtil.mapNotNull((Collection)sessions, s -> s.createVisitor(origin));
            IndexableFilesDeduplicateFilter thisProviderDeduplicateFilter = IndexableFilesDeduplicateFilter.createDelegatingTo((IndexableFilesDeduplicateFilter)indexableFilesDeduplicateFilter);
            if (origin instanceof ModuleRootOrigin) {
                pushers = FilePropertyPusher.EP_NAME.getExtensionList();
                moduleValues = (Object[])ReadAction.compute(() -> PushedFilePropertiesUpdaterImpl.getModuleImmediateValues(pushers, (ModuleRootOrigin)origin));
            } else {
                pushers = null;
                moduleValues = null;
            }
            ProgressManager.checkCanceled();
            ContentIterator collectingIterator = fileOrDir -> {
                UnindexedFileStatus status;
                ProgressManager.checkCanceled();
                if (subTaskIndicator.isCanceled()) {
                    return false;
                }
                PushedFilePropertiesUpdaterImpl.applyScannersToFile(fileOrDir, fileScannerVisitors);
                if (pushers != null && this.myPusher instanceof PushedFilePropertiesUpdaterImpl) {
                    ((PushedFilePropertiesUpdaterImpl)this.myPusher).applyPushersToFile(fileOrDir, pushers, moduleValues);
                }
                long statusTime = System.nanoTime();
                try {
                    status = ourTestMode == TestMode.PUSHING ? null : unindexedFileFinder.getFileStatus(fileOrDir);
                }
                finally {
                    statusTime = System.nanoTime() - statusTime;
                }
                if (status != null) {
                    if (status.getShouldIndex() && ourTestMode == null) {
                        files2.add(fileOrDir);
                    }
                    scanningStatistics.addStatus(fileOrDir, status, statusTime, project);
                }
                return true;
            };
            return () -> {
                subTaskIndicator.setText(provider2.getRootsScanningProgressText());
                try {
                    provider2.iterateFiles(project, collectingIterator, (VirtualFileFilter)thisProviderDeduplicateFilter);
                }
                finally {
                    scanningStatistics.setNumberOfSkippedFiles(thisProviderDeduplicateFilter.getNumberOfSkippedFiles());
                    Ref ref = allTasksFinished;
                    synchronized (ref) {
                        if (!((Boolean)allTasksFinished.get()).booleanValue()) {
                            projectIndexingHistory.addScanningStatistics(scanningStatistics);
                        }
                    }
                    subTaskIndicator.finished();
                }
            };
        });
        LOG.info("Scanning of " + this.myProject.getName() + " uses " + UnindexedFilesUpdater.getNumberOfScanningThreads() + " scanning threads");
        try {
            PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(tasks);
        }
        finally {
            Ref ref = allTasksFinished;
            synchronized (ref) {
                allTasksFinished.set((Object)true);
            }
        }
        IdentityHashMap<IndexableFilesIterator, List<VirtualFile>> identityHashMap = providerToFiles;
        if (identityHashMap == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(23);
        }
        return identityHashMap;
    }

    private void scheduleInitialVfsRefresh() {
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).markRootsForRefresh();
        Application app = ApplicationManager.getApplication();
        if (!app.isCommandLine() || CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode()) {
            final long sessionId = VirtualFileManager.getInstance().asyncRefresh(null);
            final MessageBusConnection connection = app.getMessageBus().connect();
            connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosed(@NotNull Project project) {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (project == UnindexedFilesUpdater.this.myProject) {
                        RefreshQueue.getInstance().cancelSession(sessionId);
                        connection.disconnect();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/UnindexedFilesUpdater$2", "projectClosed"));
                }
            });
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> VirtualFileManager.getInstance().syncRefresh());
        }
    }

    private static double getPowerForSmoothProgressIndicator() {
        String rawValue = Registry.stringValue((String)"indexing.progress.indicator.power");
        if ("-".equals(rawValue)) {
            return 1.0;
        }
        try {
            return Double.parseDouble(rawValue);
        }
        catch (NumberFormatException e) {
            return 1.0;
        }
    }

    public void performInDumbMode(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(24);
        }
        UnindexedFilesUpdater.delayIndexingInTestsIfNecessary();
        this.myProject.putUserData(INDEX_UPDATE_IN_PROGRESS, (Object)true);
        ProjectIndexingHistory projectIndexingHistory = new ProjectIndexingHistory(this.myProject, this.myIndexingReason);
        this.myIndex.loadIndexes();
        this.myIndex.filesUpdateStarted(this.myProject);
        IndexDiagnosticDumper.getInstance().onIndexingStarted(projectIndexingHistory);
        try {
            this.updateUnindexedFiles(projectIndexingHistory, indicator2);
        }
        catch (Throwable e) {
            projectIndexingHistory.getTimes().setWasInterrupted(true);
            if (e instanceof ControlFlowException) {
                LOG.info("Cancelled indexing of " + this.myProject.getName());
            }
            throw e;
        }
        finally {
            this.myIndex.filesUpdateFinished(this.myProject);
            this.myProject.putUserData(INDEX_UPDATE_IN_PROGRESS, (Object)false);
            projectIndexingHistory.getTimes().setUpdatingEnd(ZonedDateTime.now(ZoneOffset.UTC));
            projectIndexingHistory.getTimes().setTotalUpdatingTime(System.nanoTime() - projectIndexingHistory.getTimes().getTotalUpdatingTime());
            IndexDiagnosticDumper.getInstance().onIndexingFinished(projectIndexingHistory);
        }
    }

    private static void delayIndexingInTestsIfNecessary() {
        int delay = SystemProperties.getIntProperty((String)"intellij.indexing.tests.indexing.delay.seconds", (int)-1);
        long start2 = System.nanoTime();
        if (delay != -1) {
            ProgressIndicatorUtils.awaitWithCheckCanceled((ThrowableComputable<Boolean, ? extends Exception>)((ThrowableComputable)() -> System.nanoTime() - start2 > TimeUnit.SECONDS.toNanos(delay)));
        }
    }

    public String toString() {
        return "UnindexedFilesUpdater[" + this.myProject.getName() + "]";
    }

    public static int getNumberOfIndexingThreads() {
        int threadCount = Registry.intValue((String)"caches.indexerThreadsCount");
        if (threadCount <= 0) {
            int coresToLeaveForOtherActivity = ApplicationManager.getApplication().isCommandLine() ? 0 : 1;
            threadCount = Math.max(1, Math.min(Runtime.getRuntime().availableProcessors() - coresToLeaveForOtherActivity, 4));
        }
        return threadCount;
    }

    public static int getMaxNumberOfIndexingThreads() {
        int threadCount = Registry.intValue((String)"caches.indexerThreadsCount");
        return threadCount <= 0 ? 4 : threadCount;
    }

    public static int getNumberOfScanningThreads() {
        int scanningThreadCount = Registry.intValue((String)"caches.scanningThreadsCount");
        if (scanningThreadCount > 0) {
            return scanningThreadCount;
        }
        int coresToLeaveForOtherActivity = ApplicationManager.getApplication().isCommandLine() ? 0 : 1;
        return Math.max(Runtime.getRuntime().availableProcessors() - coresToLeaveForOtherActivity, UnindexedFilesUpdater.getNumberOfIndexingThreads());
    }

    static {
        GLOBAL_INDEXING_EXECUTOR = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Indexing", (int)UnindexedFilesUpdater.getMaxNumberOfIndexingThreads());
        MINIMUM_NUMBER_OF_FILES_TO_RUN_CONCURRENT_INDEXING = SystemProperties.getIntProperty((String)"intellij.indexing.minimum.number.of.files.to.run.concurrent.indexing", (int)100);
        CONTENT_SCANNED = Key.create((String)"CONTENT_SCANNED");
        INDEX_UPDATE_IN_PROGRESS = Key.create((String)"INDEX_UPDATE_IN_PROGRESS");
        RUNNING_TASK = Key.create((String)"RUNNING_INDEX_UPDATER_TASK");
        ourLastRunningTaskLock = new Object();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 16: 
            case 17: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 16: 
            case 17: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectIndexingHistory";
                break;
            }
            case 5: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderedProviders";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerToFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 11: 
            case 16: 
            case 17: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/UnindexedFilesUpdater";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspender";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/UnindexedFilesUpdater";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogScanningCompletedStageMessage";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderedProviders";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "collectIndexableFilesConcurrently";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateUnindexedFiles";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "indexFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLogScanningCompletedStageMessage";
                break;
            }
            case 11: 
            case 16: 
            case 17: 
            case 22: 
            case 23: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "listenToProgressSuspenderForSuspendedTimeDiagnostic";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isIndexUpdateInProgress";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isProjectContentFullyScanned";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectIndexableFilesConcurrently";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "performInDumbMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 16: 
            case 17: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TestMode {
        PUSHING,
        PUSHING_AND_SCANNING;

    }
}

