/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.util.indexing.DocumentContent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/indexing/PsiContent;", "Lcom/intellij/util/indexing/DocumentContent;", "myDocument", "Lcom/intellij/openapi/editor/Document;", "myFile", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/psi/PsiFile;)V", "modificationStamp", "", "getModificationStamp", "()J", "text", "", "getText", "()Ljava/lang/CharSequence;", "intellij.platform.lang.impl"})
public final class PsiContent
extends DocumentContent {
    private final long modificationStamp;
    private final Document myDocument;
    private final PsiFile myFile;

    @Override
    @NotNull
    public CharSequence getText() {
        FileViewProvider fileViewProvider = this.myFile.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"myFile.viewProvider");
        if (fileViewProvider.getModificationStamp() != this.myDocument.getModificationStamp()) {
            FileASTNode fileASTNode = this.myFile.getNode();
            Intrinsics.checkNotNull((Object)fileASTNode);
            ASTNode node = (ASTNode)fileASTNode;
            CharSequence charSequence = node.getChars();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"node.chars");
            return charSequence;
        }
        CharSequence charSequence = this.myDocument.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"myDocument.immutableCharSequence");
        return charSequence;
    }

    @Override
    public long getModificationStamp() {
        return this.modificationStamp;
    }

    public PsiContent(@NotNull Document myDocument, @NotNull PsiFile myFile) {
        Intrinsics.checkNotNullParameter((Object)myDocument, (String)"myDocument");
        Intrinsics.checkNotNullParameter((Object)myFile, (String)"myFile");
        super(null);
        this.myDocument = myDocument;
        this.myFile = myFile;
        FileViewProvider fileViewProvider = this.myFile.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"myFile.viewProvider");
        this.modificationStamp = fileViewProvider.getModificationStamp();
    }
}

